/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.io.IOUtils;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.util.ByteArrayIOStream;
import org.cip4.jdflib.util.StringUtil;

public class StreamUtil {
    public static InputStream getBufferedInputStream(InputStream is) {
        if (is == null) {
            return null;
        }
        if (is instanceof ByteArrayInputStream) {
            return is;
        }
        if (is instanceof BufferedInputStream) {
            return is;
        }
        return new BufferedInputStream(is);
    }

    public static OutputStream getBufferedOutputStream(OutputStream os) {
        if (os == null) {
            return null;
        }
        if (os instanceof ByteArrayOutputStream) {
            return os;
        }
        if (os instanceof BufferedOutputStream) {
            return os;
        }
        return new BufferedOutputStream(os);
    }

    public static VString getLines(InputStream in) {
        ByteArrayIOStream.ByteArrayIOInputStream ios = ByteArrayIOStream.getBufferedInputStream(in);
        if (ios == null) {
            return null;
        }
        byte[] bytes = ios.getBuf();
        String s = bytes == null ? null : new String(bytes, 0, bytes.length);
        return StringUtil.tokenize(s, "\n\r", false);
    }

    public static boolean replaceBytes(InputStream in, OutputStream out, byte[] srcbytes, byte[] targetbytes, int nReplace) {
        try {
            int readByte;
            int pos = -1;
            int n = 0;
            int len = srcbytes.length - 1;
            while ((readByte = in.read()) >= 0) {
                int i;
                byte b = (byte)(readByte & 0xFF);
                if (srcbytes[pos + 1] == b) {
                    if (++pos != len) continue;
                    ++n;
                    pos = -1;
                    if (targetbytes != null) {
                        out.write(targetbytes);
                    }
                    if (n != nReplace) continue;
                    for (i = 0; i <= pos; ++i) {
                        out.write(srcbytes[i]);
                    }
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    break;
                }
                for (i = 0; i <= pos; ++i) {
                    out.write(srcbytes[i]);
                }
                pos = -1;
                out.write(b);
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getMD5(InputStream is) {
        MessageDigest md5;
        if (is == null) {
            return null;
        }
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        MessageDigest messageDigest = md5;
        synchronized (messageDigest) {
            byte[] b = new byte[100000];
            try {
                int n = is.read(b);
                while (n > 0) {
                    md5.update(b, 0, n);
                    n = is.read(b);
                }
                return md5.digest();
            }
            catch (IOException e) {
                return null;
            }
        }
    }

    public static void close(OutputStream ios) {
        if (ios != null) {
            try {
                ios.flush();
                ios.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void copy(InputStream is, OutputStream os) {
        if (is != null && os != null) {
            try {
                IOUtils.copy((InputStream)is, (OutputStream)os);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void reset(InputStream stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(InputStream ios) {
        if (ios != null) {
            try {
                ios.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

