/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

public class ThreadUtil {
    public static boolean sleep(int millis) {
        if (millis <= 0) {
            return true;
        }
        try {
            Thread.sleep(millis);
            return true;
        }
        catch (InterruptedException x) {
            return false;
        }
    }

    public static boolean join(Thread thread, int millis) {
        if (thread == null) {
            return true;
        }
        try {
            if (millis <= 0) {
                thread.join();
            } else {
                thread.join(millis);
            }
            return true;
        }
        catch (InterruptedException x) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean wait(Object mutex, int millis) {
        if (millis < 0) {
            millis = 0;
        }
        if (mutex == null) {
            return false;
        }
        try {
            Object object = mutex;
            synchronized (object) {
                mutex.wait(millis);
            }
            return true;
        }
        catch (InterruptedException x) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyAll(Object mutex) {
        if (mutex != null) {
            Object object = mutex;
            synchronized (object) {
                mutex.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notify(Object mutex) {
        if (mutex != null) {
            Object object = mutex;
            synchronized (object) {
                mutex.notify();
            }
        }
    }

    @Deprecated
    public static abstract class WaitTimeout<a>
    extends org.cip4.jdflib.util.thread.WaitTimeout<a> {
        public WaitTimeout(int millis) {
            super(millis);
        }
    }

    @Deprecated
    public static class MyMutex
    extends org.cip4.jdflib.util.thread.MyMutex {
    }
}

