/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.elementwalker;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.elementwalker.IWalker;
import org.cip4.jdflib.elementwalker.IWalkerFactory;

public class ElementWalker {
    protected final IWalkerFactory theFactory;
    protected final Log log = LogFactory.getLog(this.getClass());

    public ElementWalker(IWalkerFactory _theFactory) {
        this.theFactory = _theFactory;
    }

    public int walkTree(KElement e, KElement trackElem) {
        if (e == null) {
            return 0;
        }
        int n = 0;
        IWalker w = this.theFactory.getWalker(e);
        KElement b = null;
        if (w != null) {
            ++n;
            b = this.doWalk(e, trackElem, w);
            if (b != null) {
                List<KElement> v = e.getChildArray_KElement(null, null, null, true, -1);
                for (KElement e2 : v) {
                    n += this.walkTree(e2, b);
                }
            }
            w.finalizeWalk(e, trackElem);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    KElement doWalk(KElement e, KElement trackElem, IWalker w) {
        KElement b = null;
        try {
            w.prepareWalk(e, trackElem);
        }
        catch (Throwable t) {
            this.log.error((Object)"Problems walking", t);
        }
        try {
            b = w.walk(e, trackElem);
        }
        catch (Throwable t) {
            this.log.error((Object)"Problems walking", t);
        }
        return b;
    }

    public int walkTreeKidsFirst(KElement e) {
        if (e == null) {
            return 0;
        }
        int n = 0;
        List<KElement> v = e.getChildArray_KElement(null, null, null, true, -1);
        for (KElement e2 : v) {
            n += this.walkTreeKidsFirst(e2);
        }
        IWalker w = this.theFactory.getWalker(e);
        if (w != null) {
            ++n;
            this.doWalk(e, null, w);
            w.finalizeWalk(e, null);
        }
        return n;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : " + this.theFactory;
    }

    public IWalkerFactory getFactory() {
        return this.theFactory;
    }
}

