/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.cip4.jdflib.auto.JDFAutoResourceInfo;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFPartAmount;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.extensions.ResourceHelper;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.WalkJDFSubElement;
import org.cip4.jdflib.jmf.JDFResourceInfo;
import org.cip4.jdflib.pool.JDFAmountPool;
import org.cip4.jdflib.resource.JDFPart;
import org.cip4.jdflib.resource.JDFResource;

public class WalkResourceInfo
extends WalkJDFSubElement {
    @Override
    public KElement walk(KElement resInfo, KElement xjdf) {
        JDFResourceInfo ri = (JDFResourceInfo)resInfo;
        KElement eNew = super.walk(ri, xjdf);
        int nRes = 0;
        int n0 = 1;
        while (n0 > 0) {
            Collection<KElement> vr = ri.getChildArray(null, null);
            n0 = 0;
            for (KElement e : vr) {
                if (!(e instanceof JDFResource)) continue;
                ++n0;
                JDFResource r = (JDFResource)e;
                if (nRes == 0) {
                    this.setResource(ri, r, eNew);
                } else {
                    this.setResource(null, r, eNew);
                }
                r.deleteNode();
                ++nRes;
            }
        }
        this.moveToResourceSet((JDFResourceInfo)eNew, ri);
        this.updateInfos((JDFResourceInfo)eNew);
        eNew.removeAttribute("ResourceName");
        resInfo.removeChildrenByClass(JDFPart.class);
        return eNew;
    }

    void updateInfos(JDFResourceInfo eNew) {
        KElement parent;
        VElement v = eNew.getChildElementVector("ResourceSet", null);
        int size = v.size();
        if (size > 1 && (parent = eNew.getParentNode_KElement()) != null) {
            int n = 0;
            VElement vRI = new VElement();
            vRI.add(eNew);
            for (int i = 1; i < size; ++i) {
                vRI.add(parent.copyElement(eNew, null));
            }
            for (KElement ri : vRI) {
                for (int ii = size - 1; ii >= 0; --ii) {
                    if (ii == n) continue;
                    ri.removeChild("ResourceSet", null, ii);
                }
                ++n;
                ri.copyAttribute("ResourceName", ri.getElement("ResourceSet"), "Name", null, null);
            }
        }
    }

    void moveToResourceSet(JDFResourceInfo ri, JDFResourceInfo jdfRI) {
        SetHelper sh0 = SetHelper.getHelper(ri.getElement("ResourceSet"));
        VJDFAttributeMap vPartMap = this.getPartMaps(jdfRI, sh0);
        this.setAmountPool(jdfRI, jdfRI, null);
        JDFAmountPool ap = jdfRI.getAmountPool();
        this.setScope(ri, jdfRI, sh0);
        KElement set = this.getSetElement(ri);
        SetHelper sh = new SetHelper(set);
        Vector<ResourceHelper> newParts = sh.getCreatePartitions(vPartMap, false);
        boolean isEstimate = JDFAutoResourceInfo.EnumScope.Estimate.equals((Object)ri.getScope());
        for (ResourceHelper ph : newParts) {
            this.processPart(ri, ap, newParts, isEstimate, ph);
        }
        if (newParts.size() > 1) {
            set.moveAttribute("ExternalID", ri);
        } else {
            ri.removeAttribute("ExternalID");
        }
        ri.removeChild("AmountPool", null, 0);
        jdfRI.removeChild("AmountPool", null, 0);
    }

    void processPart(JDFResourceInfo ri, JDFAmountPool ap, List<ResourceHelper> newParts, boolean isEstimate, ResourceHelper ph) {
        JDFAmountPool apx = ph.getAmountPool();
        if (apx == null) {
            if (ap == null) {
                ph.setAmount(ri.getActualAmount(), null, true);
                if (newParts.size() == 1) {
                    ph.getRoot().moveAttribute("ExternalID", ri);
                }
            } else if (ph.getRoot().getElement("AmountPool") == null) {
                ap.reducePartAmounts(ph.getPartMapVector());
                this.jdfToXJDF.walkTree(ap, ph.getRoot());
                ap.deleteNode();
            }
        }
        if (!isEstimate) {
            Collection<JDFPartAmount> cpa;
            apx = ph.getAmountPool();
            Collection<JDFPartAmount> collection = cpa = apx == null ? null : apx.getAllPartAmount();
            if (cpa != null) {
                for (JDFPartAmount pa : cpa) {
                    pa.renameAttribute("ActualAmount", "Amount");
                    pa.renameAttribute("ActualWaste", "Waste");
                }
            }
        }
    }

    KElement getSetElement(JDFResourceInfo ri) {
        KElement set;
        String resName = ri.getXPathAttribute("ResourceSet/@Name", null);
        if (resName == null) {
            resName = ri.getResourceName();
        }
        if ((set = ri.getChildWithAttribute("ResourceSet", "Name", null, resName, 0, true)) == null) {
            set = ri.appendElement("ResourceSet");
            set.setAttribute("Name", resName);
        }
        set.moveAttribute("ProcessUsage", ri);
        set.moveAttribute("Orientation", ri);
        set.moveAttribute("Unit", ri);
        set.moveAttribute("Usage", ri);
        return set;
    }

    void setScope(JDFResourceInfo ri, JDFResourceInfo jdfRI, SetHelper sh0) {
        boolean hasScope = jdfRI.hasNonEmpty("Scope");
        if (!hasScope) {
            boolean isJobScope = sh0 != null ? sh0.getAmountSum(true) <= 0.0 : jdfRI.getAmountPoolSumDouble("ActualAmount", null) > 0.0;
            String value = isJobScope ? "Job" : "Estimate";
            ri.setAttribute("Scope", value);
        }
    }

    VJDFAttributeMap getPartMaps(JDFResourceInfo jdfRI, SetHelper sh0) {
        VJDFAttributeMap vPartMap = jdfRI.getPartMapVector();
        if (VJDFAttributeMap.isEmpty(vPartMap)) {
            vPartMap = sh0 == null ? null : sh0.getPartMapVector();
        } else {
            List<ResourceHelper> vp;
            List<ResourceHelper> list = vp = sh0 == null ? null : sh0.getPartitionList();
            if (vp != null) {
                for (ResourceHelper rh : vp) {
                    VJDFAttributeMap m = rh.getPartMapVector();
                    m = VJDFAttributeMap.isEmpty(m) ? vPartMap : m.getOrMaps(vPartMap);
                    rh.setPartMapVector(m);
                }
            }
        }
        return vPartMap;
    }

    @Override
    public boolean matches(KElement toCheck) {
        return !this.jdfToXJDF.isRetainAll() && toCheck instanceof JDFResourceInfo;
    }

    @Override
    protected void updateAttributes(JDFAttributeMap map) {
        map.remove("ActualAmount");
        map.remove("Amount");
        map.remove("DeviceID");
        map.remove("Level");
        map.remove("LotControlled");
        map.remove("ResourceID");
        map.remove("Status");
        this.updateModule(map);
        super.updateAttributes(map);
    }

    @Override
    void makeRefElements(JDFElement je) {
    }

    @Override
    public VString getElementNames() {
        return VString.getVString("ResourceInfo", null);
    }
}

