/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import java.util.List;
import java.util.Vector;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFIntegerList;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.extensions.ResourceHelper;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.extensions.XJDFHelper;
import org.cip4.jdflib.resource.process.JDFMedia;
import org.cip4.jdflib.util.ContainerUtil;

public class XJDFCombiner {
    private final XJDFHelper mainHelper;
    private final XJDFHelper h;
    int[] typeIndex;

    public XJDFCombiner(XJDFHelper mainHelper, XJDFHelper helper) {
        this.mainHelper = mainHelper;
        this.h = helper;
        this.typeIndex = null;
    }

    public String toString() {
        return "XJDFCombiner [" + (this.mainHelper != null ? "mainHelper=" + this.mainHelper : "") + (this.h != null ? "h=" + this.h : "") + "]";
    }

    public XJDFHelper combine() {
        this.typeIndex = this.combineTypes();
        if (this.typeIndex != null) {
            Vector<SetHelper> v;
            Vector<SetHelper> v0 = this.mainHelper.getSets();
            if (v0 != null) {
                for (SetHelper s : v0) {
                    this.prepareSet(s);
                }
            }
            if ((v = this.h.getSets()) != null) {
                for (SetHelper s : v) {
                    this.combineSet(s);
                }
            }
        }
        return this.mainHelper;
    }

    private void prepareSet(SetHelper s) {
        String name;
        String pu = s.getProcessUsage();
        if (pu == null && "Media".equals(name = s.getName())) {
            ResourceHelper r = s.getPartition(0);
            JDFMedia m = (JDFMedia)(r == null ? null : r.getResource());
            String string = pu = m == null ? null : m.getNonEmpty("MediaType");
            if (pu != null) {
                s.setProcessUsage(pu);
            }
        }
    }

    void combineSet(SetHelper s) {
        this.prepareSet(s);
        SetHelper mainSet = this.getMainSet(s);
        if (mainSet == null) {
            mainSet = this.copySet(s);
        }
        this.mergeSet(mainSet, s);
    }

    SetHelper getMainSet(SetHelper s) {
        SetHelper set = this.mainHelper.getSet(s.getID());
        if (set == null) {
            JDFIntegerList cpi = s.getCombinedProcessIndex();
            if (ContainerUtil.getNonEmpty(cpi) == null) {
                cpi = this.typeIndex == null ? null : new JDFIntegerList(this.typeIndex);
            } else {
                JDFIntegerList il = new JDFIntegerList();
                for (int i = 0; i < cpi.size(); ++i) {
                    int pos = cpi.getInt(i);
                    if (pos < 0 || pos >= this.typeIndex.length) continue;
                    il.add(this.typeIndex[pos]);
                }
                cpi = il;
            }
            set = this.mainHelper.getSet(s.getName(), s.getUsage(), s.getProcessUsage(), cpi);
        }
        return set;
    }

    void mergeSet(SetHelper mainSet, SetHelper s) {
        List<ResourceHelper> v = s.getPartitionList();
        for (ResourceHelper r : v) {
            ResourceHelper partition = mainSet.getPartition(this.getPartitions(r));
            if (partition != null) {
                partition.getRoot().setAttributes(r.getRoot());
                KElement r2 = r.getResource();
                if (r2 == null) continue;
                partition.getCreateResource().mergeElement(r2, false);
                continue;
            }
            new ResourceHelper(mainSet.copyHelper(r)).setPartMapVector(this.getPartitions(r));
        }
    }

    VJDFAttributeMap getPartitions(ResourceHelper r) {
        SetHelper component;
        VJDFAttributeMap partMapVector = r.getPartMapVector();
        if (VJDFAttributeMap.isEmpty(partMapVector) && VJDFAttributeMap.isEmpty(partMapVector = this.h.getPartMapVector()) && (component = this.h.getSet("Component", JDFResourceLink.EnumUsage.Output)) != null) {
            partMapVector = component.getPartMapVector();
        }
        return partMapVector;
    }

    SetHelper copySet(SetHelper s) {
        SetHelper copied = new SetHelper(this.mainHelper.copyHelper(s));
        if (this.typeIndex != null) {
            JDFIntegerList cpi = this.getMainCPI(copied);
            copied.setCombinedProcessIndex(cpi);
        }
        copied.removePartitions();
        return copied;
    }

    protected JDFIntegerList getMainCPI(SetHelper copied) {
        JDFIntegerList cpi = copied.getCombinedProcessIndex();
        if (cpi != null) {
            for (int i = 0; i < cpi.size(); ++i) {
                int index = cpi.getInt(i);
                if (index < 0 || index >= this.typeIndex.length) continue;
                cpi.set(i, this.typeIndex[index]);
            }
        } else {
            cpi = new JDFIntegerList(this.typeIndex);
        }
        return cpi;
    }

    int[] combineTypes() {
        VString types = this.h.getTypes();
        VString mainTypes = this.mainHelper.getTypes();
        VString oldTypes = this.mainHelper.getTypes();
        if (!ContainerUtil.isEmpty(oldTypes)) {
            int[] typeList = new int[types.size()];
            if (ContainerUtil.isEmpty(oldTypes)) {
                for (int i = 0; i < types.size(); ++i) {
                    typeList[i] = i;
                }
            } else {
                int i = 0;
                for (String t : types) {
                    int pos = oldTypes.indexOf(t);
                    if (pos >= 0) {
                        typeList[i++] = pos;
                        oldTypes.set(pos, "");
                        continue;
                    }
                    typeList[i++] = mainTypes.size();
                    mainTypes.add(t);
                    this.mainHelper.setTypes(mainTypes);
                }
            }
            return typeList;
        }
        return null;
    }
}

