/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.devicecapability;

import java.util.zip.DataFormatException;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoBasicPreflightTest;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.datatypes.JDFBaseDataTypes;
import org.cip4.jdflib.datatypes.JDFDurationRangeList;
import org.cip4.jdflib.resource.devicecapability.JDFAbstractState;
import org.cip4.jdflib.resource.devicecapability.JDFTerm;
import org.cip4.jdflib.util.JDFDuration;

public class JDFDurationState
extends JDFAbstractState {
    private static final long serialVersionUID = 1L;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[4];
    private static ElemInfoTable[] elemInfoTable;

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        return new ElementInfo(super.getTheElementInfo(), elemInfoTable);
    }

    public JDFDurationState(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFDurationState(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFDurationState(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFDurationState[ --> " + super.toString() + " ]";
    }

    public void setCurrentValue(JDFDuration value) {
        this.setAttribute("CurrentValue", value.getDurationISO(), null);
    }

    public JDFDuration getCurrentValue() {
        String str = this.getAttribute("CurrentValue", null, null);
        if (str == null) {
            return null;
        }
        try {
            return new JDFDuration(str);
        }
        catch (DataFormatException dfe) {
            return null;
        }
    }

    public void setDefaultValue(JDFDuration value) {
        this.setAttribute("DefaultValue", value.getDurationISO(), null);
    }

    public JDFDuration getDefaultValue() {
        String str = this.getAttribute("DefaultValue", null, null);
        if (str == null) {
            return null;
        }
        try {
            return new JDFDuration(str);
        }
        catch (DataFormatException dfe) {
            return null;
        }
    }

    public void setAllowedValueList(JDFDurationRangeList value) {
        this.setAttribute("AllowedValueList", value.toString());
    }

    public JDFDurationRangeList getAllowedValueList() {
        try {
            String attribute = this.getAttribute("AllowedValueList", null, null);
            if (attribute != null) {
                return new JDFDurationRangeList(attribute);
            }
        }
        catch (DataFormatException dataFormatException) {
            // empty catch block
        }
        return null;
    }

    public void setPresentValueList(JDFDurationRangeList value) {
        this.setAttribute("PresentValueList", value.toString());
    }

    public JDFDurationRangeList getPresentValueList() {
        try {
            String attribute = this.getAttribute("PresentValueList", null, null);
            if (attribute != null) {
                return new JDFDurationRangeList(attribute);
            }
        }
        catch (DataFormatException dfe) {
            return null;
        }
        return this.getAllowedValueList();
    }

    @Override
    public void addValue(String value, JDFBaseDataTypes.EnumFitsValue testlists) {
        JDFDurationRangeList list;
        JDFDuration duration;
        if (this.fitsValue(value, testlists)) {
            return;
        }
        try {
            duration = new JDFDuration(value);
        }
        catch (DataFormatException x) {
            return;
        }
        if (testlists == null || JDFBaseDataTypes.EnumFitsValue.Allowed.equals((Object)testlists)) {
            list = this.getAllowedValueList();
            if (list == null) {
                list = new JDFDurationRangeList();
            }
            list.append(duration);
            this.setAllowedValueList(list);
        }
        if (testlists == null || JDFBaseDataTypes.EnumFitsValue.Present.equals((Object)testlists)) {
            list = this.getPresentValueList();
            if (list == null || !this.hasAttribute("PresentValueList")) {
                list = new JDFDurationRangeList();
            }
            list.append(duration);
            this.setPresentValueList(list);
        }
    }

    @Override
    public final boolean fitsValue(String value, JDFBaseDataTypes.EnumFitsValue testlists) {
        if (this.fitsListType(value)) {
            JDFDurationRangeList rangelist = null;
            try {
                rangelist = new JDFDurationRangeList(value);
            }
            catch (DataFormatException dfe) {
                return false;
            }
            return this.fitsValueList(rangelist, testlists);
        }
        return false;
    }

    private final boolean fitsValueList(JDFDurationRangeList rangelist, JDFBaseDataTypes.EnumFitsValue valuelist) {
        JDFDurationRangeList list = valuelist.equals((Object)JDFBaseDataTypes.EnumFitsValue.Allowed) ? this.getAllowedValueList() : this.getPresentValueList();
        if (list == null) {
            return true;
        }
        JDFAutoBasicPreflightTest.EnumListType listType = this.getListType();
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.CompleteList)) {
            return this.fitsCompleteList(rangelist, list);
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.CompleteOrderedList)) {
            return this.fitsCompleteOrderedList(rangelist, list);
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.ContainedList)) {
            return this.fitsContainedList(rangelist, list);
        }
        return list.isPartOfRange(rangelist);
    }

    private final boolean fitsCompleteList(JDFDurationRangeList value, JDFDurationRangeList list) {
        int l_size;
        int v_size = value.size();
        if (v_size != (l_size = list.size())) {
            return false;
        }
        if (!value.isUnique()) {
            return false;
        }
        JDFDurationRangeList valueList = new JDFDurationRangeList(value);
        for (int i = l_size - 1; i >= 0; --i) {
            boolean bFound = false;
            for (int j = valueList.size() - 1; j >= 0; --j) {
                if (!list.at(i).equals(valueList.at(j))) continue;
                valueList.erase(j);
                bFound = true;
                break;
            }
            if (bFound) continue;
            return false;
        }
        return true;
    }

    private final boolean fitsCompleteOrderedList(JDFDurationRangeList value, JDFDurationRangeList list) {
        int l_size;
        int v_size = value.size();
        if (v_size != (l_size = list.size())) {
            return false;
        }
        if (!value.isUnique()) {
            return false;
        }
        for (int i = 0; i < l_size; ++i) {
            if (list.at(i).equals(value.at(i))) continue;
            return false;
        }
        return true;
    }

    private final boolean fitsContainedList(JDFDurationRangeList value, JDFDurationRangeList list) {
        int v_size = value.size();
        int l_size = list.size();
        for (int i = 0; i < v_size; ++i) {
            for (int j = 0; j < l_size; ++j) {
                if (!value.at(i).equals(list.at(j))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public JDFTerm.EnumTerm getEvaluationType() {
        return JDFTerm.EnumTerm.DurationEvaluation;
    }

    static {
        JDFDurationState.atrInfoTable[0] = new AtrInfoTable("AllowedValueList", 0x33333311L, AttributeInfo.EnumAttributeType.DurationRangeList, null, null);
        JDFDurationState.atrInfoTable[1] = new AtrInfoTable("CurrentValue", 0x33333311L, AttributeInfo.EnumAttributeType.duration, null, null);
        JDFDurationState.atrInfoTable[2] = new AtrInfoTable("DefaultValue", 0x33333311L, AttributeInfo.EnumAttributeType.duration, null, null);
        JDFDurationState.atrInfoTable[3] = new AtrInfoTable("PresentValueList", 0x33333311L, AttributeInfo.EnumAttributeType.DurationRangeList, null, null);
        elemInfoTable = new ElemInfoTable[1];
        JDFDurationState.elemInfoTable[0] = new ElemInfoTable("ValueLoc", 0x33333311L);
    }
}

