/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.datatypes;

import java.util.zip.DataFormatException;
import org.cip4.jdflib.datatypes.JDFRange;
import org.cip4.jdflib.util.HashUtil;
import org.cip4.jdflib.util.StringUtil;

public class JDFNumberRange
extends JDFRange {
    private double m_left = 0.0;
    private double m_right = 0.0;

    public static JDFNumberRange createNumberRange(String s) {
        if (s != null && s.length() > 0) {
            try {
                return new JDFNumberRange(s);
            }
            catch (DataFormatException x) {
                return null;
            }
        }
        return null;
    }

    public JDFNumberRange() {
        this.init(0.0, 0.0);
    }

    public JDFNumberRange(double x) {
        this.init(x, x);
    }

    public JDFNumberRange(double xmin, double xmax) {
        this.init(xmin, xmax);
    }

    public JDFNumberRange(JDFNumberRange nr) {
        this.init(nr.getLeft(), nr.getRight());
    }

    protected void init(double xmin, double xmax) {
        this.m_left = xmin;
        this.m_right = xmax;
    }

    public JDFNumberRange(String s) throws DataFormatException {
        String[] strArray = s.split("~");
        if (strArray.length <= 0 || strArray.length > 2) {
            throw new DataFormatException("JDFNumberRange illegal string: " + s);
        }
        try {
            if (strArray.length == 1) {
                this.m_left = StringUtil.parseDouble(strArray[0], 0.0);
                if (this.m_left == 0.0 && !StringUtil.isNumber(strArray[0])) {
                    throw new DataFormatException("JDFIntegerRange illegal string: " + s);
                }
                this.m_right = this.m_left;
            } else {
                this.m_left = StringUtil.parseDouble(strArray[0], 0.0);
                if (this.m_left == 0.0 && !StringUtil.isNumber(strArray[0])) {
                    throw new DataFormatException("JDFIntegerRange illegal string: " + s);
                }
                this.m_right = StringUtil.parseDouble(strArray[1], 0.0);
                if (this.m_right == 0.0 && !StringUtil.isNumber(strArray[1])) {
                    throw new DataFormatException("JDFIntegerRange illegal string: " + s);
                }
            }
        }
        catch (NumberFormatException e) {
            throw new DataFormatException("JDFNumberRange illegal string: " + s);
        }
    }

    public boolean isValid(String s) {
        try {
            new JDFNumberRange(s);
        }
        catch (DataFormatException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        JDFNumberRange jdfNumberRange = (JDFNumberRange)other;
        return Math.abs(this.getLeft() - jdfNumberRange.getLeft()) <= 1.0E-6 && Math.abs(this.getRight() - jdfNumberRange.getRight()) <= 1.0E-6;
    }

    @Override
    public int hashCode() {
        return HashUtil.hashCode(0, this.toString());
    }

    public String getLeftString() {
        return StringUtil.formatDouble(this.getLeft());
    }

    public double getLeft() {
        return this.m_left;
    }

    @Override
    public String getLeftString(int precision) {
        return StringUtil.formatDouble(this.getLeft(), precision);
    }

    @Override
    public String getRightString(int precision) {
        return StringUtil.formatDouble(this.getRight(), precision);
    }

    public String getRightString() {
        return StringUtil.formatDouble(this.getRight());
    }

    public double getRight() {
        return this.m_right;
    }

    public void setLeft(double x) {
        this.m_left = x;
    }

    public void setRight(double x) {
        this.m_right = x;
    }

    public void scale(double f) {
        this.m_right *= f;
        this.m_left *= f;
    }

    public double getLowerValue() {
        return this.getLeft() < this.getRight() ? this.getLeft() : this.getRight();
    }

    public double getUpperValue() {
        return this.getLeft() < this.getRight() ? this.getRight() : this.getLeft();
    }

    public boolean inRange(double x) {
        return x >= this.getLowerValue() && x <= this.getUpperValue();
    }

    @Override
    public boolean isPartOfRange(JDFRange ra) {
        JDFNumberRange r = (JDFNumberRange)ra;
        return r.getLowerValue() >= this.getLowerValue() && r.getUpperValue() <= this.getUpperValue();
    }

    @Override
    protected Object getRightObject() {
        return this.m_right;
    }

    @Override
    protected Object getLeftObject() {
        return this.m_left;
    }

    @Override
    protected boolean inObjectRange(Object other) {
        return this.inRange((Double)other);
    }

    @Override
    public String getString(int precision) {
        if (Math.abs(this.getLeft() - this.getRight()) < 1.0E-6) {
            return "" + this.getRightString(precision);
        }
        return this.getLeftString(precision) + " ~ " + this.getRightString(precision);
    }
}

