/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.core;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.resource.JDFPart;
import org.cip4.jdflib.resource.JDFResource;

public class JDFRefElement
extends JDFElement {
    private static final long serialVersionUID = 1L;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[2];
    private static ElemInfoTable[] elemInfoTable;

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        AttributeInfo ai = AttributeInfo.fixedMap.get("JDFRefElement");
        if (ai != null) {
            return ai;
        }
        ai = super.getTheAttributeInfo().updateReplace(atrInfoTable);
        AttributeInfo.fixedMap.put("JDFRefElement", ai);
        return ai;
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        return super.getTheElementInfo().updateReplace(elemInfoTable);
    }

    public JDFRefElement(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFRefElement(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFRefElement(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Deprecated
    public boolean hasPart() {
        return this.hasChildElement("Part", null);
    }

    public void setrRef(String value) {
        this.setAttribute("rRef", value, "");
    }

    @Override
    public boolean fitsName(String nodeName, String nameSpaceURI) {
        return nodeName == null || nodeName.endsWith("Ref") ? this.fitsName_KElement(nodeName, nameSpaceURI) : this.fitsName_KElement(nodeName + "Ref", nameSpaceURI);
    }

    public String getrRef() {
        return this.getAttribute("rRef");
    }

    @Deprecated
    public void setrSubRef(String value) {
        this.setAttribute("rSubRef", value, "");
    }

    public String getrSubRef() {
        return this.getAttribute("rSubRef", "", "");
    }

    @Override
    public boolean isValid(JDFElement.EnumValidationLevel level) {
        boolean b = super.isValid(level);
        if (!b) {
            return false;
        }
        JDFResource r = this.getTarget();
        if (r == null) {
            return false;
        }
        if (!this.getNodeName().equals(r.getRefString())) {
            return false;
        }
        return this.validResourcePosition();
    }

    public boolean validResourcePosition() {
        return this.validResourcePosition(this.getTarget());
    }

    public JDFResource getTargetRoot() {
        if (this.hasAttribute("rSubRef")) {
            String s = this.getrSubRef();
            KElement subRef = this.getTarget_KElement(s, "ID");
            if (subRef instanceof JDFResource) {
                return (JDFResource)subRef;
            }
            return null;
        }
        JDFResource linkRoot = this.getLinkRoot(null);
        if (linkRoot != null && !this.getNodeName().equals(linkRoot.getRefString())) {
            return null;
        }
        return linkRoot;
    }

    @Override
    public JDFResource getTarget() {
        JDFResource targetRoot = this.getTargetRoot();
        if (targetRoot == null) {
            return null;
        }
        JDFAttributeMap partMap = this.getPartMap();
        if (partMap == null) {
            return targetRoot;
        }
        return targetRoot.getPartition(partMap, null);
    }

    public JDFPart getPart() {
        return (JDFPart)this.getElement("Part", "", 0);
    }

    public String getRefNodeName() {
        JDFResource target = this.getTargetRoot();
        if (target != null) {
            return target.getNodeName();
        }
        String nn = this.getNodeName();
        if (nn.endsWith("Ref")) {
            nn = nn.substring(0, nn.length() - "Ref".length());
            return nn;
        }
        return null;
    }

    public String getRefLocalName() {
        JDFResource target = this.getTargetRoot();
        if (target != null) {
            return target.getLocalName();
        }
        String nn = this.getLocalName();
        if (nn.endsWith("Ref")) {
            nn = nn.substring(0, nn.length() - "Ref".length());
            return nn;
        }
        return null;
    }

    public JDFElement inlineRef() {
        int i;
        JDFResource targetRes = this.getTarget();
        if (targetRes == null) {
            throw new JDFException("inlineRef: inlining null " + this.getLocalName() + " rRef=" + this.getrRef());
        }
        JDFResource newInline = (JDFResource)this.appendElement(targetRes.getNodeName(), null);
        newInline.setAttributes(targetRes);
        VElement v = targetRes.getChildElementVector(null, null, null, true, 0, false);
        for (i = 0; i < v.size(); ++i) {
            newInline.copyElement(v.item(i), null);
        }
        newInline.cleanResourceAttributes();
        VString partNames = targetRes.getPartIDKeys();
        for (i = 0; i < partNames.size(); ++i) {
            newInline.removeAttribute(partNames.elementAt(i), null);
        }
        this.replaceElement(newInline);
        targetRes.deleteUnLinked();
        return newInline;
    }

    public JDFElement deleteRef(boolean bCheckRefCount) {
        JDFResource e = this.getTarget();
        if (e != null) {
            if (bCheckRefCount) {
                e.deleteUnLinked();
            } else {
                e.deleteNode();
            }
        }
        return (JDFElement)this.deleteNode();
    }

    public JDFPart appendPart() {
        return (JDFPart)this.appendElementN("Part", 1, null);
    }

    public static String getRefName(String base) {
        return base + "Ref";
    }

    public JDFPart getCreatePart() {
        return (JDFPart)this.getCreateElement_KElement("Part", null, 0);
    }

    @Deprecated
    public void removePart() {
        this.removeChild("Part", null, 0);
    }

    @Override
    @Deprecated
    public VJDFAttributeMap getPartMapVector() {
        return new VJDFAttributeMap(this.getPartMap());
    }

    @Override
    public JDFAttributeMap getPartMap() {
        return super.getPartMap();
    }

    @Override
    public void setPartMap(JDFAttributeMap mPart) {
        super.setPartMap(mPart);
    }

    @Override
    public void removePartMap(JDFAttributeMap mPart) {
        super.removePartMap(mPart);
    }

    @Override
    public boolean hasPartMap(JDFAttributeMap mPart) {
        return super.hasPartMap(mPart);
    }

    static {
        JDFRefElement.atrInfoTable[0] = new AtrInfoTable("rSubRef", 0x44444433L, AttributeInfo.EnumAttributeType.IDREF, null, null);
        JDFRefElement.atrInfoTable[1] = new AtrInfoTable("rRef", 0x22222222L, AttributeInfo.EnumAttributeType.IDREF, null, null);
        elemInfoTable = new ElemInfoTable[1];
        JDFRefElement.elemInfoTable[0] = new ElemInfoTable("Part", 0x33333331L);
    }
}

