/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.extensions.MessageHelper;
import org.cip4.jdflib.extensions.XJDFHelper;
import org.cip4.jdflib.extensions.XJMFHelper;
import org.cip4.jdflib.ifaces.IStreamWriter;
import org.cip4.jdflib.ifaces.IURLSetter;
import org.cip4.jdflib.jmf.JDFMessage;
import org.cip4.jdflib.jmf.JDFQueueSubmissionParams;
import org.cip4.jdflib.jmf.JDFResubmissionParams;
import org.cip4.jdflib.jmf.JDFReturnQueueEntryParams;
import org.cip4.jdflib.util.NumberFormatter;
import org.cip4.jdflib.util.StreamUtil;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.UrlUtil;

public class XJDFZipWriter
implements IStreamWriter {
    private static final Log log = LogFactory.getLog(XJDFZipWriter.class);
    private XJMFHelper xjmf = null;
    private final ArrayList<XJDFHelper> vxjdf = new ArrayList();
    private final Map<String, InputStream> auxMap = new HashMap<String, InputStream>();
    private JDFMessage.EnumType commandType = JDFMessage.EnumType.SubmitQueueEntry;
    private String qeID;

    public void setXjmf(XJMFHelper xjmf) {
        this.xjmf = xjmf;
    }

    public void addXJDF(XJDFHelper xjdf) {
        this.addXJDF(xjdf, false);
    }

    public void addXJDF(XJDFHelper xjdf, boolean addReferenced) {
        this.vxjdf.add(xjdf);
        if (addReferenced) {
            VElement v = xjdf.getRoot().getChildrenByTagName(null);
            for (KElement e : v) {
                IURLSetter u;
                InputStream is;
                if (!(e instanceof IURLSetter) || (is = (u = (IURLSetter)((Object)e)).getURLInputStream()) == null) continue;
                String url = u.getURL();
                url = this.updateUrl(url);
                u.setURL(url);
                this.addAux(url, is);
            }
        }
    }

    String updateUrl(String url) {
        return "content/" + UrlUtil.getFileName(url, null);
    }

    public void addAux(String path, InputStream inStream) {
        if (inStream != null && !StringUtil.isEmpty(path)) {
            this.auxMap.put(path, inStream);
        }
    }

    void writeAux(ZipOutputStream zos) {
        for (String path : this.auxMap.keySet()) {
            this.writeAux(zos, path);
        }
    }

    public int numAux() {
        return this.auxMap.size();
    }

    void writeXJMF(ZipOutputStream zos) {
        this.ensureXJMF();
        try {
            ZipEntry ze = new ZipEntry("root.xjmf");
            zos.putNextEntry(ze);
            this.xjmf.writeToStream(zos);
            zos.closeEntry();
        }
        catch (Exception x) {
            log.error((Object)"oops: ", (Throwable)x);
        }
    }

    void writeXJDF(ZipOutputStream zos, XJDFHelper h, int i) {
        try {
            ZipEntry ze = new ZipEntry(this.getXJDFPath(i));
            zos.putNextEntry(ze);
            h.writeToStream(zos);
            zos.closeEntry();
        }
        catch (Exception x) {
            log.error((Object)"oops: ", (Throwable)x);
        }
    }

    void writeAux(ZipOutputStream zos, String path) {
        try {
            ZipEntry ze = new ZipEntry(path);
            zos.putNextEntry(ze);
            IOUtils.copy((InputStream)this.auxMap.get(path), (OutputStream)zos);
            zos.closeEntry();
        }
        catch (Exception x) {
            log.error((Object)"oops: ", (Throwable)x);
        }
    }

    void writeXJDFs(ZipOutputStream zos) {
        int i = 0;
        for (XJDFHelper h : this.vxjdf) {
            this.writeXJDF(zos, h, i++);
        }
    }

    XJMFHelper ensureXJMF() {
        JDFElement qsp;
        if (this.xjmf == null) {
            this.xjmf = new XJMFHelper();
        }
        MessageHelper mh = this.xjmf.getCreateMessage(JDFMessage.EnumFamily.Command, this.commandType, 0);
        if (JDFMessage.EnumType.SubmitQueueEntry.equals((Object)this.commandType)) {
            qsp = (JDFQueueSubmissionParams)mh.appendElement("QueueSubmissionParams");
        } else if (JDFMessage.EnumType.ResubmitQueueEntry.equals((Object)this.commandType)) {
            qsp = (JDFResubmissionParams)mh.appendElement("ResubmissionParams");
            ((JDFResubmissionParams)qsp).setQueueEntryID(this.qeID);
        } else if (JDFMessage.EnumType.ReturnQueueEntry.equals((Object)this.commandType)) {
            qsp = (JDFReturnQueueEntryParams)mh.appendElement("ReturnQueueEntryParams");
            ((JDFReturnQueueEntryParams)qsp).setQueueEntryID(this.qeID);
        } else {
            return null;
        }
        if (this.vxjdf.size() == 1) {
            qsp.setURL(this.getXJDFPath(0));
        } else if (this.vxjdf.size() > 1) {
            qsp.setURL("xjdf");
        }
        return this.xjmf;
    }

    protected String getXJDFPath(int i) {
        if (i >= 0 && i < this.vxjdf.size()) {
            XJDFHelper xjdfHelper = this.vxjdf.get(i);
            String jobPartID = xjdfHelper.getJobPartID();
            jobPartID = StringUtil.isEmpty(jobPartID) ? new NumberFormatter().formatInt(i, 2) : new NumberFormatter().formatInt(i, 2) + "." + jobPartID;
            return "xjdf/" + xjdfHelper.getJobID() + "." + jobPartID + ".xjdf";
        }
        return null;
    }

    @Override
    public void writeStream(OutputStream os) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(os);
        this.writeXJMF(zos);
        this.writeXJDFs(zos);
        this.writeAux(zos);
        zos.close();
        StreamUtil.close(os);
    }

    public String toString() {
        return "XJDFZipWriter [commandType=" + (Object)((Object)this.commandType) + ", qeID=" + this.qeID + ", xjmf=" + this.xjmf + ", vxjdf=" + this.vxjdf.size() + "]";
    }

    public JDFMessage.EnumType getCommandType() {
        return this.commandType;
    }

    public void setCommandType(JDFMessage.EnumType commandType) {
        if (!(JDFMessage.EnumType.SubmitQueueEntry.equals((Object)commandType) || JDFMessage.EnumType.ResubmitQueueEntry.equals((Object)commandType) || JDFMessage.EnumType.ReturnQueueEntry.equals((Object)commandType))) {
            throw new IllegalArgumentException("Invalid command type " + (Object)((Object)commandType));
        }
        this.commandType = commandType;
    }

    public String getQeID() {
        return this.qeID;
    }

    public void setQeID(String qeID) {
        this.qeID = qeID;
    }
}

