/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import java.util.List;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.JDFRefElement;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.StringArray;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.WalkJDFElement;
import org.cip4.jdflib.pool.JDFResourceLinkPool;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.intent.JDFProductionIntent;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.StringUtil;

public class WalkRefElement
extends WalkJDFElement {
    @Override
    public KElement walk(KElement jdf, KElement xjdf) {
        JDFRefElement refElem = (JDFRefElement)jdf;
        KElement parent = jdf.getParentNode_KElement();
        if (this.mustInline(parent, refElem.getRefLocalName()) && refElem.getTarget() != null) {
            try {
                JDFElement e = refElem.inlineRef();
                if (e != null && !(e instanceof JDFRefElement)) {
                    this.jdfToXJDF.walkTree(e, xjdf);
                }
            }
            catch (JDFException x) {
                this.log.error((Object)("Problems converting refElement: " + refElem.getNodeName()), (Throwable)x);
            }
        } else if (this.isProduct(refElem)) {
            this.refProduct(refElem, xjdf);
        } else if (this.wantRef(refElem)) {
            this.makeRefAttribute(refElem, xjdf);
        }
        return null;
    }

    boolean mustInline(KElement parent, String refLocalName) {
        boolean inline = this.mustInline(refLocalName);
        WalkJDFElement walker = inline ? null : (WalkJDFElement)this.jdfToXJDF.getFactory().getWalker(parent);
        inline = inline || walker != null && walker.mustInline(refLocalName);
        return inline;
    }

    private boolean wantRef(JDFRefElement refElem) {
        return !(refElem.getParentNode_KElement() instanceof JDFProductionIntent);
    }

    private void refProduct(JDFRefElement refElem, KElement xjdf) {
        String attName = "ItemRef";
        String id = this.jdfToXJDF.getProduct(refElem.getrRef());
        xjdf.appendAttribute("ItemRef", id, null, " ", true);
    }

    private boolean isProduct(JDFRefElement refElem) {
        return this.jdfToXJDF.getProduct(refElem.getrRef()) != null;
    }

    protected void makeRefAttribute(JDFRefElement re, KElement xjdf) {
        JDFAttributeMap map = this.getRefMap(re);
        String id = this.jdfToXJDF.completedRefs.get(map);
        String attName = this.getRefName(re);
        if (id != null) {
            xjdf.setAttribute(attName, id);
        } else {
            JDFResource target = re.getTarget();
            JDFResourceLink rl = this.getLinkForRef(re, target);
            KElement refRoot = this.getRefRoot(xjdf);
            if (rl != null) {
                this.setResource(rl, target, refRoot);
            }
            VJDFAttributeMap partMapVector = rl == null ? null : rl.getPartMapVector();
            boolean overlap = VJDFAttributeMap.isEmpty(partMapVector) || partMapVector.overlapsMap(re.getPartMap());
            List<KElement> v = overlap ? this.setResource(re, target, refRoot) : null;
            StringArray ids = new StringArray();
            if (v != null) {
                for (KElement ref : v) {
                    if (!ref.hasNonEmpty("ID")) {
                        ref.setID(ref.generateDotID("ID", null));
                    }
                    ids.add(ref.getID());
                }
                xjdf.appendAttributes(attName, ids, null, null, true);
                this.jdfToXJDF.completedRefs.put(map, StringUtil.setvString(ids));
            }
        }
        re.deleteNode();
    }

    JDFAttributeMap getRefMap(JDFRefElement re) {
        JDFAttributeMap map = new JDFAttributeMap("ID", re.getrRef());
        JDFAttributeMap partMap = re.getPartMap();
        ContainerUtil.putAll(map, partMap);
        return map;
    }

    protected void makeSetRefAttribute(JDFRefElement re, KElement xjdf) {
        String attName = this.getRefName(re);
        List<KElement> v = this.setResource(re, re.getTarget(), this.jdfToXJDF.newRoot);
        if (!ContainerUtil.isEmpty(v)) {
            KElement ref = v.get(0).getParentNode_KElement();
            xjdf.setAttribute(attName, ref.getID());
        }
        re.deleteNode();
    }

    private JDFResourceLink getLinkForRef(JDFRefElement re, JDFResource target) {
        JDFResourceLink rl = null;
        if (this.jdfToXJDF.oldRoot != null) {
            JDFResourceLinkPool resourceLinkPool = this.jdfToXJDF.oldRoot.getResourceLinkPool();
            rl = resourceLinkPool != null ? resourceLinkPool.getLink(target, null, null) : null;
        }
        return rl;
    }

    private KElement getRefRoot(KElement xjdf) {
        KElement ret = null;
        if (xjdf != null) {
            ret = xjdf.getDeepParent("ResourceInfo", 0);
        }
        return ret == null ? this.jdfToXJDF.newRoot : ret;
    }

    @Override
    public boolean matches(KElement toCheck) {
        return toCheck instanceof JDFRefElement;
    }
}

