/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import java.util.List;
import org.cip4.jdflib.core.JDFPartAmount;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.WalkSignal;
import org.cip4.jdflib.jmf.JDFResourceInfo;
import org.cip4.jdflib.jmf.JDFResourceQuParams;
import org.cip4.jdflib.jmf.JDFSignal;

public class WalkSignalResource
extends WalkSignal {
    private static final String[] moveAtts = new String[]{"JobID", "JobPartID", "QueueEntryID", "Scope"};

    @Override
    public boolean matches(KElement toCheck) {
        return !this.jdfToXJDF.isRetainAll() && toCheck instanceof JDFSignal && "Resource".equals(((JDFSignal)toCheck).getType());
    }

    @Override
    public KElement walk(KElement jdf, KElement xjdf) {
        this.moveFromQuParams(jdf);
        this.splitAmounts(jdf);
        return super.walk(jdf, xjdf);
    }

    void splitAmounts(KElement jdf) {
        List<JDFResourceInfo> vri = jdf.getChildArrayByClass(JDFResourceInfo.class, false, 0);
        for (JDFResourceInfo ri : vri) {
            double aa = ri.getAmountPoolSumDouble("ActualAmount", null);
            if (!(aa > 0.0)) continue;
            double a = ri.getAmountPoolSumDouble("Amount", null);
            if (a > 0.0 && !ri.hasNonEmpty("Scope")) {
                JDFResourceInfo ri2 = (JDFResourceInfo)jdf.copyElement(ri, ri);
                for (JDFPartAmount pa : ri2.getChildArrayByClass(JDFPartAmount.class, true, 0)) {
                    pa.removeAttribute("ActualAmount");
                }
                ri2.removeAttribute("ActualAmount");
                ri2.setAttribute("Scope", "Estimate");
            }
            for (JDFPartAmount pa : ri.getChildArrayByClass(JDFPartAmount.class, true, 0)) {
                pa.removeAttribute("Amount");
                pa.renameAttribute("ActualAmount", "Amount");
            }
            ri.removeAttribute("Amount");
            ri.renameAttribute("ActualAmount", "Amount");
            if (ri.hasNonEmpty("Scope")) continue;
            ri.setAttribute("Scope", "Job");
        }
    }

    void moveFromQuParams(KElement jdf) {
        JDFResourceQuParams rqp = ((JDFSignal)jdf).getCreateResourceQuParams(0);
        if (rqp != null) {
            VElement vRI = jdf.getChildElementVector("ResourceInfo", null);
            if (vRI != null) {
                for (KElement e : vRI) {
                    JDFResourceInfo ri = (JDFResourceInfo)e;
                    for (String att : moveAtts) {
                        if (ri.hasAttribute(att)) continue;
                        ri.copyAttribute(att, rqp);
                    }
                }
            }
            rqp.deleteNode();
        }
    }
}

