/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.jmf;

import java.util.Vector;
import org.cip4.jdflib.auto.JDFAutoDeviceFilter;
import org.cip4.jdflib.auto.JDFAutoDeviceInfo;
import org.cip4.jdflib.auto.JDFAutoNotification;
import org.cip4.jdflib.auto.JDFAutoQueueFilter;
import org.cip4.jdflib.auto.JDFAutoResourceInfo;
import org.cip4.jdflib.auto.JDFAutoResourceQuParams;
import org.cip4.jdflib.auto.JDFAutoShutDownCmdParams;
import org.cip4.jdflib.auto.JDFAutoStatusQuParams;
import org.cip4.jdflib.core.JDFAudit;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.jmf.JDFAbortQueueEntryParams;
import org.cip4.jdflib.jmf.JDFCommand;
import org.cip4.jdflib.jmf.JDFDeviceFilter;
import org.cip4.jdflib.jmf.JDFDeviceInfo;
import org.cip4.jdflib.jmf.JDFJMF;
import org.cip4.jdflib.jmf.JDFMessage;
import org.cip4.jdflib.jmf.JDFNewJDFCmdParams;
import org.cip4.jdflib.jmf.JDFNewJDFQuParams;
import org.cip4.jdflib.jmf.JDFQuery;
import org.cip4.jdflib.jmf.JDFQueueEntryDef;
import org.cip4.jdflib.jmf.JDFQueueFilter;
import org.cip4.jdflib.jmf.JDFQueueSubmissionParams;
import org.cip4.jdflib.jmf.JDFRequestQueueEntryParams;
import org.cip4.jdflib.jmf.JDFResourceInfo;
import org.cip4.jdflib.jmf.JDFResourceQuParams;
import org.cip4.jdflib.jmf.JDFResubmissionParams;
import org.cip4.jdflib.jmf.JDFShutDownCmdParams;
import org.cip4.jdflib.jmf.JDFSignal;
import org.cip4.jdflib.jmf.JDFStatusQuParams;
import org.cip4.jdflib.jmf.JDFStopPersChParams;
import org.cip4.jdflib.jmf.JDFSubscription;
import org.cip4.jdflib.jmf.JDFSubscriptionFilter;
import org.cip4.jdflib.node.NodeIdentifier;
import org.cip4.jdflib.resource.JDFMilestone;
import org.cip4.jdflib.resource.JDFNotification;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.util.StringUtil;

public class JMFBuilder
implements Cloneable {
    private String acknowledgeURL = null;
    private String senderID;
    private String agentName = JDFAudit.getStaticAgentName();
    private String agentVersion = JDFAudit.getStaticAgentVersion();

    public String getAcknowledgeURL() {
        return this.acknowledgeURL;
    }

    public void setAcknowledgeURL(String acknowledgeURL) {
        this.acknowledgeURL = acknowledgeURL;
    }

    public JMFBuilder() {
        this.senderID = JDFJMF.getTheSenderID();
    }

    public JDFJMF buildSuspendQueueEntry(String queueEntryId) {
        JDFJMF jmf = this.buildQueueEntryCommand(queueEntryId, JDFMessage.EnumType.SuspendQueueEntry);
        return jmf;
    }

    public JDFJMF buildHoldQueueEntry(String queueEntryId) {
        JDFJMF jmf = this.buildQueueEntryCommand(queueEntryId, JDFMessage.EnumType.HoldQueueEntry);
        return this.lastSteps(jmf);
    }

    public JDFJMF buildResumeQueueEntry(String queueEntryId) {
        JDFJMF jmf = this.buildQueueEntryCommand(queueEntryId, JDFMessage.EnumType.ResumeQueueEntry);
        return this.lastSteps(jmf);
    }

    public JDFJMF buildAbortQueueEntry(String queueEntryId) {
        JDFJMF jmf = this.buildQueueEntryCommand(queueEntryId, JDFMessage.EnumType.AbortQueueEntry);
        JDFAbortQueueEntryParams aqp = jmf.getCommand(0).getAbortQueueEntryParams();
        aqp.setEndStatus(JDFElement.EnumNodeStatus.Aborted);
        return this.lastSteps(jmf);
    }

    public JDFJMF buildReturnQueueEntry(String queueEntryId) {
        JDFJMF jmf = this.createJMF(JDFMessage.EnumFamily.Command, JDFMessage.EnumType.ReturnQueueEntry);
        JDFCommand command = jmf.getCommand(0);
        command.appendReturnQueueEntryParams().setQueueEntryID(queueEntryId);
        return this.lastSteps(jmf);
    }

    JDFJMF buildQueueEntryCommand(String queueEntryId, JDFMessage.EnumType typ) {
        if (queueEntryId == null) {
            return null;
        }
        JDFJMF jmf = this.createJMF(JDFMessage.EnumFamily.Command, typ);
        JDFCommand command = jmf.getCommand(0);
        String params = typ.getName() + "Params";
        KElement paramsEle = command.appendElement(params);
        JDFQueueFilter qf = (JDFQueueFilter)paramsEle.appendElement("QueueFilter");
        JDFQueueEntryDef qed = qf.appendQueueEntryDef(queueEntryId);
        return this.lastSteps(jmf);
    }

    public JDFJMF createJMF(JDFMessage.EnumFamily family, JDFMessage.EnumType typ) {
        JDFJMF jmf = JDFJMF.createJMF(family, typ);
        JDFMessage m = jmf.getMessageElement(null, null, 0);
        if (JDFMessage.EnumFamily.Command.equals((Object)family)) {
            JDFCommand c = (JDFCommand)m;
            if (this.acknowledgeURL != null) {
                c.setAcknowledgeURL(this.acknowledgeURL);
            }
        } else if (JDFMessage.EnumFamily.Query.equals((Object)family)) {
            JDFQuery q = (JDFQuery)m;
            if (this.acknowledgeURL != null) {
                q.setAcknowledgeURL(this.acknowledgeURL);
            }
        }
        jmf.setSenderID(this.senderID);
        jmf.setAgentName(this.agentName);
        jmf.setAgentVersion(this.agentVersion);
        m.setSenderID(this.senderID);
        m.setAgentName(this.agentName);
        m.setAgentVersion(this.agentVersion);
        return jmf;
    }

    JDFJMF lastSteps(JDFJMF jmf) {
        return jmf;
    }

    public JDFJMF buildRemoveQueueEntry(String queueEntryId) {
        JDFJMF jmf = this.buildQueueEntryCommand(queueEntryId, JDFMessage.EnumType.RemoveQueueEntry);
        return this.lastSteps(jmf);
    }

    public JDFJMF buildStatus(JDFAutoStatusQuParams.EnumDeviceDetails deviceDetails, JDFAutoStatusQuParams.EnumJobDetails jobDetails) {
        JDFJMF jmf = this.createJMF(JDFMessage.EnumFamily.Query, JDFMessage.EnumType.Status);
        JDFStatusQuParams statusQuParams = jmf.getCreateQuery(0).getCreateStatusQuParams(0);
        statusQuParams.setDeviceDetails(deviceDetails);
        statusQuParams.setJobDetails(jobDetails);
        return this.lastSteps(jmf);
    }

    public JDFJMF buildResourceQuery(boolean bExact) {
        JDFJMF jmf = this.createJMF(JDFMessage.EnumFamily.Query, JDFMessage.EnumType.Resource);
        JDFResourceQuParams resParams = jmf.getCreateQuery(0).getCreateResourceQuParams(0);
        resParams.setExact(bExact);
        return this.lastSteps(jmf);
    }

    public JDFJMF buildResourceSignal(boolean bExact, JDFResourceLink resLink) {
        JDFJMF jmf = this.buildResourceQuery(bExact);
        JDFJMF jmfSignal = this.createJMF(JDFMessage.EnumFamily.Signal, JDFMessage.EnumType.Resource);
        JDFSignal signal = jmfSignal.getSignal(0);
        if (resLink != null) {
            JDFResourceInfo.createResourceInfo(signal, resLink, bExact);
        }
        signal.setQuery(jmf.getQuery(0));
        signal.copyElement(jmf.getQuery(0).getResourceQuParams(), null);
        return this.lastSteps(jmfSignal);
    }

    public JDFJMF buildStatusSignal(JDFAutoStatusQuParams.EnumDeviceDetails deviceDetails, JDFAutoStatusQuParams.EnumJobDetails jobDetails) {
        JDFJMF jmf = this.buildStatus(deviceDetails, jobDetails);
        JDFJMF jmfSignal = this.createJMF(JDFMessage.EnumFamily.Signal, JDFMessage.EnumType.Status);
        JDFSignal signal = jmfSignal.getSignal(0);
        signal.setQuery(jmf.getQuery(0));
        signal.copyElement(jmf.getQuery(0).getStatusQuParams(), null);
        JDFDeviceInfo di = signal.appendDeviceInfo();
        di.setDeviceStatus(JDFAutoDeviceInfo.EnumDeviceStatus.Unknown);
        di.appendJobPhase();
        return this.lastSteps(jmfSignal);
    }

    public JDFJMF buildStatusSubscription(String subscriberURL, double repeatTime, int repeatStep, String queueEntryID) {
        JDFJMF jmf = this.buildSubscription(JDFMessage.EnumType.Status, subscriberURL, repeatTime, repeatStep);
        JDFQuery query = jmf.getQuery(0);
        JDFStatusQuParams statusQuParams = query.getCreateStatusQuParams(0);
        statusQuParams.setJobDetails(JDFAutoStatusQuParams.EnumJobDetails.Brief);
        statusQuParams.setDeviceDetails(JDFAutoStatusQuParams.EnumDeviceDetails.Brief);
        if (queueEntryID != null) {
            statusQuParams.setQueueEntryID(queueEntryID);
        }
        return this.lastSteps(jmf);
    }

    public JDFJMF buildResourceSubscription(String subscriberURL, double repeatTime, int repeatStep, String queueEntryID) {
        JDFJMF jmf = this.buildSubscription(JDFMessage.EnumType.Resource, subscriberURL, repeatTime, repeatStep);
        JDFQuery query = jmf.getQuery(0);
        JDFResourceQuParams resourceQuParams = query.getCreateResourceQuParams(0);
        Vector<JDFResource.EnumResourceClass> c = new Vector<JDFResource.EnumResourceClass>();
        c.add(JDFResource.EnumResourceClass.Consumable);
        c.add(JDFResource.EnumResourceClass.Handling);
        c.add(JDFResource.EnumResourceClass.Implementation);
        resourceQuParams.setClasses(c);
        if (queueEntryID != null) {
            resourceQuParams.setQueueEntryID(queueEntryID);
        }
        return this.lastSteps(jmf);
    }

    public JDFJMF buildKnownMessagesQuery() {
        return this.createQuery(JDFMessage.EnumType.KnownMessages).getJMFRoot();
    }

    public JDFJMF buildResourceCatalogQuery(String resType) {
        JDFQuery query = this.createQuery(JDFMessage.EnumType.Resource);
        JDFResourceQuParams quParams = query.getCreateResourceQuParams(0);
        quParams.setResourceName(resType);
        quParams.setExact(true);
        quParams.setResourceDetails(JDFAutoResourceQuParams.EnumResourceDetails.Full);
        quParams.setAttribute("Scope", JDFAutoResourceInfo.EnumScope.Allowed.getName());
        return query.getJMFRoot();
    }

    public JDFJMF buildMilestone(String milestoneType, String jobID) {
        JDFJMF jmf = this.createJMF(JDFMessage.EnumFamily.Signal, JDFMessage.EnumType.Notification);
        JDFSignal s = jmf.getSignal(0);
        JDFNotification n = s.appendNotification();
        n.setClass(JDFAutoNotification.EnumClass.Event);
        n.setJobID(jobID);
        JDFMilestone ms = n.appendMilestone();
        ms.setMilestoneType(milestoneType);
        return jmf;
    }

    public JDFJMF buildKnownSubscriptionsQuery(String url, String slaveQEID) {
        JDFQuery q = this.createQuery(JDFMessage.EnumType.KnownSubscriptions);
        JDFSubscriptionFilter sf = q.appendSubscriptionFilter();
        sf.setURL(url);
        sf.setQueueEntryID(slaveQEID);
        return q.getJMFRoot();
    }

    public JDFJMF buildSubmissionMethodsQuery() {
        return this.createQuery(JDFMessage.EnumType.SubmissionMethods).getJMFRoot();
    }

    public JDFJMF buildSubmitQueueEntry(String returnUrl) {
        return this.buildSubmitQueueEntry(returnUrl, null);
    }

    public JDFJMF buildSubmitQueueEntry(String returnUrl, String submitURL) {
        JDFCommand c = this.createCommand(JDFMessage.EnumType.SubmitQueueEntry);
        this.createDefaultFilter(c);
        JDFQueueSubmissionParams sp = c.appendQueueSubmissionParams();
        sp.setReturnJMF(returnUrl);
        sp.setURL(submitURL);
        return c.getJMFRoot();
    }

    private void createDefaultFilter(JDFCommand c) {
        JDFQueueFilter f = c.appendQueueFilter();
        f.setMaxEntries(0);
    }

    public JDFJMF buildKnownDevicesQuery(JDFAutoDeviceFilter.EnumDeviceDetails details) {
        JDFQuery q = this.createQuery(JDFMessage.EnumType.KnownDevices);
        JDFDeviceFilter deviceFilter = q.appendDeviceFilter();
        deviceFilter.setDeviceDetails(details);
        return q.getJMFRoot();
    }

    public JDFJMF buildNewJDFQuery(String jobID, String jobPartID) {
        JDFQuery q = this.createQuery(JDFMessage.EnumType.NewJDF);
        JDFNewJDFQuParams nqp = q.appendNewJDFQuParams();
        nqp.setIdentifier(new NodeIdentifier(jobID, jobPartID, null));
        return q.getJMFRoot();
    }

    public JDFJMF buildNewJDFCommand() {
        JDFCommand c = this.createCommand(JDFMessage.EnumType.NewJDF);
        JDFNewJDFCmdParams ncp = c.appendNewJDFCmdParams();
        ncp.appendIDInfo();
        return c.getJMFRoot();
    }

    public JDFJMF buildNotificationSubscription(String subscriberURL) {
        JDFJMF jmf = this.buildSubscription(JDFMessage.EnumType.Notification, subscriberURL, 0.0, 0);
        return jmf;
    }

    private JDFQuery createQuery(JDFMessage.EnumType typ) {
        JDFJMF jmf = this.createJMF(JDFMessage.EnumFamily.Query, typ);
        return jmf.getQuery(0);
    }

    private JDFCommand createCommand(JDFMessage.EnumType typ) {
        JDFJMF jmf = this.createJMF(JDFMessage.EnumFamily.Command, typ);
        return jmf.getCommand(0);
    }

    private JDFJMF buildSubscription(JDFMessage.EnumType typ, String subscriberURL, double repeatTime, int repeatStep) {
        JDFJMF jmf = this.createJMF(JDFMessage.EnumFamily.Query, typ);
        JDFQuery q = jmf.getQuery(0);
        JDFSubscription s = q.appendSubscription();
        s.setURL(subscriberURL);
        if (repeatTime > 0.0) {
            s.setRepeatTime(repeatTime);
        }
        if (repeatStep > 0) {
            s.setRepeatStep(repeatStep);
        }
        s.appendObservationTarget().setObservationPath("*");
        return jmf;
    }

    public JDFJMF buildQueueStatus() {
        JDFJMF jmf = this.createJMF(JDFMessage.EnumFamily.Query, JDFMessage.EnumType.QueueStatus);
        return jmf;
    }

    public JDFJMF buildQueueStatusSubscription(String subscriberURL) {
        JDFJMF jmf = this.buildSubscription(JDFMessage.EnumType.QueueStatus, subscriberURL, 0.0, 0);
        JDFQueueFilter filter = jmf.getQuery(0).appendQueueFilter();
        filter.setUpdateGranularity(JDFAutoQueueFilter.EnumUpdateGranularity.ChangesOnly);
        return jmf;
    }

    public JDFJMF buildRequestQueueEntry(String queueURL, NodeIdentifier nid) {
        JDFJMF jmf = this.createJMF(JDFMessage.EnumFamily.Command, JDFMessage.EnumType.RequestQueueEntry);
        JDFRequestQueueEntryParams qep = jmf.getCommand(0).appendRequestQueueEntryParams();
        qep.setQueueURL(queueURL);
        qep.setIdentifier(nid);
        return jmf;
    }

    public JDFJMF[] createSubscriptions(String url, String queueEntryID, double repeatTime, int repeatStep) {
        JDFJMF[] jmfs = new JDFJMF[]{this.buildStatusSubscription(url, repeatTime, repeatStep, queueEntryID), this.buildResourceSubscription(url, 0.0, 0, queueEntryID), this.buildNotificationSubscription(url), this.buildQueueStatusSubscription(url)};
        return jmfs;
    }

    public JDFJMF buildResubmitQueueEntry(String qeID, String url) {
        JDFCommand c = this.createCommand(JDFMessage.EnumType.ResubmitQueueEntry);
        this.createDefaultFilter(c);
        JDFResubmissionParams rp = c.appendResubmissionParams();
        rp.setQueueEntryID(qeID);
        rp.setURL(url);
        return c.getJMFRoot();
    }

    public JDFJMF buildShutdownCommand(JDFAutoShutDownCmdParams.EnumShutDownType typ) {
        JDFCommand c = this.createCommand(JDFMessage.EnumType.ShutDown);
        this.createDefaultFilter(c);
        JDFShutDownCmdParams cp = c.appendShutDownCmdParams();
        cp.setShutDownType(typ);
        return c.getJMFRoot();
    }

    public JDFJMF buildStopPersistentChannel(String channelID, String qeID, String url) {
        JDFCommand c = this.createCommand(JDFMessage.EnumType.StopPersistentChannel);
        JDFStopPersChParams scp = c.appendStopPersChParams();
        scp.setChannelID(channelID);
        scp.setURL(url);
        scp.setQueueEntryID(qeID);
        return c.getJMFRoot();
    }

    public JDFJMF newJMF(JDFMessage.EnumFamily family, String type) {
        JDFMessage.EnumType typ = JDFMessage.EnumType.getEnum(type);
        JDFJMF jmfRoot = JDFMessage.EnumType.Status.getName().equals(type) && JDFMessage.EnumFamily.Query.equals((Object)family) ? this.buildStatus(JDFAutoStatusQuParams.EnumDeviceDetails.Brief, JDFAutoStatusQuParams.EnumJobDetails.Brief) : (JDFMessage.EnumType.KnownDevices.getName().equals(type) && JDFMessage.EnumFamily.Query.equals((Object)family) ? this.buildKnownDevicesQuery(JDFAutoDeviceFilter.EnumDeviceDetails.Full) : this.createJMF(family, typ));
        return jmfRoot;
    }

    public String getSenderID() {
        return this.senderID;
    }

    public void setSenderID(String senderID) {
        this.senderID = senderID;
    }

    public JMFBuilder clone() {
        JMFBuilder bNew = new JMFBuilder();
        bNew.setAcknowledgeURL(this.getAcknowledgeURL());
        bNew.setSenderID(this.getSenderID());
        bNew.setAgentName(this.getAgentName());
        bNew.setAgentVersion(this.getAgentVersion());
        return bNew;
    }

    public String toString() {
        return "JMFBuilder [acknowledgeURL=" + this.acknowledgeURL + ", senderID=" + this.senderID + ", agentName=" + this.agentName + ", agentVersion=" + this.agentVersion + "]";
    }

    public String getAgentName() {
        return this.agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = StringUtil.getNonEmpty(agentName);
    }

    public String getAgentVersion() {
        return this.agentVersion;
    }

    public void setAgentVersion(String agentVersion) {
        this.agentVersion = StringUtil.getNonEmpty(agentVersion);
    }
}

