/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.pool;

import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.pool.JDFPool;
import org.cip4.jdflib.pool.JDFResourcePool;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.StringUtil;

public class JDFResourceLinkPool
extends JDFPool {
    private static final long serialVersionUID = 1L;

    public JDFResourceLinkPool(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFResourceLinkPool(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFResourceLinkPool(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        AttributeInfo ai = AttributeInfo.fixedMap.get("JDFResourceLinkPool");
        if (ai != null) {
            return ai;
        }
        ai = super.getTheAttributeInfo();
        AttributeInfo.fixedMap.put("JDFResourceLinkPool", ai);
        return ai;
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        return super.getTheElementInfo().updateAdd(JDFResourcePool.getLinkInfoTable());
    }

    @Override
    public String toString() {
        return "JDFResourceLinkPool[ --> " + super.toString() + " ]";
    }

    @Deprecated
    public VElement getLinks(JDFAttributeMap mLinkAtt) {
        return this.getPoolChildren(null, mLinkAtt, null);
    }

    @Deprecated
    public VElement getLinks(String elementName, String nameSpaceURI) {
        return this.getPoolChildren(elementName, null, nameSpaceURI);
    }

    @Deprecated
    public VElement getLinkedResources(String resName, JDFAttributeMap mLinkAtt, JDFAttributeMap mResAtt, boolean bFollowRefs) {
        return this.getLinkedResources(resName, mLinkAtt, mResAtt, bFollowRefs, null);
    }

    public VElement getLinkedResources(String resName, JDFAttributeMap mLinkAtt, JDFAttributeMap mResAtt, boolean bFollowRefs, String nameSpaceURI) {
        VElement vL = new VElement();
        VElement v = this.getPoolChildren(null, mLinkAtt, null);
        if (v != null) {
            if ((resName = StringUtil.getNonEmpty(resName)) != null && resName.endsWith("Link")) {
                resName = resName.substring(0, resName.length() - 4);
            }
            boolean bColon = JDFResourceLinkPool.xmlnsPrefix(resName) != null;
            int size = v.size();
            for (int i = 0; i < size; ++i) {
                boolean bNameMatches;
                JDFResourceLink l = (JDFResourceLink)v.elementAt(i);
                JDFResource linkRoot = l.getLinkRoot();
                if (linkRoot == null) continue;
                boolean bl = resName == null || (bColon ? linkRoot.getNodeName().equals(resName) : linkRoot.getLocalName().equals(resName)) ? true : (bNameMatches = false);
                if (bNameMatches && resName != null && JDFElement.isInJDFNameSpaceStatic(l) ^ JDFElement.isInJDFNameSpaceStatic(nameSpaceURI)) {
                    bNameMatches = bColon;
                }
                if (bNameMatches && !JDFElement.isInJDFNameSpaceStatic(nameSpaceURI)) {
                    bNameMatches = ContainerUtil.equals(nameSpaceURI, l.getNamespaceURI());
                }
                if (!bNameMatches || !linkRoot.includesAttributes(mResAtt, true)) continue;
                vL.addElement(linkRoot);
                if (!bFollowRefs) continue;
                vL.appendUnique(linkRoot.getvHRefRes(bFollowRefs, true));
            }
        }
        return vL;
    }

    @Deprecated
    public VElement getInOutLinks(boolean bInOut, boolean bLink, String resName, String resProcUsage) {
        return this.getInOutLinksExtended(bInOut ? JDFResourceLink.EnumUsage.Input : JDFResourceLink.EnumUsage.Output, bLink, resName, resProcUsage, null, true);
    }

    public VElement getInOutLinks(JDFResourceLink.EnumUsage usage, boolean bLink, String resName, JDFNode.EnumProcessUsage procUsage) {
        return this.getInOutLinksExtended(usage, bLink, resName, procUsage == null ? null : procUsage.getName(), null, true);
    }

    public VElement getInOutLinksExtended(JDFResourceLink.EnumUsage usage, boolean bLink, String resName, String procUsage, String namespaceURI, boolean bAll) {
        JDFAttributeMap mA;
        JDFAttributeMap jDFAttributeMap = mA = usage != null ? new JDFAttributeMap("Usage", usage.getName()) : null;
        if (JDFResourceLinkPool.isWildCard(procUsage)) {
            procUsage = null;
        }
        int loop1 = procUsage == null ? (bAll ? 1 : 0) : 1;
        VElement v0 = this.getPoolChildren(null, mA, null);
        for (int procUsageLoop = loop1; procUsageLoop < 2; ++procUsageLoop) {
            VElement v = new VElement();
            if (v0 == null || v0.size() == 0) {
                return v0;
            }
            v.addAll(v0);
            if (v != null) {
                for (int i = v.size() - 1; i >= 0; --i) {
                    JDFResourceLink li = (JDFResourceLink)v.elementAt(i);
                    if (!JDFResourceLinkPool.isWildCard(resName)) {
                        String linkedResourceName = li.getLinkedResourceName();
                        boolean fitsNamespace = li.getNamespaceURI().equals(namespaceURI);
                        boolean bl = fitsNamespace = fitsNamespace || JDFResourceLinkPool.isWildCard(namespaceURI) && JDFResourceLinkPool.isInJDFNameSpaceStatic(li);
                        if (!linkedResourceName.equals(resName) && (!fitsNamespace || fitsNamespace && !JDFResourceLinkPool.xmlnsLocalName(linkedResourceName).equals(resName))) {
                            v.removeElementAt(i);
                            continue;
                        }
                    }
                    String linkProcessUsage = StringUtil.getNonEmpty(li.getProcessUsage());
                    if ((procUsage == null || procUsage.equals(linkProcessUsage)) && (procUsage != null || linkProcessUsage == null || procUsageLoop != 0)) continue;
                    v.removeElementAt(i);
                }
            }
            if (v.size() <= 0 && procUsageLoop != 1) continue;
            v0 = v;
            break;
        }
        if (!bLink) {
            v0 = JDFResourceLinkPool.resourceVector(v0, null);
        }
        return v0;
    }

    public static VElement resourceVector(VElement linkVector, String resType) {
        if (linkVector == null) {
            return null;
        }
        VElement v = new VElement();
        boolean bResTypeWildcard = JDFResourceLinkPool.isWildCard(resType);
        for (KElement e : linkVector) {
            JDFResourceLink l = (JDFResourceLink)e;
            if (!bResTypeWildcard && !l.getLinkedResourceName().equals(resType)) continue;
            VElement vRes = l.getTargetVector(-1);
            v.addAll(vRes);
        }
        return v;
    }

    @Deprecated
    public JDFResourceLink appendResource(JDFResource r, boolean input, boolean bForce) {
        if (bForce) {
            bForce = true;
        }
        return this.linkResource(r, input ? JDFResourceLink.EnumUsage.Input : JDFResourceLink.EnumUsage.Output, null);
    }

    public JDFResourceLink getLink(JDFResource r, JDFResourceLink.EnumUsage usage, JDFNode.EnumProcessUsage processUsage) {
        if (r == null) {
            return null;
        }
        String id = r.getID();
        if (id == null) {
            return null;
        }
        VElement v = this.getInOutLinks(usage, true, null, processUsage);
        if (v != null) {
            int vSize = v.size();
            for (int i = 0; i < vSize; ++i) {
                JDFResourceLink resLink = (JDFResourceLink)v.elementAt(i);
                if (resLink == null || !resLink.getrRef().equals(id) || !resLink.getNodeName().equals(r.getLinkString())) continue;
                return resLink;
            }
        }
        return null;
    }

    public JDFResourceLink linkResource(JDFResource r, JDFResourceLink.EnumUsage usage, JDFNode.EnumProcessUsage processUsage) {
        if (r == null || usage == null) {
            return null;
        }
        String s = r.getID();
        if (JDFResourceLinkPool.isWildCard(s)) {
            s = r.getResourceRoot().appendAnchor(null);
        }
        JDFResourceLink rl = (JDFResourceLink)this.appendElement(r.getLinkString(), r.getNamespaceURI());
        rl.setTarget(r);
        rl.setUsage(usage);
        rl.setProcessUsage(processUsage);
        JDFNode parenNode = this.getParentJDF();
        try {
            parenNode.ensureValidRefsPosition(r);
        }
        catch (Exception x) {
            rl.deleteNode();
            rl = null;
        }
        return rl;
    }

    public VJDFAttributeMap getPartMapVector(boolean bComplete) {
        VJDFAttributeMap vMap = new VJDFAttributeMap();
        if (bComplete) {
            boolean bDone;
            VString vKeys = this.getPartIDKeys();
            int keySize = vKeys.size();
            Vector<VString> vvValues = new Vector<VString>();
            int[] pI = new int[keySize];
            int[] pISize = new int[keySize];
            for (int i = 0; i < keySize; ++i) {
                if (JDFResource.EnumPartIDKey.getEnum(vKeys.elementAt(i)) == null) continue;
                vvValues.addElement(this.getPartValues(JDFResource.EnumPartIDKey.getEnum(i)));
                pI[i] = 0;
                pISize[i] = ((VString)vvValues.elementAt(i)).size();
            }
            block1: do {
                JDFAttributeMap m = new JDFAttributeMap();
                bDone = false;
                for (int i = 0; i < keySize; ++i) {
                    m.put(vKeys.elementAt(i), ((VString)vvValues.elementAt(i)).elementAt(pI[i]));
                }
                vMap.addElement(m);
                for (int n = 0; n < keySize; ++n) {
                    int n2 = n;
                    pI[n2] = pI[n2] + 1;
                    if (pI[n2] < pISize[n]) continue block1;
                    pI[n] = 0;
                    if (n != keySize - 1) continue;
                    bDone = true;
                }
            } while (!bDone);
        } else {
            VElement links = this.getPoolChildren(null, null, null);
            if (links != null) {
                for (int l = 0; l < links.size(); ++l) {
                    JDFResourceLink link = (JDFResourceLink)links.elementAt(l);
                    VJDFAttributeMap tempMap = link.getPartMapVector();
                    for (int i = 0; i < tempMap.size(); ++i) {
                        JDFAttributeMap mTmp = tempMap.elementAt(i);
                        boolean bFound = false;
                        boolean bReplace = false;
                        for (int j = vMap.size() - 1; j >= 0; --j) {
                            JDFAttributeMap mAtt = vMap.elementAt(j);
                            if (!bReplace && mAtt.subMap(mTmp)) {
                                bFound = true;
                                break;
                            }
                            if (!mTmp.subMap(mAtt)) continue;
                            if (bReplace) {
                                int j1 = j;
                                vMap.set(j1, mTmp);
                            } else {
                                vMap.clear();
                            }
                            bReplace = true;
                        }
                        if (bFound) continue;
                        vMap.add(mTmp);
                    }
                }
            }
        }
        return vMap;
    }

    public VString getPartIDKeys() {
        VString vs = new VString();
        VElement links = this.getPoolChildren(null, null, null);
        if (links != null) {
            for (int i = 0; i < links.size(); ++i) {
                JDFResourceLink link = (JDFResourceLink)links.elementAt(i);
                VString keys = link.getLinkRoot().getPartIDKeys();
                for (int j = 0; j < keys.size(); ++j) {
                    if (vs.contains(keys.elementAt(j))) continue;
                    vs.addElement(keys.elementAt(j));
                }
            }
        }
        return vs;
    }

    public VString getPartValues(JDFResource.EnumPartIDKey partType) {
        VString vs = new VString();
        VElement links = this.getPoolChildren(null, null, null);
        if (links != null) {
            for (int i = 0; i < links.size(); ++i) {
                JDFResourceLink link = (JDFResourceLink)links.elementAt(i);
                VString keys = link.getLinkRoot().getPartValues(partType);
                for (int j = 0; j < keys.size(); ++j) {
                    if (vs.contains(keys.elementAt(j))) continue;
                    vs.addElement(keys.elementAt(j));
                }
            }
        }
        return vs;
    }

    public Vector<JDFResourceLink> getLinks() {
        return this.getChildrenByClass(JDFResourceLink.class, false, 0);
    }

    public List<JDFResourceLink> getLinkArray() {
        return this.getChildArrayByClass(JDFResourceLink.class, false, 0);
    }

    public VElement getPoolChildren(String strName, JDFAttributeMap mAttrib, String nameSpaceURI) {
        VElement v = this.getPoolChildrenGeneric(strName, mAttrib, nameSpaceURI);
        if (v == null) {
            return null;
        }
        for (int i = v.size() - 1; i >= 0; --i) {
            if (v.elementAt(i) instanceof JDFResourceLink) continue;
            v.removeElementAt(i);
        }
        return v.size() == 0 ? null : v;
    }

    public JDFResourceLink getPoolChild(int i, String strName, JDFAttributeMap mAttrib, String nameSpaceURI) {
        JDFResourceLink resLink = null;
        VElement v = this.getPoolChildren(strName, mAttrib, nameSpaceURI);
        if (v != null) {
            int size = v.size();
            if (i < 0 && (i = size + i) < 0) {
                return null;
            }
            if (size > i) {
                resLink = (JDFResourceLink)v.elementAt(i);
            }
        }
        return resLink;
    }

    @Override
    public VString getUnknownElements(boolean bIgnorePrivate, int nMax) {
        return this.getUnknownPoolElements(JDFElement.EnumPoolType.ResourceLinkPool, nMax);
    }

    @Override
    public HashSet<JDFElement> getAllRefs(HashSet<JDFElement> vDoneRefs, boolean bRecurse) {
        List<JDFResourceLink> vResourceLinks = this.getLinkArray();
        if (vResourceLinks != null) {
            for (JDFResourceLink rl : vResourceLinks) {
                JDFResource r;
                if (vDoneRefs.contains(rl)) continue;
                vDoneRefs.add(rl);
                if (!bRecurse || (r = rl.getLinkRoot()) == null || vDoneRefs.contains(r)) continue;
                vDoneRefs = r.getAllRefs(vDoneRefs, bRecurse);
            }
        }
        return vDoneRefs;
    }
}

