/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.enums.ValuedEnum;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoNotification;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.JDFAudit;
import org.cip4.jdflib.core.JDFComment;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.ifaces.IMatches;
import org.cip4.jdflib.ifaces.INodeIdentifiable;
import org.cip4.jdflib.ifaces.ISignalAudit;
import org.cip4.jdflib.jmf.JDFJMF;
import org.cip4.jdflib.jmf.JDFMessage;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.node.NodeIdentifier;
import org.cip4.jdflib.resource.JDFBarcode;
import org.cip4.jdflib.resource.JDFCounterReset;
import org.cip4.jdflib.resource.JDFError;
import org.cip4.jdflib.resource.JDFEvent;
import org.cip4.jdflib.resource.JDFFCNKey;
import org.cip4.jdflib.resource.JDFMilestone;
import org.cip4.jdflib.resource.JDFSystemTimeSet;
import org.cip4.jdflib.util.ContainerUtil;

public class JDFNotification
extends JDFAutoNotification
implements INodeIdentifiable,
ISignalAudit,
IMatches {
    private static final long serialVersionUID = 1L;
    private static ElemInfoTable[] elemInfoTable = new ElemInfoTable[7];
    private static AtrInfoTable[] atrInfoTable;

    public JDFNotification(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFNotification(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFNotification(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFNotification[  --> " + super.toString() + " ]";
    }

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        return super.getTheElementInfo().updateAdd(elemInfoTable);
    }

    @Override
    public VJDFAttributeMap getPartMapVector() {
        return super.getPartMapVector();
    }

    @Override
    public void setPartMapVector(VJDFAttributeMap vParts) {
        super.setPartMapVector(vParts);
    }

    @Override
    public void setPartMap(JDFAttributeMap mPart) {
        super.setPartMap(mPart);
    }

    @Override
    public void removePartMap(JDFAttributeMap mPart) {
        super.removePartMap(mPart);
    }

    @Override
    public boolean hasPartMap(JDFAttributeMap mPart) {
        return super.hasPartMap(mPart);
    }

    public JDFBarcode getCreateBarcode() {
        return (JDFBarcode)this.getCreateNotificationDetails(EnumNotificationDetails.Barcode);
    }

    public JDFBarcode appendBarcode() {
        return (JDFBarcode)this.appendNotificationDetails(EnumNotificationDetails.Barcode);
    }

    public JDFBarcode getBarcode() {
        JDFElement notificationDetails = this.getNotificationDetails();
        if (notificationDetails == null || !(notificationDetails instanceof JDFBarcode)) {
            return (JDFBarcode)this.getElement("Barcode");
        }
        return (JDFBarcode)notificationDetails;
    }

    public JDFFCNKey getCreateFCNKey() {
        return (JDFFCNKey)this.getCreateNotificationDetails(EnumNotificationDetails.FCNKey);
    }

    public JDFFCNKey appendFCNKey() {
        return (JDFFCNKey)this.appendNotificationDetails(EnumNotificationDetails.FCNKey);
    }

    public JDFFCNKey getFCNKey() {
        JDFElement notificationDetails = this.getNotificationDetails();
        if (notificationDetails == null || !(notificationDetails instanceof JDFFCNKey)) {
            return (JDFFCNKey)this.getElement("FCNKey");
        }
        return (JDFFCNKey)notificationDetails;
    }

    public JDFSystemTimeSet getCreateSystemTimeSet() {
        return (JDFSystemTimeSet)this.getCreateNotificationDetails(EnumNotificationDetails.SystemTimeSet);
    }

    public JDFSystemTimeSet appendSystemTimeSet() {
        return (JDFSystemTimeSet)this.appendNotificationDetails(EnumNotificationDetails.SystemTimeSet);
    }

    public JDFSystemTimeSet getSystemTimeSet() {
        JDFElement notificationDetails = this.getNotificationDetails();
        if (notificationDetails == null || !(notificationDetails instanceof JDFSystemTimeSet)) {
            return (JDFSystemTimeSet)this.getElement("SystemTimeSet");
        }
        return (JDFSystemTimeSet)notificationDetails;
    }

    public JDFCounterReset getCreateCounterReset() {
        return (JDFCounterReset)this.getCreateNotificationDetails(EnumNotificationDetails.CounterReset);
    }

    public JDFCounterReset appendCounterReset() {
        return (JDFCounterReset)this.appendNotificationDetails(EnumNotificationDetails.CounterReset);
    }

    public JDFCounterReset getCounterReset() {
        JDFElement notificationDetails = this.getNotificationDetails();
        if (notificationDetails == null || !(notificationDetails instanceof JDFCounterReset)) {
            return (JDFCounterReset)this.getElement("CounterReset");
        }
        return (JDFCounterReset)notificationDetails;
    }

    public String getCommentText() {
        JDFComment c = this.getComment(0);
        if (c == null) {
            return null;
        }
        return c.getText();
    }

    public JDFError getCreateError() {
        return (JDFError)this.getCreateNotificationDetails(EnumNotificationDetails.Error);
    }

    public JDFError appendError() {
        return (JDFError)this.appendNotificationDetails(EnumNotificationDetails.Error);
    }

    public JDFError getError() {
        JDFElement notificationDetails = this.getNotificationDetails();
        if (notificationDetails == null || !(notificationDetails instanceof JDFError)) {
            return (JDFError)this.getElement("Error");
        }
        return (JDFError)notificationDetails;
    }

    public JDFEvent getCreateEvent() {
        return (JDFEvent)this.getCreateNotificationDetails(EnumNotificationDetails.Event);
    }

    public JDFEvent appendEvent() {
        return (JDFEvent)this.appendNotificationDetails(EnumNotificationDetails.Event);
    }

    public JDFEvent setEvent(String eventID, String eventValue, String comment) {
        JDFEvent event = this.getCreateEvent();
        if (event == null) {
            return null;
        }
        event.setEventID(eventID);
        event.setEventValue(eventValue);
        this.setCommentText(comment);
        return event;
    }

    public void setNode(JDFNode n) {
        this.setNode(new NodeIdentifier(n));
    }

    public void setNode(NodeIdentifier identifier) {
        NodeIdentifier identifierLocal = identifier;
        if (identifierLocal == null) {
            identifierLocal = new NodeIdentifier(null);
        }
        this.setJobID(identifierLocal.getJobID());
        this.setJobPartID(identifierLocal.getJobPartID());
        this.setPartMapVector(identifierLocal.getPartMapVector());
    }

    public JDFElement appendNotificationDetails(EnumNotificationDetails details) {
        EnumNotificationDetails det = this.getNotificationDetailsType();
        if (det != null && !det.equals((Object)details)) {
            return null;
        }
        this.setType(details.getName());
        return (JDFElement)this.appendElementN(details.getName(), 1, null);
    }

    public JDFElement getCreateNotificationDetails(EnumNotificationDetails details) {
        JDFElement e = this.getNotificationDetails();
        if (e == null) {
            return this.appendNotificationDetails(details);
        }
        if (!details.getName().equals(e.getLocalName())) {
            return null;
        }
        this.setType(details.getName());
        return e;
    }

    public JDFElement getNotificationDetails() {
        EnumNotificationDetails det = this.getNotificationDetailsType();
        if (det == null) {
            return null;
        }
        return (JDFElement)this.getElement(det.getName(), null, 0);
    }

    public EnumNotificationDetails getNotificationDetailsType() {
        String s = this.getType();
        if (JDFNotification.isWildCard(s)) {
            return null;
        }
        return EnumNotificationDetails.getEnum(s);
    }

    public JDFEvent getEvent() {
        JDFElement notificationDetails = this.getNotificationDetails();
        if (notificationDetails == null || !(notificationDetails instanceof JDFEvent)) {
            return (JDFEvent)this.getElement("Event");
        }
        return (JDFEvent)notificationDetails;
    }

    public JDFMilestone getCreateMilestone() {
        return (JDFMilestone)this.getCreateNotificationDetails(EnumNotificationDetails.Milestone);
    }

    public JDFMilestone appendMilestone() {
        return (JDFMilestone)this.appendNotificationDetails(EnumNotificationDetails.Milestone);
    }

    public JDFMilestone getMilestone() {
        JDFElement notificationDetails = this.getNotificationDetails();
        if (notificationDetails == null || !(notificationDetails instanceof JDFMilestone)) {
            return (JDFMilestone)this.getElement("Milestone");
        }
        return (JDFMilestone)notificationDetails;
    }

    @Override
    public NodeIdentifier getIdentifier() {
        return new NodeIdentifier(this.getJobID(), this.getJobPartID(), this.getPartMapVector());
    }

    @Override
    public void setIdentifier(NodeIdentifier ni) {
        if (ni == null) {
            ni = new NodeIdentifier();
        }
        this.setJobID(ni.getJobID());
        this.setJobPartID(ni.getJobPartID());
        this.setPartMapVector(ni.getPartMapVector());
    }

    @Override
    public JDFJMF toSignalJMF() {
        JDFJMF newJMF = JDFJMF.createJMF(JDFMessage.EnumFamily.Signal, JDFMessage.EnumType.Notification);
        newJMF.getSignal(0).copyElement(this, null);
        return newJMF;
    }

    @Override
    public boolean matches(Object subset) {
        if (!(subset instanceof JDFNotification)) {
            return false;
        }
        JDFNotification other = (JDFNotification)subset;
        JDFAttributeMap map = this.getAttributeMap();
        JDFAttributeMap map2 = other.getAttributeMap();
        map.remove("ID");
        map2.remove("ID");
        map.remove("TimeStamp");
        map2.remove("TimeStamp");
        if (!map.equals(map2)) {
            return false;
        }
        if (!ContainerUtil.matches(this.getEmployee(0), other.getEmployee(0))) {
            return false;
        }
        if (!ContainerUtil.equals(this.getNotificationDetails(), other.getNotificationDetails())) {
            return false;
        }
        return ContainerUtil.matches(this.getCostCenter(), other.getCostCenter());
    }

    @Override
    public void setSeverity(JDFAudit.EnumSeverity s) {
        this.setAttribute("Severity", s, null);
    }

    @Override
    public JDFAudit.EnumSeverity getSeverity() {
        return JDFAudit.EnumSeverity.getEnum(this.getAttribute("Severity"));
    }

    static {
        JDFNotification.elemInfoTable[0] = new ElemInfoTable("Barcode", 0x33333333L);
        JDFNotification.elemInfoTable[1] = new ElemInfoTable("FCNKey", 0x33333333L);
        JDFNotification.elemInfoTable[2] = new ElemInfoTable("SystemTimeSet", 0x33333333L);
        JDFNotification.elemInfoTable[3] = new ElemInfoTable("CounterReset", 0x33333333L);
        JDFNotification.elemInfoTable[4] = new ElemInfoTable("Error", 0x33333333L);
        JDFNotification.elemInfoTable[5] = new ElemInfoTable("Event", 0x33333333L);
        JDFNotification.elemInfoTable[6] = new ElemInfoTable("Milestone", 0x33333333L);
        atrInfoTable = new AtrInfoTable[1];
        JDFNotification.atrInfoTable[0] = new AtrInfoTable("TimeStamp", 0x33333333L, AttributeInfo.EnumAttributeType.dateTime, null, null);
    }

    public static class EnumNotificationDetails
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumNotificationDetails Barcode = new EnumNotificationDetails("Barcode");
        public static final EnumNotificationDetails FCNKey = new EnumNotificationDetails("FCNKey");
        public static final EnumNotificationDetails SystemTimeSet = new EnumNotificationDetails("SystemTimeSet");
        public static final EnumNotificationDetails CounterReset = new EnumNotificationDetails("CounterReset");
        public static final EnumNotificationDetails Error = new EnumNotificationDetails("Error");
        public static final EnumNotificationDetails Event = new EnumNotificationDetails("Event");
        public static final EnumNotificationDetails Milestone = new EnumNotificationDetails("Milestone");

        private EnumNotificationDetails(String name) {
            super(name, m_startValue++);
        }

        public static EnumNotificationDetails getEnum(String enumName) {
            return (EnumNotificationDetails)EnumNotificationDetails.getEnum(EnumNotificationDetails.class, (String)enumName);
        }

        public static EnumNotificationDetails getEnum(int enumValue) {
            return (EnumNotificationDetails)EnumNotificationDetails.getEnum(EnumNotificationDetails.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumNotificationDetails.getEnumMap(EnumNotificationDetails.class);
        }

        public static List getEnumList() {
            return EnumNotificationDetails.getEnumList(EnumNotificationDetails.class);
        }

        public static Iterator iterator() {
            return EnumNotificationDetails.iterator(EnumNotificationDetails.class);
        }
    }
}

