/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource;

import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoPageList;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.datatypes.JDFIntegerList;
import org.cip4.jdflib.datatypes.JDFIntegerRangeList;
import org.cip4.jdflib.resource.process.JDFPageData;
import org.cip4.jdflib.util.StringUtil;
import org.w3c.dom.DOMException;

public class JDFPageList
extends JDFAutoPageList {
    private static final long serialVersionUID = 1L;

    public JDFPageList(CoreDocumentImpl myOwnerDocument, String qualifiedName) throws DOMException {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFPageList(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFPageList(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFPageList[  --> " + super.toString() + " ]";
    }

    public int getNPage() {
        Vector<JDFPageData> vPages = this.getChildrenByClass(JDFPageData.class, false, 0);
        if (vPages.size() > 0) {
            JDFPageData pd0 = vPages.get(0);
            if (pd0.hasAttribute("PageIndex")) {
                int max = 0;
                for (JDFPageData pd : vPages) {
                    JDFIntegerRangeList rl = pd.getPageIndex();
                    rl.normalize(true);
                    int n = rl.getElement(-1);
                    if (n < max) continue;
                    max = n + 1;
                }
                return max;
            }
            return vPages.size();
        }
        return 0;
    }

    public JDFPageData getPageDataByIndex(int index) {
        if (index < 0) {
            index += this.getNPage();
        }
        if (index < 0) {
            return null;
        }
        Vector<JDFPageData> vPages = this.getChildrenByClass(JDFPageData.class, false, 0);
        if (vPages.size() > 0) {
            JDFPageData pd0 = vPages.get(0);
            if (pd0.hasAttribute("PageIndex")) {
                for (JDFPageData pd : vPages) {
                    JDFIntegerRangeList rl = pd.getPageIndex();
                    if (!rl.inRange(index)) continue;
                    return pd;
                }
                return null;
            }
            return index < vPages.size() ? vPages.get(index) : null;
        }
        return null;
    }

    public void uniqueIndex() {
        block11: {
            block10: {
                if (this.isIndexed()) break block10;
                List<JDFPageData> v = this.getChildArrayByClass(JDFPageData.class, false, 0);
                if (v == null) break block11;
                for (int i = 0; i < v.size(); ++i) {
                    v.get(i).setPageIndex(i);
                }
                break block11;
            }
            if (!this.isNormal()) {
                List<JDFPageData> v = this.getChildArrayByClass(JDFPageData.class, false, 0);
                int lastEmpty = 0;
                if (v != null) {
                    int i;
                    int size = v.size();
                    for (i = 0; i < size; ++i) {
                        JDFPageData pageData = v.get(i);
                        JDFIntegerRangeList irl = pageData.getPageIndex();
                        if (irl != null && irl.size() > 0) {
                            JDFIntegerList il = irl.getIntegerList();
                            if (il.size() <= 1) continue;
                            pageData.setPageIndex(il.getInt(0));
                            for (int index = 1; index < il.size(); ++index) {
                                JDFPageData pd2 = (JDFPageData)this.copyElement(pageData, null);
                                pd2.setPageIndex(il.getInt(index));
                                v.add(pd2);
                            }
                            continue;
                        }
                        v.remove(pageData);
                        v.add(lastEmpty++, pageData);
                    }
                    for (i = 0; i < lastEmpty; ++i) {
                        v.remove(0).deleteNode();
                    }
                    Collections.sort(v, new KElement.SingleAttributeComparator("PageIndex", false, true, true));
                    for (i = 0; i < v.size(); ++i) {
                        JDFPageData pd = v.get(i);
                        int index = StringUtil.parseInt(pd.getAttribute("PageIndex"), -1);
                        if (index < i) {
                            pd.deleteNode();
                            v.remove(i);
                            --i;
                            continue;
                        }
                        while (index > i) {
                            JDFPageData newPageData = this.appendPageData();
                            v.add(i, newPageData);
                            newPageData.setPageIndex(i++);
                        }
                        this.moveElement(pd, null);
                    }
                }
            }
        }
    }

    public boolean isNormal() {
        JDFPageData pd = this.getFirstChildElement(JDFPageData.class);
        int i = 0;
        while (pd != null) {
            if (StringUtil.parseInt(pd.getAttribute("PageIndex"), -1) != i) {
                return false;
            }
            pd = pd.getNextSiblingElement(JDFPageData.class);
            ++i;
        }
        return true;
    }

    public boolean isIndexed() {
        for (JDFPageData pd = this.getPageData(0); pd != null; pd = pd.getNextSiblingElement(JDFPageData.class)) {
            if (StringUtil.getNonEmpty(pd.getAttribute("PageIndex", null, null)) != null) continue;
            return false;
        }
        return true;
    }
}

