/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.process;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang.enums.ValuedEnum;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoUsageCounter;
import org.cip4.jdflib.util.StringUtil;
import org.w3c.dom.DOMException;

public class JDFUsageCounter
extends JDFAutoUsageCounter {
    private static final long serialVersionUID = 1L;

    public JDFUsageCounter(CoreDocumentImpl myOwnerDocument, String qualifiedName) throws DOMException {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFUsageCounter(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFUsageCounter(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFUsageCounter[  --> " + super.toString() + " ]";
    }

    public void setCounterTypes(EnumCounterType enumVar) {
        this.setAttribute("CounterTypes", enumVar, null);
    }

    public void setCounterTypes(Vector<EnumCounterType> vVar) {
        String s = StringUtil.setvString(vVar);
        this.setAttribute("CounterTypes", s, null);
    }

    public void appendCounterType(EnumCounterType cType) {
        if (cType != null) {
            this.appendAttribute("CounterTypes", cType.getName(), null, null, true);
        }
    }

    public Vector<EnumCounterType> getEnumCounterTypes() {
        return this.getEnumerationsAttribute("CounterTypes", null, EnumCounterType.Auxiliary, false);
    }

    @Override
    public boolean matchesString(String namedResLink) {
        String idString;
        if (namedResLink == null) {
            return false;
        }
        String counterID = this.getCounterID();
        if (!JDFUsageCounter.isWildCard(counterID) && (idString = this.getLocalName() + ":" + counterID).equals(namedResLink)) {
            return true;
        }
        String ct = StringUtil.setvString(this.getCounterTypes(), "_", null, null);
        if (!JDFUsageCounter.isWildCard(ct) && namedResLink.equals(this.getLocalName() + ":" + ct)) {
            return true;
        }
        return super.matchesString(namedResLink);
    }

    public static class EnumCounterType
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumCounterType Blank = new EnumCounterType("Blank");
        public static final EnumCounterType Insert = new EnumCounterType("Insert");
        public static final EnumCounterType InsertPrefuser = new EnumCounterType("InsertPrefuser");
        public static final EnumCounterType OneSided = new EnumCounterType("OneSided");
        public static final EnumCounterType TwoSided = new EnumCounterType("TwoSided");
        public static final EnumCounterType NormalSize = new EnumCounterType("NormalSize");
        public static final EnumCounterType LargeSize = new EnumCounterType("LargeSize");
        public static final EnumCounterType Black = new EnumCounterType("Black");
        public static final EnumCounterType HighlightColor = new EnumCounterType("HighlightColor");
        public static final EnumCounterType Color = new EnumCounterType("Color");
        public static final EnumCounterType Separation = new EnumCounterType("Separation");
        public static final EnumCounterType Varnish = new EnumCounterType("Varnish");
        public static final EnumCounterType User = new EnumCounterType("User");
        public static final EnumCounterType Auxiliary = new EnumCounterType("Auxiliary");
        public static final EnumCounterType Impressions = new EnumCounterType("Impressions");
        public static final EnumCounterType Clicks = new EnumCounterType("Clicks");
        public static final EnumCounterType pt = new EnumCounterType("pt");

        private EnumCounterType(String name) {
            super(name, m_startValue++);
        }

        public static EnumCounterType getEnum(String enumName) {
            return (EnumCounterType)EnumCounterType.getEnum(EnumCounterType.class, (String)enumName);
        }

        public static EnumCounterType getEnum(int enumValue) {
            return (EnumCounterType)EnumCounterType.getEnum(EnumCounterType.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumCounterType.getEnumMap(EnumCounterType.class);
        }

        public static List getEnumList() {
            return EnumCounterType.getEnumList(EnumCounterType.class);
        }

        public static Iterator iterator() {
            return EnumCounterType.iterator(EnumCounterType.class);
        }
    }
}

