/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.util.StringUtil;

public class PlatformUtil {
    static int DEFAULT_CONNECTION_TIMEOUT = 10000;

    public static boolean isWindows() {
        return File.separator.equals("\\");
    }

    public static String getProperty(String key) {
        String property = System.getProperty(key);
        if (StringUtil.isEmpty(property)) {
            property = System.getenv(key);
        }
        return StringUtil.getNonEmpty(property);
    }

    public static String getJavaVersion() {
        return PlatformUtil.getProperty("java.version");
    }

    public static JDFAttributeMap listProperties(boolean java, boolean env) {
        JDFAttributeMap map = new JDFAttributeMap();
        if (java) {
            Properties props = System.getProperties();
            for (String string : props.stringPropertyNames()) {
                map.putNotNull(string, props.getProperty(string));
            }
        }
        if (env) {
            Map<String, String> envMap = System.getenv();
            for (Map.Entry entry : envMap.entrySet()) {
                map.putNotNull(entry.getKey(), entry.getValue());
            }
        }
        return map;
    }

    public static boolean hasProperty(String key) {
        return PlatformUtil.getProperty(key) != null;
    }

    @Deprecated
    public static int getConnectionTimeout() {
        return DEFAULT_CONNECTION_TIMEOUT;
    }
}

