/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.mime;

import java.util.Vector;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.core.JDFParser;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.UrlUtil;
import org.cip4.jdflib.util.mime.BodyPartHelper;

public class MimeHelper {
    protected Multipart theMultipart;
    private static boolean bNeedAParser = true;
    protected int markSize;
    protected static final Log log = LogFactory.getLog(MimeHelper.class);

    public MimeHelper() {
        if (bNeedAParser) {
            bNeedAParser = false;
            new JDFParser();
        }
        this.theMultipart = null;
        this.markSize = 1000000;
    }

    public MimeHelper(Multipart mp) {
        this();
        this.theMultipart = mp;
    }

    public int getCount() {
        try {
            return this.theMultipart == null ? 0 : this.theMultipart.getCount();
        }
        catch (MessagingException e) {
            log.error((Object)"Cannot get count", (Throwable)e);
            return 0;
        }
    }

    public Multipart getMultiPart() {
        return this.theMultipart;
    }

    public BodyPart getCreatePartByCID(String cid) {
        BodyPart bp = this.getPartByCID(cid);
        if (bp != null) {
            return bp;
        }
        BodyPartHelper bph = new BodyPartHelper();
        try {
            bph.setContentID(cid);
            this.theMultipart.addBodyPart(bph.getBodyPart());
            bp = bph.getBodyPart();
        }
        catch (MessagingException x) {
            log.error((Object)("Cannot create part; cid=" + cid), (Throwable)x);
        }
        return bp;
    }

    public BodyPartHelper getCreatePartByLocalName(String name) {
        BodyPartHelper bph = this.getPartHelperByLocalName(name);
        if (bph == null) {
            bph = new BodyPartHelper();
            try {
                bph.setFileName(name);
                this.theMultipart.addBodyPart(bph.getBodyPart());
            }
            catch (MessagingException x) {
                log.error((Object)("Cannot create part; name=" + name), (Throwable)x);
            }
        }
        return bph;
    }

    public BodyPart getPartByCID(String cid) {
        BodyPartHelper bph = this.getPartHelperByCID(cid);
        return bph == null ? null : bph.getBodyPart();
    }

    public BodyPartHelper getPartHelperByCID(String cid) {
        if (UrlUtil.isNotCID(cid = StringUtil.getNonEmpty(cid))) {
            log.debug((Object)("incorrect CID format: cid=" + cid));
            return null;
        }
        try {
            int i = 0;
            while (true) {
                BodyPartHelper bph;
                if ((bph = this.getBodyPartHelper(i)) == null) {
                    return null;
                }
                if (bph.matchesCID(cid)) {
                    return bph;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public BodyPartHelper getPartHelperByAttribute(String key, String value) {
        try {
            int i = 0;
            while (true) {
                BodyPartHelper bph;
                if ((bph = this.getBodyPartHelper(i)) == null) {
                    return null;
                }
                if (bph.matchesKey(key, value)) {
                    return bph;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public BodyPartHelper getBodyPartHelper(int i) {
        if (this.theMultipart == null) {
            return null;
        }
        try {
            BodyPart bp = this.theMultipart.getBodyPart(i);
            return new BodyPartHelper(bp);
        }
        catch (MessagingException e) {
            return null;
        }
    }

    public BodyPart[] getBodyParts() {
        Vector<BodyPart> v = new Vector<BodyPart>();
        try {
            int i = 0;
            while (true) {
                BodyPart bp = this.theMultipart.getBodyPart(i);
                v.add(bp);
                ++i;
            }
        }
        catch (MessagingException m) {
            return null;
        }
        catch (ArrayIndexOutOfBoundsException m) {
            if (v.size() == 0) {
                return null;
            }
            BodyPart[] ret = new BodyPart[v.size()];
            ret = v.toArray(ret);
            return ret;
        }
    }

    public int getMarkSize() {
        return this.markSize;
    }

    public void setMarkSize(int markSize) {
        this.markSize = markSize;
    }

    public BodyPartHelper getPartHelperByLocalName(String name) {
        if (!UrlUtil.isRelativeURL(name = StringUtil.getNonEmpty(name))) {
            log.info((Object)("incorrect URL local format: url=" + name));
            return null;
        }
        try {
            int i = 0;
            while (true) {
                BodyPartHelper bph;
                if ((bph = this.getBodyPartHelper(i)) == null) {
                    return null;
                }
                if (bph.matchesFileName(name)) {
                    return bph;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }
}

