/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.xml;

import java.io.OutputStream;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.XMLDoc;
import org.cip4.jdflib.ifaces.IStreamWriter;
import org.cip4.jdflib.util.StringUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XSLTransformHelper
implements IStreamWriter {
    public static final String JAVAX_XML_TRANSFORM_TRANSFORMER_FACTORY = "javax.xml.transform.TransformerFactory";
    private final KElement elem;
    private final XMLDoc xsl;
    private static final Log log = LogFactory.getLog(XSLTransformHelper.class);

    private static void setFactory() {
        String property = System.getProperty(JAVAX_XML_TRANSFORM_TRANSFORMER_FACTORY);
        if (StringUtil.isEmpty(property)) {
            System.setProperty(JAVAX_XML_TRANSFORM_TRANSFORMER_FACTORY, "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
            log.info((Object)("Setting javax.xml.transform.TransformerFactory to: " + System.getProperty(JAVAX_XML_TRANSFORM_TRANSFORMER_FACTORY)));
        } else {
            log.info((Object)("using predefined javax.xml.transform.TransformerFactory: " + System.getProperty(JAVAX_XML_TRANSFORM_TRANSFORMER_FACTORY)));
        }
    }

    public XSLTransformHelper(KElement e, XMLDoc xsl) {
        this.elem = e;
        this.xsl = xsl;
    }

    public XSLTransformHelper(XMLDoc d, XMLDoc xsl) {
        this(d.getRoot(), xsl);
    }

    public XMLDoc getTransformElement() {
        Node root;
        if (this.xsl == null) {
            return null;
        }
        DOMResult transformedResult = new DOMResult();
        this.getTransformedResult(transformedResult);
        Node transformedDoc = transformedResult.getNode();
        Node node = root = transformedDoc == null ? null : transformedDoc.getFirstChild();
        if (root == null) {
            return null;
        }
        XMLDoc xmlDoc = new XMLDoc((Document)transformedDoc);
        xmlDoc.copyMeta(this.elem.getOwnerDocument_KElement());
        return xmlDoc;
    }

    private void getTransformedResult(Result transformedResult) {
        DOMSource mySrc = new DOMSource(this.elem);
        DOMSource xslSrc = new DOMSource((Node)((Object)this.xsl.getMemberDocument()));
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer theTransformer = factory.newTransformer(xslSrc);
            theTransformer.transform(mySrc, transformedResult);
        }
        catch (TransformerException x) {
            log.error((Object)"error applying xsl transform ", (Throwable)x);
        }
    }

    @Override
    public void writeStream(OutputStream stream) {
        if (this.xsl != null && stream != null) {
            StreamResult transformedResult = new StreamResult(stream);
            this.getTransformedResult(transformedResult);
        }
    }

    static {
        XSLTransformHelper.setFactory();
    }
}

