/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.jmf;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.enums.ValuedEnum;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoJMF;
import org.cip4.jdflib.core.JDFAudit;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.jmf.JDFAcknowledge;
import org.cip4.jdflib.jmf.JDFCommand;
import org.cip4.jdflib.jmf.JDFMessage;
import org.cip4.jdflib.jmf.JDFQuery;
import org.cip4.jdflib.jmf.JDFQueueSubmissionParams;
import org.cip4.jdflib.jmf.JDFRegistration;
import org.cip4.jdflib.jmf.JDFResponse;
import org.cip4.jdflib.jmf.JDFResubmissionParams;
import org.cip4.jdflib.jmf.JDFReturnQueueEntryParams;
import org.cip4.jdflib.jmf.JDFSignal;
import org.cip4.jdflib.util.EnumUtil;

public class JDFJMF
extends JDFAutoJMF {
    private static final long serialVersionUID = 1L;
    private static String theSenderID = null;
    private static final Log mLog = LogFactory.getLog(JDFElement.class);

    public static JDFJMF parseFile(File file) {
        JDFDoc doc = JDFDoc.parseFile(file);
        return doc == null ? null : doc.getJMFRoot();
    }

    public static JDFJMF parseFile(String fileName) {
        JDFDoc doc = JDFDoc.parseFile(fileName);
        return doc == null ? null : doc.getJMFRoot();
    }

    public JDFJMF(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFJMF(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI == null ? JDFJMF.getSchemaURL() : myNamespaceURI, qualifiedName);
    }

    public JDFJMF(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI == null ? JDFJMF.getSchemaURL() : myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFJMF[ --> " + super.toString() + " ]";
    }

    @Override
    public boolean init() {
        super.init();
        this.setTimeStamp(null);
        this.setVersion(JDFJMF.getDefaultJDFVersion());
        JDFElement.EnumVersion version = this.getVersion(true);
        if (!JDFElement.EnumVersion.Version_1_3.isGreater(version)) {
            this.setMaxVersion(version);
            if (!JDFElement.EnumVersion.Version_1_4.isGreater(version)) {
                this.setAgentName(JDFAudit.getStaticAgentName());
                this.setAgentVersion(JDFAudit.getStaticAgentVersion());
            }
        }
        this.setXSIType("JMFRootMessage");
        if (theSenderID != null) {
            this.setSenderID(theSenderID);
        }
        return true;
    }

    @Override
    public JDFElement.EnumVersion getMaxVersion() {
        String version = this.getAttribute("MaxVersion", null, null);
        if (version == null) {
            return this.getVersion(false);
        }
        return JDFElement.EnumVersion.getEnum(version);
    }

    @Override
    public void setVersion(JDFElement.EnumVersion enumVer) {
        super.setVersion(enumVer);
        JDFElement.EnumVersion maxVersion = this.getMaxVersion(true);
        if (EnumUtil.aLessEqualsThanB(maxVersion, enumVer)) {
            this.setMaxVersion(enumVer);
        }
    }

    @Override
    public void setMaxVersion(JDFElement.EnumVersion enumVer) {
        this.setAttribute("MaxVersion", enumVer == null ? null : enumVer.getName(), null);
    }

    public JDFMessage getMessage(int i) {
        return this.getMessageElement(null, null, i);
    }

    @Deprecated
    public JDFCommand getCommand() {
        return this.getCommand(0, false);
    }

    @Deprecated
    public JDFCommand getCommand(int i, boolean bCreate) {
        if (bCreate) {
            return (JDFCommand)this.getCreateMessageElement(JDFMessage.EnumFamily.Command, null, i);
        }
        return (JDFCommand)this.getMessageElement(JDFMessage.EnumFamily.Command, null, i);
    }

    @Deprecated
    public JDFQuery getQuery() {
        return this.getQuery(0, false);
    }

    @Deprecated
    public JDFQuery getQuery(int i, boolean bCreate) {
        if (bCreate) {
            return (JDFQuery)this.getCreateMessageElement(JDFMessage.EnumFamily.Query, null, i);
        }
        return (JDFQuery)this.getMessageElement(JDFMessage.EnumFamily.Query, null, i);
    }

    @Deprecated
    public JDFResponse getResponse() {
        return this.getResponse(0, false);
    }

    @Deprecated
    public JDFResponse getResponse(int i, boolean bCreate) {
        if (bCreate) {
            return (JDFResponse)this.getCreateMessageElement(JDFMessage.EnumFamily.Response, null, i);
        }
        return (JDFResponse)this.getMessageElement(JDFMessage.EnumFamily.Response, null, i);
    }

    @Deprecated
    public JDFSignal getSignal() {
        return this.getSignal(0, false);
    }

    @Deprecated
    public JDFSignal getSignal(int i, boolean bCreate) {
        if (bCreate) {
            return (JDFSignal)this.getCreateMessageElement(JDFMessage.EnumFamily.Signal, null, i);
        }
        return (JDFSignal)this.getMessageElement(JDFMessage.EnumFamily.Signal, null, i);
    }

    public JDFMessage getCreateMessageElement(JDFMessage.EnumFamily family, JDFMessage.EnumType typ, int i) {
        if (family == null) {
            throw new JDFException("GetMessageElement: creating undefined message family");
        }
        JDFMessage m = this.getMessageElement(family, typ, i);
        if (m == null) {
            m = this.appendMessageElement(family, typ);
        }
        return m;
    }

    @Deprecated
    public JDFMessage getCreateMessageElement(JDFMessage.EnumFamily family, int i) {
        return this.getCreateMessageElement(family, null, i);
    }

    @Deprecated
    public JDFMessage appendMessageElement(JDFMessage.EnumFamily family) {
        return this.appendMessageElement(family, null);
    }

    public static JDFJMF createJMF(JDFMessage.EnumFamily family, JDFMessage.EnumType typ) {
        if (family == null) {
            throw new JDFException("createJMF: creating undefined message family");
        }
        JDFJMF jmf = new JDFDoc("JMF").getJMFRoot();
        jmf.appendMessageElement(family, typ);
        return jmf;
    }

    public JDFMessage appendMessageElement(JDFMessage.EnumFamily family, JDFMessage.EnumType typ) {
        if (family == null) {
            throw new JDFException("appendMessageElement: creating undefined message family");
        }
        String sFamily = family.getName();
        JDFMessage m = (JDFMessage)this.appendElement(sFamily, null);
        if (typ != null) {
            m.setType(typ);
        }
        return m;
    }

    @Deprecated
    public JDFMessage getMessageElement(JDFMessage.EnumFamily family, int i) {
        return this.getMessageElement(family, null, i);
    }

    public JDFMessage getMessageElement(JDFMessage.EnumFamily family, JDFMessage.EnumType typ, int i) {
        if (i < 0) {
            JDFMessage message = null;
            VElement v = this.getMessageVector(family, typ);
            if (v != null) {
                int siz = v.size();
                i = siz + i;
                message = (JDFMessage)(i >= 0 ? v.get(i) : null);
            }
            return message;
        }
        String typString = typ == null ? null : typ.getName();
        String familyString = family == null ? null : family.getName();
        int n = 0;
        for (KElement e = this.getElement(familyString, null, 0); e != null; e = e.getNextSiblingElement(familyString, null)) {
            if (!(e instanceof JDFMessage)) continue;
            JDFMessage m = (JDFMessage)e;
            if (typString != null && !typString.equals(m.getType()) || n++ < i) continue;
            return m;
        }
        return null;
    }

    @Deprecated
    public VElement getMessageVector() {
        return this.getMessageVector(null, null);
    }

    @Deprecated
    public VElement getMessageVector(JDFMessage.EnumFamily family) {
        return this.getMessageVector(family, null);
    }

    public static VElement getMessageVector(JDFDoc doc, JDFMessage.EnumFamily family, JDFMessage.EnumType typ) {
        if (doc == null) {
            return null;
        }
        JDFJMF jmf = doc.getJMFRoot();
        if (jmf == null) {
            return null;
        }
        VElement vM = jmf.getMessageVector(family, typ);
        return vM.size() == 0 ? null : vM;
    }

    public VElement getMessageVector(JDFMessage.EnumFamily family, JDFMessage.EnumType typ) {
        String sFamily = family != null ? family.getName() : null;
        JDFAttributeMap typMap = typ == null ? null : new JDFAttributeMap("Type", typ.getName());
        VElement vM = this.getChildrenByTagName(sFamily, null, typMap, true, true, 0);
        if (family == null) {
            for (int i = vM.size() - 1; i >= 0; --i) {
                if (vM.elementAt(i) instanceof JDFMessage) continue;
                vM.removeElementAt(i);
            }
        }
        return vM;
    }

    @Deprecated
    public JDFAcknowledge getAcknowledge() {
        return this.getAcknowledge(0, false);
    }

    @Deprecated
    public JDFAcknowledge getAcknowledge(int i, boolean bCreate) {
        if (bCreate) {
            return (JDFAcknowledge)this.getCreateMessageElement(JDFMessage.EnumFamily.Acknowledge, null, i);
        }
        return (JDFAcknowledge)this.getMessageElement(JDFMessage.EnumFamily.Acknowledge, null, i);
    }

    public JDFCommand appendCommand(JDFMessage.EnumType typ) {
        return (JDFCommand)this.appendMessageElement(JDFMessage.EnumFamily.Command, typ);
    }

    public JDFRegistration appendRegistration(JDFMessage.EnumType typ) {
        return (JDFRegistration)this.appendMessageElement(JDFMessage.EnumFamily.Registration, typ);
    }

    public JDFQuery appendQuery(JDFMessage.EnumType typ) {
        return (JDFQuery)this.appendMessageElement(JDFMessage.EnumFamily.Query, typ);
    }

    public JDFSignal appendSignal(JDFMessage.EnumType typ) {
        return (JDFSignal)this.appendMessageElement(JDFMessage.EnumFamily.Signal, typ);
    }

    public JDFResponse appendResponse(JDFMessage.EnumType typ) {
        return (JDFResponse)this.appendMessageElement(JDFMessage.EnumFamily.Response, typ);
    }

    public JDFAcknowledge appendAcknowledge(JDFMessage.EnumType typ) {
        return (JDFAcknowledge)this.appendMessageElement(JDFMessage.EnumFamily.Acknowledge, typ);
    }

    public static String getTheSenderID() {
        return theSenderID;
    }

    public static void setTheSenderID(String _theSenderID) {
        theSenderID = _theSenderID;
    }

    public JDFJMF createResponse() {
        VElement v = this.getMessageVector(null, null);
        JDFJMF jmf = new JDFDoc("JMF").getJMFRoot();
        for (int i = 0; i < v.size(); ++i) {
            JDFMessage m = (JDFMessage)v.elementAt(i);
            JDFMessage.EnumFamily family = m.getFamily();
            if (family == null || JDFMessage.EnumFamily.Response == family) continue;
            if (!m.hasAttribute("ID")) {
                m.appendAnchor(null);
            }
            JDFResponse r = jmf.appendResponse();
            r.setQuery(m);
        }
        return jmf;
    }

    public VString collectICSVersions() {
        VElement v = this.getMessageVector(null, null);
        VString vICS = this.getICSVersions();
        for (int i = 0; i < v.size(); ++i) {
            JDFMessage m = (JDFMessage)v.elementAt(i);
            if (!m.hasAttribute("ICSVersions")) continue;
            vICS.addAll(m.getICSVersions());
        }
        vICS.unify();
        this.setICSVersions(vICS.size() == 0 ? null : vICS);
        return vICS;
    }

    public void convertResponses(JDFQuery q) {
        JDFMessage.EnumType t = q == null ? null : q.getEnumType();
        VElement v = this.getMessageVector(JDFMessage.EnumFamily.Response, t);
        String queryID = q == null ? null : q.getID();
        for (int i = 0; i < v.size(); ++i) {
            JDFResponse r = (JDFResponse)v.elementAt(i);
            if (queryID != null && !queryID.equals(r.getrefID())) continue;
            JDFSignal s = this.appendSignal();
            this.moveElement(s, r);
            s.convertResponse(r, q);
            r.deleteNode();
        }
    }

    public String getSubmissionURL() {
        JDFCommand cSubmit = (JDFCommand)this.getMessageElement(JDFMessage.EnumFamily.Command, JDFMessage.EnumType.SubmitQueueEntry, 0);
        if (cSubmit != null) {
            JDFQueueSubmissionParams qsp = cSubmit.getQueueSubmissionParams(0);
            return qsp == null ? null : (JDFJMF.isWildCard(qsp.getURL()) ? null : qsp.getURL());
        }
        cSubmit = (JDFCommand)this.getMessageElement(JDFMessage.EnumFamily.Command, JDFMessage.EnumType.ResubmitQueueEntry, 0);
        if (cSubmit != null) {
            JDFResubmissionParams rsp = cSubmit.getResubmissionParams(0);
            return rsp == null ? null : (JDFJMF.isWildCard(rsp.getURL()) ? null : rsp.getURL());
        }
        cSubmit = (JDFCommand)this.getMessageElement(JDFMessage.EnumFamily.Command, JDFMessage.EnumType.ReturnQueueEntry, 0);
        if (cSubmit != null) {
            JDFReturnQueueEntryParams rsp = cSubmit.getReturnQueueEntryParams(0);
            return rsp == null ? null : (JDFJMF.isWildCard(rsp.getURL()) ? null : rsp.getURL());
        }
        return null;
    }

    public JDFAcknowledge getAcknowledge(String refID) {
        return (JDFAcknowledge)this.getChildWithAttribute("Acknowledge", "refID", null, refID, 0, true);
    }

    public JDFResponse getResponse(String refID) {
        return (JDFResponse)this.getChildWithAttribute("Response", "refID", null, refID, 0, true);
    }

    public static class EnumJMFReturnCode
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        public static final EnumJMFReturnCode SUCCESS = new EnumJMFReturnCode(0, "Success");
        public static final EnumJMFReturnCode GENERAL_ERROR = new EnumJMFReturnCode(1, "General error");
        public static final EnumJMFReturnCode INTERNAL_ERROR = new EnumJMFReturnCode(2, "Internal error");
        public static final EnumJMFReturnCode XML_PARSER = new EnumJMFReturnCode(3, "XML parser error, e.g., if a MIME file is sent to an XML controller. ");
        public static final EnumJMFReturnCode XML_VALIDATION = new EnumJMFReturnCode(4, "XML validation error");
        public static final EnumJMFReturnCode MESSAGE_NOT_IMPLEMENTED = new EnumJMFReturnCode(5, "Query/command not implemented");
        public static final EnumJMFReturnCode INVALID_PARAMETER = new EnumJMFReturnCode(6, "Invalid parameters");
        public static final EnumJMFReturnCode INSUFFICIENT_PARAMETER = new EnumJMFReturnCode(7, "Insufficient parameters");
        public static final EnumJMFReturnCode DEVICE_NOT_AVAILABLE = new EnumJMFReturnCode(8, "Device not available (controller exists but not the device or queue)");
        public static final EnumJMFReturnCode MESSAGE_INCOMPLETE = new EnumJMFReturnCode(9, "Message incomplete.");
        public static final EnumJMFReturnCode MESSAGESERVICE_BUSY = new EnumJMFReturnCode(10, "Message Service is busy");
        public static final EnumJMFReturnCode DEVICE_NOT_RUNNING = new EnumJMFReturnCode(100, "Device not running");
        public static final EnumJMFReturnCode INCAPABLE_REQUEST = new EnumJMFReturnCode(101, "Device incapable of fulfilling request");
        public static final EnumJMFReturnCode NO_EXCUTABLE_NODE = new EnumJMFReturnCode(102, "No executable node exists in the JDF");
        public static final EnumJMFReturnCode UNKNOWN_JOB_ID = new EnumJMFReturnCode(103, "Job ID not known by controller");
        public static final EnumJMFReturnCode UNKNOWN_JOBPART_ID = new EnumJMFReturnCode(104, "JobPartID not known by controller");
        public static final EnumJMFReturnCode UNKNOWN_QUEUE_ENRTY = new EnumJMFReturnCode(105, "Queue entry not in queue");
        public static final EnumJMFReturnCode QUEUE_ENRTY_ALREADY_EXECUTED = new EnumJMFReturnCode(106, "Queue request failed because queue entry is already executing");
        public static final EnumJMFReturnCode NO_CHANGE_EXECUTING_QUEUE_ENRTY = new EnumJMFReturnCode(107, "Queue entry is already executing. Late change is not accepted");
        public static final EnumJMFReturnCode RESULT_SELECTION_EMPTY = new EnumJMFReturnCode(108, "Selection or applied filter results in an empty list");
        public static final EnumJMFReturnCode RESULT_SELECTION_INCOMPLETE = new EnumJMFReturnCode(109, "Selection or applied filter results in an incomplete list. A buffer cannot provide the complete list queried for");
        public static final EnumJMFReturnCode REQUEST_FAILED_COMPLETION_TIME = new EnumJMFReturnCode(110, "Queue request of a job submission failed because the requested completion time of the job can-not be fulfilled");
        public static final EnumJMFReturnCode SUBSCRIPTION_REQUEST_DENIED = new EnumJMFReturnCode(111, "Subscription request denied");
        public static final EnumJMFReturnCode QUEUE_CLOSED = new EnumJMFReturnCode(112, "Queue request failed because the Queue is closed and does not accept new entries");
        public static final EnumJMFReturnCode QUEUE_ENTRY_ALREADY_IN_STATUS = new EnumJMFReturnCode(113, "Queue entry is already in the resulting status");
        public static final EnumJMFReturnCode QUEUE_ENTRY_COMPLETED_OR_ABORTED = new EnumJMFReturnCode(114, "Queue entry is already completed or aborted and therefore does not accept changes");
        public static final EnumJMFReturnCode QUEUE_ENTRY_NOT_RUNNING = new EnumJMFReturnCode(115, "Queue entry is not running");
        public static final EnumJMFReturnCode QUEUE_ENTRY_EXISTS = new EnumJMFReturnCode(116, "Queue entry already exists");
        public static final EnumJMFReturnCode URL_INACCESSIBLE = new EnumJMFReturnCode(120, "URL is not accessible");
        public static final EnumJMFReturnCode UNKNOWN_DEVICEID = new EnumJMFReturnCode(121, "Unknown DeviceID");
        public static final EnumJMFReturnCode GANGING_NOT_SUPPORTED = new EnumJMFReturnCode(130, "Ganging not supported");
        public static final EnumJMFReturnCode UNKNOWN_GANGNAME = new EnumJMFReturnCode(131, " Unknown Gang name");
        public static final EnumJMFReturnCode INVALID_RESOURCE_PARAMETERS = new EnumJMFReturnCode(200, "Invalid resource parameters");
        public static final EnumJMFReturnCode INSUFFICIENT_RESOURCE_PARAMETERS = new EnumJMFReturnCode(201, "Insufficient resource parameters");
        public static final EnumJMFReturnCode PIPE_UNKNOWN = new EnumJMFReturnCode(202, "Pipe unknown");
        public static final EnumJMFReturnCode UNLINKED_RESOURCE_LINK = new EnumJMFReturnCode(203, "Unlinked resource link");
        public static final EnumJMFReturnCode JDF_NOT_CREATED = new EnumJMFReturnCode(204, "Could not create new JDF node");
        public static final EnumJMFReturnCode AUTHENTICATION_DENIED = new EnumJMFReturnCode(300, "Authentication Denied");
        public static final EnumJMFReturnCode SECURE_NOT_SUPPORTED = new EnumJMFReturnCode(301, "Secure channel not supported");
        public static final EnumJMFReturnCode SECURE_REQUIRED = new EnumJMFReturnCode(302, "Secure channel required");
        public static final EnumJMFReturnCode CERTIFICATE_EXPIRED = new EnumJMFReturnCode(303, "Certificate is expired");
        public static final EnumJMFReturnCode AUTHENTICATION_PENDING = new EnumJMFReturnCode(304, "Authentication pending");
        public static final EnumJMFReturnCode AUTHENTICATION_ESTABLISHED = new EnumJMFReturnCode(305, "Authentication already established");
        public static final EnumJMFReturnCode NO_AUTHENTICATION_IN_PROCESS = new EnumJMFReturnCode(306, "No Authentication in process");
        public static final EnumJMFReturnCode CERTIFICATE_INVALID = new EnumJMFReturnCode(307, "Certificate is invalid");

        private EnumJMFReturnCode(int code, String message) {
            super(message, code);
        }

        public static EnumJMFReturnCode getEnum(String message) {
            return (EnumJMFReturnCode)EnumJMFReturnCode.getEnum(EnumJMFReturnCode.class, (String)message);
        }

        public static EnumJMFReturnCode getEnum(int code) {
            return (EnumJMFReturnCode)EnumJMFReturnCode.getEnum(EnumJMFReturnCode.class, (int)code);
        }

        public static Map getEnumMap() {
            return EnumJMFReturnCode.getEnumMap(EnumJMFReturnCode.class);
        }

        public static List getEnumList() {
            return EnumJMFReturnCode.getEnumList(EnumJMFReturnCode.class);
        }

        public static Iterator iterator() {
            return EnumJMFReturnCode.iterator(EnumJMFReturnCode.class);
        }
    }
}

