/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.process;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoMedia;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.datatypes.JDFXYPair;
import org.cip4.jdflib.ifaces.IMatches;
import org.cip4.jdflib.util.StringUtil;

public class JDFMedia
extends JDFAutoMedia
implements IMatches {
    private static final long serialVersionUID = 1L;

    public static JDFAutoMedia.EnumISOPaperSubstrate getIsoPaperFromGrade(int grade) {
        if (grade == 1) {
            return JDFAutoMedia.EnumISOPaperSubstrate.PS1;
        }
        if (grade == 2) {
            return JDFAutoMedia.EnumISOPaperSubstrate.PS4;
        }
        if (grade == 3) {
            return JDFAutoMedia.EnumISOPaperSubstrate.PS3;
        }
        if (grade == 4) {
            return JDFAutoMedia.EnumISOPaperSubstrate.PS6;
        }
        if (grade == 5) {
            return JDFAutoMedia.EnumISOPaperSubstrate.PS8;
        }
        return null;
    }

    public static int getGradeFromIsoPaper(JDFAutoMedia.EnumISOPaperSubstrate iso) {
        if (iso == null) {
            return 0;
        }
        if (JDFAutoMedia.EnumISOPaperSubstrate.PS1.equals((Object)iso)) {
            return 1;
        }
        if (JDFAutoMedia.EnumISOPaperSubstrate.PS2.equals((Object)iso) || JDFAutoMedia.EnumISOPaperSubstrate.PS3.equals((Object)iso)) {
            return 3;
        }
        if (JDFAutoMedia.EnumISOPaperSubstrate.PS4.equals((Object)iso)) {
            return 2;
        }
        if (JDFAutoMedia.EnumISOPaperSubstrate.PS5.equals((Object)iso) || JDFAutoMedia.EnumISOPaperSubstrate.PS6.equals((Object)iso) || JDFAutoMedia.EnumISOPaperSubstrate.PS7.equals((Object)iso)) {
            return 4;
        }
        if (JDFAutoMedia.EnumISOPaperSubstrate.PS8.equals((Object)iso)) {
            return 5;
        }
        return 0;
    }

    public JDFMedia(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFMedia(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFMedia(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFMedia[  --> " + super.toString() + " ]";
    }

    public void setThicknessFromWeight(boolean bLocal, boolean bRecurse) {
        JDFAutoMedia.EnumMediaType mT = this.getMediaType();
        if (!JDFAutoMedia.EnumMediaType.Paper.equals((Object)mT)) {
            return;
        }
        if (bRecurse) {
            VElement v = this.getLeaves(true);
            int size = v.size();
            for (int i = 0; i < size; ++i) {
                ((JDFMedia)v.get(i)).setThicknessFromWeight(bLocal, false);
            }
        } else {
            String t;
            String w;
            String string = w = bLocal ? this.getAttribute_KElement("Weight") : this.getAttribute("Weight");
            if (JDFMedia.isWildCard(w)) {
                return;
            }
            String string2 = t = bLocal ? this.getAttribute_KElement("Thickness") : this.getAttribute("Thickness");
            if (!JDFMedia.isWildCard(t)) {
                return;
            }
            this.setThickness(this.getWeight() * 1.25);
        }
    }

    public void setDimensionCM(JDFXYPair value) {
        if (value == null) {
            this.setDimension(null);
        } else {
            JDFXYPair xyp = new JDFXYPair(value);
            xyp.scale(28.346456692913385);
            this.setDimension(xyp);
        }
    }

    public void setDimensionCM(int x, int y) {
        this.setDimensionCM(new JDFXYPair(x, y));
    }

    public JDFXYPair getDimensionCM() {
        JDFXYPair xyp = this.getDimension();
        if (xyp != null) {
            xyp.scaleToCM();
        }
        return xyp;
    }

    public void setDimensionInch(JDFXYPair value) {
        if (value == null) {
            this.setDimension(null);
        } else {
            JDFXYPair xyp = new JDFXYPair(value);
            xyp.scale(72.0);
            this.setDimension(xyp);
        }
    }

    public JDFXYPair getDimensionInch() {
        JDFXYPair xyp = this.getDimension();
        if (xyp != null) {
            xyp.scale(0.013888888888888888);
        }
        return xyp;
    }

    public int getBackGrade() {
        JDFAutoMedia.EnumISOPaperSubstrate backIso = JDFAutoMedia.EnumISOPaperSubstrate.getEnum(this.getNonEmpty("BackISOPaperSubstrate"));
        if (backIso != null) {
            return JDFMedia.getGradeFromIsoPaper(backIso);
        }
        int frontGrade = this.getGrade();
        if (frontGrade == 0 || frontGrade >= 4) {
            return frontGrade;
        }
        JDFAutoMedia.EnumBackCoatings coatings = super.getBackCoatings();
        if (coatings == null) {
            return frontGrade;
        }
        if (JDFAutoMedia.EnumBackCoatings.None.equals((Object)coatings)) {
            return 4;
        }
        if (JDFAutoMedia.EnumBackCoatings.Matte.equals((Object)coatings)) {
            return 2;
        }
        return frontGrade;
    }

    public int getGrade(boolean checkIsoPaper) {
        int grade = super.getGrade();
        if (grade > 0 || !checkIsoPaper) {
            return grade;
        }
        return JDFMedia.getGradeFromIsoPaper(this.getISOPaperSubstrate());
    }

    @Override
    public boolean matches(Object subset) {
        boolean matches = false;
        if (subset instanceof String) {
            String subString = StringUtil.normalize((String)subset, true);
            matches = subString == null ? false : subString.equalsIgnoreCase(this.getProductID());
        } else if (subset instanceof JDFMedia) {
            JDFMedia other = (JDFMedia)subset;
            String productID = StringUtil.normalize(this.getProductID(), true);
            String otherProductID = StringUtil.normalize(other.getProductID(), true);
            if (productID != null && otherProductID != null) {
                matches = this.matches(otherProductID);
            } else {
                matches = StringUtil.getDistance(this.getBrand(), other.getBrand(), true, true, true) == 0;
                matches = matches && StringUtil.getDistance(this.getMediaQuality(), other.getMediaQuality(), true, true, true) == 0;
                matches = matches && StringUtil.getDistance(this.getAttribute("ISOPaperSubstrate"), other.getAttribute("ISOPaperSubstrate"), true, true, true) == 0;
                matches = matches && (this.getGrade() == 0 || other.getGrade() == 0 || other.getGrade() == this.getGrade());
                matches = matches && (this.getBackGrade() == 0 || other.getBackGrade() == 0 || other.getBackGrade() == this.getBackGrade());
                matches = matches && (this.getWeight() == 0.0 || other.getWeight() == 0.0 || Math.abs(other.getWeight() - this.getWeight()) < 1.0);
                boolean bl = matches = matches && (this.getThickness() == 0.0 || other.getThickness() == 0.0 || Math.abs(other.getThickness() - this.getThickness()) < 1.0);
                if (matches) {
                    JDFXYPair dim = this.getDimension();
                    JDFXYPair otherDim = other.getDimension();
                    matches = dim == null || otherDim == null || dim.matches(otherDim, 5.0);
                }
            }
        }
        return matches;
    }

    public boolean isComponentMedia() {
        JDFAutoMedia.EnumMediaType typ = this.getMediaType();
        return JDFAutoMedia.EnumMediaType.Paper.equals((Object)typ) || JDFAutoMedia.EnumMediaType.CorrugatedBoard.equals((Object)typ) || JDFAutoMedia.EnumMediaType.SelfAdhesive.equals((Object)typ) || JDFAutoMedia.EnumMediaType.Transparency.equals((Object)typ) || JDFAutoMedia.EnumMediaType.Vinyl.equals((Object)typ);
    }
}

