/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.DataFormatException;
import org.apache.commons.lang.enums.EnumUtils;
import org.apache.commons.lang.enums.ValuedEnum;
import org.cip4.jdflib.core.AtrInfo;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFVersions;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.JDFCMYKColor;
import org.cip4.jdflib.datatypes.JDFDateTimeRangeList;
import org.cip4.jdflib.datatypes.JDFDurationRangeList;
import org.cip4.jdflib.datatypes.JDFIntegerList;
import org.cip4.jdflib.datatypes.JDFIntegerRange;
import org.cip4.jdflib.datatypes.JDFIntegerRangeList;
import org.cip4.jdflib.datatypes.JDFLabColor;
import org.cip4.jdflib.datatypes.JDFMatrix;
import org.cip4.jdflib.datatypes.JDFNumberList;
import org.cip4.jdflib.datatypes.JDFNumberRange;
import org.cip4.jdflib.datatypes.JDFNumberRangeList;
import org.cip4.jdflib.datatypes.JDFRGBColor;
import org.cip4.jdflib.datatypes.JDFRectangle;
import org.cip4.jdflib.datatypes.JDFRectangleRangeList;
import org.cip4.jdflib.datatypes.JDFShape;
import org.cip4.jdflib.datatypes.JDFShapeRangeList;
import org.cip4.jdflib.datatypes.JDFXYPair;
import org.cip4.jdflib.datatypes.JDFXYPairRange;
import org.cip4.jdflib.datatypes.JDFXYPairRangeList;
import org.cip4.jdflib.util.JDFDate;
import org.cip4.jdflib.util.JDFDuration;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.UrlUtil;

public class AttributeInfo {
    public static final Map<String, AttributeInfo> fixedMap = new HashMap<String, AttributeInfo>();
    HashMap<String, AtrInfo> attribInfoTable = new HashMap();
    private JDFElement.EnumVersion version = null;

    protected AttributeInfo(AtrInfoTable[] attrInfo_own) {
        this.updateReplace(attrInfo_own);
    }

    @Deprecated
    public AttributeInfo(AttributeInfo attrInfo_super, AtrInfoTable[] attrInfo_own) {
        if (attrInfo_super != null) {
            this.attribInfoTable = new HashMap<String, AtrInfo>(attrInfo_super.attribInfoTable);
            this.version = attrInfo_super.version;
        }
        this.updateReplace(attrInfo_own);
    }

    public AttributeInfo updateAdd(AtrInfoTable attrInfo_update) {
        if (attrInfo_update != null) {
            this.attribInfoTable.put(attrInfo_update.getAttributeName(), attrInfo_update.getAtrInfo());
        }
        return this;
    }

    public AttributeInfo updateAdd(AtrInfoTable[] attrInfo_update) {
        if (attrInfo_update != null) {
            for (AtrInfoTable element : attrInfo_update) {
                this.attribInfoTable.put(element.getAttributeName(), element.getAtrInfo());
            }
        }
        return this;
    }

    public AttributeInfo updateRemove(AtrInfoTable attrInfo_update) {
        if (attrInfo_update != null && this.attribInfoTable.containsKey(attrInfo_update.getAttributeName())) {
            this.attribInfoTable.remove(attrInfo_update.getAttributeName());
        }
        return this;
    }

    public AttributeInfo updateRemove(AtrInfoTable[] attrInfo_update) {
        if (attrInfo_update != null) {
            for (AtrInfoTable element : attrInfo_update) {
                if (!this.attribInfoTable.containsKey(element.getAttributeName())) continue;
                this.attribInfoTable.remove(element.getAttributeName());
            }
        }
        return this;
    }

    public AttributeInfo updateReplace(AtrInfoTable attrInfo_update) {
        if (attrInfo_update != null) {
            this.attribInfoTable.put(attrInfo_update.getAttributeName(), attrInfo_update.getAtrInfo());
        }
        return this;
    }

    public AttributeInfo updateReplace(AtrInfoTable[] attrInfo_update) {
        if (attrInfo_update != null) {
            for (AtrInfoTable atrInfoTable : attrInfo_update) {
                this.attribInfoTable.put(atrInfoTable.getAttributeName(), atrInfoTable.getAtrInfo());
            }
        }
        return this;
    }

    public VString conformingAttribs(EnumAttributeValidity attrValidity) {
        boolean bOK;
        VString matchingAttribs = new VString();
        long l2 = JDFVersions.getTheMask(this.version);
        long v2 = JDFVersions.getTheOffset(this.version);
        Iterator<String> iter = this.attribInfoTable.keySet().iterator();
        boolean bl = bOK = attrValidity == null;
        while (iter.hasNext()) {
            long v1;
            long v3;
            String theKey = iter.next();
            AtrInfo ai = this.attribInfoTable.get(theKey);
            if (bOK) {
                matchingAttribs.add(theKey);
                continue;
            }
            long l1 = ai.getAtrValidityStatus();
            long l3 = l1 & l2;
            if (l3 != (v3 = (v1 = (long)attrValidity.getValue()) << (int)v2)) continue;
            matchingAttribs.add(theKey);
        }
        return matchingAttribs;
    }

    public JDFAttributeMap getDefaultAttributeMap() {
        JDFAttributeMap matchingAttribs = new JDFAttributeMap();
        for (String theKey : this.attribInfoTable.keySet()) {
            String def;
            AtrInfo ai = this.attribInfoTable.get(theKey);
            long l2 = JDFVersions.getTheMask(this.version);
            long v2 = JDFVersions.getTheOffset(this.version);
            EnumAttributeValidity versionVal = EnumAttributeValidity.getEnum((int)((ai.getAtrValidityStatus() & l2) >> (int)v2));
            if (!versionVal.equals((Object)EnumAttributeValidity.Optional) && !versionVal.equals((Object)EnumAttributeValidity.Required) || (def = ai.getAtrDefault()) == null) continue;
            matchingAttribs.put(theKey, def);
        }
        return matchingAttribs.isEmpty() ? null : matchingAttribs;
    }

    public boolean hasConformingAttrib(EnumAttributeValidity attrValidity) {
        Set<String> set = this.attribInfoTable.keySet();
        long l2 = JDFVersions.getTheMask(this.version);
        long v2 = JDFVersions.getTheOffset(this.version);
        for (String s : set) {
            AtrInfo ai = this.attribInfoTable.get(s);
            if ((ai.getAtrValidityStatus() & l2) != (long)attrValidity.getValue() << (int)v2) continue;
            return true;
        }
        return false;
    }

    public VString requiredAttribs() {
        return this.conformingAttribs(EnumAttributeValidity.Required);
    }

    public VString optionalAttribs() {
        VString optionals = new VString(this.conformingAttribs(EnumAttributeValidity.Optional));
        optionals.appendUnique(this.conformingAttribs(EnumAttributeValidity.Deprecated));
        for (String theKey : this.attribInfoTable.keySet()) {
            String defaultVal = this.getAttributeDefault(theKey);
            if (defaultVal == null) continue;
            optionals.appendUnique(theKey);
        }
        return optionals;
    }

    public VString knownAttribs() {
        return this.conformingAttribs(null);
    }

    public VString deprecatedAttribs() {
        return this.conformingAttribs(EnumAttributeValidity.Deprecated);
    }

    public VString prereleaseAttribs() {
        return this.conformingAttribs(EnumAttributeValidity.None);
    }

    public EnumAttributeType getAttributeType(String attributeName) {
        AtrInfo atrInfo = this.attribInfoTable.get(attributeName);
        if (atrInfo != null) {
            return atrInfo.getAtrType();
        }
        return null;
    }

    public EnumAttributeValidity getAttributeValidity(String attributeName) {
        AtrInfo atrInfo = this.attribInfoTable.get(attributeName);
        if (atrInfo != null) {
            long l = atrInfo.getAtrValidityStatus();
            long l2 = JDFVersions.getTheMask(this.version);
            long v2 = JDFVersions.getTheOffset(this.version);
            l = (l & l2) >> (int)v2;
            return EnumAttributeValidity.getEnum((int)l);
        }
        return null;
    }

    public ValuedEnum getAttributeEnum(String attributeName) {
        AtrInfo atrInfo = this.attribInfoTable.get(attributeName);
        if (atrInfo != null) {
            return atrInfo.getEnumEnum();
        }
        return null;
    }

    public String getAttributeDefault(String attributeName) {
        AtrInfo atrInfo = this.attribInfoTable.get(attributeName);
        if (atrInfo != null) {
            return atrInfo.getAtrDefault();
        }
        return null;
    }

    public void setVersion(JDFElement.EnumVersion v) {
        this.version = v;
    }

    @Deprecated
    public EnumAttributeType getAtrType(String attributeName) {
        AtrInfo ai = this.attribInfoTable.get(attributeName);
        if (ai == null) {
            return null;
        }
        return ai.getAtrType();
    }

    public boolean validAttribute(String key, String attribute, JDFElement.EnumValidationLevel level) {
        EnumAttributeType typ = this.getAttributeType(key);
        if (typ == null) {
            return true;
        }
        ValuedEnum enu = null;
        if (typ == EnumAttributeType.enumeration || typ == EnumAttributeType.enumerations) {
            enu = this.getAttributeEnum(key);
        } else if (typ == EnumAttributeType.JDFJMFVersion) {
            enu = JDFElement.EnumVersion.getEnum(0);
        }
        EnumAttributeValidity val = this.getAttributeValidity(key);
        if (val == EnumAttributeValidity.Unknown) {
            return attribute == null;
        }
        if (val == EnumAttributeValidity.Deprecated) {
            return attribute == null || JDFElement.EnumValidationLevel.isNoWarn(level);
        }
        if (val == EnumAttributeValidity.None) {
            return attribute == null || attribute.equals(this.getAttributeDefault(key)) || JDFElement.EnumValidationLevel.isNoWarn(level);
        }
        if (val == EnumAttributeValidity.Optional || level != JDFElement.EnumValidationLevel.Complete && level != JDFElement.EnumValidationLevel.RecursiveComplete) {
            return attribute == null || attribute.isEmpty() || AttributeInfo.validStringForType(attribute, typ, enu);
        }
        if (val == EnumAttributeValidity.Required) {
            return attribute != null && AttributeInfo.validStringForType(attribute, typ, enu);
        }
        return true;
    }

    public static boolean validStringForType(String val, EnumAttributeType iType, ValuedEnum enu) {
        if (val == null || val.isEmpty()) {
            return false;
        }
        if (iType == null) {
            return true;
        }
        try {
            if (iType == EnumAttributeType.Any || iType == EnumAttributeType.string) {
                return true;
            }
            if (iType == EnumAttributeType.shortString) {
                return val.length() < 64;
            }
            if (iType == EnumAttributeType.ID || iType == EnumAttributeType.IDREF) {
                return StringUtil.isID(val);
            }
            if (iType == EnumAttributeType.NMTOKEN) {
                return StringUtil.isNMTOKEN(val);
            }
            if (iType == EnumAttributeType.NMTOKENS) {
                return StringUtil.isNMTOKENS(val, false);
            }
            if (iType == EnumAttributeType.IDREFS) {
                return StringUtil.isNMTOKENS(val, true);
            }
            if (iType == EnumAttributeType.boolean_) {
                return StringUtil.isBoolean(val);
            }
            if (iType == EnumAttributeType.double_) {
                return StringUtil.isNumber(val);
            }
            if (iType == EnumAttributeType.integer) {
                return StringUtil.isInteger(val);
            }
            if (iType == EnumAttributeType.unbounded) {
                return "unbounded".equals(val) || StringUtil.isInteger(val);
            }
            if (iType == EnumAttributeType.URI || iType == EnumAttributeType.URL) {
                return UrlUtil.isIRL(val);
            }
            if (iType == EnumAttributeType.RegExp) {
                return true;
            }
            if (iType == EnumAttributeType.enumeration || iType == EnumAttributeType.JDFJMFVersion) {
                return AttributeInfo.isEnum(val, enu);
            }
            if (iType == EnumAttributeType.enumerations) {
                return AttributeInfo.isEnums(val, enu);
            }
            if (iType == EnumAttributeType.IntegerRange) {
                new JDFIntegerRange(val);
                return true;
            }
            if (iType == EnumAttributeType.IntegerList) {
                new JDFIntegerList(val);
                return true;
            }
            if (iType == EnumAttributeType.IntegerRangeList) {
                new JDFIntegerRangeList(val);
                return true;
            }
            if (iType == EnumAttributeType.NumberRange) {
                new JDFNumberRange(val);
                return true;
            }
            if (iType == EnumAttributeType.NumberRangeList) {
                new JDFNumberRangeList(val);
                return true;
            }
            if (iType == EnumAttributeType.NumberList) {
                new JDFNumberList(val);
                return true;
            }
            if (iType == EnumAttributeType.matrix) {
                new JDFMatrix(val);
                return true;
            }
            if (iType == EnumAttributeType.rectangle) {
                new JDFRectangle(val);
                return true;
            }
            if (iType == EnumAttributeType.shape) {
                new JDFShape(val);
                return true;
            }
            if (iType == EnumAttributeType.XYPair) {
                new JDFXYPair(val);
                return true;
            }
            if (iType == EnumAttributeType.XYPairRange) {
                new JDFXYPairRange(val);
                return true;
            }
            if (iType == EnumAttributeType.XYPairRangeList) {
                new JDFXYPairRangeList(val);
                return true;
            }
            if (iType == EnumAttributeType.dateTime) {
                if (val.length() < 20) {
                    return false;
                }
                new JDFDate(val);
                return val.indexOf(84) == 10;
            }
            if (iType == EnumAttributeType.duration) {
                new JDFDuration(val);
                return true;
            }
            if (iType == EnumAttributeType.DurationRangeList) {
                new JDFDurationRangeList(val);
                return true;
            }
            if (iType == EnumAttributeType.DateTimeRangeList) {
                new JDFDateTimeRangeList(val);
                return true;
            }
            if (iType == EnumAttributeType.RectangleRangeList) {
                new JDFRectangleRangeList(val);
                return true;
            }
            if (iType == EnumAttributeType.ShapeRangeList) {
                new JDFShapeRangeList(val);
                return true;
            }
            if (iType == EnumAttributeType.CMYKColor) {
                new JDFCMYKColor(val);
                return true;
            }
            if (iType == EnumAttributeType.LabColor) {
                new JDFLabColor(val);
                return true;
            }
            if (iType == EnumAttributeType.RGBColor) {
                new JDFRGBColor(val);
                return true;
            }
            if (iType == EnumAttributeType.language) {
                return AttributeInfo.validLanguageString(val);
            }
            if (iType == EnumAttributeType.languages) {
                VString v = StringUtil.tokenize(val, " ", false);
                for (int i = 0; i < v.size(); ++i) {
                    if (AttributeInfo.validLanguageString(v.elementAt(i))) continue;
                    return false;
                }
                return true;
            }
            if (iType == EnumAttributeType.PDFPath) {
                return true;
            }
            if (iType == EnumAttributeType.XPath) {
                return true;
            }
            if (iType == EnumAttributeType.hexBinary) {
                return StringUtil.matches(val, "([0-9a-fA-F]{2})+");
            }
            if (iType == EnumAttributeType.TransferFunction) {
                JDFNumberList nl = new JDFNumberList(val);
                return nl.size() % 2 == 0;
            }
            return false;
        }
        catch (DataFormatException excep) {
            return false;
        }
    }

    static boolean isEnums(String val, ValuedEnum enu) {
        if (enu != null) {
            VString vs = StringUtil.tokenize(val, " ", false);
            for (int i = 0; i < vs.size(); ++i) {
                ValuedEnum ve = (ValuedEnum)EnumUtils.getEnum(enu.getClass(), (String)vs.get(i));
                if (ve != null) continue;
                return false;
            }
            return true;
        }
        return StringUtil.isNMTOKENS(val, false);
    }

    static boolean isEnum(String val, ValuedEnum enu) {
        if (enu != null) {
            ValuedEnum ve = (ValuedEnum)EnumUtils.getEnum(enu.getClass(), (String)val);
            return ve != null;
        }
        return StringUtil.isNMTOKEN(val);
    }

    private static boolean validLanguageString(String val) {
        int l = val.length();
        int posDash = val.indexOf(45);
        return l >= 2 && l <= 3 || l > 4 && posDash >= 2 && posDash < 4;
    }

    public String toString() {
        String s = "AttributeInfoTable verion=" + (Object)((Object)this.version);
        s = s + this.attribInfoTable.toString();
        return s;
    }

    public JDFElement.EnumVersion getFirstVersion(String attributeName) {
        if (this.attribInfoTable.containsKey(attributeName)) {
            return this.attribInfoTable.get(attributeName).getFirstVersion();
        }
        return null;
    }

    public JDFElement.EnumVersion getLastVersion(String attributeName) {
        if (this.attribInfoTable.containsKey(attributeName)) {
            return this.attribInfoTable.get(attributeName).getLastVersion();
        }
        return null;
    }

    public static final class EnumAttributeValidity
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumAttributeValidity Unknown = new EnumAttributeValidity("Unknown");
        public static final EnumAttributeValidity None = new EnumAttributeValidity("None");
        public static final EnumAttributeValidity Required = new EnumAttributeValidity("Required");
        public static final EnumAttributeValidity Optional = new EnumAttributeValidity("Optional");
        public static final EnumAttributeValidity Deprecated = new EnumAttributeValidity("Deprecated");
        public static final EnumAttributeValidity Any = new EnumAttributeValidity("Any");

        private EnumAttributeValidity(String name) {
            super(name, m_startValue++);
        }

        public static EnumAttributeValidity getEnum(String enumName) {
            return (EnumAttributeValidity)EnumAttributeValidity.getEnum(EnumAttributeValidity.class, (String)enumName);
        }

        public static EnumAttributeValidity getEnum(int enumValue) {
            return (EnumAttributeValidity)EnumAttributeValidity.getEnum(EnumAttributeValidity.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumAttributeValidity.getEnumMap(EnumAttributeValidity.class);
        }

        public static List getEnumList() {
            return EnumAttributeValidity.getEnumList(EnumAttributeValidity.class);
        }

        public static Iterator iterator() {
            return EnumAttributeValidity.iterator(EnumAttributeValidity.class);
        }
    }

    public static final class EnumAttributeType
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        private static Set<EnumAttributeType> setRange = null;
        public static final EnumAttributeType Any = new EnumAttributeType("Any");
        public static final EnumAttributeType boolean_ = new EnumAttributeType("boolean_");
        public static final EnumAttributeType CMYKColor = new EnumAttributeType("CMYKColor");
        public static final EnumAttributeType dateTime = new EnumAttributeType("dateTime");
        public static final EnumAttributeType DateTimeRange = new EnumAttributeType("DateTimeRange");
        public static final EnumAttributeType DateTimeRangeList = new EnumAttributeType("DateTimeRangeList");
        public static final EnumAttributeType double_ = new EnumAttributeType("double_");
        public static final EnumAttributeType duration = new EnumAttributeType("duration");
        public static final EnumAttributeType DurationRange = new EnumAttributeType("DurationRange");
        public static final EnumAttributeType DurationRangeList = new EnumAttributeType("DurationRangeList");
        public static final EnumAttributeType enumeration = new EnumAttributeType("enumeration");
        public static final EnumAttributeType enumerations = new EnumAttributeType("enumerations");
        public static final EnumAttributeType hexBinary = new EnumAttributeType("hexBinary");
        public static final EnumAttributeType ID = new EnumAttributeType("ID");
        public static final EnumAttributeType IDREF = new EnumAttributeType("IDREF");
        public static final EnumAttributeType IDREFS = new EnumAttributeType("IDREFS");
        public static final EnumAttributeType integer = new EnumAttributeType("integer");
        public static final EnumAttributeType IntegerList = new EnumAttributeType("IntegerList");
        public static final EnumAttributeType IntegerRange = new EnumAttributeType("IntegerRange");
        public static final EnumAttributeType IntegerRangeList = new EnumAttributeType("IntegerRangeList");
        public static final EnumAttributeType JDFJMFVersion = new EnumAttributeType("JDFJMFVersion");
        public static final EnumAttributeType LabColor = new EnumAttributeType("LabColor");
        public static final EnumAttributeType language = new EnumAttributeType("language");
        public static final EnumAttributeType languages = new EnumAttributeType("languages");
        public static final EnumAttributeType matrix = new EnumAttributeType("matrix");
        public static final EnumAttributeType NameRange = new EnumAttributeType("NameRange");
        public static final EnumAttributeType NameRangeList = new EnumAttributeType("NameRangeList");
        public static final EnumAttributeType NMTOKEN = new EnumAttributeType("NMTOKEN");
        public static final EnumAttributeType NMTOKENS = new EnumAttributeType("NMTOKENS");
        public static final EnumAttributeType NumberList = new EnumAttributeType("NumberList");
        public static final EnumAttributeType NumberRange = new EnumAttributeType("NumberRange");
        public static final EnumAttributeType NumberRangeList = new EnumAttributeType("NumberRangeList");
        public static final EnumAttributeType PDFPath = new EnumAttributeType("PDFPath");
        public static final EnumAttributeType rectangle = new EnumAttributeType("rectangle");
        public static final EnumAttributeType RectangleRange = new EnumAttributeType("RectangleRange");
        public static final EnumAttributeType RectangleRangeList = new EnumAttributeType("RectangleRangeList");
        public static final EnumAttributeType RegExp = new EnumAttributeType("RegExp");
        public static final EnumAttributeType RGBColor = new EnumAttributeType("RGBColor");
        public static final EnumAttributeType shape = new EnumAttributeType("shape");
        public static final EnumAttributeType ShapeRange = new EnumAttributeType("ShapeRange");
        public static final EnumAttributeType ShapeRangeList = new EnumAttributeType("ShapeRangeList");
        public static final EnumAttributeType shortString = new EnumAttributeType("shortString");
        public static final EnumAttributeType string = new EnumAttributeType("string");
        public static final EnumAttributeType TransferFunction = new EnumAttributeType("TransferFunction");
        public static final EnumAttributeType unbounded = new EnumAttributeType("unbounded");
        public static final EnumAttributeType URI = new EnumAttributeType("URI");
        public static final EnumAttributeType URL = new EnumAttributeType("URL");
        public static final EnumAttributeType XYPair = new EnumAttributeType("XYPair");
        public static final EnumAttributeType XYPairRange = new EnumAttributeType("XYPairRange");
        public static final EnumAttributeType XYPairRangeList = new EnumAttributeType("XYPairRangeList");
        public static final EnumAttributeType XPath = new EnumAttributeType("XPath");
        public static final EnumAttributeType XYRelation = new EnumAttributeType("XYRelation");

        private EnumAttributeType(String name) {
            super(name, m_startValue++);
        }

        public static EnumAttributeType getEnum(String enumName) {
            EnumAttributeType eat = (EnumAttributeType)EnumAttributeType.getEnum(EnumAttributeType.class, (String)enumName);
            return eat == null ? Any : eat;
        }

        public static EnumAttributeType getEnum(int enumValue) {
            return (EnumAttributeType)EnumAttributeType.getEnum(EnumAttributeType.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumAttributeType.getEnumMap(EnumAttributeType.class);
        }

        public static List getEnumList() {
            return EnumAttributeType.getEnumList(EnumAttributeType.class);
        }

        public static Iterator iterator() {
            return EnumAttributeType.iterator(EnumAttributeType.class);
        }

        public static boolean isRange(EnumAttributeType test) {
            if (setRange == null) {
                HashSet<EnumAttributeType> setRangeLocal = new HashSet<EnumAttributeType>();
                setRangeLocal.add(DateTimeRange);
                setRangeLocal.add(DateTimeRangeList);
                setRangeLocal.add(DurationRange);
                setRangeLocal.add(DurationRangeList);
                setRangeLocal.add(IntegerRange);
                setRangeLocal.add(IntegerRangeList);
                setRangeLocal.add(NameRange);
                setRangeLocal.add(NameRangeList);
                setRangeLocal.add(NumberRange);
                setRangeLocal.add(NumberRangeList);
                setRangeLocal.add(RectangleRange);
                setRangeLocal.add(RectangleRangeList);
                setRangeLocal.add(ShapeRange);
                setRangeLocal.add(ShapeRangeList);
                setRangeLocal.add(XYPairRange);
                setRangeLocal.add(XYPairRangeList);
                setRange = setRangeLocal;
            }
            return test == null ? false : setRange.contains((Object)test);
        }
    }
}

