/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.datatypes;

import java.util.ArrayList;
import java.util.zip.DataFormatException;
import org.cip4.jdflib.core.StringArray;
import org.cip4.jdflib.datatypes.JDFNameRange;
import org.cip4.jdflib.datatypes.JDFRangeList;
import org.cip4.jdflib.util.StringUtil;

public class JDFNameRangeList
extends JDFRangeList {
    public static JDFNameRangeList createNameRangeList(String s) {
        if (s != null && s.length() > 0) {
            try {
                return new JDFNameRangeList(s);
            }
            catch (DataFormatException x) {
                return null;
            }
        }
        return null;
    }

    public JDFNameRangeList() {
    }

    public JDFNameRangeList(String s) throws DataFormatException {
        if (s != null && !s.equals("")) {
            this.setString(s);
        }
    }

    public JDFNameRangeList(JDFNameRangeList rl) {
        this.rangeList = new ArrayList(rl.rangeList);
    }

    public void setString(String s) throws DataFormatException {
        if (s.indexOf("~") == 0 || s.lastIndexOf("~") == s.length() - 1) {
            throw new DataFormatException("JDFNameRangeList::SetString: Illegal string " + s);
        }
        String zappedWS = StringUtil.zappTokenWS(s, "~");
        StringArray vs = StringArray.getVString(zappedWS, " \t");
        this.rangeList.clear();
        for (String str : vs) {
            JDFNameRange r = new JDFNameRange(str);
            this.rangeList.add(r);
        }
    }

    public boolean inRange(String x) {
        for (int i = 0; i < this.rangeList.size(); ++i) {
            if (!((JDFNameRange)this.rangeList.get(i)).inRange(x)) continue;
            return true;
        }
        return false;
    }

    public void append(JDFNameRange r) {
        this.rangeList.add(r);
    }

    @Override
    public boolean isUniqueOrdered() {
        return false;
    }

    @Override
    public boolean isOrdered() {
        return false;
    }
}

