/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.elementwalker;

import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.security.CodeSource;
import java.util.List;
import java.util.zip.ZipEntry;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.elementwalker.BaseWalkerFactory;
import org.cip4.jdflib.elementwalker.ElementWalker;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.ListMap;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.UrlUtil;
import org.cip4.jdflib.util.zip.ZipReader;

public class PackageElementWalker
extends ElementWalker {
    private static final String WALK_CLASS = "Walk*.class";
    static ListMap<Class<?>, String> classes = null;

    public PackageElementWalker(BaseWalkerFactory _theFactory) {
        super(_theFactory);
        if (classes == null) {
            classes = new ListMap();
        }
        this.constructWalkers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void constructWalkers() {
        ListMap<Class<?>, String> listMap = classes;
        synchronized (listMap) {
            Class<?> parent = this.getClass();
            if (classes.get(parent) != null) {
                this.constructWorkersVClass((List)classes.get(parent));
            } else {
                CodeSource codesrc = parent.getProtectionDomain().getCodeSource();
                URL packsrc = codesrc.getLocation();
                this.log.info((Object)("Constructing walkers for package URL: " + packsrc.toExternalForm()));
                File f = UrlUtil.urlToFile(UrlUtil.urlToString(packsrc));
                if (f.isDirectory()) {
                    this.constructWorkersDir(f);
                } else {
                    this.constructWorkersJar(f);
                }
            }
        }
    }

    private void constructWorkersVClass(List<String> classVector) {
        for (String classConst : classVector) {
            this.constructWalker(classConst);
        }
    }

    private void constructWorkersJar(File jarFile) {
        ZipReader zr = ZipReader.getZipReader(jarFile);
        if (zr == null) {
            this.log.error((Object)("Could not unpack zip file: " + jarFile));
        } else {
            Class<Object> currentClass;
            Class<?> baseClass = currentClass = this.getClass();
            this.log.info((Object)("constructing from jar: " + jarFile));
            while (currentClass != null) {
                ZipEntry ze;
                String packageName = currentClass.getPackage().getName();
                String packagePath = StringUtil.replaceChar(packageName, '.', "/", 0);
                String classExpr = packagePath + "/" + WALK_CLASS;
                zr.buffer();
                while ((ze = zr.getNextMatchingEntry(classExpr)) != null) {
                    this.processSingleEntry(baseClass, packageName, packagePath, ze);
                }
                currentClass = this.getParentClass(currentClass);
            }
        }
    }

    void processSingleEntry(Class<? extends PackageElementWalker> baseClass, String packageName, String packagePath, ZipEntry ze) {
        String name;
        String className;
        String entryName = ZipReader.getEntryName(ze);
        String zipPackageName = StringUtil.leftStr(entryName, -1 - (className = StringUtil.token(entryName, -1, "/")).length());
        if (packagePath.equals(zipPackageName) && (name = packageName + "." + UrlUtil.newExtension(className, null)).indexOf(36) < 0) {
            BaseWalker w = this.constructWalker(name);
            this.log.info((Object)("constructed class: " + name + " Depth=" + w.getDepth()));
            classes.putOne(baseClass, name);
        }
    }

    private void constructWorkersDir(File dir) {
        Class<Object> currentClass;
        Class<?> baseClass = currentClass = this.getClass();
        while (currentClass != null) {
            String packageName = currentClass.getPackage().getName();
            String packagePath = StringUtil.replaceChar(packageName, '.', File.separator, 0);
            packagePath = dir.getAbsolutePath() + File.separator + packagePath;
            File[] classFiles = FileUtil.listFilesWithExpression(new File(packagePath), WALK_CLASS);
            if (classFiles != null) {
                for (File f : classFiles) {
                    String name = f.getName();
                    if ((name = UrlUtil.prefix(name)).indexOf(36) > 0) continue;
                    name = packageName + "." + name;
                    BaseWalker w = this.constructWalker(name);
                    if (w != null) {
                        this.log.debug((Object)("constructed class: " + name + " Depth=" + w.getDepth()));
                    } else {
                        this.log.warn((Object)("could not construct class: " + name));
                    }
                    classes.putOne(baseClass, name);
                }
            }
            currentClass = this.getParentClass(currentClass);
        }
    }

    private Class<? extends PackageElementWalker> getParentClass(Class<? extends PackageElementWalker> currentClass) {
        Class<? extends PackageElementWalker> nextClass = currentClass.getSuperclass();
        currentClass = PackageElementWalker.class.isAssignableFrom(nextClass) ? nextClass : null;
        return currentClass;
    }

    protected BaseWalker constructWalker(String name) {
        try {
            Class<?> newClass = Class.forName(name);
            Constructor<?> con = newClass.getConstructor(new Class[0]);
            BaseWalker w = (BaseWalker)con.newInstance(new Object[0]);
            w.addToFactory(this.getFactory());
            return w;
        }
        catch (Throwable e) {
            this.log.warn((Object)("Cannot construct class: " + name), e);
            return null;
        }
    }

    @Override
    public BaseWalkerFactory getFactory() {
        return (BaseWalkerFactory)this.theFactory;
    }
}

