/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.elementwalker.fixversion;

import org.cip4.jdflib.auto.JDFAutoMedia;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.elementwalker.fixversion.WalkResource;
import org.cip4.jdflib.resource.process.JDFMedia;
import org.cip4.jdflib.util.EnumUtil;
import org.cip4.jdflib.util.StringUtil;

public class WalkMedia
extends WalkResource {
    @Override
    public boolean matches(KElement toCheck) {
        return toCheck instanceof JDFMedia;
    }

    @Override
    public VString getElementNames() {
        return VString.getVString("Media", null);
    }

    @Override
    boolean updateAttributes(JDFAttributeMap m) {
        boolean ret = false;
        if (EnumUtil.aLessEqualsThanB(JDFElement.EnumVersion.Version_1_6, this.fixVersion.version)) {
            m.renameKey("UserMediaType", "MediaTypeDetails");
            ret = true;
            this.updateGrade(m, "Grade", "ISOPaperSubstrate");
            this.updateGrade(m, "BackGrade", "BackISOPaperSubstrate");
        }
        return super.updateAttributes(m) || ret;
    }

    private void updateGrade(JDFAttributeMap map, String oldGrade, String newGrade) {
        int igrade;
        JDFAutoMedia.EnumISOPaperSubstrate ips;
        String grade = map.get(oldGrade);
        if (map.getNonEmpty(newGrade) == null && (ips = JDFMedia.getIsoPaperFromGrade(igrade = StringUtil.parseInt(grade, 0))) != null) {
            map.put(newGrade, ips.getName());
        }
    }
}

