/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Vector;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.core.XMLDoc;
import org.cip4.jdflib.datatypes.JDFIntegerList;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.extensions.AuditPoolHelper;
import org.cip4.jdflib.extensions.BaseXJDFHelper;
import org.cip4.jdflib.extensions.ProductHelper;
import org.cip4.jdflib.extensions.ResourceHelper;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.extensions.xjdfwalker.IDRemover;
import org.cip4.jdflib.ifaces.INodeIdentifiable;
import org.cip4.jdflib.node.ICSVersion;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.node.NodeIdentifier;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.EnumUtil;
import org.cip4.jdflib.util.JDFDate;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.UrlUtil;

public class XJDFHelper
extends BaseXJDFHelper
implements Cloneable,
INodeIdentifiable {
    public static final String RESOURCE = "Resource";
    public static final String XJDF = "XJDF";
    public static final String XJMF = "XJMF";
    @Deprecated
    public static final String PARAMETER = "Parameter";

    public static XJDFHelper getHelper(XMLDoc doc) {
        if (doc == null) {
            return null;
        }
        KElement root = doc.getRoot();
        return XJDFHelper.getHelper(root);
    }

    public static XJDFHelper getHelper(KElement root) {
        if (root == null) {
            return null;
        }
        if (!root.getLocalName().equals(XJDF)) {
            root = root.getDeepParent(XJDF, 0);
        }
        return root != null ? new XJDFHelper(root) : null;
    }

    public static boolean isXJDF(KElement root) {
        return root != null && XJDF.equals(root.getLocalName());
    }

    public static boolean isXJMF(KElement root) {
        return root != null && XJMF.equals(root.getLocalName());
    }

    public static XJDFHelper parseFile(String fileName) {
        return XJDFHelper.getHelper(JDFDoc.parseFile(fileName));
    }

    public static XJDFHelper parseFile(File fileName) {
        return XJDFHelper.getHelper(JDFDoc.parseFile(fileName));
    }

    public XJDFHelper(KElement xjdf) {
        if (xjdf == null) {
            this.newXJDF(XJDFHelper.getDefaultVersion());
        } else {
            this.theElement = xjdf;
        }
        if (this.theElement instanceof JDFElement) {
            ((JDFElement)this.theElement).getOwnerDocument_JDFElement().setInitOnCreate(false);
        }
    }

    public XJDFHelper(String jobID, String jobPartID, VJDFAttributeMap parts) {
        this.newXJDF(null);
        if (jobID == null) {
            jobID = "Job_" + new JDFDate().getFormattedDateTime("MMdd_hhmmss");
        }
        this.setAttribute("JobID", jobID);
        this.setAttribute("JobPartID", jobPartID);
        this.setParts(parts);
        this.cleanUp();
    }

    public XJDFHelper(JDFElement.EnumVersion version, String jobID) {
        this.newXJDF(version);
        this.setJobID(jobID);
        this.cleanUp();
    }

    public XJDFHelper(String jobID, String jobPartID) {
        this(jobID, jobPartID, null);
    }

    private void setParts(VJDFAttributeMap parts) {
        SetHelper niHelper = this.getCreateSet("NodeInfo", JDFResourceLink.EnumUsage.Input);
        niHelper.getCreatePartitions(parts, true);
    }

    void newXJDF(JDFElement.EnumVersion version) {
        if (version == null) {
            version = XJDFHelper.getDefaultVersion();
        }
        JDFDoc doc = new JDFDoc(XJDF, version);
        doc.setInitOnCreate(false);
        this.theElement = doc.getRoot();
        if (EnumUtil.aLessThanB(JDFElement.EnumVersion.Version_2_0, version)) {
            this.theElement.setAttribute("Version", version.getName());
        }
        AuditPoolHelper aph = this.getCreateAuditPool();
        aph.appendMessage("AuditCreated");
    }

    public Vector<SetHelper> getSets() {
        return this.getSets(null, null);
    }

    public Vector<SetHelper> getSets(String setName, JDFResourceLink.EnumUsage usage) {
        Vector<SetHelper> v = new Vector<SetHelper>();
        for (KElement e = this.theElement.getFirstChildElement(); e != null; e = e.getNextSiblingElement()) {
            if (!SetHelper.isSet(e)) continue;
            SetHelper set = new SetHelper(e);
            if (setName != null && !setName.equals(set.getName()) || usage != null && !usage.equals((Object)set.getUsage())) continue;
            v.add(set);
        }
        return v.size() == 0 ? null : v;
    }

    public AuditPoolHelper getAuditPool() {
        KElement auditPool = this.theElement.getElement("AuditPool");
        return auditPool == null ? null : new AuditPoolHelper(auditPool);
    }

    public AuditPoolHelper getCreateAuditPool() {
        KElement auditPool = this.theElement.getCreateElement("AuditPool");
        return new AuditPoolHelper(auditPool);
    }

    public SetHelper getSet(String id) {
        if (StringUtil.isEmpty(id)) {
            return null;
        }
        for (KElement e = this.theElement.getFirstChildElement(); e != null; e = e.getNextSiblingElement()) {
            if (!id.equals(e.getID()) || !SetHelper.isSet(e)) continue;
            return new SetHelper(e);
        }
        return null;
    }

    public SetHelper getNodeInfo() {
        return this.getSet("NodeInfo", 0);
    }

    public SetHelper getCreateNodeInfo() {
        return this.getCreateSet("NodeInfo", JDFResourceLink.EnumUsage.Input);
    }

    public SetHelper getSetForPartition(String id) {
        ResourceHelper ph = this.getPartition(id);
        if (ph != null) {
            return ph.getSet();
        }
        return this.getSet(id);
    }

    public ResourceHelper getPartition(String id) {
        if (id == null) {
            return null;
        }
        for (KElement e = this.theElement.getFirstChildElement(); e != null; e = e.getNextSiblingElement()) {
            ResourceHelper ph;
            if (!SetHelper.isSet(e) || (ph = new SetHelper(e).getPartition(id)) == null) continue;
            return ph;
        }
        return null;
    }

    @Deprecated
    public boolean isSet(KElement e) {
        return SetHelper.isSet(e);
    }

    public String getJobID() {
        return this.getXPathValue("@JobID");
    }

    public VString getDependentJobParts(JDFResourceLink.EnumUsage usage) {
        Vector<SetHelper> vsh = this.getSets(null, usage);
        VString ret = new VString();
        if (vsh != null) {
            for (SetHelper sh : vsh) {
                ret.appendUnique(sh.getDependentJobParts());
            }
        }
        return ret.isEmpty() ? null : ret;
    }

    public ProductHelper getProduct(String id) {
        KElement productList = this.theElement == null ? null : this.theElement.getElement("ProductList");
        KElement productElement = productList == null ? null : productList.getChildWithAttribute("Product", "ID", null, id, 0, true);
        return productElement == null ? null : new ProductHelper(productElement);
    }

    public ProductHelper getProductByExternalID(String id) {
        KElement productList = this.theElement == null ? null : this.theElement.getElement("ProductList");
        KElement productElement = productList == null ? null : productList.getChildWithAttribute("Product", "ExternalID", null, id, 0, true);
        return productElement == null ? null : new ProductHelper(productElement);
    }

    public ProductHelper getCreateProduct(String id) {
        return this.getCreateProduct(id, null);
    }

    public ProductHelper getCreateProduct(String id, String externalID) {
        ProductHelper ph = this.getProduct(id);
        if (ph == null) {
            ph = this.appendProduct();
            ph.setID(id);
            ph.setExternalID(externalID);
        }
        return ph;
    }

    public ProductHelper getRootProduct(int iProduct) {
        Vector<ProductHelper> rootProductHelpers = this.getRootProductHelpers();
        if (rootProductHelpers == null) {
            return null;
        }
        if (iProduct < 0) {
            iProduct = rootProductHelpers.size() + iProduct;
        }
        if (iProduct >= rootProductHelpers.size() || iProduct < 0) {
            return null;
        }
        ProductHelper productHelper = rootProductHelpers.get(iProduct);
        return productHelper;
    }

    public ProductHelper getCreateRootProduct(int iProduct) {
        ProductHelper productHelper = this.getRootProduct(iProduct);
        if (productHelper == null) {
            productHelper = this.appendProduct();
            productHelper.setRoot();
        }
        return productHelper;
    }

    public int numProductHelpers(boolean rootOnly) {
        Vector<ProductHelper> v = rootOnly ? this.getRootProductHelpers() : this.getProductHelpers();
        return v == null ? 0 : v.size();
    }

    public Vector<ProductHelper> getRootProductHelpers() {
        Vector<ProductHelper> vp = this.getProductHelpers();
        if (vp == null) {
            return null;
        }
        Vector<ProductHelper> vp2 = new Vector<ProductHelper>();
        for (ProductHelper ph : vp) {
            if (!ph.isRootProduct()) continue;
            vp2.add(ph);
        }
        return vp2.size() == 0 ? null : vp2;
    }

    public Vector<ProductHelper> getProductHelpers() {
        VElement products;
        KElement productList = this.theElement == null ? null : this.theElement.getElement("ProductList");
        VElement vElement = products = productList == null ? null : productList.getChildElementVector("Product", null);
        if (ContainerUtil.isEmpty(products)) {
            return null;
        }
        Vector<ProductHelper> vph = new Vector<ProductHelper>();
        for (KElement e : products) {
            vph.add(new ProductHelper(e));
        }
        return vph;
    }

    public ResourceHelper getPartition(String name, int iSet, int iPart) {
        SetHelper sh = this.getSet(name, iSet);
        return sh == null ? null : sh.getPartition(iPart);
    }

    public KElement getResource(String name, int iSet, int iPart) {
        ResourceHelper ph = this.getPartition(name, iSet, iPart);
        return ph == null ? null : ph.getResource();
    }

    public SetHelper getSet(String name, int iSkip) {
        int n = 0;
        KElement e2 = null;
        for (KElement e = this.theElement.getFirstChildElement(); e != null; e = e.getNextSiblingElement()) {
            if (!SetHelper.isSet(e) || name != null && !name.equals(e.getAttribute("Name", null, null)) || n++ != iSkip) continue;
            e2 = e;
            break;
        }
        return e2 == null ? null : new SetHelper(e2);
    }

    public SetHelper getSet(String name, JDFResourceLink.EnumUsage usage, String processUsage) {
        int cpi;
        SetHelper set = this.getSet(name, usage, processUsage, null);
        if (set == null && (cpi = this.indexOfType(processUsage, 0)) >= 0) {
            set = this.getSet(name, usage, null, cpi);
        }
        return set;
    }

    public SetHelper getSet(String name, JDFResourceLink.EnumUsage usage, String processUsage, JDFIntegerList cpi) {
        String usageString;
        String string = usageString = usage == null ? null : usage.getName();
        for (KElement e = this.theElement.getFirstChildElement(); e != null; e = e.getNextSiblingElement()) {
            if (!SetHelper.isSet(e) || name != null && !name.equals(e.getNonEmpty("Name")) || !StringUtil.equals(usageString, e.getNonEmpty("Usage")) || !StringUtil.equals(processUsage, e.getNonEmpty("ProcessUsage")) || !ContainerUtil.containsAny(new SetHelper(e).getCombinedProcessIndex(), cpi)) continue;
            return new SetHelper(e);
        }
        return null;
    }

    public SetHelper getSet(String name, JDFResourceLink.EnumUsage usage, String processUsage, int cpi) {
        String usageString;
        String string = usageString = usage == null ? null : usage.getName();
        for (KElement e = this.theElement.getFirstChildElement(); e != null; e = e.getNextSiblingElement()) {
            if (!SetHelper.isSet(e) || name != null && !name.equals(e.getNonEmpty("Name")) || !StringUtil.equals(usageString, e.getNonEmpty("Usage")) || !StringUtil.equals(processUsage, e.getNonEmpty("ProcessUsage")) || !ContainerUtil.contains(new SetHelper(e).getCombinedProcessIndex(), cpi)) continue;
            return new SetHelper(e);
        }
        return null;
    }

    public SetHelper getCreateSet(String name, JDFResourceLink.EnumUsage usage, String processUsage, JDFIntegerList cpi) {
        SetHelper s0 = this.getSet(name, usage, processUsage, cpi);
        if (s0 == null) {
            s0 = this.appendResourceSet(name, usage);
            s0.setProcessUsage(processUsage);
            s0.setCombinedProcessIndex(cpi);
        }
        return s0;
    }

    public SetHelper getSet(String name, JDFResourceLink.EnumUsage usage) {
        KElement e;
        String usageString;
        String string = usageString = usage == null ? null : usage.getName();
        for (e = this.theElement.getFirstChildElement(); e != null; e = e.getNextSiblingElement()) {
            if (!SetHelper.isSet(e) || name != null && !name.equals(e.getNonEmpty("Name")) || !StringUtil.equals(usageString, e.getNonEmpty("Usage"))) continue;
            return new SetHelper(e);
        }
        if (usage == null) {
            for (e = this.theElement.getFirstChildElement(); e != null; e = e.getNextSiblingElement()) {
                if (!SetHelper.isSet(e) || name != null && !name.equals(e.getNonEmpty("Name"))) continue;
                return new SetHelper(e);
            }
        }
        return null;
    }

    public SetHelper appendSet(String family, String name, JDFResourceLink.EnumUsage usage) {
        if (family == null) {
            family = RESOURCE;
        }
        KElement newSet = this.theElement.appendElement(family + "Set");
        newSet.setAttribute("Name", name);
        if (name == null) {
            name = "Set";
        }
        SetHelper h = new SetHelper(newSet);
        h.setID(KElement.xmlnsLocalName(name) + KElement.uniqueID(0));
        if (usage != null) {
            h.setUsage(usage);
        }
        return h;
    }

    @Deprecated
    public SetHelper getCreateSet(String family, String name, JDFResourceLink.EnumUsage usage) {
        SetHelper newSet = this.getSet(name, usage, null);
        if (newSet == null) {
            newSet = this.appendSet(family, name, usage);
        }
        return newSet;
    }

    @Deprecated
    public SetHelper getCreateResourceSet(String name, JDFResourceLink.EnumUsage usage) {
        return this.getCreateSet(RESOURCE, name, usage);
    }

    public SetHelper getCreateSet(String name, JDFResourceLink.EnumUsage usage) {
        SetHelper set = this.getSet(name, usage);
        if (set == null) {
            set = this.appendResourceSet(name, usage);
        }
        return set;
    }

    public KElement getCreateResource(String name, JDFResourceLink.EnumUsage usage, String processUsage) {
        SetHelper set = this.getCreateSet(name, usage, processUsage);
        ResourceHelper rh = set.getCreatePartition(null, true);
        return rh.getResource();
    }

    public SetHelper getCreateSet(String name, JDFResourceLink.EnumUsage usage, String processUsage) {
        SetHelper set = this.getSet(name, usage, processUsage);
        if (set == null) {
            set = this.appendSet(RESOURCE, name, usage);
            set.setProcessUsage(processUsage);
        }
        return set;
    }

    @Deprecated
    public SetHelper getCreateParameterSet(String name, JDFResourceLink.EnumUsage usage) {
        return this.getCreateSet(RESOURCE, name, usage);
    }

    public void removeSet(String name) {
        SetHelper newSet = this.getSet(name, 0);
        if (newSet != null) {
            newSet.getSet().deleteNode();
        }
    }

    @Deprecated
    public SetHelper appendParameter(String name, JDFResourceLink.EnumUsage usage) {
        return this.appendResourceSet(name, usage);
    }

    public ProductHelper appendProduct() {
        KElement product = this.theElement.getCreateElement("ProductList").appendElement("Product");
        ProductHelper productHelper = new ProductHelper(product);
        productHelper.setRoot(productHelper.isRootProduct());
        return productHelper;
    }

    @Deprecated
    public SetHelper appendResource(String name, JDFResourceLink.EnumUsage usage) {
        return this.appendResourceSet(name, usage);
    }

    public SetHelper appendResourceSet(String name, JDFResourceLink.EnumUsage usage) {
        return this.appendSet(RESOURCE, name, usage);
    }

    public SetHelper appendSet(String name, JDFResourceLink.EnumUsage usage) {
        return this.appendSet(RESOURCE, name, usage);
    }

    @Override
    public String toString() {
        return "XJDFHelper: " + this.theElement;
    }

    public boolean writeToFile(String file) {
        this.cleanUp();
        boolean b = this.getRoot().getOwnerDocument_KElement().write2File(file, 2, false);
        return b;
    }

    public File writeToDir(String dir) {
        String file;
        String newURL;
        boolean ok;
        String jobPartID;
        String jobID = this.getJobID();
        if (StringUtil.getNonEmpty(jobID) == null) {
            jobID = "xjdf";
        }
        if (StringUtil.getNonEmpty(jobPartID = this.getJobPartID()) == null) {
            String types = this.getAttribute("Types");
            if (StringUtil.getNonEmpty(types) == null) {
                types = "unknown";
            }
            jobPartID = types;
        }
        return (ok = this.writeToFile(newURL = UrlUtil.getURLWithDirectory(dir, file = jobID + "." + jobPartID + ".xjdf"))) ? new File(newURL) : null;
    }

    public void writeToStream(OutputStream os) throws IOException {
        this.cleanUp();
        this.getRoot().getOwnerDocument_KElement().write2Stream(os, 2, false);
    }

    public void setTypes(String types) {
        VString vtypes = VString.getVString(types, null);
        this.setTypes(vtypes);
    }

    public void setTypes(VString vtypes) {
        this.setAttribute("Types", StringUtil.setvString(vtypes));
    }

    public VString getTypes() {
        return VString.getVString(this.getAttribute("Types"), null);
    }

    public String getCategory() {
        return this.getAttribute("Category");
    }

    public VJDFAttributeMap getPartMapVector() {
        SetHelper sh = this.getSet("NodeInfo", JDFResourceLink.EnumUsage.Input, null);
        return sh == null ? null : sh.getPartMapVector();
    }

    public JDFNode.EnumType getType() {
        VString types = this.getTypes();
        JDFNode.EnumType typ = null;
        if (types != null && types.size() == 1) {
            typ = JDFNode.EnumType.getEnum(types.get(0));
        }
        return typ == null ? JDFNode.EnumType.ProcessGroup : typ;
    }

    @Override
    public void cleanUp() {
        this.cleanUp(true);
    }

    public void cleanUp(boolean zappIDs) {
        AuditPoolHelper auditPoolHelper;
        Vector<ProductHelper> vp;
        super.cleanUp();
        Vector<SetHelper> v = this.getSets();
        if (v != null) {
            for (SetHelper setHelper : v) {
                setHelper.cleanUp();
                this.theElement.moveElement(setHelper.getSet(), null);
            }
        }
        if (!ContainerUtil.isEmpty(vp = this.getProductHelpers())) {
            this.sortProducts(vp);
            for (ProductHelper ph : vp) {
                ph.cleanUp();
                this.theElement.getElement("ProductList").moveElement(ph.getProduct(), null);
            }
        }
        if ((auditPoolHelper = this.getAuditPool()) != null) {
            auditPoolHelper.cleanUp();
        }
        if (zappIDs) {
            new IDRemover().removeIDs(this.theElement);
        }
    }

    void sortProducts(List<ProductHelper> vp) {
        int i;
        int jRoot = 0;
        int size = vp.size();
        for (i = 0; i < size; ++i) {
            if (!vp.get(i).isRootProduct()) continue;
            if (jRoot != i) {
                ProductHelper ph0 = vp.set(jRoot, vp.get(i));
                vp.set(i, ph0);
                --i;
            }
            ++jRoot;
        }
        for (i = 0; i < size; ++i) {
            List<String> kids = vp.get(i).getChildRefs(false);
            if (ContainerUtil.isEmpty(kids)) continue;
            int p0 = i + 1;
            for (int j = i + 1; j < size; ++j) {
                String id = vp.get(j).getID();
                if (!kids.contains(id)) continue;
                if (p0 != j) {
                    ProductHelper ph0 = vp.set(p0, vp.get(j));
                    vp.set(j, ph0);
                }
                ++p0;
            }
        }
    }

    public XJDFHelper clone() {
        KElement k = this.theElement == null ? null : this.theElement.cloneNewDoc();
        return new XJDFHelper(k);
    }

    public String getJobPartID() {
        return this.getAttribute("JobPartID");
    }

    public void setJobPartID(String jobPartID) {
        this.setAttribute("JobPartID", jobPartID);
    }

    public void setJobID(String jobID) {
        this.setAttribute("JobID", jobID);
    }

    public void setCategory(String cat) {
        this.setAttribute("Category", cat);
    }

    @Override
    public String getDescriptiveName() {
        return this.getAttribute("DescriptiveName");
    }

    public void removeType(String typ, int iSkip) {
        VString types = this.getTypes();
        if (types != null && types.indexOf(typ, iSkip) >= 0) {
            int pos = types.indexOf(typ, iSkip);
            types.remove(pos);
            this.setTypes(types);
            Vector<SetHelper> sets = this.getSets();
            if (sets != null) {
                for (SetHelper set : sets) {
                    set.removeTypeFromCPI(pos);
                }
            }
        }
    }

    public XJDFHelper addType(String typ) {
        this.addType(typ, -1);
        return this;
    }

    public XJDFHelper addType(JDFNode.EnumType typ) {
        return this.addType(typ.getName());
    }

    public void addType(String typ, int iSkip) {
        VString types = this.getTypes();
        if (types == null) {
            types = new VString();
        }
        int lastPos = types.size();
        if (iSkip < 0) {
            iSkip = lastPos;
        }
        if (iSkip <= lastPos) {
            types.insertElementAt(typ, iSkip);
            this.setTypes(types);
            Vector<SetHelper> sets = this.getSets();
            if (sets != null) {
                for (SetHelper set : sets) {
                    set.addTypeToCPI(iSkip);
                }
            }
        }
    }

    public int indexOfType(String typ, int iSkip) {
        VString types = this.getTypes();
        if (types == null || typ == null) {
            return -1;
        }
        int n = -1;
        while (iSkip-- >= 0) {
            int i = types.indexOf(typ, n + 1);
            if (i >= 0) {
                n = i;
                continue;
            }
            n = -1;
            break;
        }
        return n;
    }

    public static JDFElement.EnumVersion defaultVersion() {
        return XJDFHelper.getDefaultVersion();
    }

    public void setVersion(JDFElement.EnumVersion v) {
        this.setAttribute("Version", v == null ? XJDFHelper.defaultVersion().getName() : v.getName());
    }

    public VString setICSVersions(ICSVersion ... versions) {
        this.setAttribute("ICSVersions", null);
        for (ICSVersion v : versions) {
            this.appendICSVersion(v);
        }
        return VString.getVString(this.getAttribute("ICSVersions"), null);
    }

    public String appendICSVersion(ICSVersion v) {
        return this.getRoot().appendAttribute("ICSVersions", v == null ? null : v.toString(), true);
    }

    @Override
    public void setExternalID(String newID) {
        this.getCreateNodeInfo().setExternalID(newID);
    }

    @Override
    public void setDescriptiveName(String description) {
        super.setDescriptiveName(description);
    }

    @Override
    public NodeIdentifier getIdentifier() {
        return new NodeIdentifier(this.getJobID(), this.getJobPartID(), this.getPartMapVector());
    }

    @Override
    public void setIdentifier(NodeIdentifier ni) {
        if (ni != null) {
            this.setJobID(ni.getJobID());
            this.setJobPartID(ni.getJobPartID());
            this.setParts(ni.getPartMapVector());
        }
    }

    @Override
    public void setGeneralID(String idUsage, String idValue) {
        super.setGeneralID(idUsage, idValue);
    }
}

