/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.JDFMatrix;
import org.cip4.jdflib.datatypes.JDFNumList;
import org.cip4.jdflib.datatypes.JDFRectangle;
import org.cip4.jdflib.datatypes.JDFXYPair;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.WalkJDFSubElement;
import org.cip4.jdflib.resource.process.JDFCutBlock;

public class WalkCutBlock
extends WalkJDFSubElement {
    @Override
    public boolean matches(KElement toCheck) {
        return !this.jdfToXJDF.isRetainAll() && toCheck instanceof JDFCutBlock;
    }

    @Override
    public KElement walk(KElement e, KElement trackElem) {
        JDFCutBlock cutBlock = (JDFCutBlock)e;
        this.copyToBox(cutBlock);
        return super.walk(e, trackElem);
    }

    private void copyToBox(JDFCutBlock cutBlock) {
        JDFXYPair size = cutBlock.getBlockSize();
        if (size != null) {
            JDFMatrix blockTrf = cutBlock.getBlockTrf();
            JDFRectangle box = new JDFRectangle(0.0, 0.0, size.getX(), size.getY());
            if (blockTrf != null) {
                JDFXYPair shift = blockTrf.getShift();
                box.shift(shift);
            }
            cutBlock.setAttribute("Box", (JDFNumList)box, (String)null);
        }
        cutBlock.removeAttribute("BlockSize");
        cutBlock.removeAttribute("BlockTrf");
    }

    @Override
    public VString getElementNames() {
        return new VString("CutBlock", null);
    }

    @Override
    protected void updateAttributes(JDFAttributeMap map) {
        map.remove("Class");
        map.renameKey("AssemblyIDs", "BinderySignatureIDs");
        String externalID = map.get("ProductID");
        String name = map.get("DescriptiveName");
        super.updateAttributes(map);
        map.putNotNull("ExternalID", externalID);
        map.putNotNull("DescriptiveName", name);
        map.remove("BlockElementType");
        map.remove("BlockType");
    }
}

