/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf;

import java.util.List;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.StringArray;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf.WalkStrippingParams;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.JDFStrippingParams;
import org.cip4.jdflib.resource.process.JDFLayout;
import org.cip4.jdflib.util.StringUtil;

public class WalkLayout
extends WalkStrippingParams {
    private static final StringArray copyRefs = new StringArray(new String[]{"FilmRef", "PaperRef", "PlateRef", "ProofPaperRef", "Automated"});

    @Override
    public boolean matches(KElement toCheck) {
        return toCheck instanceof JDFLayout;
    }

    private void splitLayout(KElement e, KElement trackElem) {
        JDFStrippingParams stripParams = (JDFStrippingParams)e.appendElement("StrippingParams");
        boolean foundSome = this.moveToStripping(e, stripParams);
        if (foundSome) {
            this.createStrippingPartition(stripParams, (JDFLayout)trackElem);
        }
        stripParams.deleteNode();
    }

    private boolean moveToStripping(KElement e, JDFStrippingParams stripParams) {
        VString vAtt = stripParams.knownAttributes();
        JDFAttributeMap map = e.getAttributeMap();
        boolean foundSome = false;
        for (String s : map.keySet()) {
            if (copyRefs.contains(s)) {
                stripParams.setAttribute(s, map.get(s));
                foundSome = true;
                continue;
            }
            if (!vAtt.contains(s)) continue;
            stripParams.setAttribute(s, map.get(s));
            e.removeAttribute(s);
            foundSome = true;
        }
        VString stripKnown = stripParams.knownElements();
        List<KElement> vMyElm = e.getChildArray_KElement(null, null, null, true, 0);
        for (KElement myElm : vMyElm) {
            String localName = myElm.getLocalName();
            if (stripKnown.contains(localName) || localName.endsWith("Ref") && stripKnown.contains(StringUtil.leftStr(localName, -3))) {
                stripParams.moveElement(myElm, null);
                foundSome = true;
                continue;
            }
            if ("FileSpec".equals(localName)) {
                stripParams.getCreateExternalImpositionTemplate().moveElement(myElm, null);
                foundSome = true;
                continue;
            }
            if (!"FitPolicy".equals(localName)) continue;
            myElm.deleteNode();
        }
        return foundSome;
    }

    private void createStrippingPartition(JDFStrippingParams stripParams, JDFLayout trackLayout) {
        JDFNode node = this.xjdfToJDFImpl.currentJDFNode;
        node = this.getNode(stripParams.getParentNode_KElement().getParentNode_KElement(), node);
        if (node == null) {
            this.log.error((Object)"whazzup - not in xjdf root???");
        } else {
            JDFStrippingParams sp;
            JDFNode layoutParent = trackLayout.getParentJDF();
            JDFStrippingParams sp0 = layoutParent == null ? null : (JDFStrippingParams)layoutParent.getResourcePool().getResource("StrippingParams", 0, null);
            JDFAttributeMap partMap = trackLayout.getPartMap();
            if (sp0 != null) {
                sp = sp0;
                node.ensureLink(sp, JDFResourceLink.EnumUsage.Input, null);
            } else {
                sp = (JDFStrippingParams)node.getCreateResource("StrippingParams", JDFResourceLink.EnumUsage.Input, 0);
            }
            JDFStrippingParams part = (JDFStrippingParams)sp.getCreatePartition(partMap, trackLayout.getPartIDKeys());
            KElement foo = part.appendElement("ResourcePool");
            this.xjdfToJDFImpl.walkTree(stripParams, foo);
            JDFResource tmpStripParams = (JDFResource)foo.getElement("StrippingParams");
            tmpStripParams.removeAttribute("Class");
            tmpStripParams.removeAttribute("ID");
            tmpStripParams.copyAttribute("Status", trackLayout);
            tmpStripParams.removeAttribute("PartIDKeys");
            List<? extends KElement> vLeaves = tmpStripParams.getDirectPartitionArray();
            for (KElement kElement : vLeaves) {
                JDFResource rLeaf = (JDFResource)kElement;
                String bs = rLeaf.getBinderySignatureName();
                JDFResource bsPart = part.getPartition(new JDFAttributeMap("BinderySignatureName", bs), JDFResource.EnumPartUsage.Explicit);
                if (bsPart == null) continue;
                rLeaf.deleteNode();
            }
            part.copyAttribute("DescriptiveName", trackLayout);
            part.copyInto(tmpStripParams, false);
            if (tmpStripParams.getElement_KElement("StrippingParams", null, 0) != null) {
                sp.addPartIDKey(JDFResource.EnumPartIDKey.BinderySignatureName);
            }
            foo.deleteNode();
        }
    }

    @Override
    public KElement walk(KElement xjdfLayout, KElement jdfLayout) {
        this.splitLayout(xjdfLayout, jdfLayout);
        KElement walk = super.walk(xjdfLayout, jdfLayout);
        return walk;
    }

    @Override
    protected String getRefName(String val) {
        if ("PaperRef".equals(val) || "PlateRef".equals(val) || "ProofRef".equals(val)) {
            return "MediaRef";
        }
        return super.getRefName(val);
    }
}

