/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.process;

import java.util.Collection;
import java.util.List;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoAssembly;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.StringArray;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.process.JDFAssemblySection;
import org.cip4.jdflib.util.ContainerUtil;

public class JDFAssembly
extends JDFAutoAssembly {
    private static final long serialVersionUID = 1L;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[1];

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    public JDFAssembly(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFAssembly(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFAssembly(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFAssembly[  --> " + super.toString() + " ]";
    }

    public VString getAssemblyAttributes(String attName) {
        VElement leaves = this.getLeaves(false);
        VString v = new VString();
        for (KElement e : leaves) {
            VElement sections = e.getChildElementVector("AssemblySection", null);
            String at = e.getAttribute(attName, null, null);
            if (at != null) {
                v.add(at);
            }
            if (sections == null) continue;
            for (KElement es : sections) {
                at = es.getAttribute(attName, null, null);
                if (at == null) continue;
                v.add(at);
            }
        }
        ContainerUtil.unify(v);
        return v.size() == 0 ? null : v;
    }

    public StringArray getAllAssemblyIDs() {
        List<JDFResource> leaves = this.getLeafArray(false);
        StringArray v = new StringArray();
        for (JDFResource e : leaves) {
            JDFAssembly leaf = (JDFAssembly)e;
            v.addNonEmpty(leaf.getAssemblyID());
            VString aids = leaf.getAssemblyIDs();
            v.addAll(aids);
            Collection<JDFAssemblySection> asss = leaf.getAllAssemblySection();
            for (JDFAssemblySection ass : asss) {
                v.addAll(ass.getAllAssemblyIDs());
            }
        }
        ContainerUtil.unify(v);
        return v.isEmpty() ? null : v;
    }

    static {
        JDFAssembly.atrInfoTable[0] = new AtrInfoTable("Order", 0x33333311L, AttributeInfo.EnumAttributeType.enumeration, JDFAutoAssembly.EnumOrder.getEnum(0), "Gathering");
    }
}

