/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.lang.enums.EnumUtils;
import org.apache.commons.lang.enums.ValuedEnum;
import org.cip4.jdflib.core.StringArray;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.util.StringUtil;

public class EnumUtil {
    private static final String NULL = "null";

    public static VString getNamesVector(Class<? extends ValuedEnum> e) {
        if (e == null) {
            return null;
        }
        VString namesVector = new VString();
        Iterator it = EnumUtils.iterator(e);
        while (it.hasNext()) {
            namesVector.addElement(((ValuedEnum)it.next()).getName());
        }
        return namesVector;
    }

    public static StringArray getNamesList(Class<? extends ValuedEnum> e) {
        if (e == null) {
            return null;
        }
        StringArray list = new StringArray();
        Iterator it = EnumUtils.iterator(e);
        while (it.hasNext()) {
            list.add(((ValuedEnum)it.next()).getName());
        }
        return list;
    }

    public static Vector<ValuedEnum> getEnumsVector(Class<? extends ValuedEnum> e) {
        Vector<ValuedEnum> v = new Vector<ValuedEnum>();
        Iterator it = EnumUtils.iterator(e);
        while (it.hasNext()) {
            v.addElement((ValuedEnum)it.next());
        }
        return v;
    }

    public static ValuedEnum min(ValuedEnum e1, ValuedEnum e2) {
        if (e1 == null || e2 == null) {
            return null;
        }
        return e1.getValue() < e2.getValue() ? e1 : e2;
    }

    public static ValuedEnum max(ValuedEnum e1, ValuedEnum e2) {
        if (e1 == null) {
            return e2;
        }
        if (e2 == null) {
            return e1;
        }
        return e1.getValue() > e2.getValue() ? e1 : e2;
    }

    public static String getName(ValuedEnum en) {
        return en == null ? NULL : en.getName();
    }

    public static String getEnumName(ValuedEnum en) {
        return en == null ? null : StringUtil.token(en.getClass().getName(), -1, "$");
    }

    public static boolean aLessThanB(ValuedEnum a, ValuedEnum b) {
        int aa = a == null ? -1 : a.getValue();
        int bb = b == null ? -1 : b.getValue();
        return aa < bb;
    }

    public static boolean aLessEqualsThanB(ValuedEnum a, ValuedEnum b) {
        int aa = a == null ? -1 : a.getValue();
        int bb = b == null ? -1 : b.getValue();
        return aa <= bb;
    }

    public static ValuedEnum getEnumIgnoreCase(Class<? extends ValuedEnum> clazz, Enum<?> e) {
        String s = e == null ? null : e.name();
        return EnumUtil.getEnumIgnoreCase(clazz, s);
    }

    public static ValuedEnum getEnumIgnoreCase(Class<? extends ValuedEnum> clazz, String s) {
        if (!StringUtil.isEmpty(s) && clazz != null) {
            Iterator it = EnumUtils.iterator(clazz);
            while (it.hasNext()) {
                ValuedEnum next = (ValuedEnum)it.next();
                if (!s.equalsIgnoreCase(next.getName())) continue;
                return (ValuedEnum)EnumUtils.getEnum(clazz, (String)next.getName());
            }
        }
        return null;
    }
}

