/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cip4.jdflib.util.ContainerUtil;

public class MemorySpy {
    private static final String PEAK = "Peak";
    public static final String CURRENT = "Current";
    public static final String TOTAL = "Total";
    public static final String FREE = "Free";
    private final List<MemoryPoolMXBean> memList = ManagementFactory.getMemoryPoolMXBeans();
    private final MemoryMXBean mainBean = ManagementFactory.getMemoryMXBean();
    static final long MEGA = 0x100000L;
    private boolean wantMega = defaultMega;
    private static boolean defaultMega = false;

    public static boolean isDefaultMega() {
        return defaultMega;
    }

    public static void setDefaultMega(boolean defaultMega) {
        MemorySpy.defaultMega = defaultMega;
    }

    public Map<String, Long> getSizeMap() {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("heap", this.mainBean.getHeapMemoryUsage().getUsed());
        map.put("non-heap", this.mainBean.getNonHeapMemoryUsage().getUsed());
        for (MemoryPoolMXBean poolBean : this.memList) {
            map.put(poolBean.getName(), poolBean.getUsage().getUsed());
            map.put("comitted " + poolBean.getName(), poolBean.getUsage().getCommitted());
            map.put("peak " + poolBean.getName(), poolBean.getPeakUsage().getUsed());
        }
        return map;
    }

    public long getHeapUsed(MemScope scope) {
        MemoryUsage usage = this.mainBean.getHeapMemoryUsage();
        return this.getMem(usage, scope) / this.getFactor();
    }

    public long getNonHeapUsed(MemScope scope) {
        MemoryUsage usage = this.mainBean.getNonHeapMemoryUsage();
        return this.getMem(usage, scope) / this.getFactor();
    }

    public long getPermGen(MemScope scope) {
        return this.getMemFromPool("Perm Gen", scope);
    }

    private MemoryPoolMXBean getBeanFromPool(String name) {
        for (MemoryPoolMXBean poolBean : this.memList) {
            if (!name.endsWith(poolBean.getName())) continue;
            return poolBean;
        }
        return null;
    }

    private long getMem(MemoryUsage usage, MemScope scope) {
        if (MemScope.current.equals((Object)scope) || MemScope.peak.equals((Object)scope)) {
            return usage.getUsed();
        }
        if (MemScope.commit.equals((Object)scope) || MemScope.peak.equals((Object)scope)) {
            return usage.getCommitted();
        }
        if (MemScope.init.equals((Object)scope)) {
            return usage.getInit();
        }
        return -1L;
    }

    public long getMemFromPool(String name, MemScope scope) {
        MemoryPoolMXBean bean = this.getBeanFromPool(name);
        if (bean == null) {
            return -1L;
        }
        boolean peak = MemScope.peak.equals((Object)scope) || MemScope.peakCommit.equals((Object)scope);
        MemoryUsage usage = peak ? bean.getPeakUsage() : bean.getUsage();
        return this.getMem(usage, scope) / this.getFactor();
    }

    public String getSummary(String delim) {
        StringBuilder b = new StringBuilder();
        Map<String, Long> map = this.getSummaryMap();
        List<String> keyList = ContainerUtil.getKeyList(map);
        keyList.sort(null);
        for (String s : keyList) {
            b.append("Mem ").append(s).append(": ").append(map.get(s)).append(delim);
        }
        return b.toString();
    }

    public String getSummary() {
        return this.getSummary("\n");
    }

    public long getCurrentMem() {
        Runtime rt = Runtime.getRuntime();
        return (rt.totalMemory() - rt.freeMemory()) / this.getFactor();
    }

    public Map<String, Long> getSummaryMap() {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put(FREE, this.getFreeMem());
        map.put(TOTAL, this.getTotalMemory());
        map.put(CURRENT, this.getCurrentMem());
        map.put(PEAK, this.getHeapUsed(MemScope.peak));
        return map;
    }

    public long getTotalMemory() {
        return Runtime.getRuntime().totalMemory() / this.getFactor();
    }

    public long getFreeMem() {
        return Runtime.getRuntime().freeMemory() / this.getFactor();
    }

    long getFactor() {
        long div = this.wantMega ? 0x100000L : 1L;
        return div;
    }

    public String toString() {
        Map<String, Long> sizeMap = this.getSizeMap();
        List<String> keys = ContainerUtil.getKeyList(sizeMap);
        Collections.sort(keys);
        StringBuilder b = new StringBuilder("MemorySpy: \n");
        for (String key : keys) {
            b.append(key);
            b.append(" = ");
            b.append(sizeMap.get(key));
            b.append("\n");
        }
        return b.toString();
    }

    public boolean isWantMega() {
        return this.wantMega;
    }

    public void setWantMega(boolean wantMega) {
        this.wantMega = wantMega;
    }

    public static enum MemScope {
        current,
        peak,
        init,
        peakCommit,
        commit;

    }
}

