/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.core.XMLDoc;
import org.cip4.jdflib.ifaces.IStreamWriter;
import org.cip4.jdflib.ifaces.IURLSetter;
import org.cip4.jdflib.util.BiHashMap;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.MimeUtil;
import org.cip4.jdflib.util.PlatformUtil;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.URLReader;
import org.cip4.jdflib.util.UrlPart;
import org.cip4.jdflib.util.mime.BodyPartHelper;
import org.cip4.jdflib.util.mime.MimeHelper;
import org.cip4.jdflib.util.zip.ZipReader;

public class UrlUtil {
    private static final String SLASHSLASH = "//";
    private static final String FILE = "file:";
    private static final String FTP = "ftp:";
    private static final String HTTPS = "https:";
    private static final String HTTP = "http:";
    public static final int MAX_STREAM = 12345678;
    private static Log log = LogFactory.getLog(UrlUtil.class);
    public static final String POST = HttpMethod.POST.name();
    public static final String PUT = HttpMethod.PUT.name();
    public static final String GET = HttpMethod.GET.name();
    public static final String HEAD = HttpMethod.HEAD.name();
    public static final String DELETE = HttpMethod.DELETE.name();
    public static final String CONNECT = HttpMethod.CONNECT.name();
    public static final String OPTIONS = HttpMethod.OPTIONS.name();
    public static final String TRACE = HttpMethod.TRACE.name();
    public static final String PATCH = HttpMethod.PATCH.name();
    public static final String KEEPALIVE = "keep-alive";
    static int DEFAULT_CONNECTION_TIMEOUT = 42000;
    public static final String ACCEPT = "accept";
    public static final String CLOSE = "close";
    public static final String CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";
    public static final String m_URIEscape = "|#%?@&=+$,;[]\\\"'<>^{}~*";
    public static final String m_UNCEscape = "/\\*?<>|";
    public static final String TEXT_HTML = "text/html";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String TEXT_UNKNOWN = "text/unknown";
    public static final String APPLICATION_XML = "application/xml";
    public static final String APPLICATION_CFF2 = "application/cff2";
    public static final String APPLICATION_ZIP = "application/zip";
    public static final String APPLICATION_XZIP = "application/x-zip-compressed";
    public static final String APPLICATION_PDF = "application/pdf";
    public static final String APPLICATION_PS = "application/postscript";
    public static final String TEXT_XML = "text/xml";
    public static final String TEXT_CSV = "text/csv";
    public static final String TEXT_JSON = "text/json";
    public static final String APPLICATION_JSON = "application/json";
    public static final String VND_PPF = "application/vnd.cip4-ppf";
    public static final String VND_PTK = "application/vnd.cip4-ptk+xml";
    public static final String VND_PTK_J = "application/vnd.cip4-ptk+json";
    public static final String VND_JDF = "application/vnd.cip4-jdf+xml";
    public static final String VND_JMF = "application/vnd.cip4-jmf+xml";
    public static final String VND_XJDF = "application/vnd.cip4-xjdf+xml";
    public static final String VND_XJMF = "application/vnd.cip4-xjmf+xml";
    public static final String VND_XJDF_J = "application/vnd.cip4-xjdf+json";
    public static final String VND_XJMF_J = "application/vnd.cip4-xjmf+json";
    public static final String CONTENT_ID = "Content-ID";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String BASE64 = "base64";
    public static final String BINARY = "binary";
    public static final String CONNECTION = "Connection";
    public static final String AUTHORIZATION = "Authorization";
    private static BiHashMap<String, String> mimeMap = null;

    public static void setConnectionTimeout(int timeout) {
        DEFAULT_CONNECTION_TIMEOUT = timeout;
    }

    public static int getConnectionTimeout() {
        return DEFAULT_CONNECTION_TIMEOUT;
    }

    public static String getRelativeURL(File f, File baseDir, boolean bEscape128) {
        String relPath = UrlUtil.getRelativePath(f, baseDir);
        if (relPath == null) {
            return UrlUtil.fileToUrl(f, true);
        }
        relPath = StringUtil.replaceChar(relPath, '\\', "/", 0);
        byte[] utf8 = StringUtil.getUTF8Bytes(relPath);
        relPath = new String(utf8);
        relPath = UrlUtil.escape(relPath, bEscape128, false);
        return relPath;
    }

    public static String createHttpUrl(boolean bSecure, String host, int port, String path) {
        if (path != null && !path.startsWith("/")) {
            path = "/" + path;
        }
        try {
            if (port > 0) {
                URL url = new URL("http" + (bSecure ? "s" : ""), host, port, path);
                return url.toExternalForm();
            }
            URL url = new URL("http" + (bSecure ? "s" : ""), host, path);
            return url.toExternalForm();
        }
        catch (MalformedURLException x) {
            return null;
        }
    }

    public static String getRelativePath(File f, File fCWD) {
        if (fCWD == null) {
            fCWD = new File(System.getProperty("user.dir"));
        }
        String cPath = null;
        String cwd = null;
        try {
            cPath = f.getCanonicalPath();
            cwd = fCWD.getCanonicalPath();
            if (cPath.charAt(0) != cwd.charAt(0)) {
                return null;
            }
        }
        catch (IOException e) {
            return null;
        }
        VString vCwd = StringUtil.tokenize(cwd, "/\\", false);
        VString vPath = StringUtil.tokenize(cPath, "/\\", false);
        int lenPath = vPath.size();
        int siz = vCwd.size();
        if (lenPath < siz) {
            siz = lenPath;
        }
        for (int i = 0; i < siz && vCwd.get(0).equals(vPath.get(0)); ++i) {
            vCwd.remove(0);
            vPath.remove(0);
        }
        lenPath = vPath.size();
        siz = vCwd.size();
        String prefix = siz == 0 ? "." : "..";
        for (int i = 1; i < siz; ++i) {
            prefix = prefix + "/..";
        }
        String s = lenPath == 0 ? prefix : StringUtil.setvString(vPath, "/", prefix + "/", null);
        s = UrlUtil.cleanDots(s);
        return StringUtil.replaceString(s, "/", File.separator);
    }

    public static String getFileName(String url, Multipart mp) {
        BodyPart bp;
        String ret;
        if (mp != null && !UrlUtil.isNotCID(url) && (ret = MimeUtil.getFileName(bp = MimeUtil.getPartByCID(mp, url))) != null) {
            return ret;
        }
        return UrlUtil.urlToFileName(url);
    }

    public static InputStream getCidURLStream(String url, Multipart multipart) {
        if (StringUtil.isEmpty(url)) {
            return null;
        }
        MimeHelper mimeHelper = new MimeHelper(multipart);
        BodyPartHelper bp = mimeHelper.getPartHelperByCID(url);
        if (bp == null) {
            bp = mimeHelper.getPartHelperByLocalName(url);
        }
        return bp == null ? null : bp.getInputStream();
    }

    public static String extension(String pathName) {
        if (pathName == null) {
            return null;
        }
        String filename = FilenameUtils.getName((String)pathName);
        int index = filename.lastIndexOf(".");
        return index == -1 ? null : filename.substring(index + 1);
    }

    @Deprecated
    public static String removeExtension(String pathName) {
        return UrlUtil.prefix(pathName);
    }

    public static UrlPart[] getURLParts(HttpURLConnection connection) {
        Multipart mp;
        if (connection == null) {
            return null;
        }
        String urlContentType = connection.getContentType();
        if (!"multipart/related".equalsIgnoreCase(urlContentType)) {
            UrlPart p;
            try {
                p = new UrlPart(connection);
            }
            catch (IOException x) {
                return null;
            }
            return new UrlPart[]{p};
        }
        try {
            mp = MimeUtil.getMultiPart(connection.getInputStream());
        }
        catch (IOException x) {
            return null;
        }
        BodyPart[] bp = MimeUtil.getBodyParts(mp);
        if (bp == null) {
            return null;
        }
        UrlPart[] parts = new UrlPart[bp.length];
        for (int i = 0; i < bp.length; ++i) {
            try {
                bp[i].getContentType();
                parts[i] = new UrlPart(bp[i]);
                continue;
            }
            catch (MessagingException e) {
                parts[i] = null;
                continue;
            }
            catch (IOException e) {
                parts[i] = null;
            }
        }
        return parts;
    }

    public static InputStream getURLInputStream(String urlString, BodyPart bodyPart, ZipReader zr) {
        URLReader reader = new URLReader(urlString);
        reader.setBodyPart(bodyPart);
        reader.setZipReader(zr);
        return reader.getURLInputStream();
    }

    public static InputStream getURLInputStream(String urlString, BodyPart bodyPart) {
        return UrlUtil.getURLInputStream(urlString, bodyPart, null);
    }

    public static InputStream getURLInputStream(String urlString) {
        return UrlUtil.getURLInputStream(urlString, null);
    }

    @Deprecated
    public static File getCreateDirectory(String newDir) {
        return FileUtil.getCreateDirectory(newDir);
    }

    public static String fileToUrl(File f, boolean bEscape128) {
        if (f == null) {
            return null;
        }
        String s = f.getAbsolutePath();
        if (PlatformUtil.isWindows()) {
            s = StringUtil.replaceChar(s, '\\', "/", 0);
        }
        s = UrlUtil.cleanDots(s);
        if ((s = UrlUtil.escape(s, bEscape128, false)) != null && s.charAt(0) != '/') {
            s = "///" + s;
        }
        return FILE + s;
    }

    public static String urlToFileName(String urlString) {
        int posQ;
        if (urlString == null) {
            return null;
        }
        int posSlash = urlString.lastIndexOf("/");
        posSlash = Math.max(posSlash, urlString.lastIndexOf("\\"));
        if ((posSlash = Math.max(posSlash, urlString.lastIndexOf(":"))) > 0) {
            urlString = urlString.substring(posSlash + 1);
        }
        if ((posQ = urlString.lastIndexOf("?")) > 0) {
            urlString = urlString.substring(0, posQ);
        }
        if (urlString.length() == 0) {
            return null;
        }
        File urlToFile = UrlUtil.urlToFile(urlString);
        return urlToFile == null ? null : urlToFile.getName();
    }

    public static File urlToFile(String urlString) {
        if (urlString == null || UrlUtil.isCID(urlString) || UrlUtil.isNet(urlString)) {
            return null;
        }
        if (UrlUtil.isFile(urlString)) {
            urlString = urlString.substring(5);
        }
        if (StringUtil.getNonEmpty(urlString) == null) {
            return null;
        }
        File f = new File(urlString);
        if (f.exists()) {
            return f;
        }
        urlString = UrlUtil.unEscape(urlString);
        if (PlatformUtil.isWindows()) {
            if (urlString.startsWith("///") && urlString.length() > 6 && urlString.charAt(4) == ':' && urlString.charAt(5) == '/') {
                urlString = urlString.charAt(3) + ":" + urlString.substring(5);
            } else if (urlString.toLowerCase().startsWith("//localhost/") && urlString.length() > 15 && urlString.charAt(13) == ':' && urlString.charAt(14) == '/') {
                urlString = urlString.charAt(12) + ":" + urlString.substring(14);
            } else if (urlString.startsWith("/") && urlString.length() > 3 && urlString.charAt(1) != '/') {
                if (urlString.charAt(2) == '/') {
                    urlString = urlString.charAt(1) + ":" + urlString.substring(2);
                } else if (urlString.charAt(2) == ':') {
                    urlString = urlString.substring(1);
                }
            } else if (urlString.startsWith("/") && urlString.length() > 3 && urlString.charAt(2) == ':' && urlString.charAt(1) != '/') {
                urlString = urlString.charAt(1) + urlString.substring(2);
            } else if (urlString.startsWith("///")) {
                urlString = urlString.substring(2);
            }
        }
        return new File(urlString);
    }

    public static String urlToUNC(String urlString) {
        if (urlString == null || UrlUtil.isCID(urlString) || UrlUtil.isNet(urlString)) {
            return null;
        }
        if (UrlUtil.isFile(urlString)) {
            urlString = urlString.substring(5);
        }
        if (StringUtil.getNonEmpty(urlString) == null || UrlUtil.isWindowsLocalPath(urlString)) {
            return null;
        }
        urlString = StringUtil.replaceCharSet(urlString, "/\\", "\u0000", 0);
        urlString = UrlUtil.unEscape(urlString);
        urlString = StringUtil.escape(urlString, m_UNCEscape, "%", 16, 2, -1, -1);
        urlString = StringUtil.replaceChar(urlString, '\u0000', "\\", 0);
        return urlString;
    }

    public static String uncToUrl(String unc, boolean escape128) {
        if (!UrlUtil.isUNC(unc)) {
            URL url = UrlUtil.stringToURL(unc);
            return url == null ? null : url.toExternalForm();
        }
        String url = StringUtil.replaceCharSet(unc, "\\", "/", 0);
        url = UrlUtil.escape(url, escape128, false);
        return FILE + url;
    }

    public static String urlToString(URL url) {
        if (url == null) {
            return null;
        }
        return url.toExternalForm();
    }

    public static String addParameter(String baseUrl, String key, String val) {
        if (StringUtil.isEmpty(baseUrl) || StringUtil.isEmpty(key) || StringUtil.isEmpty(val)) {
            return baseUrl;
        }
        int posQMark = baseUrl.indexOf("?");
        String flag = posQMark >= 0 ? "&" : "?";
        StringBuilder buf = new StringBuilder(baseUrl);
        key = UrlUtil.escape(key, true, false);
        val = UrlUtil.escape(val, true, false);
        val = StringUtil.escape(val, ":/", "%", 16, 2, -1, -1);
        buf.append(flag).append(key).append("=").append(val);
        return buf.toString();
    }

    public static String getSecurePath(String url, boolean allowAbsolute) throws IllegalArgumentException {
        if (url == null || !allowAbsolute && !UrlUtil.isRelativeURL(url)) {
            throw new IllegalArgumentException("URL must be relative " + url);
        }
        if (StringUtil.hasToken(url, "..", "/\\", 0)) {
            throw new IllegalArgumentException("URL must not contain .. " + url);
        }
        return UrlUtil.cleanDots(url);
    }

    public static String setParameter(String baseUrl, String key, String val) {
        if (StringUtil.isEmpty(baseUrl) || StringUtil.isEmpty(key)) {
            return baseUrl;
        }
        String oldval = UrlUtil.getParameter(baseUrl, key);
        if (oldval != null) {
            String keyval = UrlUtil.escape(key, true, false) + "=" + UrlUtil.escape(oldval, true, false);
            baseUrl = baseUrl.replace(keyval, "");
            baseUrl = baseUrl.replace("?&", "?");
            if ((baseUrl = baseUrl.replace("&&", "&")).endsWith("?") || baseUrl.endsWith("&")) {
                baseUrl = StringUtil.leftStr(baseUrl, -1);
            }
        }
        return UrlUtil.addParameter(baseUrl, key, val);
    }

    public static String getParameter(String baseUrl, String key) {
        String keye;
        int pos;
        if (!StringUtil.isEmpty(baseUrl) && !StringUtil.isEmpty(key) && (pos = baseUrl.indexOf(keye = UrlUtil.escape(key, true, false) + "=")) > 0 && "?&".contains(baseUrl.substring(pos - 1, pos))) {
            int posEnd = baseUrl.indexOf(38, pos);
            if (posEnd < 0) {
                posEnd = baseUrl.length();
            }
            String val = baseUrl.substring(pos + keye.length(), posEnd);
            return UrlUtil.unEscape(val);
        }
        return null;
    }

    public static String addPath(String baseUrl, String path) throws IllegalArgumentException {
        String newBase = UrlUtil.getSecurePath(baseUrl, true);
        if (path == null) {
            return newBase;
        }
        String newPath = UrlUtil.getSecurePath(path, false);
        String request = StringUtil.token(newBase, 0, "?");
        request = StringUtil.addToken(request, "/", newPath);
        String params = StringUtil.token(newBase, 1, "?");
        if (params != null) {
            request = request + "?" + params;
        }
        return UrlUtil.cleanDots(request);
    }

    public static String escape(String toEscape, boolean bEscape128) {
        return UrlUtil.escape(toEscape, bEscape128, false);
    }

    public static String escape(String toEscape, boolean bEscape128, boolean escapeSlash) {
        String esc;
        if (toEscape == null) {
            return null;
        }
        String string = esc = escapeSlash ? "|#%?@&=+$,;[]\\\"'<>^{}~*/" : m_URIEscape;
        if (bEscape128) {
            byte[] utf8Bytes = StringUtil.getUTF8Bytes(toEscape);
            toEscape = new String(utf8Bytes);
            toEscape = StringUtil.escape(toEscape, esc, "%", 16, 2, 33, 127);
        } else {
            toEscape = StringUtil.escape(toEscape, esc, "%", 16, 2, 33, Integer.MAX_VALUE);
        }
        return toEscape;
    }

    public static String unEscape(String toEscape) {
        return StringUtil.unEscape(toEscape, "%", 16, 2);
    }

    public static URL stringToURL(String urlString) {
        URL url = null;
        if (StringUtil.getNonEmpty(urlString) == null) {
            return null;
        }
        if (UrlUtil.isUNC(urlString)) {
            try {
                return new URL(UrlUtil.uncToUrl(urlString, true));
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        if (UrlUtil.isEscaped(urlString)) {
            urlString = UrlUtil.unEscape(urlString);
        }
        try {
            String fileToUrl;
            url = UrlUtil.isCID(urlString) || UrlUtil.isNet(urlString) ? new URL(urlString) : ((fileToUrl = UrlUtil.fileToUrl(UrlUtil.urlToFile(urlString), true)) == null ? null : new URL(fileToUrl));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return url;
    }

    public static boolean isFileOK(File f) {
        return f != null && f.exists() && !f.isDirectory() && f.canRead();
    }

    public static boolean isEscaped(String url) {
        if (url == null) {
            return false;
        }
        int posColon = url.indexOf(":");
        int posEscapedColon = url.toLowerCase().indexOf("%3a");
        if (posColon < 0 && posEscapedColon < 0) {
            return false;
        }
        if (posColon < 0) {
            posColon += Integer.MAX_VALUE;
        }
        if (posEscapedColon < 0) {
            posEscapedColon += Integer.MAX_VALUE;
        }
        return posEscapedColon < posColon;
    }

    public static String getExtensionFromMimeType(String contentType) {
        if (contentType == null) {
            return null;
        }
        UrlUtil.getMimeTypeFromURL(null);
        String extension = mimeMap.getKey(contentType);
        if (extension == null) {
            if (UrlUtil.isZIPType(contentType)) {
                extension = "zip";
            } else if (UrlUtil.isXMLType(contentType)) {
                extension = "xml";
            } else if (UrlUtil.isJSONType(contentType)) {
                extension = "json";
            }
        }
        return extension;
    }

    public static String getMimeTypeFromURL(String url) {
        String extension;
        if (mimeMap == null) {
            mimeMap = new BiHashMap();
            mimeMap.setUnique(false);
            mimeMap.put("pdf", APPLICATION_PDF);
            mimeMap.put("ps", APPLICATION_PS);
            mimeMap.put("cip", VND_PPF);
            mimeMap.put("cip3", VND_PPF);
            mimeMap.put("ppf", VND_PPF);
            mimeMap.put("ppml", "application/vnd.podi-ppml+xml");
            mimeMap.put("ptk", VND_PTK);
            mimeMap.put("xjdf", VND_XJDF);
            mimeMap.put("xjmf", VND_XJMF);
            mimeMap.put("jdf", VND_JDF);
            mimeMap.put("jmf", VND_JMF);
            mimeMap.put("jjdf", VND_XJDF_J);
            mimeMap.put("jjmf", VND_XJMF_J);
            mimeMap.put("xsl", TEXT_XML);
            mimeMap.put("xsd", TEXT_XML);
            mimeMap.put("xml", TEXT_XML);
            mimeMap.put("json", APPLICATION_JSON);
            mimeMap.put("jsn", APPLICATION_JSON);
            mimeMap.put("csv", TEXT_CSV);
            mimeMap.put("txt", TEXT_UNKNOWN);
            mimeMap.put("jpg", "image/jpeg");
            mimeMap.put("jpeg", "image/jpeg");
            mimeMap.put("png", "image/x-png");
            mimeMap.put("tif", "image/tiff");
            mimeMap.put("tiff", "image/tiff");
            mimeMap.put("mjm", "multipart/related");
            mimeMap.put("mjd", "multipart/related");
            mimeMap.put("mim", "multipart/related");
            mimeMap.put("zip", APPLICATION_ZIP);
            mimeMap.put("cf2", APPLICATION_CFF2);
            mimeMap.put("cff2", APPLICATION_CFF2);
        }
        String mimeType = (extension = UrlUtil.extension(url)) == null ? null : mimeMap.get(extension.toLowerCase());
        return mimeType == null ? TEXT_UNKNOWN : mimeType;
    }

    public static boolean isCID(String url) {
        if (url == null) {
            return false;
        }
        if (url.startsWith("<")) {
            url = url.substring(1);
        }
        String lowerURL = url.toLowerCase();
        return lowerURL.startsWith("cid:");
    }

    public static boolean isNotCID(String url) {
        if (StringUtil.getNonEmpty(url) == null) {
            return true;
        }
        if (UrlUtil.isCID(url)) {
            return false;
        }
        if (UrlUtil.isNet(url)) {
            return true;
        }
        return UrlUtil.isFile(url);
    }

    public static boolean isFile(String url) {
        if (url == null) {
            return false;
        }
        return url.toLowerCase().startsWith(FILE);
    }

    public static boolean isWindowsLocalPath(String pathName) {
        if (pathName == null || pathName.length() <= 1 || UrlUtil.isUNC(pathName)) {
            return false;
        }
        return StringUtils.isAlpha((String)pathName.substring(0, 1)) && pathName.substring(1, 2).equals(":") || StringUtils.countMatches((String)pathName, (String)"\\") > StringUtils.countMatches((String)pathName, (String)"/");
    }

    public static boolean isHttp(String url) {
        if (url == null) {
            return false;
        }
        String lowerURL = url.toLowerCase();
        return lowerURL.startsWith(HTTP);
    }

    public static boolean isFtp(String url) {
        if (url == null) {
            return false;
        }
        String lowerURL = url.toLowerCase();
        return lowerURL.startsWith(FTP);
    }

    public static boolean isHttps(String url) {
        if (url == null) {
            return false;
        }
        String lowerURL = url.toLowerCase();
        return lowerURL.startsWith(HTTPS);
    }

    public static boolean isNet(String url) {
        if (url == null) {
            return false;
        }
        String lowerURL = url.toLowerCase();
        return lowerURL.startsWith(HTTP) || lowerURL.startsWith(HTTPS) || lowerURL.startsWith(FTP);
    }

    public static String normalize(String urlString) {
        if (UrlUtil.isUNC(urlString)) {
            return UrlUtil.uncToUrl(urlString, false);
        }
        if (UrlUtil.isFile(urlString)) {
            urlString = FILE + urlString.substring(5);
            urlString = UrlUtil.unEscape(urlString);
            urlString = UrlUtil.escape(urlString, false, false);
        } else if (UrlUtil.isCID(urlString)) {
            urlString = StringUtil.replaceCharSet(urlString, "<>", null, 0);
            urlString = "cid:" + urlString.substring(4);
        } else if (!UrlUtil.isRelativeURL(urlString)) {
            URL url = UrlUtil.stringToURL(urlString);
            urlString = UrlUtil.urlToString(url);
        }
        urlString = UrlUtil.cleanDots(urlString);
        return urlString;
    }

    public static boolean isUNC(String pathName) {
        if (pathName == null || pathName.length() == 0) {
            return false;
        }
        return pathName.startsWith("\\\\");
    }

    public static boolean isMIME(File file) {
        String packageName;
        try {
            packageName = file.getCanonicalPath();
        }
        catch (IOException x) {
            return false;
        }
        String lower = packageName.toLowerCase();
        return UrlUtil.isMIMEExtenstension(lower);
    }

    public static URLProtocol getProtocol(String url) {
        if (UrlUtil.isCID(url)) {
            return URLProtocol.cid;
        }
        if (UrlUtil.isHttp(url) || UrlUtil.isHttps(url)) {
            return URLProtocol.http;
        }
        if (UrlUtil.isFile(url)) {
            return URLProtocol.file;
        }
        if (UrlUtil.isFtp(url)) {
            return URLProtocol.ftp;
        }
        return null;
    }

    public static String getIPFromBytes(byte[] ip) {
        if (ip == null || ip.length != 4 && ip.length != 6) {
            return null;
        }
        StringBuilder b = new StringBuilder(32);
        for (int i = 0; i < ip.length; ++i) {
            b.append(ip[i]);
            if (i <= 0) continue;
            b.append('.');
        }
        return b.toString();
    }

    public static byte[] getBytesFromIP(String ip) {
        VString v = StringUtil.tokenize(ip, ".", false);
        if (v == null || v.size() < 4) {
            return null;
        }
        byte[] b = new byte[v.size()];
        int n = 0;
        for (String s : v) {
            int i = StringUtil.parseInt(s, -1);
            if (i > 255 || i < 0) {
                return null;
            }
            b[n++] = (byte)i;
        }
        return b;
    }

    public static boolean isMIMEExtenstension(String lower) {
        if ((lower = UrlUtil.extension(lower)) == null) {
            return false;
        }
        return lower.equalsIgnoreCase("mjm") || lower.equalsIgnoreCase("mjd") || lower.equalsIgnoreCase("mim");
    }

    public static boolean isIRL(String val) {
        char[] c = val.toCharArray();
        boolean bFix = false;
        for (int i = 0; i < c.length; ++i) {
            if (c[i] <= '\u007f') continue;
            c[i] = 97;
            bFix = true;
        }
        return UrlUtil.isURL(bFix ? new String(c) : val);
    }

    public static String removeProtocol(String url) {
        if (url == null) {
            return null;
        }
        int pos = url.indexOf("://");
        if (pos > -1) {
            url = url.substring(pos + 3);
        } else if (UrlUtil.isCID(url)) {
            url = StringUtil.rightStr(url, -4);
        }
        return StringUtil.getNonEmpty(url);
    }

    public static boolean isURL(String val) {
        if (val == null) {
            return false;
        }
        try {
            URI uri = new URI(val);
            String scheme = uri.getScheme();
            if (scheme != null && scheme.toLowerCase().startsWith("http") && uri.getHost() == null) {
                return false;
            }
        }
        catch (URISyntaxException x) {
            return false;
        }
        return val.length() < 4096;
    }

    public static String getLocalURL(String directory, String url) {
        if (directory == null || url == null || directory.length() == 0) {
            return url;
        }
        int len = directory.length();
        if (len > 0 && !directory.endsWith("/")) {
            ++len;
        }
        if (url.length() <= len) {
            return null;
        }
        VString vDirectory = StringUtil.tokenize(directory, "/", false);
        VString vURL = StringUtil.tokenize(url, "/", false);
        if (vDirectory.size() >= vURL.size()) {
            return null;
        }
        if (vDirectory.size() > 0 && vURL.size() > 0) {
            if (vDirectory.get(0).endsWith(":")) {
                vDirectory.set(0, vDirectory.get(0).toLowerCase());
            }
            if (vURL.get(0).endsWith(":")) {
                vURL.set(0, vURL.get(0).toLowerCase());
            }
        }
        for (String dirChunk : vDirectory) {
            String urlChunk = vURL.get(0);
            if (urlChunk.equals(dirChunk)) {
                vURL.remove(0);
                continue;
            }
            return null;
        }
        return StringUtil.setvString(vURL, "/", null, null);
    }

    public static String addSecure(String baseURL, String url) throws IllegalArgumentException {
        if (!UrlUtil.isRelativeURL(url)) {
            throw new IllegalArgumentException("url must be relative " + url);
        }
        if (StringUtil.isEmpty(baseURL)) {
            throw new IllegalArgumentException("base url must not be empty");
        }
        if (UrlUtil.isRelativeURL(baseURL)) {
            throw new IllegalArgumentException("base url must not be relative " + baseURL);
        }
        if (StringUtil.hasToken(baseURL, "..", "/\\", 0)) {
            throw new IllegalArgumentException("base url must not contain .. " + baseURL);
        }
        if (StringUtil.hasToken(url, "..", "/\\", 0)) {
            throw new IllegalArgumentException("url must not contain .. " + url);
        }
        return StringUtil.addToken(baseURL, "/", url);
    }

    public static String getURLWithDirectory(String directory, String url) {
        if (StringUtil.getNonEmpty(directory) == null) {
            return url;
        }
        if (url == null) {
            return directory;
        }
        if (url.indexOf(":") > 0 && (url.indexOf("/") < 0 || url.indexOf("/") > url.indexOf(":"))) {
            return url;
        }
        if (url.startsWith("/")) {
            try {
                URI dirURI = new URI(directory);
                String scheme = dirURI.getScheme();
                if (scheme != null) {
                    directory = scheme + ":";
                    if (!url.startsWith(SLASHSLASH)) {
                        url = "/" + url;
                    }
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        if (!directory.endsWith("/") && !url.startsWith("/")) {
            directory = directory + "/";
        }
        return UrlUtil.cleanDots(directory + url);
    }

    public static String getParentDirectory(String url) {
        if (url == null) {
            return null;
        }
        int pos = url.lastIndexOf(47);
        int pos2 = url.lastIndexOf(92);
        if (pos2 >= 0 && pos2 > pos) {
            pos = pos2;
        }
        return pos > 0 ? StringUtil.leftStr(url, pos) : ".";
    }

    public static String cleanDots(String url) {
        int i;
        String prefix;
        int posTriple;
        if (url == null) {
            return null;
        }
        while (url.length() > 2 && url.startsWith("./")) {
            url = url.substring(2);
        }
        int posDouble = url.indexOf(SLASHSLASH);
        int prefixLen = posDouble == (posTriple = url.indexOf("///")) ? 3 : 2;
        String string = prefix = url.startsWith("/") ? "/" : "";
        if (posDouble >= 0) {
            prefix = url.substring(0, posDouble + prefixLen);
            url = url.substring(posDouble + prefixLen);
        }
        VString vs = StringUtil.tokenize(url, "/", false);
        for (i = vs.size() - 1; i > 0; --i) {
            if (!vs.get(i).equals("") && !vs.get(i).equals(".")) continue;
            vs.remove(i);
        }
        block2: for (i = vs.size() - 1; i > 0; --i) {
            if (!vs.get(i).equals("..")) continue;
            for (int j = i - 1; j >= 0; --j) {
                if (vs.get(j).equals("..")) continue;
                vs.remove(i--);
                vs.remove(j);
                continue block2;
            }
        }
        return prefix + (vs.isEmpty() ? "." : StringUtil.setvString(vs, "/", null, null));
    }

    public static String cleanHttpURL(String url) {
        VString v = StringUtil.tokenize(url, "/", false);
        if (v == null) {
            return null;
        }
        String protocol = v.get(0);
        if (!protocol.startsWith("http")) {
            protocol = "http://";
        } else if (protocol.startsWith("https")) {
            protocol = "https://";
            v.remove(0);
        } else {
            protocol = "http://";
            v.remove(0);
        }
        return StringUtil.setvString(v, "/", protocol, null);
    }

    public static UrlPart writeToURL(String strUrl, InputStream stream, String method, String contentType, org.cip4.jdflib.util.net.HTTPDetails det) {
        org.cip4.jdflib.util.URLWriter urlWriter = new org.cip4.jdflib.util.URLWriter(stream, strUrl, method, contentType, det);
        return urlWriter.writeToURL();
    }

    public static UrlPart writerToURL(String strUrl, IStreamWriter streamWriter, String method, String contentType, org.cip4.jdflib.util.net.HTTPDetails det) {
        org.cip4.jdflib.util.URLWriter urlWriter = new org.cip4.jdflib.util.URLWriter(strUrl, streamWriter, method, contentType, det);
        return urlWriter.writeToURL();
    }

    @Deprecated
    public static File moveToDir(IURLSetter parent, File dir, boolean overWrite) {
        return UrlUtil.moveToDir(parent, dir, null, overWrite);
    }

    public static File moveToDir(IURLSetter urlSetter, File dir, String cwd, boolean overWrite) {
        return UrlUtil.moveToDir(urlSetter, dir, cwd, overWrite, false);
    }

    public static File moveToDir(IURLSetter urlSetter, File dir, String cwd, boolean overWrite, boolean deleteFile) {
        boolean needCopy;
        XMLDoc d;
        if (urlSetter == null || dir == null || dir.exists() && !dir.isDirectory()) {
            return null;
        }
        dir.mkdirs();
        String url = urlSetter.getURL();
        if (StringUtil.getNonEmpty(url) == null) {
            return null;
        }
        String fileName = StringUtil.getNonEmpty(urlSetter.getUserFileName());
        if (fileName == null) {
            File oldDir;
            File oldFile;
            if (UrlUtil.isRelativeURL(url)) {
                fileName = UrlUtil.cleanDots(UrlUtil.unEscape(url));
                if (cwd != null) {
                    url = UrlUtil.getURLWithDirectory(cwd, url);
                }
            }
            if ((oldFile = UrlUtil.urlToFile(url)) != null && FileUtil.equals(oldDir = oldFile.getParentFile(), dir)) {
                return oldFile;
            }
        }
        XMLDoc xMLDoc = d = urlSetter instanceof KElement ? ((KElement)((Object)urlSetter)).getOwnerDocument_KElement() : null;
        if (fileName == null) {
            Multipart mp = d == null ? null : d.getMultiPart();
            fileName = UrlUtil.getFileName(url, mp);
        }
        if (StringUtil.hasToken(fileName, "..", "/\\", 0)) {
            throw new IllegalArgumentException("illegal filename " + fileName);
        }
        File localFile = fileName == null ? null : new File(fileName);
        File out = FileUtil.getFileInDirectory(dir, localFile);
        if (out != null && out.exists()) {
            if (overWrite) {
                out.delete();
            } else {
                return out;
            }
        }
        URLReader urlReader = new URLReader(url, d);
        File oldFile = deleteFile ? urlReader.getFile() : null;
        boolean bl = needCopy = !deleteFile;
        if (oldFile != null) {
            boolean bl2 = needCopy = !FileUtil.moveFile(oldFile, out);
        }
        if (needCopy) {
            InputStream inputStream = urlReader.getURLInputStream();
            out = inputStream != null ? FileUtil.streamToFile(inputStream, out) : null;
        }
        if (out != null) {
            urlSetter.setURL(UrlUtil.fileToUrl(out, false));
        }
        return out;
    }

    public static boolean isRelativeURL(String url) {
        if (StringUtil.isEmpty(url)) {
            return false;
        }
        return url.indexOf(":/") < 0 && url.indexOf(":\\") < 0 && !url.startsWith("/") && !url.startsWith("\\") && !UrlUtil.isCID(url);
    }

    public static boolean isXMLType(String contentType) {
        if (contentType == null) {
            return false;
        }
        String lower = UrlUtil.normalizeType(contentType);
        if (TEXT_XML.equals(lower) || APPLICATION_XML.equals(lower)) {
            return true;
        }
        return (lower.startsWith("application") || lower.startsWith("text")) && lower.endsWith("+xml");
    }

    public static boolean isJSONType(String contentType) {
        if (contentType == null) {
            return false;
        }
        String lower = UrlUtil.normalizeType(contentType);
        return TEXT_JSON.equals(lower) || APPLICATION_JSON.equals(lower) || lower.endsWith("+json");
    }

    private static String normalizeType(String contentType) {
        String lower = StringUtil.normalize(contentType, true);
        while (lower.endsWith(";")) {
            lower = StringUtil.leftStr(lower, -1);
        }
        return lower;
    }

    public static boolean isZIPType(String contentType) {
        String lower = StringUtil.normalize(contentType, true);
        while (lower != null && lower.endsWith(";")) {
            lower = StringUtil.leftStr(lower, -1);
        }
        return lower != null && (APPLICATION_ZIP.equals(lower) || APPLICATION_XZIP.equals(lower) || lower.endsWith("+zip"));
    }

    public static String newExtension(String strWork, String newExt) {
        if (strWork == null) {
            return null;
        }
        if (newExt == null) {
            return UrlUtil.prefix(strWork);
        }
        if (!newExt.startsWith(".")) {
            newExt = "." + newExt;
        }
        return UrlUtil.prefix(strWork) + newExt;
    }

    public static String prefix(String strWork) {
        if (strWork == null) {
            return null;
        }
        String ext = UrlUtil.extension(strWork);
        if (ext == null) {
            return strWork;
        }
        return strWork.substring(0, strWork.length() - ext.length() - 1);
    }

    public static boolean isRedirect(int responseCode) {
        return responseCode == 301 || responseCode == 302 || responseCode == 303 || responseCode == 307 || responseCode == 308;
    }

    public static boolean isReturnCodeOK(int responseCode) {
        return responseCode / 100 == 2;
    }

    public static boolean isReturnCodeOK(UrlPart p) {
        return p != null && UrlUtil.isReturnCodeOK(p.getResponseCode());
    }

    public static enum URLProtocol {
        cid,
        http,
        file,
        ftp;

    }

    public static enum HttpMethod {
        POST,
        PUT,
        GET,
        HEAD,
        DELETE,
        CONNECT,
        OPTIONS,
        TRACE,
        PATCH;

    }

    @Deprecated
    public static class URLWriter
    extends org.cip4.jdflib.util.URLWriter {
        public URLWriter(String strUrl, IStreamWriter streamWriter, String method, String contentType, org.cip4.jdflib.util.net.HTTPDetails details) {
            super(strUrl, streamWriter, method, contentType, details);
        }
    }

    @Deprecated
    public static class HTTPDetails
    extends org.cip4.jdflib.util.net.HTTPDetails {
    }
}

