/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions;

import java.util.List;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.StringArray;
import org.cip4.jdflib.extensions.IntentHelper;
import org.cip4.jdflib.resource.process.JDFColor;

public class ColorIntentHelper
extends IntentHelper {
    public ColorIntentHelper(KElement intent) {
        super(intent);
    }

    public void setNumColors(int front, int back) {
        if (front > 0) {
            this.getCreateSurfaceColor(EnumSurface.Front, this.getSurfaceColors(front));
        }
        if (back > 0) {
            this.getCreateSurfaceColor(EnumSurface.Back, this.getSurfaceColors(back));
        }
    }

    public KElement getSurfaceColor(EnumSurface front) {
        KElement i = this.getResource();
        return i == null ? null : i.getChildWithAttribute("SurfaceColor", "Surface", null, front.name(), 0, true);
    }

    public String getSurfaceAttribute(EnumSurface front, String attName) {
        KElement s = this.getSurfaceColor(front);
        return s == null ? null : s.getNonEmpty(attName);
    }

    public StringArray getSurfaceList(EnumSurface front, String attName) {
        return StringArray.getVString(this.getSurfaceAttribute(front, attName), null);
    }

    public KElement getCreateSurfaceColor(EnumSurface front, List<String> surfaceColors) {
        KElement i = this.getCreateResource();
        KElement sc = i.getCreateChildWithAttribute("SurfaceColor", "Surface", null, front.name(), 0);
        sc.setAttribute("ColorsUsed", surfaceColors, null);
        return sc;
    }

    public List<String> getSurfaceColors(int n) {
        if (n <= 0) {
            return null;
        }
        StringArray r = new StringArray();
        int p = 0;
        for (String sep : JDFColor.getKCMYSeparations()) {
            if (p++ == n) break;
            r.add(sep);
        }
        for (int s = 1; s <= n - 4; ++s) {
            r.add("Spot" + s);
        }
        return r;
    }

    public static enum EnumSurface {
        Front,
        Back;

    }
}

