/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.datatypes;

import java.util.zip.DataFormatException;
import org.cip4.jdflib.datatypes.JDFRange;
import org.cip4.jdflib.util.JDFDate;

public class JDFDateTimeRange
extends JDFRange {
    private JDFDate m_left = null;
    private JDFDate m_right = null;

    public JDFDateTimeRange() {
        this.init(null, null);
    }

    public JDFDateTimeRange(JDFDate x) {
        this.init(x, x);
    }

    public JDFDateTimeRange(JDFDate xmin, JDFDate xmax) {
        this.init(xmin, xmax);
    }

    public JDFDateTimeRange(JDFDateTimeRange r) {
        this.init(r.getLeft(), r.getRight());
    }

    protected void init(JDFDate xmin, JDFDate xmax) {
        this.m_left = xmin;
        this.m_right = xmax;
    }

    public static JDFDateTimeRange createDateTimeRange(String date) {
        if (date == null || date.length() == 0) {
            return null;
        }
        try {
            return new JDFDateTimeRange(date);
        }
        catch (DataFormatException e) {
            return null;
        }
    }

    public JDFDateTimeRange(String s) throws DataFormatException {
        String[] strArray = s.split("~");
        if (strArray.length <= 0 || strArray.length > 2) {
            throw new DataFormatException("JDFDateTimeRange illegal string: " + s);
        }
        try {
            if (strArray.length == 1) {
                this.m_left = new JDFDate(strArray[0].trim());
                this.m_right = new JDFDate(strArray[0].trim());
            } else {
                this.m_left = new JDFDate(strArray[0].trim());
                this.m_right = new JDFDate(strArray[1].trim());
            }
        }
        catch (DataFormatException e) {
            throw new DataFormatException("JDFDateTimeRange illegal string: " + s);
        }
    }

    @Override
    public String toString() {
        return this.getString(0);
    }

    @Override
    public String getXJDFString(int precision) {
        return this.m_left.getDateTimeISO() + " . " + this.m_right.getDateTimeISO();
    }

    public boolean isValid(String s) {
        try {
            new JDFDateTimeRange(s);
        }
        catch (DataFormatException e) {
            return false;
        }
        return true;
    }

    public boolean inRange(JDFDate x) {
        JDFDate min = this.getLowerValue();
        JDFDate max = this.getUpperValue();
        return !(!x.isLater(min) && !x.equals(min) || !x.isEarlier(max) && !x.equals(max));
    }

    @Override
    public boolean isPartOfRange(JDFRange ra) {
        JDFDateTimeRange r = (JDFDateTimeRange)ra;
        JDFDate min = this.getLowerValue();
        JDFDate r_min = r.getLowerValue();
        JDFDate max = this.getUpperValue();
        JDFDate r_max = r.getUpperValue();
        return r_min.isLater(min) && r_max.isEarlier(max);
    }

    public JDFDate getLeft() {
        return this.m_left;
    }

    public JDFDate getRight() {
        return this.m_right;
    }

    public void setLeft(JDFDate x) {
        this.m_left = x;
    }

    public void setRight(JDFDate x) {
        this.m_right = x;
    }

    public JDFDate getUpperValue() {
        return this.m_left.isEarlier(this.m_right) || this.m_left.equals(this.m_right) ? this.m_right : this.m_left;
    }

    public JDFDate getLowerValue() {
        return this.m_left.isEarlier(this.m_right) ? this.m_left : this.m_right;
    }

    @Override
    protected JDFDate getRightObject() {
        return this.m_right;
    }

    @Override
    protected JDFDate getLeftObject() {
        return this.m_left;
    }

    @Override
    protected boolean inObjectRange(Object other) {
        return this.inRange((JDFDate)other);
    }

    @Override
    public String getRightString(int precision) {
        return this.getRight().getDateISO();
    }

    @Override
    public String getLeftString(int precision) {
        return this.getLeft().getDateISO();
    }
}

