/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.datatypes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.zip.DataFormatException;
import org.cip4.jdflib.core.StringArray;
import org.cip4.jdflib.datatypes.JDFIntegerList;
import org.cip4.jdflib.datatypes.JDFIntegerRange;
import org.cip4.jdflib.datatypes.JDFRange;
import org.cip4.jdflib.datatypes.JDFRangeList;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.StringUtil;

public class JDFIntegerRangeList
extends JDFRangeList {
    private int m_xDef = JDFIntegerRange.getDefaultDef();

    public JDFIntegerRangeList() {
    }

    public JDFIntegerRangeList(String s) throws DataFormatException {
        this(s, JDFIntegerRange.getDefaultDef());
    }

    public JDFIntegerRangeList(String s, int xdef) throws DataFormatException {
        this.setString(s);
        this.setDef(xdef);
    }

    public JDFIntegerRangeList(JDFIntegerRangeList irl) {
        this.rangeList = new ArrayList(irl.rangeList);
        this.setDef(irl.getDef());
    }

    public JDFIntegerRangeList(JDFIntegerRange ir) {
        this.rangeList = new ArrayList();
        this.rangeList.add(ir);
        this.setDef(ir.getDef());
    }

    public JDFIntegerRangeList(int[] array) {
        this.rangeList = new ArrayList();
        if (array != null) {
            for (int i : array) {
                this.append(i);
            }
        }
    }

    @Deprecated
    public static JDFIntegerRangeList getIntegerRangeList(String rangelist) {
        return JDFIntegerRangeList.createIntegerRangeList(rangelist);
    }

    public static JDFIntegerRangeList createIntegerRangeList(String rangelist) {
        if (StringUtil.getNonEmpty(rangelist) == null) {
            return null;
        }
        try {
            return new JDFIntegerRangeList(rangelist);
        }
        catch (DataFormatException e) {
            return null;
        }
    }

    public boolean inRange(int x) {
        int sz = this.rangeList.size();
        for (int i = 0; i < sz; ++i) {
            JDFIntegerRange r = (JDFIntegerRange)this.rangeList.get(i);
            if (!r.inRange(x)) continue;
            return true;
        }
        return false;
    }

    public void setString(String s) throws DataFormatException {
        this.rangeList.clear();
        if (s == null || s.equals("")) {
            return;
        }
        if (s.indexOf("~") == 0 || s.lastIndexOf("~") == s.length() - 1) {
            throw new DataFormatException("JDFIntegerRangeList::SetString: Illegal string " + s);
        }
        String zappedWS = StringUtil.zappTokenWS(s, "~");
        StringArray vs = StringArray.getVString(zappedWS, " \t");
        for (String str : vs) {
            try {
                JDFIntegerRange ir = new JDFIntegerRange(str);
                this.rangeList.add(ir);
            }
            catch (DataFormatException dfe) {
                throw new DataFormatException("JDFIntegerRangeList::SetString: Illegal string " + s);
            }
        }
    }

    public boolean isValid(String s) {
        try {
            new JDFIntegerRangeList(s);
        }
        catch (DataFormatException e) {
            return false;
        }
        return true;
    }

    public int getElementCount() {
        int sz = this.rangeList.size();
        int elementCount = 0;
        for (int i = 0; i < sz; ++i) {
            JDFIntegerRange r = (JDFIntegerRange)this.rangeList.get(i);
            int elemCount = r.getElementCount();
            if (elemCount <= 0) {
                return -1;
            }
            elementCount += elemCount;
        }
        return elementCount;
    }

    public int getElement(int i) throws NoSuchElementException {
        int n = this.getElementCount();
        if (i >= n || i < -n) {
            throw new NoSuchElementException("JDFIntegerRangeList::Element out of range error!");
        }
        if (i < 0) {
            return this.getElement(n + i);
        }
        n = 0;
        for (int j = 0; j < this.rangeList.size(); ++j) {
            JDFIntegerRange r = (JDFIntegerRange)this.rangeList.get(j);
            int k = r.getElementCount();
            if (i >= k) {
                i -= k;
                continue;
            }
            return r.getElement(i);
        }
        return 0;
    }

    public void append(JDFIntegerRange r) {
        r.setDef(this.getDef());
        this.rangeList.add(r);
    }

    public void append(int xMin, int xMax) {
        this.append(new JDFIntegerRange(xMin, xMax, this.m_xDef));
    }

    public void append(int x) {
        JDFIntegerRange r;
        if (!ContainerUtil.isEmpty(this.rangeList) && (r = (JDFIntegerRange)this.rangeList.get(this.rangeList.size() - 1)).append(x)) {
            return;
        }
        this.append(new JDFIntegerRange(x, x, this.m_xDef));
    }

    public JDFIntegerList getIntegerList() {
        JDFIntegerList irl = new JDFIntegerList();
        for (int i = 0; i < this.rangeList.size(); ++i) {
            JDFIntegerRange r = (JDFIntegerRange)this.rangeList.get(i);
            irl.addAll(r.getIntegerList());
        }
        return irl;
    }

    public void setDef(int xdef) {
        this.m_xDef = xdef;
        for (int i = 0; i < this.rangeList.size(); ++i) {
            ((JDFIntegerRange)this.rangeList.get(i)).setDef(xdef);
        }
    }

    public int getDef() {
        return this.m_xDef;
    }

    @Override
    public boolean isOrdered() {
        int siz = this.rangeList.size();
        if (siz == 0) {
            return false;
        }
        ArrayList<Integer> test = new ArrayList<Integer>();
        for (int i = 0; i < siz; ++i) {
            JDFIntegerRange r = (JDFIntegerRange)this.rangeList.get(i);
            test.add(r.getLeft());
            if (r.getLeft() == r.getRight()) continue;
            test.add(r.getRight());
        }
        int n = test.size() - 1;
        if (n == 0) {
            return true;
        }
        int first = (Integer)test.get(0);
        int last = (Integer)test.get(n);
        for (int j = 0; j < n; ++j) {
            int value = (Integer)test.get(j);
            int nextvalue = (Integer)test.get(j + 1);
            if (first == last && value == nextvalue || first < last && value <= nextvalue || first > last && value >= nextvalue) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isUniqueOrdered() {
        int last;
        int siz = this.rangeList.size();
        if (siz == 0) {
            return false;
        }
        ArrayList<Integer> a = new ArrayList<Integer>();
        for (int i = 0; i < siz; ++i) {
            JDFIntegerRange r = (JDFIntegerRange)this.rangeList.get(i);
            a.add(r.getLeft());
            if (Integer.valueOf(r.getLeft()).equals(r.getRight())) continue;
            a.add(r.getRight());
        }
        int n = a.size() - 1;
        if (n == 0) {
            return true;
        }
        int first = (Integer)a.get(0);
        if (first == (last = ((Integer)a.get(n)).intValue())) {
            return false;
        }
        for (int j = 0; j < n; ++j) {
            int value = (Integer)a.get(j);
            int nextvalue = (Integer)a.get(j + 1);
            if (first < last && value < nextvalue || first > last && value < nextvalue) continue;
            return false;
        }
        return true;
    }

    public JDFIntegerRangeList deepCopy() throws DataFormatException {
        JDFIntegerRangeList rl = new JDFIntegerRangeList();
        rl.setString(this.toString());
        return rl;
    }

    public boolean isOverlapping(JDFIntegerRange newRange, JDFIntegerRange oldRange) {
        ArrayList<JDFRange> rangeListToCheck = this.rangeList;
        if (oldRange != null) {
            rangeListToCheck = new ArrayList<JDFRange>();
            rangeListToCheck.addAll(this.rangeList);
            rangeListToCheck.remove(oldRange);
        }
        return this.checkOverlap(rangeListToCheck, newRange);
    }

    private boolean checkOverlap(ArrayList<JDFRange> vRangeList, JDFIntegerRange newRange) {
        int rangeLower = newRange.getLowerValue();
        int rangeUpper = newRange.getUpperValue();
        for (int i = 0; i < vRangeList.size(); ++i) {
            JDFIntegerRange r = (JDFIntegerRange)vRangeList.get(i);
            if (rangeUpper < r.getLowerValue() || rangeLower > r.getUpperValue()) continue;
            return true;
        }
        return false;
    }

    public void normalize(boolean bSort) {
        int[] l = this.getIntegerList().getIntArray();
        if (bSort) {
            Arrays.sort(l);
        }
        this.clear();
        int lSiz = l.length;
        for (int i = 0; i < lSiz; ++i) {
            this.append(l[i]);
        }
    }
}

