/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.elementwalker;

import java.util.HashSet;
import java.util.Set;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.elementwalker.BaseElementWalker;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.elementwalker.BaseWalkerFactory;
import org.cip4.jdflib.resource.process.JDFGeneralID;

public class RemovePrivate
extends BaseElementWalker {
    Set<String> prefixes = null;
    boolean zappGeneralID = true;
    boolean zappElements = true;
    boolean zappAttributes = true;

    public RemovePrivate() {
        super(new BaseWalkerFactory());
        new BaseWalker(this.getFactory());
    }

    public void addPrefix(String prefix) {
        if (this.prefixes == null) {
            this.prefixes = new HashSet<String>();
        }
        this.prefixes.add(prefix);
    }

    public void setZappGeneralID(boolean zappGeneralID) {
        this.zappGeneralID = zappGeneralID;
    }

    public void setZappAttributes(boolean zappAttributes) {
        this.zappAttributes = zappAttributes;
    }

    public void setZappElements(boolean zappElements) {
        this.zappElements = zappElements;
    }

    public class WalkGeneralID
    extends WalkElement {
        @Override
        public KElement walk(KElement e, KElement trackElem) {
            String idUsage = ((JDFGeneralID)e).getIDUsage();
            String prefix = KElement.xmlnsPrefix(idUsage);
            if (prefix != null && !"JDF".equalsIgnoreCase(prefix) && (RemovePrivate.this.prefixes == null || RemovePrivate.this.prefixes.contains(prefix))) {
                e.deleteNode();
                return null;
            }
            return super.walk(e, trackElem);
        }

        @Override
        public boolean matches(KElement toCheck) {
            return RemovePrivate.this.zappGeneralID && toCheck instanceof JDFGeneralID;
        }
    }

    public class WalkPrivate
    extends WalkElement {
        @Override
        public KElement walk(KElement e, KElement trackElem) {
            if (!"http://www.CIP4.org/JDFSchema_1_1".equals(e.getNamespaceURI())) {
                e.deleteNode();
                return null;
            }
            return e;
        }

        @Override
        public boolean matches(KElement toCheck) {
            boolean b;
            boolean bl = b = RemovePrivate.this.zappElements && super.matches(toCheck);
            if (!b) {
                return false;
            }
            if (RemovePrivate.this.prefixes != null) {
                String prefix = toCheck.getPrefix();
                if (prefix == null || !RemovePrivate.this.prefixes.contains(prefix)) {
                    b = false;
                }
            } else {
                b = !JDFElement.isInAnyCIP4NameSpaceStatic(toCheck);
            }
            return b;
        }
    }

    public class WalkElement
    extends BaseWalker {
        public WalkElement() {
            super(RemovePrivate.this.getFactory());
        }

        @Override
        public KElement walk(KElement e1, KElement trackElem) {
            if (!RemovePrivate.this.zappAttributes) {
                return e1;
            }
            VString unknown = new VString();
            if (RemovePrivate.this.prefixes == null) {
                if (!(e1 instanceof JDFElement)) {
                    return e1;
                }
                JDFElement j = (JDFElement)e1;
                if (!e1.getClass().equals(JDFElement.class)) {
                    unknown = j.getUnknownAttributes(false, -1);
                }
            } else {
                unknown = e1.getAttributeVector_KElement();
            }
            if (unknown != null) {
                for (String attName : unknown) {
                    String prefix;
                    if (RemovePrivate.this.prefixes != null && ((prefix = KElement.xmlnsPrefix(attName)) == null || ("xmlns".equals(prefix) ? !RemovePrivate.this.prefixes.contains(KElement.xmlnsLocalName(attName)) : !RemovePrivate.this.prefixes.contains(prefix)))) continue;
                    e1.removeAttribute(attName);
                }
            }
            return e1;
        }

        @Override
        public boolean matches(KElement toCheck) {
            return true;
        }
    }
}

