/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.node;

import java.util.Collections;
import java.util.Vector;
import org.cip4.jdflib.core.JDFAudit;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.ifaces.ISignalAudit;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.pool.JDFAuditPool;

public class AuditToJMF {
    private final JDFNode theNode;
    private final VJDFAttributeMap vPartMap;
    private final boolean bInlineUpdates;

    public AuditToJMF(JDFNode _theNode, VJDFAttributeMap vParts, boolean inlineUpdates) {
        this.theNode = _theNode;
        this.vPartMap = vParts;
        this.bInlineUpdates = inlineUpdates;
    }

    public VElement getLocalJMFs(JDFAudit.EnumAuditType auditType) {
        VElement audits;
        JDFAuditPool ap = this.theNode == null ? null : this.theNode.getAuditPool();
        VElement vElement = audits = ap == null ? null : ap.getAudits(auditType, null, this.vPartMap);
        if (this.bInlineUpdates) {
            this.inlineUpdates(audits);
        }
        if (audits == null || audits.size() == 0) {
            return null;
        }
        Vector<JDFAudit> va = new Vector<JDFAudit>();
        for (int i = 0; i < audits.size(); ++i) {
            va.add((JDFAudit)audits.get(i));
        }
        Collections.sort(va, (JDFAudit)audits.elementAt(0));
        VElement vJMF = new VElement();
        for (int i = 0; i < audits.size(); ++i) {
            JDFAudit audit = (JDFAudit)audits.get(i);
            if (!(audit instanceof ISignalAudit)) continue;
            vJMF.add(((ISignalAudit)((Object)audit)).toSignalJMF());
        }
        return vJMF.size() == 0 ? null : vJMF;
    }

    private void inlineUpdates(VElement audits) {
        if (audits == null) {
            return;
        }
        for (int i = audits.size() - 1; i >= 0; --i) {
            JDFAudit audit = (JDFAudit)audits.elementAt(i);
            while (audit != null) {
                if ((audit = audit.getUpdatedPreviousAudit()) == null) continue;
                audits.remove(audit);
                --i;
            }
        }
    }
}

