/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.intent;

import java.util.List;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoDropIntent;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.resource.intent.JDFDeliveryIntent;
import org.cip4.jdflib.resource.intent.JDFDropItemIntent;
import org.cip4.jdflib.resource.intent.JDFIntentResource;
import org.cip4.jdflib.resource.process.JDFComponent;
import org.cip4.jdflib.resource.process.JDFContact;
import org.cip4.jdflib.resource.process.JDFDrop;
import org.cip4.jdflib.resource.process.JDFDropItem;
import org.cip4.jdflib.span.JDFNameSpan;
import org.cip4.jdflib.span.JDFSpanSurplusHandling;
import org.cip4.jdflib.span.JDFSpanTransfer;
import org.cip4.jdflib.span.JDFStringSpan;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.StringUtil;

public class JDFDropIntent
extends JDFAutoDropIntent {
    private static final long serialVersionUID = 1L;

    public JDFDropIntent(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFDropIntent(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFDropIntent(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFDropIntent[  --> " + super.toString() + " ]";
    }

    public JDFDeliveryIntent getParentDeliveryIntent() {
        return (JDFDeliveryIntent)this.getParentNode();
    }

    @Override
    public int getAdditionalAmount() {
        if (this.hasAttribute("AdditionalAmount", null, false)) {
            return super.getAdditionalAmount();
        }
        return this.getParentDeliveryIntent().getAdditionalAmount();
    }

    @Override
    public String getBuyerAccount() {
        if (this.hasAttribute("BuyerAccount")) {
            return super.getBuyerAccount();
        }
        return this.getParentDeliveryIntent().getBuyerAccount();
    }

    @Override
    public JDFNameSpan getMethod() {
        if (this.hasChildElement("Method", null)) {
            return super.getMethod();
        }
        return this.getParentDeliveryIntent().getMethod();
    }

    @Override
    public JDFNameSpan getReturnMethod() {
        if (this.hasChildElement("ReturnMethod", null)) {
            return super.getReturnMethod();
        }
        return this.getParentDeliveryIntent().getReturnMethod();
    }

    @Override
    public JDFStringSpan getServiceLevel() {
        if (this.hasChildElement("ServiceLevel", null)) {
            return super.getServiceLevel();
        }
        return this.getParentDeliveryIntent().getServiceLevel();
    }

    @Override
    public JDFSpanSurplusHandling getSurplusHandling() {
        if (this.hasChildElement("SurplusHandling", null)) {
            return super.getSurplusHandling();
        }
        return this.getParentDeliveryIntent().getSurplusHandling();
    }

    @Override
    public JDFSpanTransfer getTransfer() {
        if (this.hasChildElement("Transfer", null)) {
            return this.getTransfer();
        }
        return this.getParentDeliveryIntent().getTransfer();
    }

    @Override
    public JDFContact getContact(int iSkip) {
        if (this.hasChildElement("Contact", null)) {
            return super.getContact(iSkip);
        }
        return this.getParentDeliveryIntent().getContact();
    }

    public JDFDropItemIntent getDropItemWithComponent(JDFComponent c) {
        List<JDFDropItemIntent> v = this.getChildArrayByClass(JDFDropItemIntent.class, false, 0);
        if (v == null || c == null || StringUtil.getNonEmpty(c.getID()) == null) {
            return null;
        }
        String cID = c.getID();
        JDFAttributeMap partMap = c.getPartMap();
        for (JDFDropItemIntent dii : v) {
            JDFComponent cdii = dii.getComponent();
            if (cdii == null || !cID.equals(cdii.getID()) || !ContainerUtil.equals(partMap, cdii.getPartMap())) continue;
            return dii;
        }
        return null;
    }

    public JDFDropItemIntent getCreateDropItemWithComponent(JDFComponent c) {
        if (c == null) {
            return null;
        }
        JDFDropItemIntent di = this.getDropItemWithComponent(c);
        if (di == null) {
            di = this.appendDropItemIntent();
            di.refComponent(c);
        }
        return di;
    }

    public void setFromDrop(JDFDrop drop) {
        List<JDFDropItem> vdi = drop.getChildArrayByClass(JDFDropItem.class, false, 0);
        for (JDFDropItem dropItem : vdi) {
            JDFDropItemIntent dropItemIntent = this.appendDropItemIntent();
            dropItemIntent.setFromDropItem(dropItem);
        }
        JDFIntentResource.copyProcessToActual(this, drop, null, "Method");
        JDFIntentResource.copyProcessToActual(this, drop, null, "Earliest");
        JDFIntentResource.copyProcessToActual(this, drop, null, "Required");
        this.copyAttribute("DropID", drop);
        this.copyChildren("Contact", drop);
        this.copyChildren("FileSpec", drop);
    }
}

