
/**
 * The CIP4 Software License, Version 1.0
 *
 *
 * Copyright (c) 2001-2019 The International Cooperation for the Integration of Processes in Prepress, Press and Postpress (CIP4). All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the
 * distribution.
 *
 * 3. The end-user documentation included with the redistribution, if any, must include the following acknowledgment: "This product includes software developed by the The International Cooperation for
 * the Integration of Processes in Prepress, Press and Postpress (www.cip4.org)" Alternately, this acknowledgment may appear in the software itself, if and wherever such third-party acknowledgments
 * normally appear.
 *
 * 4. The names "CIP4" and "The International Cooperation for the Integration of Processes in Prepress, Press and Postpress" must not be used to endorse or promote products derived from this software
 * without prior written permission. For written permission, please contact info@cip4.org.
 *
 * 5. Products derived from this software may not be called "CIP4", nor may "CIP4" appear in their name, without prior written permission of the CIP4 organization
 *
 * Usage of this software in commercial products is subject to restrictions. For details please consult info@cip4.org.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE INTERNATIONAL COOPERATION FOR THE INTEGRATION OF PROCESSES IN PREPRESS, PRESS AND POSTPRESS OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE. ====================================================================
 *
 * This software consists of voluntary contributions made by many individuals on behalf of the The International Cooperation for the Integration of Processes in Prepress, Press and Postpress and was
 * originally based on software copyright (c) 1999-2006, Heidelberger Druckmaschinen AG copyright (c) 1999-2001, Agfa-Gevaert N.V.
 * 
 * For more information on The International Cooperation for the Integration of Processes in Prepress, Press and Postpress , please see <http://www.cip4.org/>.
 *
 */

package org.cip4.jdflib.resource.process.prepress;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoAssetListCreationParams;
import org.cip4.jdflib.core.AttributeName;
import org.cip4.jdflib.core.ElementName;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.resource.process.JDFFileSpec;

public class JDFAssetListCreationParams extends JDFAutoAssetListCreationParams
{
	private static final String SEARCH_PATH = "SearchPath";
	private static final long serialVersionUID = 1L;

	/**
	 * ructor for JDFAssetListCreationParams
	 *
	 * @param ownerDocument
	 * @param qualifiedName
	 */
	public JDFAssetListCreationParams(final CoreDocumentImpl myOwnerDocument, final String qualifiedName)
	{
		super(myOwnerDocument, qualifiedName);
	}

	/**
	 * ructor for JDFAssetListCreationParams
	 *
	 * @param ownerDocument
	 * @param namespaceURI
	 * @param qualifiedName
	 */
	public JDFAssetListCreationParams(final CoreDocumentImpl myOwnerDocument, final String myNamespaceURI, final String qualifiedName)
	{
		super(myOwnerDocument, myNamespaceURI, qualifiedName);
	}

	/**
	 * ructor for JDFAssetListCreationParams
	 *
	 * @param ownerDocument
	 * @param namespaceURI
	 * @param qualifiedName
	 * @param localName
	 */
	public JDFAssetListCreationParams(final CoreDocumentImpl myOwnerDocument, final String myNamespaceURI, final String qualifiedName, final String myLocalName)
	{
		super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
	}

	// **************************************** Methods
	// *********************************************
	/**
	 * toString
	 *
	 * @return String
	 */
	@Override
	public String toString()
	{
		return "JDFAssetListCreationParams[  --> " + super.toString() + " ]";
	}

	public JDFFileSpec getSearchPath(final int iSkip)
	{
		int iSkipLocal = iSkip;

		JDFFileSpec res = null;
		final VElement v = getChildElementVector(ElementName.FILESPEC, null, null, true, 0, false);
		final int siz = v.size();

		for (int i = 0; i < siz; i++)
		{
			res = (JDFFileSpec) v.elementAt(i);
			if (res.hasAttribute(AttributeName.RESOURCEUSAGE))
			{
				if (SEARCH_PATH.equals(res.getResourceUsage()))
				{
					if (iSkipLocal >= 0)
					{
						iSkipLocal--;
					}
					else
					{
						break;
					}
				}
			}
		}

		return res;
	}

	public JDFFileSpec getCreateSearchPath(final int iSkip)
	{

		JDFFileSpec res = getSearchPath(iSkip);
		if (res == null)
		{
			res = appendSearchPath();
		}

		return res;
	}

	public JDFFileSpec appendSearchPath()
	{

		final JDFFileSpec res = appendFileSpec();
		res.setResourceUsage(SEARCH_PATH);

		return res;
	}

	@Override
	public VString getInvalidElements(final EnumValidationLevel level, final boolean bIgnorePrivate, final int nMax)
	{

		final VString vElem = new VString();
		int n = 0;
		final int nElem = numChildElements(ElementName.FILESPEC, null);

		for (int i = 0; i < nElem; i++)
		{

			final String ru = getFileSpec(i).getResourceUsage();
			if (!ru.equals(SEARCH_PATH))
			{
				vElem.appendUnique(ElementName.FILESPEC);
				if (++n >= nMax)
					return vElem;
				break;
			}
		}
		vElem.appendUnique(getInvalidElements(level, bIgnorePrivate, (nMax - n)));

		return vElem;
	}
}
