/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.datatypes;

import java.util.zip.DataFormatException;
import org.cip4.jdflib.datatypes.JDFRange;
import org.cip4.jdflib.datatypes.JDFXYPair;
import org.cip4.jdflib.util.HashUtil;

public class JDFXYPairRange
extends JDFRange {
    private JDFXYPair m_left = null;
    private JDFXYPair m_right = null;

    public JDFXYPairRange() {
        this(null, null);
    }

    public JDFXYPairRange(JDFXYPair x) {
        this(x, x);
    }

    public JDFXYPairRange(JDFXYPair min, JDFXYPair max) {
        this.init(min, max);
    }

    public JDFXYPairRange(JDFXYPairRange r) {
        this.init(r.getLeft(), r.getRight());
    }

    protected void init(JDFXYPair min, JDFXYPair max) {
        this.m_left = min;
        this.m_right = max;
    }

    public JDFXYPairRange(String s) throws DataFormatException {
        String[] strArray = s.split("~");
        if (strArray.length > 2) {
            throw new DataFormatException("JDFXYPairRange illegal string: " + s);
        }
        try {
            if (strArray.length == 1) {
                this.m_left = new JDFXYPair(strArray[0].trim());
                this.m_right = new JDFXYPair(strArray[0].trim());
            } else if (strArray.length == 2) {
                this.m_left = new JDFXYPair(strArray[0].trim());
                this.m_right = new JDFXYPair(strArray[1].trim());
            }
        }
        catch (DataFormatException e) {
            throw new DataFormatException("JDFXYPairRange illegal string: " + s);
        }
    }

    public String toString() {
        if (this.m_left.equals(this.m_right)) {
            return "" + this.getLeft();
        }
        return this.getLeft().toString() + " ~ " + this.getRight().toString();
    }

    public boolean isValid(String s) {
        try {
            new JDFXYPairRange(s);
        }
        catch (DataFormatException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        JDFXYPairRange range = (JDFXYPairRange)other;
        return this.getLeft().equals(range.getLeft()) && this.getRight().equals(range.getRight());
    }

    @Override
    public int hashCode() {
        return HashUtil.hashCode(0, this.toString());
    }

    public JDFXYPair getLeft() {
        return this.m_left;
    }

    public JDFXYPair getRight() {
        return this.m_right;
    }

    public void setLeft(JDFXYPair xy) {
        this.m_left = xy;
    }

    public void setRight(JDFXYPair xy) {
        this.m_right = xy;
    }

    public double getLowerXValue() {
        return this.getLeft().getX() < this.getRight().getX() ? this.getLeft().getX() : this.getRight().getX();
    }

    public double getUpperXValue() {
        return this.getLeft().getX() < this.getRight().getX() ? this.getRight().getX() : this.getLeft().getX();
    }

    public double getLowerYValue() {
        return this.getLeft().getY() < this.getRight().getY() ? this.getLeft().getY() : this.getRight().getY();
    }

    public double getUpperYValue() {
        return this.getLeft().getY() < this.getRight().getY() ? this.getRight().getY() : this.getLeft().getY();
    }

    public JDFXYPair getUpperValue() {
        return this.m_left.isLessOrEqual(this.m_right) ? this.m_right : this.m_left;
    }

    public JDFXYPair getLowerValue() {
        return this.m_left.isLess(this.m_right) ? this.m_left : this.m_right;
    }

    public boolean isEqual(JDFXYPairRange g) {
        return this.m_left.equals(g.m_left) && this.m_right.equals(g.m_right);
    }

    public boolean inRange(JDFXYPair xypair) {
        JDFXYPair min = this.getLowerValue();
        JDFXYPair max = this.getUpperValue();
        return xypair.isGreaterOrEqual(min) && xypair.isLessOrEqual(max);
    }

    @Override
    public boolean isPartOfRange(JDFRange ra) {
        JDFXYPairRange r = (JDFXYPairRange)ra;
        JDFXYPair min = this.getLowerValue();
        JDFXYPair r_min = r.getLowerValue();
        JDFXYPair max = this.getUpperValue();
        JDFXYPair r_max = r.getUpperValue();
        return r_min.isGreaterOrEqual(min) && r_max.isLessOrEqual(max);
    }

    @Override
    protected Object getRightObject() {
        return this.m_right;
    }

    @Override
    protected Object getLeftObject() {
        return this.m_left;
    }

    @Override
    protected boolean inObjectRange(Object other) {
        return this.inRange((JDFXYPair)other);
    }
}

