/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.elementwalker;

import java.lang.reflect.Constructor;
import org.cip4.jdflib.elementwalker.BaseWalkerFactory;
import org.cip4.jdflib.elementwalker.ElementWalker;
import org.cip4.jdflib.util.StringUtil;

public class BaseElementWalker
extends ElementWalker {
    public BaseElementWalker(BaseWalkerFactory _theFactory) {
        super(_theFactory);
        this.constructWalkers("$Walk");
    }

    private void constructWalkers(String classPrefix) {
        for (Class<?> parent = this.getClass(); parent != null; parent = parent.getSuperclass()) {
            Class<?>[] cs;
            String name = parent.getSimpleName();
            for (Class<?> theClass : cs = parent.getDeclaredClasses()) {
                String className = theClass.getName();
                if (!(className = StringUtil.token(className, -1, ".")).startsWith(name + classPrefix)) continue;
                try {
                    Constructor<?> con = theClass.getDeclaredConstructor(parent);
                    con.newInstance(this);
                }
                catch (Throwable x) {
                    this.log.error((Object)"Snafu instantiating walker", x);
                }
            }
        }
    }

    @Override
    public BaseWalkerFactory getFactory() {
        return (BaseWalkerFactory)this.theFactory;
    }
}

