/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.node;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import org.apache.commons.lang.enums.ValuedEnum;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoDeviceInfo;
import org.cip4.jdflib.auto.JDFAutoMISDetails;
import org.cip4.jdflib.auto.JDFAutoNodeInfo;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.JDFAudit;
import org.cip4.jdflib.core.JDFCustomerInfo;
import org.cip4.jdflib.core.JDFCustomerMessage;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.JDFNodeInfo;
import org.cip4.jdflib.core.JDFPartAmount;
import org.cip4.jdflib.core.JDFPartStatus;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.StringArray;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.core.XMLDocUserData;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.JDFIntegerList;
import org.cip4.jdflib.datatypes.JDFXYPair;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.elementwalker.UnLinkFinder;
import org.cip4.jdflib.ifaces.INodeIdentifiable;
import org.cip4.jdflib.ifaces.IURLSetter;
import org.cip4.jdflib.jmf.JDFJMF;
import org.cip4.jdflib.node.ICSVersion;
import org.cip4.jdflib.node.JDFAncestor;
import org.cip4.jdflib.node.LinkInfo;
import org.cip4.jdflib.node.LinkInfoMap;
import org.cip4.jdflib.node.LinkValidator;
import org.cip4.jdflib.node.LinkValidatorMap;
import org.cip4.jdflib.node.NodeIdentifier;
import org.cip4.jdflib.pool.JDFAmountPool;
import org.cip4.jdflib.pool.JDFAncestorPool;
import org.cip4.jdflib.pool.JDFAuditPool;
import org.cip4.jdflib.pool.JDFResourceLinkPool;
import org.cip4.jdflib.pool.JDFResourcePool;
import org.cip4.jdflib.pool.JDFStatusPool;
import org.cip4.jdflib.resource.JDFCreated;
import org.cip4.jdflib.resource.JDFDevice;
import org.cip4.jdflib.resource.JDFPart;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.JDFResourceAudit;
import org.cip4.jdflib.resource.PartitionGetter;
import org.cip4.jdflib.resource.process.JDFBusinessInfo;
import org.cip4.jdflib.resource.process.JDFCompany;
import org.cip4.jdflib.resource.process.JDFComponent;
import org.cip4.jdflib.resource.process.JDFContact;
import org.cip4.jdflib.resource.process.JDFEmployee;
import org.cip4.jdflib.resource.process.JDFMISDetails;
import org.cip4.jdflib.resource.process.JDFNotificationFilter;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.EnumUtil;
import org.cip4.jdflib.util.JDFDate;
import org.cip4.jdflib.util.JDFDuration;
import org.cip4.jdflib.util.JDFMerge;
import org.cip4.jdflib.util.JDFSpawn;
import org.cip4.jdflib.util.StatusCounter;
import org.cip4.jdflib.util.StringUtil;

public class JDFNode
extends JDFElement
implements INodeIdentifiable,
IURLSetter {
    private static AtrInfoTable[] atrInfoTable_abstract = new AtrInfoTable[21];
    private static AtrInfoTable[] atrInfoTable_root;
    private static AtrInfoTable[] atrInfoTable_Combined;
    private static AtrInfoTable[] atrInfoTable_PG;
    private static ElemInfoTable[] elemInfoTable_abstract;
    private static ElemInfoTable[] elemInfoTable_root;
    private static ElemInfoTable[] elemInfoTable_JDF;
    private static final long serialVersionUID = 1L;
    private static final Log nLog;
    @Deprecated
    public static final EnumActivation Activation_Inactive;
    @Deprecated
    public static final EnumActivation Activation_Informative;
    @Deprecated
    public static final EnumActivation Activation_Held;
    @Deprecated
    public static final EnumActivation Activation_TestRun;
    @Deprecated
    public static final EnumActivation Activation_TestRunAndGo;
    @Deprecated
    public static final EnumActivation Activation_Active;
    @Deprecated
    public static final EnumType Type_ProcessGroup;
    @Deprecated
    public static final EnumType Type_Combined;
    @Deprecated
    public static final EnumType Type_Product;
    @Deprecated
    public static final EnumType Type_Approval;
    @Deprecated
    public static final EnumType Type_Buffer;
    @Deprecated
    public static final EnumType Type_Combine;
    @Deprecated
    public static final EnumType Type_Delivery;
    @Deprecated
    public static final EnumType Type_ManualLabor;
    @Deprecated
    public static final EnumType Type_Ordering;
    @Deprecated
    public static final EnumType Type_Packing;
    @Deprecated
    public static final EnumType Type_QualityControl;
    @Deprecated
    public static final EnumType Type_ResourceDefinition;
    @Deprecated
    public static final EnumType Type_Split;
    @Deprecated
    public static final EnumType Type_Verification;
    @Deprecated
    public static final EnumType Type_AssetListCreation;
    @Deprecated
    public static final EnumType Type_ColorCorrection;
    @Deprecated
    public static final EnumType Type_ColorSpaceConversion;
    @Deprecated
    public static final EnumType Type_ContactCopying;
    @Deprecated
    public static final EnumType Type_ContoneCalibration;
    @Deprecated
    public static final EnumType Type_DBDocTemplateLayout;
    @Deprecated
    public static final EnumType Type_DBTemplateMerging;
    @Deprecated
    public static final EnumType Type_DigitalDelivery;
    @Deprecated
    public static final EnumType Type_FilmToPlateCopying;
    @Deprecated
    public static final EnumType Type_FormatConversion;
    @Deprecated
    public static final EnumType Type_ImageReplacement;
    @Deprecated
    public static final EnumType Type_ImageSetting;
    @Deprecated
    public static final EnumType Type_Imposition;
    @Deprecated
    public static final EnumType Type_InkZoneCalculation;
    @Deprecated
    public static final EnumType Type_Interpreting;
    @Deprecated
    public static final EnumType Type_LayoutElementProduction;
    @Deprecated
    public static final EnumType Type_LayoutPreparation;
    @Deprecated
    public static final EnumType Type_PDFToPSConversion;
    @Deprecated
    public static final EnumType Type_Preflight;
    @Deprecated
    public static final EnumType Type_PreviewGeneration;
    @Deprecated
    public static final EnumType Type_Proofing;
    @Deprecated
    public static final EnumType Type_PSToPDFConversion;
    @Deprecated
    public static final EnumType Type_Rendering;
    @Deprecated
    public static final EnumType Type_Scanning;
    @Deprecated
    public static final EnumType Type_Screening;
    @Deprecated
    public static final EnumType Type_Separation;
    @Deprecated
    public static final EnumType Type_SoftProofing;
    @Deprecated
    public static final EnumType Type_Stripping;
    @Deprecated
    public static final EnumType Type_Tiling;
    @Deprecated
    public static final EnumType Type_Trapping;
    @Deprecated
    public static final EnumType Type_ConventionalPrinting;
    @Deprecated
    public static final EnumType Type_DigitalPrinting;
    @Deprecated
    public static final EnumType Type_IDPrinting;
    @Deprecated
    public static final EnumType Type_AdhesiveBinding;
    @Deprecated
    public static final EnumType Type_BlockPreparation;
    @Deprecated
    public static final EnumType Type_BoxPacking;
    @Deprecated
    public static final EnumType Type_Bundling;
    @Deprecated
    public static final EnumType Type_CaseMaking;
    @Deprecated
    public static final EnumType Type_CasingIn;
    @Deprecated
    public static final EnumType Type_ChannelBinding;
    @Deprecated
    public static final EnumType Type_CoilBinding;
    @Deprecated
    public static final EnumType Type_Collecting;
    @Deprecated
    public static final EnumType Type_CoverApplication;
    @Deprecated
    public static final EnumType Type_Creasing;
    @Deprecated
    public static final EnumType Type_Cutting;
    @Deprecated
    public static final EnumType Type_Dividing;
    @Deprecated
    public static final EnumType Type_Embossing;
    @Deprecated
    public static final EnumType Type_EndSheetGluing;
    @Deprecated
    public static final EnumType Type_Feeding;
    @Deprecated
    public static final EnumType Type_Folding;
    @Deprecated
    public static final EnumType Type_Gathering;
    @Deprecated
    public static final EnumType Type_Gluing;
    @Deprecated
    public static final EnumType Type_HeadBandApplication;
    @Deprecated
    public static final EnumType Type_HoleMaking;
    @Deprecated
    public static final EnumType Type_Inserting;
    @Deprecated
    public static final EnumType Type_Jacketing;
    @Deprecated
    public static final EnumType Type_Labeling;
    @Deprecated
    public static final EnumType Type_Laminating;
    @Deprecated
    public static final EnumType Type_LongitudinalRibbonOperations;
    @Deprecated
    public static final EnumType Type_Numbering;
    @Deprecated
    public static final EnumType Type_Palletizing;
    @Deprecated
    public static final EnumType Type_Perforating;
    @Deprecated
    public static final EnumType Type_PlasticCombBinding;
    @Deprecated
    public static final EnumType Type_PrintRolling;
    @Deprecated
    public static final EnumType Type_RingBinding;
    @Deprecated
    public static final EnumType Type_SaddleStitching;
    @Deprecated
    public static final EnumType Type_ShapeCutting;
    @Deprecated
    public static final EnumType Type_Shrinking;
    @Deprecated
    public static final EnumType Type_SideSewing;
    @Deprecated
    public static final EnumType Type_SpinePreparation;
    @Deprecated
    public static final EnumType Type_SpineTaping;
    @Deprecated
    public static final EnumType Type_Stacking;
    @Deprecated
    public static final EnumType Type_Stitching;
    @Deprecated
    public static final EnumType Type_Strapping;
    @Deprecated
    public static final EnumType Type_StripBinding;
    @Deprecated
    public static final EnumType Type_ThreadSealing;
    @Deprecated
    public static final EnumType Type_ThreadSewing;
    @Deprecated
    public static final EnumType Type_Trimming;
    @Deprecated
    public static final EnumType Type_WireCombBinding;
    @Deprecated
    public static final EnumType Type_Wrapping;
    @Deprecated
    public static final EnumProcessUsage ProcessUsage_AnyInput;
    @Deprecated
    public static final EnumProcessUsage ProcessUsage_AnyOutput;
    @Deprecated
    public static final EnumProcessUsage ProcessUsage_Any;
    @Deprecated
    public static final EnumProcessUsage ProcessUsage_Rejected;
    @Deprecated
    public static final EnumProcessUsage ProcessUsage_Accepted;
    @Deprecated
    public static final EnumProcessUsage ProcessUsage_Marks;
    @Deprecated
    public static final EnumProcessUsage ProcessUsage_Document;
    @Deprecated
    public static final EnumProcessUsage ProcessUsage_Surface;
    @Deprecated
    public static final EnumProcessUsage ProcessUsage_Waste;
    @Deprecated
    public static final EnumProcessUsage ProcessUsage_Proof;
    @Deprecated
    public static final EnumProcessUsage ProcessUsage_Input;
    @Deprecated
    public static final EnumProcessUsage ProcessUsage_Plate;
    @Deprecated
    public static final EnumProcessUsage ProcessUsage_Good;
    @Deprecated
    public static final EnumProcessUsage ProcessUsage_Cover;
    @Deprecated
    public static final EnumProcessUsage ProcessUsage_BookBlock;
    @Deprecated
    public static final EnumProcessUsage ProcessUsage_Box;
    @Deprecated
    public static final EnumProcessUsage ProcessUsage_CoverMaterial;
    @Deprecated
    public static final EnumProcessUsage ProcessUsage_SpineBoard;
    @Deprecated
    public static final EnumProcessUsage ProcessUsage_CoverBoard;
    @Deprecated
    public static final EnumProcessUsage ProcessUsage_Case;
    @Deprecated
    public static final EnumProcessUsage ProcessUsage_FrontEndSheet;
    @Deprecated
    public static final EnumProcessUsage ProcessUsage_BackEndSheet;
    @Deprecated
    public static final EnumProcessUsage ProcessUsage_Child;
    @Deprecated
    public static final EnumProcessUsage ProcessUsage_Mother;
    @Deprecated
    public static final EnumProcessUsage ProcessUsage_Jacket;
    @Deprecated
    public static final EnumProcessUsage ProcessUsage_Book;
    @Deprecated
    public static final EnumProcessUsage ProcessUsage_Label;
    @Deprecated
    public static final EnumProcessUsage ProcessUsage_RingBinder;
    @Deprecated
    public static final EnumProcessUsage ProcessUsage_Ancestor;

    @Override
    public InputStream getURLInputStream() {
        return this.getURLInputStream(this.getURL());
    }

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        AttributeInfo ai = super.getTheAttributeInfo().updateReplace(atrInfoTable_abstract);
        String nodeType = this.getType();
        if ("ProcessGroup".equals(nodeType) && !this.hasChildElement("JDF", null)) {
            ai.updateAdd(atrInfoTable_PG);
        } else if ("Combined".equals(nodeType)) {
            ai.updateAdd(atrInfoTable_Combined);
        }
        if (this.isJDFRoot()) {
            ai.updateReplace(atrInfoTable_root);
        }
        return ai;
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        ElementInfo ei = super.getTheElementInfo().updateReplace(elemInfoTable_abstract);
        String typ = this.getType();
        if ("ProcessGroup".equals(typ) || "Product".equals(typ)) {
            ei.updateAdd(elemInfoTable_JDF);
        }
        if (this.isJDFRoot()) {
            ei.updateAdd(elemInfoTable_root);
        }
        return ei;
    }

    public JDFNode(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFNode(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFNode(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFNode[ --> " + super.toString() + " ]";
    }

    @Override
    public boolean init() {
        if (this.hasAttribute("ID")) {
            return false;
        }
        this.appendAnchor(null);
        this.ensureCreated();
        if (this.isJDFRoot()) {
            this.addNameSpace(null, JDFNode.getSchemaURL());
            this.setVersion(JDFNode.getDefaultJDFVersion());
            Object comment = "Generated by the CIP4 Java open source JDF Library version : ";
            comment = (String)comment + JDFAudit.software();
            if (this.getOwnerDocument_KElement().getXMLComment() == null && this.getOwnerDocument_KElement().getRoot() != null) {
                this.setXMLComment((String)comment, true);
            }
        }
        this.ensureJobPartID();
        this.setStatus(JDFElement.EnumNodeStatus.Waiting);
        return true;
    }

    public String ensureJobPartID() {
        if (!this.hasNonEmpty("JobPartID")) {
            String jpid = this.generateDotID("JobPartID", null);
            this.setJobPartID(jpid);
        }
        return this.getJobPartID(false);
    }

    public boolean isJDFRoot() {
        KElement e = this.getParentNode_KElement();
        if (e == null) {
            return true;
        }
        return !(e instanceof JDFNode);
    }

    public VString linkNames() {
        return new LinkValidator(this).linkNames();
    }

    @Deprecated
    public VString linkInfo() {
        LinkInfoMap linkInfos = new LinkValidator(this).getLinkInfoMap();
        VString v = new VString();
        if (linkInfos != null) {
            for (LinkInfo linkInfo : linkInfos.values()) {
                v.add(linkInfo.getString());
            }
        }
        return v;
    }

    public LinkInfoMap getLinkInfoMap() {
        return new LinkValidator(this).getLinkInfoMap();
    }

    @Deprecated
    public boolean setPartStatus(VJDFAttributeMap vmattr, JDFElement.EnumNodeStatus status) {
        return this.setPartStatus(vmattr, status, null);
    }

    public boolean setPartStatus(VJDFAttributeMap vmattr, JDFElement.EnumNodeStatus status, String statusDetails) {
        return new PartStatusHelper().setPartStatus(vmattr, status, statusDetails);
    }

    @Deprecated
    public boolean setPartStatus(JDFAttributeMap mattr, JDFElement.EnumNodeStatus status) {
        return this.setPartStatus(mattr, status, null);
    }

    public boolean setPartStatus(JDFAttributeMap mattr, JDFElement.EnumNodeStatus status, String statusDetails) {
        return new PartStatusHelper().setPartStatus(mattr, status, statusDetails);
    }

    public JDFElement.EnumNodeStatus getVectorPartStatus(VJDFAttributeMap vMap) {
        if (vMap == null || vMap.size() == 0) {
            return this.getPartStatus(null, 0);
        }
        JDFElement.EnumNodeStatus status = this.getPartStatus(vMap.elementAt(0), 0);
        if (status == null) {
            return null;
        }
        for (int i = 1; i < vMap.size(); ++i) {
            JDFElement.EnumNodeStatus status2 = this.getPartStatus(vMap.elementAt(i), 0);
            if (status.equals((Object)status2)) continue;
            return null;
        }
        return status;
    }

    public String getVectorPartStatusDetails(VJDFAttributeMap vMap) {
        if (vMap == null || vMap.size() == 0) {
            return this.getPartStatusDetails(null);
        }
        String status = this.getPartStatusDetails(vMap.elementAt(0));
        if (status == null) {
            return null;
        }
        for (int i = 1; i < vMap.size(); ++i) {
            String status2 = this.getPartStatusDetails(vMap.elementAt(i));
            if (status.equals(status2)) continue;
            return null;
        }
        return status;
    }

    @Deprecated
    public JDFElement.EnumNodeStatus getPartStatus(JDFAttributeMap mattr) {
        return this.getPartStatus(mattr, 0);
    }

    public JDFElement.EnumNodeStatus getPartStatus(JDFAttributeMap attMap, int method) {
        JDFElement.EnumNodeStatus status = this.getStatus();
        if (status != JDFElement.EnumNodeStatus.Pool && status != JDFElement.EnumNodeStatus.Part) {
            return status;
        }
        if (status == JDFElement.EnumNodeStatus.Part) {
            JDFNodeInfo niBase = this.getNodeInfo();
            if (niBase == null) {
                return null;
            }
            int numParts = attMap == null ? 0 : attMap.size();
            JDFNodeInfo ni = (JDFNodeInfo)niBase.getPartition(attMap, null);
            if (ni == null) {
                ni = (JDFNodeInfo)niBase.getResourceRoot().getPartition(attMap, null);
            }
            if (ni == null) {
                return null;
            }
            JDFAttributeMap identicalSrcMap = null;
            if (attMap != null && !attMap.overlapMap(ni.getPartMap())) {
                PartitionGetter partitionGetter = new PartitionGetter(niBase);
                partitionGetter.setFollowIdentical(false);
                JDFNodeInfo identicalSrc = (JDFNodeInfo)partitionGetter.getPartition(attMap, null);
                if (identicalSrc != null) {
                    identicalSrcMap = identicalSrc.getPartMap();
                }
            }
            status = null;
            List<JDFResource> vLeaves = ni.getLeafArray(false);
            int size = vLeaves.size();
            for (int i = 0; i < size; ++i) {
                JDFNodeInfo niCmp = (JDFNodeInfo)vLeaves.get(i);
                JDFAttributeMap map = niCmp.getPartMap();
                if (identicalSrcMap != null) {
                    map.putAll(identicalSrcMap);
                }
                if (map != null && !JDFPart.overlapPartMap(map, attMap, false)) continue;
                while (niCmp != null) {
                    KElement parent;
                    int mapParts = map == null ? 0 : map.size();
                    JDFElement.EnumNodeStatus nodeStatus = niCmp.getNodeStatus();
                    if (!ContainerUtil.equals((Object)nodeStatus, (Object)status)) {
                        if (status == null) {
                            status = nodeStatus;
                        } else {
                            if (nodeStatus == null || method == 0) {
                                return null;
                            }
                            if (method < 0) {
                                status = (JDFElement.EnumNodeStatus)EnumUtil.min(status, nodeStatus);
                            } else if (method > 0) {
                                status = (JDFElement.EnumNodeStatus)EnumUtil.max(status, nodeStatus);
                            }
                        }
                    }
                    if ((parent = niCmp.getParentNode_KElement()) instanceof JDFNodeInfo && mapParts > numParts) {
                        niCmp = (JDFNodeInfo)parent;
                        map = niCmp.getPartMap();
                        continue;
                    }
                    niCmp = null;
                }
            }
            if (status == null && (ni = (JDFNodeInfo)ni.getPartition(attMap, null)) != null) {
                status = ni.getNodeStatus();
            }
        } else if (status == JDFElement.EnumNodeStatus.Pool) {
            JDFStatusPool statusPool = this.getStatusPool();
            if (statusPool == null) {
                return null;
            }
            status = statusPool.getStatus(attMap);
        }
        return status;
    }

    public String getPartStatusDetails(JDFAttributeMap mattr) {
        JDFElement.EnumNodeStatus stat = this.getStatus();
        String statDetails = null;
        if (stat != JDFElement.EnumNodeStatus.Pool && stat != JDFElement.EnumNodeStatus.Part) {
            return StringUtil.getNonEmpty(this.getStatusDetails());
        }
        if (stat == JDFElement.EnumNodeStatus.Part) {
            JDFNodeInfo ni = this.getNodeInfo();
            if (ni == null) {
                return null;
            }
            if ((ni = (JDFNodeInfo)ni.getPartition(mattr, null)) == null) {
                return null;
            }
            statDetails = ni.getNodeStatusDetails();
            JDFAttributeMap identicalSrcMap = null;
            if (mattr != null && !mattr.overlapMap(ni.getPartMap())) {
                PartitionGetter partitionGetter = new PartitionGetter(ni);
                partitionGetter.setFollowIdentical(false);
                JDFNodeInfo identicalSrc = (JDFNodeInfo)partitionGetter.getPartition(mattr, null);
                if (identicalSrc != null) {
                    identicalSrcMap = identicalSrc.getPartMap();
                }
            }
            List<JDFResource> vLeaves = ni.getLeafArray(false);
            int size = vLeaves.size();
            for (int i = 0; i < size; ++i) {
                JDFNodeInfo niCmp = (JDFNodeInfo)vLeaves.get(i);
                JDFAttributeMap map = niCmp.getPartMap();
                if (identicalSrcMap != null) {
                    map.putAll(identicalSrcMap);
                }
                if (map != null && !map.overlapMap(mattr) || ContainerUtil.equals(statDetails, niCmp.getNodeStatusDetails())) continue;
                return null;
            }
        } else if (stat == JDFElement.EnumNodeStatus.Pool) {
            JDFStatusPool statusPool = this.getStatusPool();
            if (statusPool == null) {
                return null;
            }
            JDFPartStatus ps = statusPool.getPartStatus(mattr);
            statDetails = ps == null ? null : StringUtil.getNonEmpty(ps.getStatusDetails());
        }
        return StringUtil.getNonEmpty(statDetails);
    }

    @Deprecated
    public JDFDoc setPhase(JDFElement.EnumNodeStatus nodeStatus, String nodeStatusDetails, JDFAutoDeviceInfo.EnumDeviceStatus deviceStatus, String deviceStatusDetails, VJDFAttributeMap vPartMap) {
        StatusCounter sc = new StatusCounter(this, vPartMap, null);
        sc.setPhase(nodeStatus, nodeStatusDetails, deviceStatus, deviceStatusDetails);
        return sc.getDocJMFPhaseTime();
    }

    public VJDFAttributeMap getStatusPartMapVector() {
        JDFNodeInfo ni;
        JDFElement.EnumNodeStatus status = this.getStatus();
        if (JDFElement.EnumNodeStatus.Pool.equals((Object)status)) {
            JDFStatusPool pool = this.getStatusPool();
            if (pool != null) {
                VJDFAttributeMap vMap = new VJDFAttributeMap();
                VElement vParts = pool.getPartStatusVector(null);
                for (int i = 0; i < vParts.size(); ++i) {
                    JDFPartStatus ps = (JDFPartStatus)vParts.item(i);
                    vMap.add(ps.getPartMap());
                }
                vMap.unify();
                return vMap;
            }
        } else if (JDFElement.EnumNodeStatus.Part.equals((Object)status) && (ni = this.getNodeInfo()) != null) {
            return ni.getPartMapVector(true);
        }
        return null;
    }

    @Override
    public VJDFAttributeMap getPartMapVector() {
        JDFAncestorPool ancPool = this.getAncestorPool();
        if (ancPool != null) {
            return ancPool.getPartMapVector();
        }
        return null;
    }

    public VJDFAttributeMap getNodeInfoPartMapVector() {
        VJDFAttributeMap parts = this.getPartMapVector();
        if (parts == null) {
            JDFNodeInfo ni = this.getNodeInfo();
            VJDFAttributeMap vJDFAttributeMap = parts = ni == null ? null : ni.getPartMapVector(false);
            if (parts == null) {
                JDFResource output = this.getResource(null, JDFResourceLink.EnumUsage.Output, null, 0);
                parts = output == null ? null : output.getPartMapVector(false);
            }
        }
        return ContainerUtil.isEmpty(parts) ? null : parts;
    }

    @Deprecated
    public EnumActivation getActivation() {
        return this.getActivation(false);
    }

    public EnumActivation getActivation(boolean bWalkThroughAncestors) {
        EnumActivation res = null;
        if (bWalkThroughAncestors) {
            res = EnumActivation.Active;
            for (JDFNode p = this; p != null; p = (JDFNode)p.getParentNode_KElement()) {
                EnumActivation a = EnumActivation.getEnum(p.getAttribute("Activation", null, null));
                if (a == null) continue;
                int value = a.getValue();
                if (value <= EnumActivation.TestRun.getValue() || res.getValue() < EnumActivation.Active.getValue()) {
                    res = value < res.getValue() ? a : res;
                    continue;
                }
                if (!res.equals((Object)EnumActivation.TestRunAndGo)) continue;
                res = a;
            }
        } else {
            res = EnumActivation.getEnum(this.getAttribute("Activation", null, null));
        }
        return res;
    }

    public void setActivation(EnumActivation bActive) {
        this.setAttribute("Activation", bActive == null ? null : bActive.getName(), null);
    }

    public JDFAudit addModified(String by) {
        return this.getCreateAuditPool().addModified(by, null);
    }

    public JDFResource getResource(String strName, JDFResourceLink.EnumUsage usage, EnumProcessUsage processUsage, int i) {
        return this.getResource(strName, usage, processUsage == null ? null : processUsage.getName(), null, i);
    }

    public JDFResource getResourceRoot(String strName, JDFResourceLink.EnumUsage usage, int i) {
        JDFAttributeMap map = usage == null ? null : new JDFAttributeMap("Usage", usage);
        JDFResourceLink rl = this.getLink(i, strName, map, null);
        return rl == null ? null : rl.getLinkRoot();
    }

    public JDFResource getResource(String strName, JDFResourceLink.EnumUsage usage, int i) {
        return this.getResource(strName, usage, null, null, i);
    }

    public JDFResource getResource(String strName, JDFResourceLink.EnumUsage usage) {
        return this.getResource(strName, usage, null, null, 0);
    }

    public JDFResource getResource(String strName) {
        return this.getResource(strName, null, null, null, 0);
    }

    @Deprecated
    public JDFResource getResource(String strName, JDFResourceLink.EnumUsage usage, EnumProcessUsage processUsage, int i, String namespaceURI) {
        return this.getResource(strName, usage, processUsage == null ? null : processUsage.getName(), namespaceURI, i);
    }

    public JDFResource getCreateResource(String strName, JDFResourceLink.EnumUsage usage, String processUsage) {
        JDFResource r = this.getResource(strName, usage, processUsage, null, 0);
        if (r == null) {
            r = this.addResource(strName, usage);
            if (usage != null) {
                this.getLink(r, usage).setProcessUsage(processUsage);
            }
        }
        return r;
    }

    public JDFResourceLink getLink(String strName, JDFResourceLink.EnumUsage usage, String processUsage) {
        return this.getLink(strName, usage, processUsage, null, 0);
    }

    public JDFResourceLink getLink(String strName, JDFResourceLink.EnumUsage usage, String processUsage, String namespaceURI, int i) {
        int siz;
        Vector velem = null;
        JDFResourceLinkPool rlp = this.getResourceLinkPool();
        if (rlp != null) {
            velem = rlp.getInOutLinksExtended(usage, true, strName, processUsage, namespaceURI, false);
        }
        int n = siz = velem == null ? 0 : velem.size();
        if (i < 0) {
            i += siz;
        }
        if (siz == 0 || i < 0 || i >= siz || velem == null) {
            return null;
        }
        return (JDFResourceLink)((VElement)velem).elementAt(i);
    }

    public JDFResource getResource(String strName, JDFResourceLink.EnumUsage usage, String processUsage, String namespaceURI, int i) {
        JDFResourceLink rl = this.getLink(strName, usage, processUsage, namespaceURI, i);
        return rl == null ? null : rl.getTarget();
    }

    public List<JDFResource> getResourceLeaves(String strName, JDFResourceLink.EnumUsage usage) {
        return this.getResourceLeaves(strName, usage, null, null, 0);
    }

    public List<JDFResource> getResourceLeaves(String strName, JDFResourceLink.EnumUsage usage, String processUsage, String namespaceURI, int i) {
        JDFResourceLink rl = this.getLink(strName, usage, processUsage, namespaceURI, i);
        return rl == null ? null : rl.getTargetList();
    }

    public JDFResource getCreateResource(String strName, JDFResourceLink.EnumUsage usage, int i) {
        JDFResource r = this.getResource(strName, usage, i);
        if (r == null) {
            r = this.addResource(strName, usage);
        }
        return r;
    }

    public JDFResource getCreateResource(String strName, JDFResourceLink.EnumUsage usage) {
        return this.getCreateResource(strName, usage, 0);
    }

    @Deprecated
    public JDFResource addResource(String strName, JDFResource.EnumResourceClass resClass, boolean bInput, JDFNode resRoot, boolean bLink, String nameSpaceURI) {
        JDFResourceLink.EnumUsage usage = null;
        if (bLink) {
            usage = bInput ? JDFResourceLink.EnumUsage.Input : JDFResourceLink.EnumUsage.Output;
        }
        return this.addResource(strName, resClass, usage, null, resRoot, nameSpaceURI, null);
    }

    public JDFResource addResource(String strName, JDFResourceLink.EnumUsage usage) {
        return this.addResource(strName, null, usage, null, null, null, null);
    }

    public JDFResource addResource(String strName, JDFResource.EnumResourceClass resClass, JDFResourceLink.EnumUsage usage, EnumProcessUsage processUsage, JDFNode resRoot, String nameSpaceURI, JDFResource toReplace) {
        JDFResource.EnumResourceClass resClass2;
        if (resRoot == null) {
            resRoot = this;
        }
        JDFResourcePool p = resRoot.getCreateResourcePool();
        JDFResource r = p.appendResource(strName, null, nameSpaceURI);
        if (usage != null) {
            this.linkResource(r, usage, processUsage);
        }
        if ((resClass2 = r.getResourceClass()) != null) {
            resClass = resClass2;
        }
        if (resClass != null) {
            r.setResourceClass(resClass);
        }
        if (JDFResourceLink.EnumUsage.Input.equals((Object)usage) && (JDFResource.EnumResourceClass.Parameter.equals((Object)resClass) || JDFResource.EnumResourceClass.Consumable.equals((Object)resClass) || JDFResource.EnumResourceClass.Intent.equals((Object)resClass))) {
            r.setResStatus(JDFResource.EnumResStatus.Available, false);
        } else {
            r.setResStatus(JDFResource.EnumResStatus.Unavailable, false);
        }
        if (toReplace != null) {
            this.replaceUpdate(usage, toReplace, r);
        }
        return r;
    }

    protected void replaceUpdate(JDFResourceLink.EnumUsage usage, JDFResource toReplace, JDFResource r) {
        VElement vRL;
        JDFAuditPool auditPool = this.getCreateAuditPool();
        JDFResourceAudit resourceAudit = auditPool.addResourceAudit(null);
        resourceAudit.addNewOldLink(true, r, usage);
        resourceAudit.addNewOldLink(false, toReplace, usage);
        JDFResourceLinkPool resourceLinkPool = this.getResourceLinkPool();
        VElement vElement = vRL = resourceLinkPool == null ? null : resourceLinkPool.getInOutLinks(usage, true, null, null);
        if (vRL != null) {
            for (int i = 0; i < vRL.size(); ++i) {
                JDFResourceLink l = (JDFResourceLink)vRL.elementAt(i);
                if (l.getTarget() != toReplace) continue;
                l.deleteNode();
            }
        }
    }

    @Deprecated
    public JDFResourceLink linkResource(JDFResource jdfResource, boolean input, boolean bForce) {
        boolean bForceLocal = bForce;
        if (bForceLocal) {
            bForceLocal = true;
        }
        return this.linkResource(jdfResource, input ? JDFResourceLink.EnumUsage.Input : JDFResourceLink.EnumUsage.Output, null);
    }

    public JDFResourceLink linkResource(JDFResource jdfResource, JDFResourceLink.EnumUsage usage, EnumProcessUsage processUsage) {
        if (jdfResource == null || usage == null) {
            return null;
        }
        JDFResourceLinkPool resourceLinkPool = this.getCreateResourceLinkPool();
        JDFResourceLink resourceLink = resourceLinkPool.linkResource(jdfResource, usage, processUsage);
        VString types = this.getTypes();
        if (resourceLink != null && types != null && !JDFResource.EnumResourceClass.Implementation.equals((Object)jdfResource.getResourceClass()) && !(jdfResource instanceof JDFNodeInfo)) {
            CombinedProcessIndexHelper.generateCombinedProcessIndex(jdfResource, usage, processUsage, resourceLink, types);
        }
        return resourceLink;
    }

    public JDFResourceLink ensureLink(JDFResource jdfResource, JDFResourceLink.EnumUsage usage, EnumProcessUsage processUsage) {
        String puName = processUsage == null ? null : processUsage.getName();
        return this.ensureLinkPU(jdfResource, usage, puName);
    }

    public JDFResourceLink ensureLinkPU(JDFResource jdfResource, JDFResourceLink.EnumUsage usage, String processUsage) {
        JDFResourceLink rl;
        if (jdfResource == null) {
            return null;
        }
        JDFAttributeMap m = new JDFAttributeMap();
        if (usage != null) {
            m.put("Usage", (ValuedEnum)usage);
        }
        m.put("rRef", jdfResource.getID());
        if (processUsage != null) {
            m.put("ProcessUsage", processUsage);
        }
        if ((rl = this.getLink(0, jdfResource.getNodeName(), m, null)) == null) {
            if (processUsage != null) {
                m.remove("ProcessUsage");
                rl = this.getLink(0, jdfResource.getNodeName(), m, null);
                if (rl != null) {
                    rl.setProcessUsage(processUsage);
                }
            }
            if (rl == null && usage != null) {
                rl = this.linkResource(jdfResource, usage, null);
                rl.setProcessUsage(processUsage);
            }
        }
        return rl;
    }

    public void ensureValidRefsPosition(JDFResource r) {
        if (r == null) {
            return;
        }
        VElement refs = r.getvHRefRes(true, true);
        if (refs == null) {
            refs = new VElement();
        }
        refs.add(r);
        for (KElement target : refs) {
            JDFResource res = ((JDFResource)target).getResourceRoot();
            this.ensureValidResPosition(res);
        }
    }

    public void ensureValidResPosition(JDFResource res) {
        if (res == null) {
            return;
        }
        JDFNode parent = res.getParentJDF();
        while (parent != null && !parent.isAncestor(this) && (parent = res.getParentJDF()) != null) {
            if ((parent = parent.getParentJDF()) == null) {
                throw new JDFException("JDFResourceLink ensureValidResPosition resource is not in the same document");
            }
            res = (JDFResource)parent.getCreateResourcePool().moveElement(res, null);
        }
    }

    @Deprecated
    public VElement getResourceLinks() {
        return this.getResourceLinks(null);
    }

    public VElement getResourceLinks(JDFAttributeMap mLinkAtt) {
        JDFResourceLinkPool resList = this.getResourceLinkPool();
        if (resList == null) {
            return null;
        }
        if (mLinkAtt == null) {
            VElement v = new VElement();
            List<JDFResourceLink> vrl = resList.getLinkArray();
            if (!ContainerUtil.isEmpty(vrl)) {
                v.addAll(vrl);
                return v;
            }
            return null;
        }
        return resList.getPoolChildren(null, mLinkAtt, null);
    }

    public VElement getLinkedResources(JDFAttributeMap mResAtt, boolean bFollowRefs) {
        JDFAncestorPool ancestorPool;
        JDFNodeInfo nodeInfo;
        JDFCustomerInfo customerInfo;
        JDFAuditPool auditPool;
        JDFResourceLinkPool resourceLinkPool = this.getResourceLinkPool();
        VElement vLinkedResources = new VElement();
        if (resourceLinkPool != null) {
            vLinkedResources = resourceLinkPool.getLinkedResources(null, null, mResAtt, bFollowRefs, null);
        }
        if ((auditPool = this.getAuditPool()) != null) {
            vLinkedResources.appendUnique(auditPool.getLinkedResources(null, true));
        }
        if ((customerInfo = (JDFCustomerInfo)this.getElement("CustomerInfo")) != null) {
            vLinkedResources.appendUnique(customerInfo.getLinkedResources(mResAtt, bFollowRefs));
        }
        if ((nodeInfo = (JDFNodeInfo)this.getElement("NodeInfo")) != null) {
            vLinkedResources.appendUnique(nodeInfo.getLinkedResources(mResAtt, bFollowRefs));
        }
        if ((ancestorPool = this.getAncestorPool()) != null) {
            vLinkedResources.appendUnique(ancestorPool.getLinkedResources(mResAtt, bFollowRefs));
        }
        return vLinkedResources;
    }

    @Deprecated
    public VElement getUnlinkedResources(boolean bLocal) {
        JDFResourcePool resourcePool = this.getResourcePool();
        if (resourcePool == null) {
            return null;
        }
        VElement vUnlinkedResources = resourcePool.getUnlinkedResources();
        if (bLocal) {
            return vUnlinkedResources;
        }
        if (vUnlinkedResources == null) {
            vUnlinkedResources = new VElement();
        }
        VElement children = this.getvJDFNode(null, null, true);
        for (int i = 0; i < children.size(); ++i) {
            vUnlinkedResources.addAll(((JDFNode)children.elementAt(i)).getUnlinkedResources(bLocal));
        }
        return vUnlinkedResources.size() == 0 ? null : vUnlinkedResources;
    }

    @Deprecated
    public Vector getPredecessors(boolean bPre) {
        return this.getPredecessors(bPre, false);
    }

    public VElement getPredecessors(boolean bPre, boolean bDirect) {
        HashSet<KElement> hashSet = new HashSet<KElement>();
        HashSet<ResPart> done = new HashSet<ResPart>();
        this.getPredecessorImpl(bPre, bDirect, hashSet, done);
        VElement v = new VElement();
        v.addAll(hashSet);
        return v;
    }

    void getPredecessorImpl(boolean bPre, boolean bDirect, HashSet<KElement> h, HashSet<ResPart> done) {
        Vector vLoc;
        JDFResourceLinkPool rlp = this.getResourceLinkPool();
        Vector vector = rlp == null ? null : (vLoc = rlp.getInOutLinks(bPre ? JDFResourceLink.EnumUsage.Input : JDFResourceLink.EnumUsage.Output, false, null, null));
        if (vLoc != null) {
            for (KElement resElem : vLoc) {
                if (resElem instanceof JDFNodeInfo || resElem instanceof JDFDevice) continue;
                this.checkPredecessorResource(bPre, bDirect, h, done, resElem);
            }
        }
    }

    protected void checkPredecessorResource(boolean bPre, boolean bDirect, HashSet<KElement> h, HashSet<ResPart> done, KElement resElem) {
        JDFResourceLink rl;
        VElement vNode;
        JDFResource r = (JDFResource)resElem;
        ResPart id = new ResPart(r);
        if (done.add(id) && (vNode = r.getCreator(bPre)) != null && (rl = this.getLink(r, bPre ? JDFResourceLink.EnumUsage.Input : JDFResourceLink.EnumUsage.Output)) != null) {
            this.checkPredecessorLink(bPre, bDirect, h, done, r, vNode, rl);
        }
    }

    void checkPredecessorLink(boolean bPre, boolean bDirect, HashSet<KElement> h, HashSet<ResPart> done, JDFResource r, VElement vNode, JDFResourceLink rl) {
        VJDFAttributeMap vMaps = rl.getPartMapVector();
        for (KElement nodeElem : vNode) {
            JDFResourceLink rl2;
            JDFNode p = (JDFNode)nodeElem;
            if (h.contains(p) || p == this || (rl2 = p.getLink(r, bPre ? JDFResourceLink.EnumUsage.Output : JDFResourceLink.EnumUsage.Input)) == null || vMaps != null && !vMaps.overlapsMap(rl2.getPartMapVector())) continue;
            h.add(p);
            if (bDirect) continue;
            p.getPredecessorImpl(bPre, bDirect, h, done);
        }
    }

    public boolean isExecutable(JDFAttributeMap partMap, boolean bCheckChildren) {
        JDFResourceLinkPool resourceLinkPool = this.getResourceLinkPool();
        if (resourceLinkPool == null) {
            return false;
        }
        JDFElement.EnumNodeStatus status = this.getPartStatus(partMap, 0);
        if (status != JDFElement.EnumNodeStatus.Waiting && status != JDFElement.EnumNodeStatus.Ready) {
            return false;
        }
        if (!this.fitsActivation(EnumActivation.Active, true)) {
            return false;
        }
        VElement v = resourceLinkPool.getPoolChildren(null, null, null);
        if (v != null) {
            for (KElement e : v) {
                JDFResourceLink rl = (JDFResourceLink)e;
                if (rl == null || rl.isExecutable(partMap, bCheckChildren)) continue;
                return false;
            }
        }
        return true;
    }

    @Deprecated
    public JDFElement.EnumNodeStatus getProcessStatus(JDFAttributeMap mattr) {
        JDFElement.EnumNodeStatus stat = this.getStatus();
        if (stat.compareTo((Object)JDFElement.EnumNodeStatus.Pool) != 0) {
            return stat;
        }
        stat = null;
        KElement statusPoolEl = this.getElement_JDFElement("StatusPool", null, 0);
        if (statusPoolEl == null) {
            return stat;
        }
        JDFStatusPool statusPool = (JDFStatusPool)statusPoolEl;
        return statusPool.getStatus(mattr);
    }

    public static boolean resourceTypeEqual(JDFResource res1, JDFResource res2) {
        JDFResource.EnumResourceClass res2_class;
        JDFResource.EnumResourceClass res1_class = res1.getResourceClass();
        if (!res1_class.equals((Object)(res2_class = res2.getResourceClass()))) {
            return false;
        }
        String res1_type = res1.getNodeName();
        String res2_type = res2.getNodeName();
        if (res1_type.compareTo("HDM:ReportList") == 0) {
            res1_type = "RunList";
        }
        if (res2_type.compareTo("HDM:ReportList") == 0) {
            res2_type = "RunList";
        }
        return res1_type.compareTo(res2_type) == 0;
    }

    public VElement getvJDFNode(String task, EnumActivation active, boolean bDirect) {
        boolean wantTask;
        VElement l;
        VElement v = new VElement();
        VElement vElement = l = bDirect ? this.getTree("JDF", null, null, bDirect, true) : this.getTree("JDF");
        if (!bDirect && l.size() > 1) {
            KElement e0 = (KElement)l.remove(0);
            l.add(e0);
        }
        boolean bl = wantTask = !KElement.isWildCard(task);
        if (active == null && !wantTask) {
            v.addAll(l);
        } else {
            for (KElement e : l) {
                JDFNode p = (JDFNode)e;
                if (!p.fitsActivation(active, true) || wantTask && !p.getType().equals(task)) continue;
                v.addElement(p);
            }
        }
        return v;
    }

    @Deprecated
    public Vector getvJDFNode(String task, boolean active) {
        return this.getvJDFNode(task, null, active);
    }

    @Deprecated
    public boolean isActive() {
        return this.fitsActivation(EnumActivation.Active, true);
    }

    @Deprecated
    public boolean isActive(boolean bWalkThroughAnchestors) {
        return this.fitsActivation(EnumActivation.Active, bWalkThroughAnchestors);
    }

    public boolean fitsActivation(EnumActivation active, boolean bWalkThroughAncestors) {
        if (active == null) {
            return true;
        }
        EnumActivation a = this.getActivation(bWalkThroughAncestors);
        if (active.equals((Object)EnumActivation.TestRun)) {
            return a.equals((Object)EnumActivation.TestRun) || a.equals((Object)EnumActivation.TestRunAndGo);
        }
        if (active.equals((Object)EnumActivation.Active)) {
            return a.equals((Object)EnumActivation.Active) || a.equals((Object)EnumActivation.TestRunAndGo);
        }
        return a.equals((Object)active);
    }

    @Deprecated
    public void removeNode(boolean bLeaveSubmit) {
        if (bLeaveSubmit) {
            String id = this.getID();
            this.removeAttributes(VString.emptyVector);
            this.setAttribute("ID", id, null);
            this.setStatus(JDFElement.EnumNodeStatus.Spawned);
            this.removeChildren(null, null, null);
        } else {
            this.deleteNode();
        }
    }

    @Deprecated
    public JDFNode addTask(String task, VString tasks) {
        if (task.equals("")) {
            return this;
        }
        JDFNode p = (JDFNode)this.appendElement("JDF", null);
        if (p != null) {
            if (task.equals("Combined")) {
                p.setCombined(tasks);
            } else {
                p.setType(task, false);
            }
        }
        return p;
    }

    @Deprecated
    public JDFNode addTask(String task) {
        return this.addTask(task, null);
    }

    public void setType(EnumType typ) {
        this.setType(typ == null ? null : typ.getName(), true);
    }

    public boolean setType(String newType, boolean checkName) {
        EnumType eTyp = EnumType.getEnum(newType);
        if (!checkName || eTyp != null) {
            this.removeAttribute("type", "http://www.w3.org/2001/XMLSchema-instance");
            this.setAttribute("Type", newType, null);
            if (eTyp != null) {
                this.setXSIType(newType);
                if (!eTyp.equals((Object)EnumType.Combined) && !eTyp.equals((Object)EnumType.ProcessGroup)) {
                    this.removeAttribute("Types");
                }
            }
        } else {
            throw new JDFException("SetType illegal type: " + newType);
        }
        return true;
    }

    public String getType() {
        return this.getAttribute("Type", null, "");
    }

    public String getTypesString() {
        String s = this.getAttribute("Types", null, null);
        return s == null ? this.getType() : s;
    }

    public boolean fixNiCi(JDFElement.EnumVersion version) {
        boolean bRet = true;
        for (int i = 0; i < 2; ++i) {
            String nam = i > 0 ? "NodeInfo" : "CustomerInfo";
            String linkNam = nam + "Link";
            if (version.getValue() >= JDFElement.EnumVersion.Version_1_3.getValue()) {
                bRet = this.fixNiCiToResource(i, nam, linkNam);
                continue;
            }
            this.fixNiCiToElement(i, nam, linkNam);
        }
        return bRet;
    }

    private void fixNiCiToElement(int i, String nam, String linkNam) {
        JDFResourceLinkPool rlp = this.getResourceLinkPool();
        if (rlp != null && rlp.hasChildElement(linkNam, null)) {
            JDFResourceLink rl = rlp.getPoolChild(0, linkNam, null, null);
            JDFResource root = rl.getLinkRoot();
            JDFElement e = (JDFElement)this.getCreateElement(nam);
            if (!root.hasAttribute("PartIDKeys")) {
                e.mergeElement(root, false);
                if (i == 1 && this.getStatus() == JDFElement.EnumNodeStatus.Part) {
                    this.moveAttribute("Status", e, "NodeStatus", null, null);
                    if (e.hasAttribute("NodeStatusDetails")) {
                        this.moveAttribute("StatusDetails", e, "NodeStatusDetails", null, null);
                    }
                }
            } else {
                if (i == 1) {
                    this.setStatus(JDFElement.EnumNodeStatus.Pool);
                    VElement vLeaves = root.getLeaves(false);
                    JDFStatusPool sp = this.getCreateStatusPool();
                    sp.removeChildren(null, null, null);
                    for (int j = 0; j < vLeaves.size(); ++j) {
                        JDFNodeInfo ni = (JDFNodeInfo)vLeaves.elementAt(j);
                        JDFPartStatus ps = sp.appendPartStatus();
                        ps.setPartMap(ni.getPartMap());
                        ps.setAttribute("Status", ni.getAttribute("NodeStatus"));
                        if (!ni.hasAttribute("StatusDetails")) continue;
                        ps.setAttribute("StatusDetails", ni.getAttribute("NodeStatusDetails"));
                    }
                }
                JDFResource target = rl.getTarget();
                target.removeChildren(target.getNodeName(), null, null);
                target.expand(false);
                e.mergeElement(target, false);
                String partidkeys = root.getAttribute("PartIDKeys", null, null);
                if (partidkeys != null) {
                    e.setAttribute("PartIDKeys", partidkeys);
                }
            }
            ((JDFResource)e).cleanResourceAttributes();
            rl.deleteNode();
            root.deleteNode();
        }
    }

    private boolean fixNiCiToResource(int i, String nam, String linkNam) {
        boolean bRet = true;
        JDFResourceLinkPool rlp = this.getResourceLinkPool();
        if (this.hasChildElement(nam, null) || i == 1 && this.hasChildElement("StatusPool", null)) {
            JDFElement e = (JDFElement)this.getElement(nam);
            if (rlp == null || !rlp.hasChildElement(linkNam, null)) {
                JDFResource r = this.addResource(nam, null, JDFResourceLink.EnumUsage.Input, null, null, null, null);
                if (e != null) {
                    r.mergeElement(e, false);
                }
                if (i == 1) {
                    JDFNodeInfo ni = (JDFNodeInfo)r;
                    if (this.hasChildElement("StatusPool", null)) {
                        JDFStatusPool statusPool = this.getStatusPool();
                        VElement vPartStatus = statusPool.getPoolChildren(null);
                        this.setStatus(JDFElement.EnumNodeStatus.Part);
                        JDFAttributeMap mps = null;
                        if (!vPartStatus.isEmpty()) {
                            JDFPartStatus ps = (JDFPartStatus)vPartStatus.elementAt(0);
                            mps = ps.getPartMap();
                        }
                        VString partIDKeys = this.getPartIDKeys(mps);
                        ni.setAttribute("NodeStatus", statusPool.getAttribute("Status"));
                        ni.setAttribute("NodeStatusDetails", statusPool.getStatusDetails());
                        for (int ips = 0; ips < vPartStatus.size(); ++ips) {
                            JDFPartStatus ps = (JDFPartStatus)vPartStatus.elementAt(ips);
                            try {
                                ni = (JDFNodeInfo)r.getCreatePartition(ps.getPartMap(), partIDKeys);
                            }
                            catch (JDFException ex) {
                                bRet = false;
                                continue;
                            }
                            ni.setAttribute("NodeStatus", ps.getAttribute("Status"));
                            if (!ps.hasAttribute("StatusDetails")) continue;
                            ni.setAttribute("NodeStatusDetails", ps.getStatusDetails());
                        }
                        this.removeChild("StatusPool", null, 0);
                    }
                }
            }
            this.removeChild(nam, null, 0);
        }
        return bRet;
    }

    @Override
    public boolean isValid(JDFElement.EnumValidationLevel level) {
        JDFNode n;
        boolean bValid = super.isValid(level);
        if (!bValid) {
            return false;
        }
        boolean bl = bValid = !this.hasInvalidLinks(level);
        if (bValid && EnumType.Product.equals((Object)this.getEnumType()) && (n = this.getParentJDF()) != null) {
            bValid = EnumType.Product.equals((Object)n.getEnumType());
        }
        return bValid;
    }

    public boolean hasInvalidLinks(JDFElement.EnumValidationLevel level) {
        return this.getInvalidLinks(level, 1).size() > 0;
    }

    public VString getInvalidLinks(JDFElement.EnumValidationLevel level, int nMax) {
        return new LinkValidator(this).getInvalidLinks(level, nMax);
    }

    public StatusSynch getStatusSynch() {
        return new StatusSynch();
    }

    @Deprecated
    public void updatePartStatus(VJDFAttributeMap vMap, boolean updateKids, boolean updateParents) {
        this.updatePartStatus(vMap, updateKids, updateParents, 0);
    }

    public void updatePartStatus(VJDFAttributeMap vMap, boolean updateKids, boolean updateParents, int method) {
        JDFNode parent;
        VElement vNodes = this.getvJDFNode(null, null, true);
        if (vNodes != null && !vNodes.isEmpty()) {
            JDFAttributeMap map;
            int i;
            int kidsize = vNodes.size();
            VJDFAttributeMap statusMaps = new VJDFAttributeMap();
            for (i = 0; i < kidsize; ++i) {
                JDFNode node = (JDFNode)vNodes.item(i);
                if (updateKids) {
                    node.updatePartStatus(vMap, updateKids, false, method);
                }
                statusMaps.addAll(node.getStatusPartMapVector());
            }
            statusMaps.unify();
            if (statusMaps.size() > 0) {
                for (i = statusMaps.size() - 1; i >= 0; --i) {
                    map = statusMaps.elementAt(i);
                    if (map.subMap(vMap)) continue;
                    statusMaps.removeElementAt(i);
                }
                if (statusMaps.size() == 0) {
                    return;
                }
            } else {
                statusMaps.add(null);
            }
            for (i = 0; i < statusMaps.size(); ++i) {
                map = statusMaps.elementAt(i);
                JDFElement.EnumNodeStatus minStatus = JDFElement.EnumNodeStatus.Aborted;
                JDFElement.EnumNodeStatus maxStatus = JDFElement.EnumNodeStatus.Waiting;
                for (int j = 0; j < kidsize; ++j) {
                    JDFNode node = (JDFNode)vNodes.item(j);
                    JDFElement.EnumNodeStatus status = node.getPartStatus(map, method);
                    if (status == null) {
                        minStatus = null;
                        break;
                    }
                    if (minStatus.getValue() > status.getValue()) {
                        minStatus = status;
                        continue;
                    }
                    if (maxStatus.getValue() >= status.getValue()) continue;
                    maxStatus = status;
                }
                if (minStatus == null) continue;
                if (method <= 0) {
                    this.setPartStatus(map, minStatus, null);
                    continue;
                }
                this.setPartStatus(map, maxStatus, null);
            }
        }
        if (updateParents && (parent = this.getParentJDF()) != null) {
            parent.updatePartStatus(vMap, false, true, 0);
        }
    }

    @Deprecated
    public void upDateStatus() {
        JDFResourceLinkPool resourceLinkPool = this.getResourceLinkPool();
        if (resourceLinkPool == null) {
            return;
        }
        VElement vOut = resourceLinkPool.getInOutLinks(JDFResourceLink.EnumUsage.Output, false, null, null);
        if (vOut == null || vOut.isEmpty()) {
            return;
        }
        boolean bReady = true;
        for (int i = 0; i < vOut.size(); ++i) {
            JDFResource g = (JDFResource)vOut.elementAt(i);
            if (g.getResStatus(false).getValue() >= JDFResource.EnumResStatus.Available.getValue()) continue;
            bReady = false;
        }
        if (bReady) {
            this.setStatus(JDFElement.EnumNodeStatus.Completed);
            KElement parent = this.getParentNode_KElement();
            if (parent != null) {
                JDFNode p = (JDFNode)parent;
                p.upDateStatus();
            }
        }
    }

    public JDFNode getJobPart(NodeIdentifier nodeID) {
        if (nodeID == null) {
            return this;
        }
        return this.getJobPart(nodeID.getJobPartID(), nodeID.getJobID());
    }

    public JDFNode getJDF(int iSkip) {
        return (JDFNode)this.getElement("JDF", null, iSkip);
    }

    public JDFNode getJobPart(String jobPartID, String jobID) {
        JDFAttributeMap jobPartIDMap = new JDFAttributeMap("JobPartID", jobPartID);
        JDFNode n = (JDFNode)this.getTreeElement("JDF", null, jobPartIDMap, false, true);
        if (n != null && !JDFNode.isWildCard(jobID) && !jobID.equals(n.getJobID(true))) {
            jobPartIDMap.put("JobID", jobID);
            n = (JDFNode)this.getTreeElement("JDF", null, jobPartIDMap, false, true);
        }
        return n;
    }

    public Collection<JDFResource> checkSpawnedResources(VString vRWResources, VJDFAttributeMap vSpawnParts) {
        JDFSpawn spawn = new JDFSpawn(this);
        spawn.vSpawnParts = vSpawnParts;
        spawn.vRWResources_in = new VString(vRWResources);
        return spawn.checkSpawnedResources();
    }

    @Override
    public HashSet<JDFElement> getAllRefs(HashSet<JDFElement> vDoneRefs, boolean bRecurse) {
        JDFAncestorPool ap;
        JDFNodeInfo ni;
        JDFCustomerInfo ci;
        JDFResourceLinkPool rlp;
        JDFResourcePool rp;
        HashSet<JDFElement> v1 = vDoneRefs;
        if (v1 == null) {
            v1 = new LinkedHashSet<JDFElement>();
        }
        if ((rp = this.getResourcePool()) != null && bRecurse) {
            v1 = rp.getAllRefs(v1, bRecurse);
        }
        if ((rlp = this.getResourceLinkPool()) != null) {
            v1 = rlp.getAllRefs(v1, bRecurse);
        }
        if ((ci = (JDFCustomerInfo)this.getElement("CustomerInfo")) != null) {
            v1 = ci.getAllRefs(v1, bRecurse);
        }
        if ((ni = (JDFNodeInfo)this.getElement("NodeInfo")) != null) {
            v1 = ni.getAllRefs(v1, bRecurse);
        }
        if ((ap = this.getAncestorPool()) != null) {
            v1 = ap.getAllRefs(v1, true);
        }
        VElement vNodes = this.getvJDFNode(null, null, true);
        for (KElement e : vNodes) {
            v1 = ((JDFNode)e).getAllRefs(v1, bRecurse);
        }
        return v1;
    }

    public void setCombined(VString vCombiNodes) {
        this.setType("Combined", false);
        this.setTypes(vCombiNodes);
    }

    @Deprecated
    public Vector getCombinedTypes() {
        if (!this.isTypesNode()) {
            return new Vector();
        }
        String s = this.getAttribute("Types", null, "");
        return StringUtil.tokenize(s, " ", false);
    }

    @Deprecated
    public JDFComponent addComponent(String cType, boolean bInput, JDFNode resRoot, boolean bLink) {
        JDFComponent c = (JDFComponent)this.addResource("Component", JDFResource.EnumResourceClass.Quantity, bInput, resRoot, bLink, null);
        if (c != null) {
            c.setResStatus(JDFResource.EnumResStatus.Unavailable, false);
            c.setDescriptiveName(cType);
        }
        return c;
    }

    public void setSpawnID(String value) {
        this.setAttribute("SpawnID", value, null);
    }

    @Deprecated
    public JDFNode spawn(String parentURL, String spawnURL, VString vRWResources_in, VJDFAttributeMap vSpawnParts, boolean bSpawnROPartsOnly, boolean bCopyNodeInfo, boolean bCopyCustomerInfo, boolean bCopyComments) {
        JDFSpawn spawn = new JDFSpawn(this);
        return spawn.spawn(parentURL, spawnURL, vRWResources_in, vSpawnParts, bSpawnROPartsOnly, bCopyNodeInfo, bCopyCustomerInfo, bCopyComments);
    }

    @Deprecated
    public JDFNode spawnInformative(String parentURL, String spawnURL, VJDFAttributeMap vSpawnParts, boolean bSpawnROPartsOnly, boolean bCopyNodeInfo, boolean bCopyCustomerInfo, boolean bCopyComments) {
        JDFSpawn _spawn = new JDFSpawn(this);
        return _spawn.spawnInformative(parentURL, spawnURL, vSpawnParts, bSpawnROPartsOnly, bCopyNodeInfo, bCopyCustomerInfo, bCopyComments);
    }

    @Deprecated
    public JDFNode unSpawn(String spawnID) {
        return new JDFSpawn(this).unSpawn(spawnID);
    }

    public JDFNode mergeNode(JDFNode e, boolean bDelete) {
        VElement v = e.getChildElementVector(null, null, null, true, 0, false);
        for (int i = 0; i < v.size(); ++i) {
            KElement m = v.elementAt(i);
            String strName = m.getNodeName();
            KElement mHere = null;
            if (strName.equals("NodeInfo") || strName.equals("CustomerInfo") || strName.equals("ResourcePool") || strName.equals("ResourceLinkPool") || strName.equals("AncestorPool") || strName.equals("AuditPool")) {
                mHere = this.getElement_JDFElement(m.getNodeName(), null, 0);
            }
            if (mHere == null) {
                if (bDelete) {
                    this.moveElement(m, null);
                    continue;
                }
                this.copyElement(m, null);
                continue;
            }
            mHere.mergeElement(m, bDelete);
            if (!bDelete) continue;
            m.deleteNode();
        }
        this.setAttributes(e);
        return this;
    }

    @Deprecated
    public JDFResourceLink getLink(JDFResource r, boolean bInput) {
        return this.getLink(r, bInput ? JDFResourceLink.EnumUsage.Input : JDFResourceLink.EnumUsage.Output);
    }

    public JDFResourceLink getLink(JDFResource r, JDFResourceLink.EnumUsage usage) {
        JDFResourceLinkPool p = this.getResourceLinkPool();
        if (p == null || r == null) {
            return null;
        }
        VElement v = p.getInOutLinks(usage, true, null, null);
        if (v != null) {
            String linkString = r.getLinkString();
            String rID = r.getID();
            for (KElement e : v) {
                JDFResourceLink resLink = (JDFResourceLink)e;
                if (resLink == null || !resLink.getrRef().equals(rID) || !resLink.getNodeName().equals(linkString)) continue;
                return resLink;
            }
        }
        return null;
    }

    public VElement getLinkedResourceVector(JDFResourceLink.EnumUsage usage, String resName, EnumProcessUsage procUsage, boolean expandLeaves) {
        VElement vLinks;
        JDFResourceLinkPool p = this.getResourceLinkPool();
        VElement vElement = vLinks = p == null ? null : p.getInOutLinks(usage, true, resName, procUsage);
        if (vLinks == null || vLinks.size() == 0) {
            return null;
        }
        VElement v = new VElement();
        for (KElement e : vLinks) {
            JDFResourceLink rl = (JDFResourceLink)e;
            VElement vRes = rl.getTargetVector(0);
            if (vRes == null) continue;
            if (expandLeaves) {
                for (KElement r : vRes) {
                    JDFResource res = (JDFResource)r;
                    v.addAll(res.getLeafArray(false));
                }
                continue;
            }
            v.addAll(vRes);
        }
        v.unify();
        return v.size() == 0 ? null : v;
    }

    public JDFNode getRoot() {
        return (JDFNode)this.getDeepParent("JDF", Integer.MAX_VALUE);
    }

    public VString getAncestorIDs() {
        VString vs = new VString();
        JDFNode me = this;
        while (true) {
            String pid = me.getID();
            vs.addElement(pid);
            KElement parent = me.getParentNode_KElement();
            if (parent == null || !(parent instanceof JDFNode)) break;
            me = (JDFNode)parent;
        }
        VString vs2 = new VString();
        for (int i = vs.size() - 1; i >= 0; --i) {
            vs2.addElement(vs.elementAt(i));
        }
        return vs2;
    }

    @Deprecated
    public JDFNode getAncestorNode(int nSkip) {
        KElement parent = this.getParentNode_KElement();
        JDFNode node = (JDFNode)parent;
        if (node != null) {
            for (int i = 0; i < nSkip && (node = (JDFNode)(parent = node.getParentNode_KElement())) != null; ++i) {
            }
        }
        return node;
    }

    public String getAncestorAttribute(String attrib, String nameSpaceURI, String def) {
        String s = this.getInheritedAttribute(attrib, nameSpaceURI, null);
        if (s != null) {
            return s;
        }
        JDFNode root = this.getJDFRoot();
        if (root == null) {
            return def;
        }
        JDFAncestorPool ap = root.getAncestorPool();
        if (ap == null) {
            return def;
        }
        return ap.getAncestorAttribute(attrib, nameSpaceURI, def);
    }

    public boolean hasAncestorAttribute(String attrib, String nameSpaceURI) {
        return this.getAncestorAttribute(attrib, nameSpaceURI, null) != null;
    }

    public boolean hasActivation(boolean bInherit) {
        if (bInherit) {
            return this.hasAncestorAttribute("Activation", null);
        }
        return this.hasAttribute("Activation", null, false);
    }

    @Deprecated
    public boolean hasJobID(boolean bInherit) {
        if (bInherit) {
            return this.hasAncestorAttribute("JobID", null);
        }
        return this.hasAttribute("JobID", null, false);
    }

    public KElement getAncestorElement(String element, String nameSpaceURI) {
        if ("NodeInfo".equals(element) || "CustomerInfo".equals(element)) {
            return this.getNiCi(element, true, null);
        }
        JDFElement e = (JDFElement)this.getInheritedElement(element, nameSpaceURI, 0);
        if (e != null) {
            return e;
        }
        JDFNode root = this.getJDFRoot();
        if (root == null) {
            return null;
        }
        JDFAncestorPool ap = root.getAncestorPool();
        if (ap == null) {
            return null;
        }
        return ap.getAncestorElement(element, nameSpaceURI, null);
    }

    @Deprecated
    public boolean hasAncestorElement(String element, String nameSpaceURI) {
        return this.getAncestorElement(element, nameSpaceURI) != null;
    }

    @Deprecated
    public JDFResource addParameter(String strName, boolean bInput, JDFNode resRoot, boolean bLink) {
        return this.addResource(strName, JDFResource.EnumResourceClass.Parameter, bInput, resRoot, bLink, null);
    }

    @Deprecated
    public JDFResource addConsumable(String strName, boolean bInput, JDFNode resRoot, boolean bLink) {
        return this.addResource(strName, JDFResource.EnumResourceClass.Consumable, bInput, resRoot, bLink, null);
    }

    @Deprecated
    public JDFResource addHandling(String strName, boolean bInput, JDFNode resRoot, boolean bLink) {
        return this.addResource(strName, JDFResource.EnumResourceClass.Handling, bInput, resRoot, bLink, null);
    }

    public boolean isCombined() {
        return "Combined".equals(this.getType());
    }

    public boolean isProduct() {
        return "Product".equals(this.getType());
    }

    public boolean isProcessGroup() {
        return "ProcessGroup".equals(this.getType());
    }

    public boolean isGroupNode() {
        EnumType type2 = this.getEnumType();
        return EnumType.ProcessGroup.equals((Object)type2) && !this.hasAttribute("Types") || EnumType.Product.equals((Object)type2);
    }

    public boolean isTypesNode() {
        EnumType type2 = this.getEnumType();
        return EnumType.ProcessGroup.equals((Object)type2) || EnumType.Combined.equals((Object)type2);
    }

    @Override
    public String getIDPrefix() {
        return "n";
    }

    public String getJobID(boolean bInherit) {
        if (bInherit) {
            return this.getAncestorAttribute("JobID", null, "");
        }
        return this.getAttribute("JobID", null, "");
    }

    @Deprecated
    public String getJobPartID() {
        return this.getJobPartID(false);
    }

    public String getJobPartID(boolean bInherit) {
        if (bInherit) {
            return this.getAncestorAttribute("JobPartID", null, "");
        }
        return this.getAttribute("JobPartID", null, "");
    }

    public void setJobPartID(String jobPartID) {
        this.setAttribute("JobPartID", jobPartID, null);
    }

    public void setJobID(String value) {
        this.setAttribute("JobID", value, null);
    }

    @Deprecated
    public boolean hasStatusPool() {
        return this.numChildElements("StatusPool", null) > 0;
    }

    @Deprecated
    public String getSpawnID() {
        return this.getSpawnID(false);
    }

    public String getSpawnID(boolean bInherit) {
        if (bInherit) {
            return this.getAncestorAttribute("SpawnID", null, "");
        }
        return this.getAttribute("SpawnID");
    }

    @Deprecated
    public void removeSpawnID() {
        this.removeAttribute("SpawnID", null);
    }

    @Deprecated
    public void removeAncestorPool() {
        this.removeChild("AncestorPool", null, 0);
    }

    @Deprecated
    public JDFNode getParentJDFNode() {
        return this.getParentJDF();
    }

    @Override
    public JDFNode getParentJDF() {
        KElement jdfElem = this.getParentNode_KElement();
        if (jdfElem instanceof JDFNode) {
            return (JDFNode)jdfElem;
        }
        return null;
    }

    public JDFNode getParentProduct() {
        JDFNode parent;
        for (parent = this; parent != null && !parent.isProduct(); parent = parent.getParentJDF()) {
        }
        return parent;
    }

    @Deprecated
    public boolean hasType() {
        return this.hasAttribute("Type", null, false);
    }

    public boolean containsType(String type) {
        if (type == null) {
            return true;
        }
        String myType = this.getTypesString();
        if (myType == null) {
            return false;
        }
        return StringUtil.hasToken(myType, type, " ", 0);
    }

    public VString getInsertLinkVector(int nMax) {
        return new LinkValidator(this).getInsertLinkVector(nMax);
    }

    @Deprecated
    public EnumProcessUsage getEnumProcessUsage(String info, int i) {
        String iToken = StringUtil.token(info, i, " ");
        if (iToken.equals("")) {
            return null;
        }
        if (iToken.length() > 2) {
            String pu = iToken.substring(2);
            return EnumProcessUsage.getEnum(pu);
        }
        if (iToken.charAt(0) == 'i') {
            return EnumProcessUsage.AnyInput;
        }
        if (iToken.charAt(0) == 'o') {
            return EnumProcessUsage.AnyOutput;
        }
        throw new JDFException("JDFNode.getEnumProcessUsage: bad input: " + info);
    }

    @Deprecated
    public boolean hasAncestorPool() {
        return this.numChildElements("AncestorPool", null) > 0;
    }

    @Deprecated
    public boolean hasProjectID(boolean bInherit) {
        if (bInherit) {
            return this.hasAncestorAttribute("ProjectID", null);
        }
        return this.hasAttribute("ProjectID", null, false);
    }

    @Deprecated
    public boolean hasProjectID() {
        return this.hasProjectID(false);
    }

    public void setProjectID(String strValue) {
        this.setAttribute("ProjectID", strValue, null);
    }

    public String getProjectID(boolean bInherit) {
        if (bInherit) {
            return this.getAncestorAttribute("ProjectID", null, "");
        }
        return this.getAttribute("ProjectID", null, "");
    }

    @Deprecated
    public String getProjectID() {
        return this.getProjectID(false);
    }

    public boolean isValidLink(JDFElement.EnumValidationLevel level, JDFResourceLink rl) {
        return new LinkValidator(this).isValidLink(level, rl);
    }

    public boolean isValidLink(String resName, JDFResourceLink.EnumUsage usage, String processUsage) {
        return new LinkValidator(this).isValidLink(resName, usage, processUsage);
    }

    @Deprecated
    public VString getMissingLinks(int nMax) {
        return this.getMissingLinkVector(nMax);
    }

    public VElement getMatchingLinks(String resName, boolean bLink, EnumProcessUsage processUsage) {
        return new LinkValidator(this).getMatchingLinks(resName, bLink, processUsage);
    }

    public VString getMissingLinkVector(int nMax) {
        return new LinkValidator(this).getMissingLinkVector(nMax);
    }

    @Deprecated
    public JDFResource getMatchingResource(String resName, int processUsage, JDFAttributeMap partMap, int pos) {
        JDFResourceLink rl = this.getMatchingLink(resName, EnumProcessUsage.getEnum(processUsage), pos);
        if (rl == null) {
            return null;
        }
        if (!partMap.isEmpty() && !rl.hasPartMap(partMap)) {
            return null;
        }
        JDFResource r = rl.getTarget();
        return r.getPartition(partMap, null);
    }

    public JDFResource getMatchingResource(String resName, EnumProcessUsage processUsage, JDFAttributeMap partMap, int pos) {
        JDFResourceLink rl = this.getMatchingLink(resName, processUsage, pos);
        if (rl == null) {
            return null;
        }
        if (partMap != null && !partMap.isEmpty() && !rl.hasPartMap(partMap)) {
            return null;
        }
        JDFResource r = rl.getTarget();
        if (r == null) {
            return null;
        }
        return r.getPartition(partMap, null);
    }

    public JDFResourceLink getMatchingLink(String resName, EnumProcessUsage processUsage, int pos) {
        return new LinkValidator(this).getMatchingLink(resName, processUsage, pos);
    }

    public JDFResource appendMatchingResource(String resName, JDFResourceLink.EnumUsage usage) {
        EnumProcessUsage processUsage = null;
        if (JDFResourceLink.EnumUsage.Input.equals((Object)usage)) {
            processUsage = EnumProcessUsage.AnyInput;
        } else if (JDFResourceLink.EnumUsage.Output.equals((Object)usage)) {
            processUsage = EnumProcessUsage.AnyOutput;
        }
        return new LinkValidator(this).appendMatchingResource(resName, processUsage, null);
    }

    public JDFResource appendMatchingResource(String resName, EnumProcessUsage processUsage, JDFNode resourceRoot) {
        return new LinkValidator(this).appendMatchingResource(resName, processUsage, resourceRoot);
    }

    public boolean removeMatchingLink(String resName, int processUsage, boolean bRemoveResource, int pos) {
        JDFResourceLink l = null;
        l = this.getMatchingLink(resName, EnumProcessUsage.getEnum(processUsage), pos);
        if (l == null) {
            return false;
        }
        this.removeLink(l, bRemoveResource);
        return true;
    }

    public void removeLink(JDFResourceLink l, boolean bRemoveResource) {
        if (l == null) {
            return;
        }
        if (bRemoveResource) {
            JDFResource r = l.getLinkRoot();
            l.deleteNode();
            if (r.getLinks(null, null).size() == 0) {
                r.deleteUnLinked();
            }
        } else {
            l.deleteNode();
        }
    }

    public boolean removeMatchingLinks(String resName, EnumProcessUsage processUsage, boolean bRemoveResource) {
        VElement v = this.getMatchingLinks(resName, true, processUsage);
        for (KElement e : v) {
            this.removeLink((JDFResourceLink)e, bRemoveResource);
        }
        return v.size() > 0;
    }

    public JDFResourceLink linkMatchingResource(JDFResource resource, EnumProcessUsage processUsage, JDFAttributeMap partMap) {
        return new LinkValidator(this).linkMatchingResource(resource, processUsage, partMap);
    }

    public int numMatchingLinks(String resName, boolean bLink, EnumProcessUsage processUsage) {
        return new LinkValidator(this).numMatchingLinks(resName, bLink, processUsage);
    }

    public JDFAncestorPool getCreateAncestorPool() {
        return (JDFAncestorPool)this.getCreateElement_KElement("AncestorPool", null, 0);
    }

    public JDFAncestorPool appendAncestorPool() {
        return (JDFAncestorPool)this.appendElementN("AncestorPool", 1, null);
    }

    public JDFAncestorPool getAncestorPool() {
        return this.getElementByClass(JDFAncestorPool.class, 0, false);
    }

    public JDFAuditPool getCreateAuditPool() {
        return (JDFAuditPool)this.getCreateElement_KElement("AuditPool", null, 0);
    }

    public JDFAuditPool appendAuditPool() {
        return (JDFAuditPool)this.appendElementN("AuditPool", 1, null);
    }

    public JDFAuditPool getAuditPool() {
        return this.getElementByClass(JDFAuditPool.class, 0, false);
    }

    public JDFCustomerInfo getCreateCustomerInfo() {
        return (JDFCustomerInfo)this.getCreateNiCi("CustomerInfo");
    }

    public JDFCustomerInfo appendCustomerInfo() {
        return (JDFCustomerInfo)this.appendNiCi("CustomerInfo");
    }

    public JDFCustomerInfo getCustomerInfo() {
        return (JDFCustomerInfo)this.getNiCi("CustomerInfo", false, null);
    }

    @Override
    public NodeIdentifier getIdentifier() {
        return new NodeIdentifier(this.getJobID(true), this.getJobPartID(false), this.getNodeInfoPartMapVector());
    }

    private KElement getNiCi(String elementName, boolean bInherit, String xPath) {
        KElement nici = this.getElement(elementName);
        JDFElement.EnumVersion eVer = this.getVersion(true);
        if (eVer == null || eVer.getValue() >= JDFElement.EnumVersion.Version_1_3.getValue() || nici == null) {
            VElement v = this.getResourceLinks(elementName, new JDFAttributeMap("Usage", "Input"), null);
            Object retLink = null;
            if (v == null || v.isEmpty()) {
                retLink = null;
            } else if (v.size() == 1) {
                retLink = (JDFResourceLink)v.get(0);
            } else {
                VString vString = this.getTypes();
                for (KElement e : v) {
                    JDFResourceLink rl = (JDFResourceLink)e;
                    JDFIntegerList combinedProcessIndex = rl.getCombinedProcessIndex();
                    if (combinedProcessIndex != null && vString != null && (vString == null || combinedProcessIndex.size() != vString.size())) continue;
                    retLink = rl;
                    break;
                }
                if (retLink == null) {
                    retLink = (JDFResourceLink)v.get(0);
                }
            }
            if (retLink != null) {
                KElement kElement = nici = ((JDFResourceLink)retLink).getPart(1) == null ? ((JDFResourceLink)retLink).getTarget() : ((JDFResourceLink)retLink).getLinkRoot();
            }
        }
        if (xPath != null) {
            if (nici instanceof JDFResource) {
                List<JDFResource> vLeaves = ((JDFResource)nici).getLeafArray(true);
                for (KElement kElement : vLeaves) {
                    if (!kElement.hasXPathNode(xPath)) continue;
                    return nici;
                }
            }
            KElement nici2 = nici;
            while (nici2 != null && !nici2.hasXPathNode(xPath)) {
                if (nici2 instanceof JDFResource && !((JDFResource)nici2).isResourceRoot()) {
                    nici2 = nici2.getParentNode_KElement();
                    continue;
                }
                nici2 = null;
                nici = null;
            }
        }
        if (nici != null || !bInherit) {
            return nici;
        }
        JDFNode parent = this.getParentJDF();
        if (parent != null) {
            return parent.getNiCi(elementName, bInherit, xPath);
        }
        JDFAncestorPool ap = this.getAncestorPool();
        if (ap != null) {
            return ap.getAncestorElement(elementName, null, xPath);
        }
        return null;
    }

    public JDFNodeInfo getCreateNodeInfo() {
        return (JDFNodeInfo)this.getCreateNiCi("NodeInfo");
    }

    private KElement getCreateNiCi(String s) {
        KElement nici = this.getNiCi(s, false, null);
        if (nici == null) {
            nici = this.appendNiCi(s);
        }
        return nici;
    }

    private KElement appendNiCi(String s) {
        KElement nici;
        JDFElement.EnumVersion eVer = this.getVersion(true);
        if (eVer == null || eVer.getValue() >= JDFElement.EnumVersion.Version_1_3.getValue()) {
            nici = this.addResource(s, JDFResourceLink.EnumUsage.Input);
        } else if (this.getNiCi(s, false, null) == null) {
            nici = this.appendElement(s);
        } else {
            throw new JDFException(s + " already exists");
        }
        return nici;
    }

    public JDFNodeInfo appendNodeInfo() {
        return (JDFNodeInfo)this.appendNiCi("NodeInfo");
    }

    public JDFNodeInfo appendNodeInfo(int combinedProcessIndex) {
        if (combinedProcessIndex < 0 || combinedProcessIndex >= this.getTypes().size()) {
            throw new JDFException("appendNodeInfo: appending ni for non existing ccombinedProcessIndex:" + combinedProcessIndex + " types=" + this.getTypes());
        }
        if (this.getNodeInfo(combinedProcessIndex) != null) {
            throw new JDFException("JDFNodeInfo.appendNodeInfo: NodeInfo already exists");
        }
        JDFNodeInfo ni = (JDFNodeInfo)this.addResource("NodeInfo", JDFResourceLink.EnumUsage.Input);
        JDFResourceLink rl = this.getLink((JDFResource)ni, null);
        rl.setCombinedProcessIndex(new JDFIntegerList(combinedProcessIndex));
        return ni;
    }

    public JDFNodeInfo getNodeInfo(int combinedProcessIndex) {
        if (combinedProcessIndex < 0 || combinedProcessIndex >= ContainerUtil.size(this.getTypes())) {
            if (combinedProcessIndex == 0) {
                return this.getNodeInfo();
            }
            return null;
        }
        JDFResourceLinkPool rlp = this.getResourceLinkPool();
        if (rlp == null) {
            return null;
        }
        JDFResourceLink rl = (JDFResourceLink)rlp.getChildWithMatchingAttribute("NodeInfoLink", "CombinedProcessIndex", null, String.valueOf(combinedProcessIndex), 0, true, AttributeInfo.EnumAttributeType.IntegerList);
        if (rl == null) {
            return null;
        }
        return (JDFNodeInfo)rl.getTarget();
    }

    public JDFNodeInfo getNodeInfo() {
        return (JDFNodeInfo)this.getNiCi("NodeInfo", false, null);
    }

    public JDFNodeInfo getInheritedNodeInfo(String xPath) {
        return (JDFNodeInfo)this.getNiCi("NodeInfo", true, xPath);
    }

    @Deprecated
    public JDFNodeInfo getInheritedNodeInfo() {
        return this.getInheritedNodeInfo(null);
    }

    public void removeNodeInfo() {
        this.removeNiCi("NodeInfo");
    }

    public void removeCustomerInfo() {
        this.removeNiCi("CustomerInfo");
    }

    private void removeNiCi(String elmName) {
        this.removeResource(elmName, 0);
        this.removeChild(elmName, null, 0);
    }

    @Deprecated
    public void removeNodeInfos() {
        JDFResource remRes;
        while (this.numNodeInfos() > 0 && (remRes = this.removeResource("NodeInfo", 0)) != null) {
        }
        VElement nodeInfoChilds = this.getChildElementVector("NodeInfo", null, null, false, Integer.MAX_VALUE, false);
        for (int i = 0; i < nodeInfoChilds.size(); ++i) {
            this.removeChild(nodeInfoChilds.elementAt(i));
        }
    }

    @Deprecated
    public void removeCustomerInfos() {
        JDFResource remRes;
        while (this.hasCustomerInfo() && (remRes = this.removeResource("CustomerInfo", 0)) != null) {
        }
        VElement nodeInfoChilds = this.getChildElementVector("CustomerInfo", null, null, false, Integer.MAX_VALUE, false);
        for (int i = 0; i < nodeInfoChilds.size(); ++i) {
            this.removeChild(nodeInfoChilds.elementAt(i));
        }
    }

    public void eraseUnlinkedResources() {
        UnLinkFinder uf = new UnLinkFinder();
        uf.eraseUnlinkedResources(this);
    }

    @Deprecated
    public void removeFromTypes(String type, int iSkip) {
        this.removeFromTypes(type, iSkip, false);
    }

    public void removeFromTypes(String type, int iSkip, boolean bRemoveEmptyLink) {
        VString v = this.getTypes();
        if (v == null) {
            return;
        }
        int posLast = -1;
        for (int n = 0; n <= iSkip; ++n) {
            int pos;
            posLast = pos = v.indexOf(type, posLast + 1);
            if (pos < 0) break;
        }
        if (posLast >= 0) {
            v.remove(posLast);
            this.setTypes(v);
            VElement vResLinks = this.getResourceLinks(new JDFAttributeMap("CombinedProcessIndex", "*"));
            if (vResLinks != null) {
                for (KElement e : vResLinks) {
                    int[] ii;
                    JDFResourceLink rl = (JDFResourceLink)e;
                    JDFIntegerList list = rl.getCombinedProcessIndex();
                    if (list == null) continue;
                    JDFIntegerList newList = new JDFIntegerList();
                    for (int i : ii = list.getIntArray()) {
                        if (i < posLast) {
                            newList.add(i);
                            continue;
                        }
                        if (i <= posLast) continue;
                        newList.add(i - 1);
                    }
                    if (newList.size() > 0) {
                        rl.setCombinedProcessIndex(newList);
                        continue;
                    }
                    if (!bRemoveEmptyLink) continue;
                    this.removeLink(rl, true);
                }
            }
        }
    }

    public JDFResource removeResource(String nodeName, int iSkip) {
        JDFResource kRet = null;
        JDFResourceLink rl = this.getLink(iSkip, nodeName, null, null);
        if (rl != null) {
            kRet = rl.getTarget();
            this.removeLink(rl, true);
        }
        return kRet;
    }

    @Deprecated
    public int numNodeInfos() {
        VElement poolChildren;
        int i = this.numChildElements("NodeInfo", null);
        JDFResourceLinkPool rlp = this.getResourceLinkPool();
        if (rlp != null && (poolChildren = rlp.getPoolChildren("NodeInfoLink", null, null)) != null) {
            i += poolChildren.size();
        }
        return i;
    }

    @Deprecated
    public int numCustomerInfos() {
        VElement poolChildren;
        int i = this.numChildElements("CustomerInfo", null);
        JDFResourceLinkPool rlp = this.getResourceLinkPool();
        if (rlp != null && (poolChildren = rlp.getPoolChildren("CustomerInfoLink", null, null)) != null) {
            i += poolChildren.size();
        }
        return i;
    }

    @Deprecated
    public boolean hasNodeInfo() {
        return this.getNodeInfo() != null;
    }

    @Deprecated
    public boolean hasCustomerInfo() {
        return this.getCustomerInfo() != null;
    }

    public JDFResourceLinkPool getCreateResourceLinkPool() {
        return (JDFResourceLinkPool)this.getCreateElement_KElement("ResourceLinkPool", null, 0);
    }

    public JDFResourceLinkPool appendResourceLinkPool() {
        return (JDFResourceLinkPool)this.appendElementN("ResourceLinkPool", 1, null);
    }

    public JDFResourceLinkPool getResourceLinkPool() {
        return this.getElementByClass(JDFResourceLinkPool.class, 0, false);
    }

    public JDFResourcePool getCreateResourcePool() {
        return (JDFResourcePool)this.getCreateElement_KElement("ResourcePool", null, 0);
    }

    public JDFResourcePool appendResourcePool() {
        return (JDFResourcePool)this.appendElementN("ResourcePool", 1, null);
    }

    public JDFResourcePool getResourcePool() {
        return this.getElementByClass(JDFResourcePool.class, 0, false);
    }

    public JDFStatusPool getCreateStatusPool() {
        this.setStatus(JDFElement.EnumNodeStatus.Pool);
        return (JDFStatusPool)this.getCreateElement_KElement("StatusPool", null, 0);
    }

    public JDFStatusPool appendStatusPool() {
        this.setStatus(JDFElement.EnumNodeStatus.Pool);
        return (JDFStatusPool)this.appendElementN("StatusPool", 1, null);
    }

    public JDFStatusPool getStatusPool() {
        return (JDFStatusPool)this.getElement("StatusPool", null, 0);
    }

    public JDFNode getChildJDFNode(String id, boolean bDirect) {
        JDFAttributeMap m = new JDFAttributeMap("ID", id);
        return (JDFNode)this.getTreeElement("JDF", null, m, bDirect, true);
    }

    public boolean hasVersion(boolean bInherit) {
        if (bInherit) {
            return this.hasAncestorAttribute("Version", null);
        }
        return this.hasAttribute("Version", null, false);
    }

    @Deprecated
    public void setVersion(String value) {
        this.setAttribute("Version", value, null);
    }

    @Override
    public JDFElement.EnumVersion getVersion(boolean bInherit) {
        String version = bInherit ? this.getAncestorAttribute("Version", null, null) : this.getAttribute("Version", null, null);
        return JDFElement.EnumVersion.getEnum(version);
    }

    public JDFResourceAudit cloneResourceToModify(JDFResourceLink resLink) {
        JDFResourceAudit resourceAudit = null;
        JDFResource r = resLink.getLinkRoot();
        if (r == null) {
            return null;
        }
        JDFResourcePool pool = r.getParentJDF().getResourcePool();
        JDFResource oldCopy = (JDFResource)pool.copyElement(r, null);
        if (oldCopy != null) {
            oldCopy.setLocked(true);
            String newID = r.newModifiedID();
            oldCopy.setID(newID);
            resourceAudit = this.prepareToModifyLink(resLink);
            JDFResourceLink resLinkAudit = (JDFResourceLink)resourceAudit.copyElement(resLink, null);
            if (resLinkAudit != null) {
                resLinkAudit.setrRef(newID);
            }
        }
        return resourceAudit;
    }

    public JDFResourceAudit prepareToModifyLink(JDFResourceLink resLink) {
        JDFAuditPool ap = this.getCreateAuditPool();
        JDFResourceAudit resourceAudit = ap.addResourceAudit(null);
        if (resourceAudit != null) {
            resourceAudit.setContentsModified(false);
            resourceAudit.updateLink(resLink);
        }
        return resourceAudit;
    }

    public VString getTypes() {
        if (!this.isTypesNode()) {
            return null;
        }
        String types = StringUtil.getNonEmpty(this.getAttribute("Types", null, null));
        return types == null ? null : new VString(types, null);
    }

    public Vector<EnumType> getEnumTypes() {
        Vector<EnumType> vs = null;
        VString types = this.getTypes();
        if (types != null) {
            Iterator typesIterator = types.iterator();
            while (typesIterator.hasNext()) {
                EnumType typ = EnumType.getEnum((String)typesIterator.next());
                if (typ == null) {
                    return null;
                }
                if (vs == null) {
                    vs = new Vector<EnumType>();
                }
                vs.add(typ);
            }
        }
        return vs;
    }

    public int getCombinedProcessIndex(EnumType typ, int start) {
        if (typ == null) {
            return -1;
        }
        return this.getCombinedProcessIndex(typ.getName(), start);
    }

    public int getCombinedProcessIndex(String typ, int start) {
        VString types = this.getTypes();
        if (types == null) {
            return -1;
        }
        return types.indexOf(typ, start);
    }

    public void addTypes(EnumType typ) {
        this.addTypes(typ, null, false);
    }

    public void addTypes(EnumType typ, EnumType combineType, boolean unique) {
        if (EnumType.Combined.equals((Object)combineType) || EnumType.ProcessGroup.equals((Object)combineType)) {
            this.ensureCombined(combineType);
        }
        if (!this.isTypesNode() || typ == null) {
            return;
        }
        this.appendAttribute("Types", typ.getName(), null, " ", unique);
    }

    public void ensureCombined(EnumType combineType) {
        boolean isCombined = this.isTypesNode();
        if (!isCombined && !this.isProduct()) {
            this.renameAttribute("Type", "Types");
        }
        this.setType(combineType);
    }

    public VString getAllTypes() {
        VString vs = new VString();
        String myType = this.getType();
        if (myType.equals("Product")) {
            vs = new VString("Product", null);
        } else if (myType.equals("Combined")) {
            vs = this.getTypes();
        } else if (myType.equals("ProcessGroup")) {
            VElement vNodes = this.getvJDFNode(null, null, true);
            VString vsTypes = this.getTypes();
            int nodeSize = vNodes.size();
            for (int i = 0; i < nodeSize; ++i) {
                JDFNode node = (JDFNode)vNodes.elementAt(i);
                VString allTypes = node.getAllTypes();
                if (allTypes == null) continue;
                vs.addAll(allTypes);
            }
            if (vsTypes != null) {
                vs.addAll(vsTypes);
            }
        } else {
            String type = myType;
            vs = new VString(type, null);
        }
        return vs;
    }

    public void setTypes(VString vCombiNodes) {
        EnumType type = EnumType.getEnum(this.getType());
        if (type != null && !EnumType.Combined.equals((Object)type) && !EnumType.ProcessGroup.equals((Object)type)) {
            throw new JDFException("Setting Types on illegal node Type:" + this.getType());
        }
        this.setAttribute("Types", vCombiNodes, (String)null);
    }

    public void setTypes(VString vCombiNodes, boolean isProcessGroup) {
        this.setType(isProcessGroup ? EnumType.ProcessGroup : EnumType.Combined);
        this.setTypes(vCombiNodes);
    }

    public VElement getLinksForCombinedProcessIndex(int combinedProcessIndex) {
        CombinedProcessLinkHelper h = new CombinedProcessLinkHelper();
        return h.getLinksForCombinedProcessIndex(combinedProcessIndex);
    }

    public VElement getLinksForType(EnumType type, int nType) {
        CombinedProcessLinkHelper combinedProcessLinkHelper = new CombinedProcessLinkHelper();
        combinedProcessLinkHelper.setNPos(nType);
        return combinedProcessLinkHelper.getLinksForType(type);
    }

    public EnumType getEnumType() {
        return EnumType.getEnum(this.getType());
    }

    public void insertTypeInTypes(EnumType type, int beforePos) {
        VString types = this.getTypes();
        if (types == null) {
            types = new VString();
        }
        int typeSize = types.size();
        if (beforePos < 0) {
            beforePos = typeSize + beforePos;
        }
        if (beforePos < 0) {
            beforePos = 0;
        }
        if (beforePos <= typeSize) {
            VElement vResLinks = this.getResourceLinks(null, new JDFAttributeMap("CombinedProcessIndex", ""), null);
            if (vResLinks != null) {
                for (int i = 0; i < vResLinks.size(); ++i) {
                    JDFResourceLink rl = (JDFResourceLink)vResLinks.elementAt(i);
                    int[] cpi = rl.getCombinedProcessIndex().getIntArray();
                    for (int j = 0; j < cpi.length; ++j) {
                        if (cpi[j] < beforePos) continue;
                        int n = j;
                        cpi[n] = cpi[n] + 1;
                    }
                    rl.setCombinedProcessIndex(new JDFIntegerList(cpi));
                }
            }
            types.insertElementAt(type.getName(), beforePos);
        } else {
            types.add(type.getName());
        }
        this.setTypes(types);
    }

    public VString getParentIds() {
        VString vs = new VString();
        if (this.getAncestorPool() != null) {
            VElement v = this.getAncestorPool().getPoolChildren(null);
            for (int i = 0; i < v.size(); ++i) {
                vs.add(((JDFAncestor)v.elementAt(i)).getNodeID());
            }
        }
        return vs;
    }

    @Deprecated
    public JDFNode mergeJDF(JDFNode toMerge, String urlMerge, EnumCleanUpMerge cleanPolicy, JDFResource.EnumAmountMerge amountPolicy) {
        return new JDFMerge(this).mergeJDF(toMerge, urlMerge, cleanPolicy, amountPolicy);
    }

    public boolean hasParent(JDFNode p) {
        VString vpa = p.getAncestorIDs();
        VString vParents = this.getParentIds();
        vParents.add(this.getID());
        if (vpa.size() == 0) {
            return false;
        }
        String id = vpa.elementAt(0);
        if (id.equals("")) {
            throw new JDFException("JDFNode.HasParent: no id???");
        }
        for (int i = 0; i < vParents.size(); ++i) {
            if (!id.equals(vParents.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public int getMinID() {
        VElement v = this.getChildrenByTagName(null, null, null, false, true, 0);
        v.add(this);
        int iMax = 0;
        VString vIDNames = new VString("ID SpawnID MergeID NewSpawnID", null);
        int idSize = vIDNames.size();
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            KElement jdfElem = v.item(i);
            for (int j = 0; j < idSize; ++j) {
                int iPos;
                int pos;
                String strID = jdfElem.getAttribute(vIDNames.get(j), null, null);
                if (strID == null) continue;
                if (strID.length() > 7) {
                    strID = strID.substring(strID.length() - 7);
                }
                if ((pos = StringUtil.find_last_not_of(strID, "0123456789")) == -1) continue;
                strID = strID.substring(pos + 1);
                strID = strID.trim();
                int len = strID.length();
                if (strID.equals("")) continue;
                for (iPos = 0; iPos < len && strID.charAt(iPos) == '0'; ++iPos) {
                }
                if (iPos > 0) {
                    strID = strID.substring(iPos);
                }
                if (strID.equals("")) continue;
                int iS = StringUtil.parseInt(strID, 0);
                if (iS > 1000000) {
                    iS %= 1000000;
                }
                iMax = iS > iMax ? iS : iMax;
            }
        }
        JDFNode.uniqueID(iMax);
        return iMax;
    }

    public int getMaxJobPartId(String idPrefix) {
        VElement v = this.getvJDFNode(null, null, false);
        int prefixSize = idPrefix.length();
        int iMax = -1;
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            int pos;
            JDFNode e = (JDFNode)v.elementAt(i);
            String s = e.getJobPartID(false);
            if (s.equals("") || s.substring(0, prefixSize).equals(idPrefix.substring(0, prefixSize))) continue;
            s = s.substring(prefixSize).trim();
            int len = s.length();
            for (pos = 0; pos < len && s.charAt(pos) == '0'; ++pos) {
            }
            if (pos > 0) {
                s = s.substring(s.length() - pos, s.length());
            }
            if (s.equals("")) continue;
            int parseInt = StringUtil.parseInt(s, 0);
            iMax = parseInt > iMax ? parseInt : iMax;
        }
        return iMax;
    }

    public JDFNode addJDFNode(String typ) {
        EnumType myType = EnumType.getEnum(this.getType());
        if (myType == null || !myType.equals((Object)EnumType.Product) && !myType.equals((Object)EnumType.ProcessGroup)) {
            throw new JDFException("JDFNode.addJDFNode adding JDF Node to invalid node type: Type = " + this.getType());
        }
        JDFNode p = (JDFNode)this.appendElement("JDF", null);
        if (typ != null && !typ.equals("")) {
            p.setType(typ, false);
        }
        if (EnumType.Product.equals((Object)myType) || EnumType.ProcessGroup.equals((Object)myType)) {
            this.removeAttribute("Types");
        }
        return p;
    }

    public JDFNode addJDFNode(EnumType typ) {
        JDFNode p = this.addJDFNode((String)null);
        p.setType(typ);
        return p;
    }

    @Deprecated
    public JDFNode addProcess(String prodName) {
        JDFNode p = this.addJDFNode(prodName);
        return p;
    }

    public JDFNode addProcessGroup(VString tasks) {
        JDFNode p = this.addJDFNode(EnumType.ProcessGroup);
        p.setType(EnumType.ProcessGroup.getName(), false);
        if (!StringUtil.isEmpty(tasks)) {
            p.setTypes(tasks);
        }
        return p;
    }

    public JDFNode addCombined(VString tasks) {
        JDFNode cNode = this.addJDFNode(EnumType.Combined);
        cNode.setTypes(tasks);
        return cNode;
    }

    public JDFNode addProduct() {
        if (!EnumType.getEnum(this.getType()).equals((Object)EnumType.Product)) {
            throw new JDFException("JDFNode.AddProduct adding Product to invalid node type: Type = " + this.getType());
        }
        JDFNode p = this.addJDFNode(EnumType.Product);
        return p;
    }

    @Deprecated
    public boolean removeCompleted() {
        VElement v = this.getCompleted();
        for (int i = 0; i < v.size(); ++i) {
            JDFNode pr = (JDFNode)((Vector)v).elementAt(i);
            pr.removeNode(false);
        }
        return true;
    }

    public VElement getCompleted() {
        JDFNode pr;
        VElement v = this.getvJDFNode(null, null, false);
        VElement v2 = new VElement();
        int size = v.size();
        for (int i = 0; i < size && (pr = (JDFNode)v.elementAt(i)) != null; ++i) {
            if (!JDFElement.EnumNodeStatus.Completed.equals((Object)pr.getStatus())) continue;
            v2.addElement(pr);
        }
        return v2;
    }

    public JDFResource getTargetResource(String id) {
        JDFResource r;
        KElement e;
        XMLDocUserData ud = this.getXMLDocUserData();
        if (ud != null && (e = ud.getTarget(id)) instanceof JDFResource) {
            return (JDFResource)e;
        }
        JDFResourcePool p = this.getResourcePool();
        if (p != null && (r = p.getResourceByID(id)) != null) {
            return r;
        }
        VElement v = this.getvJDFNode(null, null, true);
        for (int i = 0; i < v.size(); ++i) {
            JDFResource r2 = ((JDFNode)v.elementAt(i)).getTargetResource(id);
            if (r2 == null) continue;
            return r2;
        }
        return null;
    }

    public String getAncestorElementAttribute(String element, String attrib, String nameSpaceURI, String def) {
        if (StringUtil.getNonEmpty(attrib) == null) {
            return null;
        }
        if ("NodeInfo".equals(element) || "CustomerInfo".equals(element)) {
            String xpath = "@" + attrib;
            KElement e = this.getNiCi(element, true, xpath);
            return e == null ? null : e.getAttribute(attrib, nameSpaceURI, "");
        }
        JDFNode n = this;
        while (n != null) {
            KElement e = this.getElement(element, nameSpaceURI, 0);
            if (e != null && e.hasAttribute(attrib, nameSpaceURI, false)) {
                return e.getAttribute(attrib, nameSpaceURI, null);
            }
            n = this.getParentJDF();
        }
        JDFNode root = this.getJDFRoot();
        if (root == null) {
            return def;
        }
        JDFAncestorPool ancestorPool = root.getAncestorPool();
        if (ancestorPool == null) {
            return def;
        }
        return ancestorPool.getAncestorElementAttribute(element, attrib, nameSpaceURI, def);
    }

    public boolean hasAncestorElementAttribute(String element, String attrib, String nameSpaceURI) {
        return this.getAncestorElementAttribute(element, attrib, nameSpaceURI, null) != null;
    }

    public VElement getIntents() {
        VElement velem = null;
        JDFResourceLinkPool rlp = this.getResourceLinkPool();
        if (rlp != null) {
            JDFAttributeMap mALink = new JDFAttributeMap("Usage", "Input");
            JDFAttributeMap mARes = new JDFAttributeMap("Class", "Intent");
            velem = rlp.getLinkedResources(null, mALink, mARes, false, null);
        }
        return velem;
    }

    public VElement getUnknownLinkVector(VString vInNameSpace, int nMax) {
        boolean bAllNS;
        Vector vUnknown = null;
        VString names = this.linkNames();
        VElement ve = this.getResourceLinks(null, null, null);
        boolean bl = bAllNS = vInNameSpace == null || vInNameSpace.isEmpty();
        if (vInNameSpace != null) {
            for (int j = 0; j < vInNameSpace.size(); ++j) {
                if (!vInNameSpace.elementAt(j).equals(" ")) continue;
                vInNameSpace.setElementAt("", j);
            }
        }
        if (ve != null) {
            for (JDFResourceLink rl : ve) {
                String nodename = rl.getNodeName().substring(0, rl.getNodeName().length() - 4);
                if (!bAllNS && (vInNameSpace == null || !vInNameSpace.contains(JDFNode.xmlnsPrefix(nodename))) || names.contains(nodename)) continue;
                if (vUnknown == null) {
                    vUnknown = new VElement();
                }
                vUnknown.add(rl);
                if (vUnknown.size() < nMax) continue;
                break;
            }
        }
        return vUnknown;
    }

    public void setCategory(String value) {
        this.setAttribute("Category", value);
    }

    public String getCategory() {
        return this.getAttribute("Category");
    }

    @Deprecated
    public String getCategory(boolean bInherit) {
        if (bInherit) {
            return this.getAncestorAttribute("Category", null, "");
        }
        return this.getAttribute("Category");
    }

    public void setICSVersions(VString value) {
        this.setAttribute("ICSVersions", value, (String)null);
    }

    public VString setICSVersions(ICSVersion ... versions) {
        this.setAttribute("ICSVersions", null);
        for (ICSVersion v : versions) {
            this.appendICSVersion(v);
        }
        return this.getICSVersions(true);
    }

    public String appendICSVersion(ICSVersion v) {
        return this.appendAttribute("ICSVersions", v == null ? null : v.toString(), true);
    }

    public VString getICSVersions(boolean bInherit) {
        if (bInherit) {
            return new VString(this.getAncestorAttribute("ICSVersions", null, ""), null);
        }
        return new VString(this.getAttribute("ICSVersions"), null);
    }

    public void setMaxVersion(JDFElement.EnumVersion enumVer) {
        this.setAttribute("MaxVersion", enumVer == null ? null : enumVer.getName(), null);
    }

    @Deprecated
    public void setMaxVersion(String value) {
        this.setAttribute("MaxVersion", value);
    }

    @Override
    public JDFElement.EnumVersion getMaxVersion(boolean bInherit) {
        String version;
        String string = version = bInherit ? this.getAncestorAttribute("MaxVersion", null, null) : this.getAttribute("MaxVersion", null, null);
        if (version == null) {
            return this.getVersion(bInherit);
        }
        return JDFElement.EnumVersion.getEnum(version);
    }

    public void setNamedFeatures(VString value) {
        this.setAttribute("NamedFeatures", value, (String)null);
    }

    public VString getNamedFeatures() {
        return new VString(this.getAttribute("NamedFeatures", null, null), null);
    }

    public void setRelatedJobID(String value) {
        this.setAttribute("RelatedJobID", value);
    }

    public String getRelatedJobID(boolean bInherit) {
        if (bInherit) {
            return this.getAncestorAttribute("RelatedJobID", null, "");
        }
        return this.getAttribute("RelatedJobID");
    }

    public void setRelatedJobPartID(String value) {
        this.setAttribute("RelatedJobPartID", value);
    }

    public String getRelatedJobPartID(boolean bInherit) {
        if (bInherit) {
            return this.getAncestorAttribute("RelatedJobPartID", null, "");
        }
        return this.getAttribute("RelatedJobPartID");
    }

    public void setStatusDetails(String value) {
        this.setAttribute("StatusDetails", value);
    }

    public String getStatusDetails() {
        return this.getAttribute("StatusDetails");
    }

    @Deprecated
    public String getStatusDetails(boolean bInherit) {
        if (bInherit) {
            return this.getAncestorAttribute("StatusDetails", null, "");
        }
        return this.getAttribute("StatusDetails");
    }

    public void setTemplate(boolean value) {
        this.setAttribute("Template", value, null);
    }

    public boolean getTemplate() {
        return this.getBoolAttribute("Template", null, false);
    }

    public void setTemplateID(String value) {
        this.setAttribute("TemplateID", value);
    }

    public String getTemplateID(boolean bInherit) {
        if (bInherit) {
            return this.getAncestorAttribute("TemplateID", null, "");
        }
        return this.getAttribute("TemplateID");
    }

    public void setTemplateVersion(String value) {
        this.setAttribute("TemplateVersion", value);
    }

    public String getTemplateVersion(boolean bInherit) {
        if (bInherit) {
            return this.getAncestorAttribute("TemplateVersion", null, "");
        }
        return this.getAttribute("TemplateVersion");
    }

    public String getWorkStepID(JDFAttributeMap map) {
        JDFNodeInfo ni = this.getNodeInfo();
        if (ni == null) {
            return this.getJobPartID(false);
        }
        if ((ni = (JDFNodeInfo)ni.getPartition(map, null)) == null) {
            return this.getJobPartID(false);
        }
        String wsID = ni.getWorkStepID();
        return JDFNode.isWildCard(wsID) ? this.getJobPartID(false) : wsID;
    }

    @Deprecated
    public JDFDuration getNodeInfoCleanupDuration() {
        return this.getInheritedNodeInfo(null).getCleanupDuration();
    }

    @Deprecated
    public JDFAutoMISDetails.EnumCostType getNodeInfoCostType() {
        JDFNodeInfo inheritedNodeInfo = this.getInheritedNodeInfo(null);
        if (inheritedNodeInfo == null) {
            return null;
        }
        JDFMISDetails details = inheritedNodeInfo.getMISDetails();
        if (details == null) {
            return null;
        }
        return details.getCostType();
    }

    @Deprecated
    public JDFAutoNodeInfo.EnumDueLevel getNodeInfoDueLevel() {
        JDFNodeInfo inheritedNodeInfo = this.getInheritedNodeInfo(null);
        if (inheritedNodeInfo == null) {
            return null;
        }
        return inheritedNodeInfo.getDueLevel();
    }

    @Deprecated
    public JDFDate getNodeInfoEnd() {
        JDFNodeInfo inheritedNodeInfo = this.getInheritedNodeInfo(null);
        if (inheritedNodeInfo == null) {
            return null;
        }
        return inheritedNodeInfo.getEnd();
    }

    @Deprecated
    public JDFDate getNodeInfoFirstEnd() {
        JDFNodeInfo inheritedNodeInfo = this.getInheritedNodeInfo(null);
        if (inheritedNodeInfo == null) {
            return null;
        }
        return inheritedNodeInfo.getFirstEnd();
    }

    @Deprecated
    public JDFDate getNodeInfoFirstStart() {
        JDFNodeInfo inheritedNodeInfo = this.getInheritedNodeInfo(null);
        if (inheritedNodeInfo == null) {
            return null;
        }
        return inheritedNodeInfo.getFirstStart();
    }

    @Deprecated
    public JDFXYPair getNodeInfoIPPVersion() {
        JDFNodeInfo inheritedNodeInfo = this.getInheritedNodeInfo(null);
        if (inheritedNodeInfo == null) {
            return null;
        }
        return inheritedNodeInfo.getIPPVersion();
    }

    @Deprecated
    public int getNodeInfoJobPriority() {
        JDFNodeInfo inheritedNodeInfo = this.getInheritedNodeInfo(null);
        if (inheritedNodeInfo == null) {
            return 0;
        }
        return inheritedNodeInfo.getJobPriority();
    }

    @Deprecated
    public JDFDate getNodeInfoLastEnd() {
        JDFNodeInfo inheritedNodeInfo = this.getInheritedNodeInfo(null);
        if (inheritedNodeInfo == null) {
            return null;
        }
        return inheritedNodeInfo.getLastEnd();
    }

    @Deprecated
    public JDFDate getNodeInfoLastStart() {
        JDFNodeInfo inheritedNodeInfo = this.getInheritedNodeInfo(null);
        if (inheritedNodeInfo == null) {
            return null;
        }
        return inheritedNodeInfo.getLastStart();
    }

    @Deprecated
    public String getNodeInfoNaturalLang() {
        JDFNodeInfo inheritedNodeInfo = this.getInheritedNodeInfo(null);
        if (inheritedNodeInfo == null) {
            return "";
        }
        return inheritedNodeInfo.getNaturalLang();
    }

    @Deprecated
    public String getNodeInfoRoute() {
        JDFNodeInfo inheritedNodeInfo = this.getInheritedNodeInfo(null);
        if (inheritedNodeInfo == null) {
            return "";
        }
        return inheritedNodeInfo.getRoute();
    }

    @Deprecated
    public JDFDuration getNodeInfoSetupDuration() {
        JDFNodeInfo inheritedNodeInfo = this.getInheritedNodeInfo(null);
        if (inheritedNodeInfo == null) {
            return null;
        }
        return inheritedNodeInfo.getSetupDuration();
    }

    @Deprecated
    public JDFDate getNodeInfoStart() {
        JDFNodeInfo inheritedNodeInfo = this.getInheritedNodeInfo(null);
        if (inheritedNodeInfo == null) {
            return null;
        }
        return inheritedNodeInfo.getStart();
    }

    @Deprecated
    public String getNodeInfoTargetRoute() {
        JDFNodeInfo inheritedNodeInfo = this.getInheritedNodeInfo(null);
        if (inheritedNodeInfo == null) {
            return "";
        }
        return inheritedNodeInfo.getTargetRoute();
    }

    @Deprecated
    public JDFDuration getNodeInfoTotalDuration() {
        JDFNodeInfo inheritedNodeInfo = this.getInheritedNodeInfo(null);
        if (inheritedNodeInfo == null) {
            return null;
        }
        return inheritedNodeInfo.getTotalDuration();
    }

    @Deprecated
    public JDFAutoMISDetails.EnumWorkType getNodeInfoWorkType() {
        JDFNodeInfo inheritedNodeInfo = this.getInheritedNodeInfo(null);
        if (inheritedNodeInfo == null) {
            return null;
        }
        JDFMISDetails details = inheritedNodeInfo.getMISDetails();
        if (details == null) {
            return null;
        }
        return details.getWorkType();
    }

    @Deprecated
    public String getNodeInfoWorkTypeDetails() {
        JDFNodeInfo inheritedNodeInfo = this.getInheritedNodeInfo(null);
        if (inheritedNodeInfo == null) {
            return null;
        }
        JDFMISDetails details = inheritedNodeInfo.getMISDetails();
        if (details == null) {
            return null;
        }
        return details.getWorkTypeDetails();
    }

    @Deprecated
    public JDFBusinessInfo getNodeInfoBusinessInfo() {
        JDFNodeInfo inheritedNodeInfo = this.getInheritedNodeInfo(null);
        if (inheritedNodeInfo == null) {
            return null;
        }
        return inheritedNodeInfo.getBusinessInfo();
    }

    @Deprecated
    public JDFEmployee getNodeInfoEmployee() {
        JDFNodeInfo inheritedNodeInfo = this.getInheritedNodeInfo(null);
        if (inheritedNodeInfo == null) {
            return null;
        }
        return inheritedNodeInfo.getEmployee();
    }

    @Deprecated
    public JDFJMF getNodeInfoJMF(int iSkip) {
        JDFNodeInfo inheritedNodeInfo = this.getInheritedNodeInfo(null);
        if (inheritedNodeInfo == null) {
            return null;
        }
        return inheritedNodeInfo.getJMF(iSkip);
    }

    @Deprecated
    public JDFNotificationFilter getNodeInfoNotificationFilter(int iSkip) {
        JDFNodeInfo inheritedNodeInfo = this.getInheritedNodeInfo(null);
        if (inheritedNodeInfo == null) {
            return null;
        }
        return inheritedNodeInfo.getNotificationFilter(iSkip);
    }

    public JDFCustomerInfo getInheritedCustomerInfo(String xPath) {
        return (JDFCustomerInfo)this.getNiCi("CustomerInfo", true, xPath);
    }

    @Deprecated
    public JDFCustomerInfo getInheritedCustomerInfo() {
        return this.getInheritedCustomerInfo(null);
    }

    @Deprecated
    public String getCustomerInfoBillingCode() {
        JDFCustomerInfo inheritedCustomerInfo = this.getInheritedCustomerInfo();
        if (inheritedCustomerInfo == null) {
            return "";
        }
        return inheritedCustomerInfo.getBillingCode();
    }

    @Deprecated
    public String getCustomerInfoCustomerID() {
        JDFCustomerInfo inheritedCustomerInfo = this.getInheritedCustomerInfo();
        if (inheritedCustomerInfo == null) {
            return "";
        }
        return inheritedCustomerInfo.getCustomerID();
    }

    @Deprecated
    public String getCustomerInfoCustomerJobName() {
        JDFCustomerInfo inheritedCustomerInfo = this.getInheritedCustomerInfo();
        if (inheritedCustomerInfo == null) {
            return "";
        }
        return inheritedCustomerInfo.getCustomerJobName();
    }

    @Deprecated
    public String getCustomerInfoCustomerOrderID() {
        JDFCustomerInfo inheritedCustomerInfo = this.getInheritedCustomerInfo();
        if (inheritedCustomerInfo == null) {
            return "";
        }
        return inheritedCustomerInfo.getCustomerOrderID();
    }

    @Deprecated
    public String getCustomerInfoCustomerProjectID() {
        JDFCustomerInfo inheritedCustomerInfo = this.getInheritedCustomerInfo();
        if (inheritedCustomerInfo == null) {
            return "";
        }
        return inheritedCustomerInfo.getCustomerProjectID();
    }

    @Deprecated
    public JDFCompany getCustomerInfoCompany() {
        JDFCustomerInfo inheritedCustomerInfo = this.getInheritedCustomerInfo();
        if (inheritedCustomerInfo == null) {
            return null;
        }
        return inheritedCustomerInfo.getCompany();
    }

    @Deprecated
    public JDFContact getCustomerInfoContact(int iSkip) {
        JDFCustomerInfo inheritedCustomerInfo = this.getInheritedCustomerInfo();
        if (inheritedCustomerInfo == null) {
            return null;
        }
        return inheritedCustomerInfo.getContact(iSkip);
    }

    @Deprecated
    public JDFCustomerMessage getCustomerInfoCustomerMessage(int iSkip) {
        JDFCustomerInfo inheritedCustomerInfo = this.getInheritedCustomerInfo();
        if (inheritedCustomerInfo == null) {
            return null;
        }
        return inheritedCustomerInfo.getCustomerMessage(iSkip);
    }

    public boolean isSuccessor(JDFNode proc) {
        boolean isSuccessor = false;
        if (this.isProcessNode() && proc.isProcessNode()) {
            VString vsInputResIDs = this.getResourceIDs(true);
            VString vsOutputResIDs = proc.getResourceIDs(false);
            for (int i = 0; i < vsInputResIDs.size() && !isSuccessor; ++i) {
                isSuccessor = vsOutputResIDs.contains(vsInputResIDs.get(i));
            }
        }
        return isSuccessor;
    }

    public VString getResourceIDs(boolean isInput) {
        VElement vInOutLinks;
        VString vsLinks = new VString();
        JDFResourceLinkPool linkPool = this.getResourceLinkPool();
        if (linkPool != null && (vInOutLinks = linkPool.getInOutLinks(isInput ? JDFResourceLink.EnumUsage.Input : JDFResourceLink.EnumUsage.Output, true, null, null)) != null) {
            int nInOutLinks = vInOutLinks.size();
            for (int i = 0; i < nInOutLinks; ++i) {
                JDFResourceLink link = (JDFResourceLink)vInOutLinks.get(i);
                vsLinks.add(link.getrRef());
            }
        }
        return vsLinks;
    }

    @Deprecated
    public VJDFAttributeMap getExecutablePartitions(JDFResourceLink link, JDFResource res, JDFResource.EnumResStatus minStatus) {
        JDFResource resLocal = res;
        if (resLocal != null) {
            resLocal = null;
        }
        return this.getExecutablePartitions(link, minStatus);
    }

    @Deprecated
    public VJDFAttributeMap getExecutablePartitions(JDFResourceLink link, JDFResource.EnumResStatus minStatus) {
        return this.getExecutablePartitions(link, minStatus, true);
    }

    public VJDFAttributeMap getExecutablePartitions(JDFResourceLink link, JDFResource.EnumResStatus minStatus, boolean bCheckNodeStatus) {
        VJDFAttributeMap vp = new VJDFAttributeMap();
        if (link == null) {
            return null;
        }
        VElement v = link.getTargetVector(0);
        for (int i = 0; i < v.size(); ++i) {
            JDFResource res = (JDFResource)v.elementAt(i);
            new ExecCheck().addExecutablePartitions(link, res, res.getPartIDKeys(), vp, minStatus, bCheckNodeStatus);
        }
        vp.unify();
        return vp;
    }

    @Deprecated
    public JDFNode[] getProcessNodes() {
        VElement vJDFNodes = this.getvJDFNode(null, null, false);
        Vector<JDFNode> vProcessNodes = new Vector<JDFNode>();
        Object[] processNodes = null;
        for (int i = 0; i < vJDFNodes.size(); ++i) {
            JDFNode jdfNode = (JDFNode)((Vector)vJDFNodes).elementAt(i);
            if (!jdfNode.isProcessNode()) continue;
            vProcessNodes.add(jdfNode);
        }
        processNodes = new JDFNode[vProcessNodes.size()];
        vProcessNodes.copyInto(processNodes);
        return processNodes;
    }

    public boolean isProcessNode() {
        EnumType typ = this.getEnumType();
        return !this.hasChildElement("JDF", null) && !EnumType.Product.equals((Object)typ);
    }

    public JDFResource addInternalPipe(String resourceName, int indexOutput, int indexInput) {
        if (EnumType.getEnum(this.getType()) != EnumType.Combined) {
            throw new JDFException("JDFNode.addInternalPipe: adding pipe to node that is not combined " + this.getType());
        }
        JDFResource r = this.addResource(resourceName, null, null, null, null, null, null);
        r.setPipeProtocol("Internal");
        JDFResourceLink rl = this.linkResource(r, JDFResourceLink.EnumUsage.Input, null);
        rl.setPipeProtocol("Internal");
        rl.setCombinedProcessIndex(new JDFIntegerList(indexInput));
        rl = this.linkResource(r, JDFResourceLink.EnumUsage.Output, null);
        rl.setPipeProtocol("Internal");
        rl.setCombinedProcessIndex(new JDFIntegerList(indexOutput));
        return r;
    }

    public VString getPartIDKeys(JDFAttributeMap partMap) {
        VString matchingPartIDKeys = new VString();
        if (partMap != null && partMap.size() > 1) {
            JDFResourceLinkPool resourceLinkPool = this.getResourceLinkPool();
            if (resourceLinkPool != null) {
                VElement linkedResources = resourceLinkPool.getLinkedResources(null, null, null, false, null);
                int linkedResourcesSize = linkedResources.size();
                for (int i = 0; i < linkedResourcesSize; ++i) {
                    JDFResource resource = (JDFResource)linkedResources.elementAt(i);
                    VString partIDKeys = resource.getPartIDKeys();
                    if (partIDKeys.size() < partMap.size() || !partIDKeys.containsAll(partMap.getKeyList())) continue;
                    matchingPartIDKeys = partIDKeys;
                    break;
                }
            }
        } else if (partMap != null) {
            matchingPartIDKeys = partMap.getKeys();
        }
        if (matchingPartIDKeys.isEmpty()) {
            JDFResource r;
            Vector vRes = null;
            JDFResourceLinkPool rp = this.getResourceLinkPool();
            if (rp != null && (vRes = rp.getInOutLinks(JDFResourceLink.EnumUsage.Output, true, null, null)) != null) {
                for (int i = 0; i < vRes.size(); ++i) {
                    JDFResourceLink rl = (JDFResourceLink)((VElement)vRes).get(i);
                    vRes.setElementAt(rl.getLinkRoot(), i);
                }
            }
            if (vRes != null && vRes.size() > 0 && (r = (JDFResource)((VElement)vRes).elementAt(0)) != null) {
                JDFResource resRoot = r.getResourceRoot();
                matchingPartIDKeys = resRoot.getPartIDKeys();
            }
        }
        return matchingPartIDKeys;
    }

    public VElement prepareNodeInfo(VJDFAttributeMap vSpawnParts) {
        JDFNodeInfo ni = this.getCreateNodeInfo();
        VElement vni = new VElement();
        if (ni.hasAttribute("Class", null, false)) {
            JDFAttributeMap spawnPart = new JDFAttributeMap();
            if (vSpawnParts != null && vSpawnParts.size() > 0) {
                for (int i = 0; i < vSpawnParts.size(); ++i) {
                    if (vSpawnParts.elementAt(i).size() <= spawnPart.size()) continue;
                    spawnPart = vSpawnParts.elementAt(i);
                }
                if (!JDFElement.EnumNodeStatus.Part.equals((Object)this.getStatus())) {
                    ni.setAttribute("NodeStatus", this.getAttribute("Status"));
                    this.setStatus(JDFElement.EnumNodeStatus.Part);
                }
                VString partVector = this.getPartIDKeys(spawnPart);
                for (int i = 0; i < vSpawnParts.size(); ++i) {
                    JDFAttributeMap partMap = vSpawnParts.elementAt(i);
                    VElement v = ni.getPartitionVector(partMap, JDFResource.EnumPartUsage.Explicit);
                    if (v != null && v.size() > 0) {
                        vni.addAll(v);
                        continue;
                    }
                    JDFNodeInfo niLeaf = (JDFNodeInfo)ni.getCreatePartition(partMap, partVector);
                    niLeaf.setAttribute("NodeStatus", "Waiting");
                    vni.add(niLeaf);
                }
            } else {
                vni.add(ni);
            }
        } else {
            vni.add(ni);
        }
        vni.unify();
        return vni;
    }

    @Deprecated
    public VElement getLinks(String linkName, JDFAttributeMap mLinkAtt, String linkNS) {
        return this.getResourceLinks(linkName, mLinkAtt, linkNS);
    }

    public VElement getResourceLinks(String linkName, JDFAttributeMap mLinkAtt, String linkNS) {
        JDFResourceLinkPool rlp = this.getResourceLinkPool();
        if (rlp == null) {
            return null;
        }
        if (linkName != null && !((String)linkName).endsWith("Link")) {
            linkName = (String)linkName + "Link";
        }
        return rlp.getPoolChildren((String)linkName, mLinkAtt, linkNS);
    }

    public JDFResourceLink getLink(int index, String linkName, JDFAttributeMap mLinkAtt, String linkNS) {
        JDFResourceLinkPool rlp = this.getResourceLinkPool();
        if (rlp == null) {
            return null;
        }
        if (linkName != null && !((String)linkName).endsWith("Link")) {
            linkName = (String)linkName + "Link";
        }
        return rlp.getPoolChild(index, (String)linkName, mLinkAtt, linkNS);
    }

    @Deprecated
    public VElement getLinks(String linkName, String nameSpaceURI) {
        JDFAttributeMap m = new JDFAttributeMap("rRef", this.getID());
        return this.getDocRoot().getChildrenByTagName(linkName, nameSpaceURI, m, false, false, 0);
    }

    @Override
    public void sortChildren() {
        super.sortChildren();
        JDFResourcePool rp = this.getResourcePool();
        if (rp != null) {
            rp.sortChildren();
        }
        VElement vNode = this.getvJDFNode(null, null, true);
        for (int i = 0; i < vNode.size(); ++i) {
            vNode.item(i).sortChildren();
        }
    }

    public VElement getMatchingNodes(NodeIdentifier ni) {
        VElement v = this.getvJDFNode(null, null, false);
        if (ni == null) {
            return v;
        }
        if (v != null) {
            int siz = v.size();
            for (int i = siz - 1; i >= 0; --i) {
                JDFNode n = (JDFNode)v.get(i);
                if (n.getIdentifier().matches(ni)) continue;
                v.remove(i);
                --siz;
            }
            return siz == 0 ? null : v;
        }
        return null;
    }

    public void linkOutputs(JDFNode thePreviousNode) {
        if (thePreviousNode == null) {
            return;
        }
        JDFResourceLinkPool resourceLinkPool = thePreviousNode.getResourceLinkPool();
        if (resourceLinkPool == null) {
            return;
        }
        VElement v = resourceLinkPool.getInOutLinks(JDFResourceLink.EnumUsage.Output, true, null, null);
        JDFResourceLinkPool rlp = this.getCreateResourceLinkPool();
        for (int i = 0; i < v.size(); ++i) {
            JDFResourceLink rl0 = (JDFResourceLink)v.elementAt(i);
            JDFResourceLink rl = (JDFResourceLink)rlp.getChildWithAttribute(null, "rRef", null, rl0.getrRef(), 0, true);
            if (rl != null) continue;
            JDFResource r = rl0.getLinkRoot();
            rl = this.linkResource(r, JDFResourceLink.EnumUsage.Input, rl0.getEnumProcessUsage());
            rl.removeAttribute("CombinedProcessIndex");
        }
    }

    public void synchParentAmounts() {
        JDFNode parent = this.getParentJDF();
        if (parent == null) {
            return;
        }
        JDFResourceLinkPool parentPool = parent.getResourceLinkPool();
        JDFResourceLinkPool linkPool = this.getResourceLinkPool();
        if (parentPool == null || linkPool == null) {
            return;
        }
        VElement links = linkPool.getPoolChildren(null, null, null);
        if (links == null) {
            return;
        }
        for (int i = 0; i < links.size(); ++i) {
            JDFResourceLink link = (JDFResourceLink)links.get(i);
            JDFResourceLink parentLink = (JDFResourceLink)parentPool.getChildWithAttribute(link.getLocalName(), "rRef", null, link.getrRef(), 0, true);
            if (parentLink == null) continue;
            VJDFAttributeMap vParts = link.getPartMapVector();
            if (vParts == null) {
                vParts = new VJDFAttributeMap();
                vParts.add(null);
            }
            for (int j = 0; j < vParts.size(); ++j) {
                JDFAmountPool amountPool = link.getAmountPool();
                if (amountPool != null) {
                    JDFAmountPool parentAmountPool = parentLink.getCreateAmountPool();
                    VElement parts = amountPool.getMatchingPartAmountVector(vParts.elementAt(j));
                    if (parts == null) continue;
                    int pSiz = parts.size();
                    for (int k = 0; k < pSiz; ++k) {
                        JDFPartAmount pa = (JDFPartAmount)parts.elementAt(k);
                        if (!pa.hasAttribute("ActualAmount")) continue;
                        VJDFAttributeMap vPAMap = pa.getPartMapVector();
                        JDFPartAmount parentPA = parentAmountPool.getCreatePartAmount(vPAMap);
                        parentPA.copyAttribute("ActualAmount", pa, null, null, null);
                    }
                    continue;
                }
                parentLink.copyAttribute("ActualAmount", link, null, null, null);
            }
        }
    }

    private void ensureCreated() {
        JDFAuditPool ap = this.getCreateAuditPool();
        ap.ensureCreated();
    }

    public void toGrayBox(boolean bExpand) {
        EnumType t = this.getEnumType();
        String typeString = this.getType();
        if (EnumType.ProcessGroup.equals((Object)t) || EnumType.Product.equals((Object)t)) {
            return;
        }
        VString types = null;
        if (!bExpand && !EnumType.Combined.equals((Object)t)) {
            this.renameAttribute("Type", "Types", null, null);
        } else {
            types = this.getTypes();
        }
        this.setType(EnumType.ProcessGroup);
        if (bExpand) {
            JDFNode child = this.addJDFNode(typeString);
            String jobPart = this.getJobPartID(false);
            child.setJobPartID(jobPart);
            this.setJobPartID("pg." + jobPart);
            child.copyElement(this.getResourceLinkPool(), null);
            if (types != null) {
                child.setTypes(types);
            }
            JDFAuditPool ap = child.getCreateAuditPool();
            ap.ensureCreated();
            JDFCreated c = (JDFCreated)ap.getAudit(0, JDFAudit.EnumAuditType.Created, null, null);
            if (c == null) {
                c = ap.addCreated(null, null);
            }
            c.setDescriptiveName("automatically generated by toGrayBox");
        }
    }

    @Override
    public void setIdentifier(NodeIdentifier ni) {
        if (ni == null) {
            ni = new NodeIdentifier();
        }
        this.setJobID(ni.getJobID());
        this.setJobPartID(ni.getJobPartID());
        this.setPartMapVector(ni.getPartMapVector());
    }

    @Override
    public void setURL(String url) {
        this.setCommentURL(url);
    }

    @Override
    public String getURL() {
        return this.getCommentURL();
    }

    @Override
    public String getUserFileName() {
        return null;
    }

    @Override
    public void setVersion(JDFElement.EnumVersion enumVer) {
        super.setVersion(enumVer);
        JDFElement.EnumVersion maxVersion = this.getMaxVersion(true);
        if (EnumUtil.aLessEqualsThanB(maxVersion, enumVer)) {
            this.setMaxVersion(enumVer);
        }
    }

    public static JDFNode parseFile(File file) {
        JDFDoc doc = JDFDoc.parseFile(file);
        return doc == null ? null : doc.getJDFRoot();
    }

    public static JDFNode parseFile(String fileName) {
        JDFDoc doc = JDFDoc.parseFile(fileName);
        return doc == null ? null : doc.getJDFRoot();
    }

    public static JDFNode parseStream(InputStream is) {
        JDFDoc doc = JDFDoc.parseStream(is);
        return doc == null ? null : doc.getJDFRoot();
    }

    public static JDFNode createRoot() {
        return new JDFDoc("JDF").getJDFRoot();
    }

    public JDFNode getJobPart(String jobPartID) {
        return this.getJobPart(jobPartID, null);
    }

    static {
        JDFNode.atrInfoTable_abstract[0] = new AtrInfoTable("Activation", 0x33333333L, AttributeInfo.EnumAttributeType.enumeration, EnumActivation.getEnum(0), null);
        JDFNode.atrInfoTable_abstract[1] = new AtrInfoTable("Category", 0x33333311L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFNode.atrInfoTable_abstract[2] = new AtrInfoTable("ICSVersions", 0x33333311L, AttributeInfo.EnumAttributeType.NMTOKENS, null, null);
        JDFNode.atrInfoTable_abstract[3] = new AtrInfoTable("ID", 0x22222222L, AttributeInfo.EnumAttributeType.ID, null, null);
        JDFNode.atrInfoTable_abstract[4] = new AtrInfoTable("JobID", 0x33333333L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFNode.atrInfoTable_abstract[5] = new AtrInfoTable("JobPartID", 0x33333333L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFNode.atrInfoTable_abstract[6] = new AtrInfoTable("MaxVersion", 0x33333311L, AttributeInfo.EnumAttributeType.JDFJMFVersion, null, null);
        JDFNode.atrInfoTable_abstract[7] = new AtrInfoTable("NamedFeatures", 0x33333311L, AttributeInfo.EnumAttributeType.NMTOKENS, null, null);
        JDFNode.atrInfoTable_abstract[8] = new AtrInfoTable("ProjectID", 0x33333331L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFNode.atrInfoTable_abstract[9] = new AtrInfoTable("RelatedJobID", 0x33333311L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFNode.atrInfoTable_abstract[10] = new AtrInfoTable("RelatedJobPartID", 0x33333311L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFNode.atrInfoTable_abstract[11] = new AtrInfoTable("SpawnID", 0x33333331L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFNode.atrInfoTable_abstract[12] = new AtrInfoTable("Status", 0x22222222L, AttributeInfo.EnumAttributeType.enumeration, JDFElement.EnumNodeStatus.getEnum(0), null);
        JDFNode.atrInfoTable_abstract[13] = new AtrInfoTable("StatusDetails", 0x33333311L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFNode.atrInfoTable_abstract[14] = new AtrInfoTable("Template", 0x33333311L, AttributeInfo.EnumAttributeType.boolean_, null, "false");
        JDFNode.atrInfoTable_abstract[15] = new AtrInfoTable("TemplateID", 0x33333311L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFNode.atrInfoTable_abstract[16] = new AtrInfoTable("TemplateVersion", 0x33333311L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFNode.atrInfoTable_abstract[17] = new AtrInfoTable("Type", 0x22222222L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFNode.atrInfoTable_abstract[18] = new AtrInfoTable("Version", 0x33333333L, AttributeInfo.EnumAttributeType.JDFJMFVersion, JDFElement.EnumVersion.getEnum(0), null);
        JDFNode.atrInfoTable_abstract[19] = new AtrInfoTable("xmlns", 0x33333331L, AttributeInfo.EnumAttributeType.URI, JDFElement.EnumVersion.getEnum(0), null);
        JDFNode.atrInfoTable_abstract[20] = new AtrInfoTable("xsi:type", 0x33333311L, AttributeInfo.EnumAttributeType.NMTOKEN, JDFElement.EnumVersion.getEnum(0), null);
        atrInfoTable_root = new AtrInfoTable[2];
        JDFNode.atrInfoTable_root[0] = new AtrInfoTable("Version", 0x22222222L, AttributeInfo.EnumAttributeType.JDFJMFVersion, JDFElement.EnumVersion.getEnum(0), null);
        JDFNode.atrInfoTable_root[1] = new AtrInfoTable("xmlns", 0x33333331L, AttributeInfo.EnumAttributeType.URI, null, null);
        atrInfoTable_Combined = new AtrInfoTable[1];
        JDFNode.atrInfoTable_Combined[0] = new AtrInfoTable("Types", 0x22222222L, AttributeInfo.EnumAttributeType.NMTOKENS, null, null);
        atrInfoTable_PG = new AtrInfoTable[1];
        JDFNode.atrInfoTable_PG[0] = new AtrInfoTable("Types", 0x33333333L, AttributeInfo.EnumAttributeType.NMTOKENS, null, null);
        elemInfoTable_abstract = new ElemInfoTable[6];
        JDFNode.elemInfoTable_abstract[0] = new ElemInfoTable("AuditPool", 0x66666666L);
        JDFNode.elemInfoTable_abstract[1] = new ElemInfoTable("CustomerInfo", 0x77777666L);
        JDFNode.elemInfoTable_abstract[2] = new ElemInfoTable("NodeInfo", 0x77777666L);
        JDFNode.elemInfoTable_abstract[3] = new ElemInfoTable("ResourceLinkPool", 0x66666666L);
        JDFNode.elemInfoTable_abstract[4] = new ElemInfoTable("ResourcePool", 0x66666666L);
        JDFNode.elemInfoTable_abstract[5] = new ElemInfoTable("StatusPool", 0x77777666L);
        elemInfoTable_root = new ElemInfoTable[1];
        JDFNode.elemInfoTable_root[0] = new ElemInfoTable("AncestorPool", 0x66666666L);
        elemInfoTable_JDF = new ElemInfoTable[1];
        JDFNode.elemInfoTable_JDF[0] = new ElemInfoTable("JDF", 0x33333333L);
        nLog = LogFactory.getLog(JDFElement.class);
        Activation_Inactive = EnumActivation.Inactive;
        Activation_Informative = EnumActivation.Informative;
        Activation_Held = EnumActivation.Held;
        Activation_TestRun = EnumActivation.TestRun;
        Activation_TestRunAndGo = EnumActivation.TestRunAndGo;
        Activation_Active = EnumActivation.Active;
        Type_ProcessGroup = EnumType.ProcessGroup;
        Type_Combined = EnumType.Combined;
        Type_Product = EnumType.Product;
        Type_Approval = EnumType.Approval;
        Type_Buffer = EnumType.Buffer;
        Type_Combine = EnumType.Combine;
        Type_Delivery = EnumType.Delivery;
        Type_ManualLabor = EnumType.ManualLabor;
        Type_Ordering = EnumType.Ordering;
        Type_Packing = EnumType.Packing;
        Type_QualityControl = EnumType.QualityControl;
        Type_ResourceDefinition = EnumType.ResourceDefinition;
        Type_Split = EnumType.Split;
        Type_Verification = EnumType.Verification;
        Type_AssetListCreation = EnumType.AssetListCreation;
        Type_ColorCorrection = EnumType.ColorCorrection;
        Type_ColorSpaceConversion = EnumType.ColorSpaceConversion;
        Type_ContactCopying = EnumType.ContactCopying;
        Type_ContoneCalibration = EnumType.ContoneCalibration;
        Type_DBDocTemplateLayout = EnumType.DBDocTemplateLayout;
        Type_DBTemplateMerging = EnumType.DBTemplateMerging;
        Type_DigitalDelivery = EnumType.DigitalDelivery;
        Type_FilmToPlateCopying = EnumType.FilmToPlateCopying;
        Type_FormatConversion = EnumType.FormatConversion;
        Type_ImageReplacement = EnumType.ImageReplacement;
        Type_ImageSetting = EnumType.ImageSetting;
        Type_Imposition = EnumType.Imposition;
        Type_InkZoneCalculation = EnumType.InkZoneCalculation;
        Type_Interpreting = EnumType.Interpreting;
        Type_LayoutElementProduction = EnumType.LayoutElementProduction;
        Type_LayoutPreparation = EnumType.LayoutPreparation;
        Type_PDFToPSConversion = EnumType.PDFToPSConversion;
        Type_Preflight = EnumType.Preflight;
        Type_PreviewGeneration = EnumType.PreviewGeneration;
        Type_Proofing = EnumType.Proofing;
        Type_PSToPDFConversion = EnumType.PSToPDFConversion;
        Type_Rendering = EnumType.Rendering;
        Type_Scanning = EnumType.Scanning;
        Type_Screening = EnumType.Screening;
        Type_Separation = EnumType.Separation;
        Type_SoftProofing = EnumType.SoftProofing;
        Type_Stripping = EnumType.Stripping;
        Type_Tiling = EnumType.Tiling;
        Type_Trapping = EnumType.Trapping;
        Type_ConventionalPrinting = EnumType.ConventionalPrinting;
        Type_DigitalPrinting = EnumType.DigitalPrinting;
        Type_IDPrinting = EnumType.IDPrinting;
        Type_AdhesiveBinding = EnumType.AdhesiveBinding;
        Type_BlockPreparation = EnumType.BlockPreparation;
        Type_BoxPacking = EnumType.BoxPacking;
        Type_Bundling = EnumType.Bundling;
        Type_CaseMaking = EnumType.CaseMaking;
        Type_CasingIn = EnumType.CasingIn;
        Type_ChannelBinding = EnumType.ChannelBinding;
        Type_CoilBinding = EnumType.CoilBinding;
        Type_Collecting = EnumType.Collecting;
        Type_CoverApplication = EnumType.CoverApplication;
        Type_Creasing = EnumType.Creasing;
        Type_Cutting = EnumType.Cutting;
        Type_Dividing = EnumType.Dividing;
        Type_Embossing = EnumType.Embossing;
        Type_EndSheetGluing = EnumType.EndSheetGluing;
        Type_Feeding = EnumType.Feeding;
        Type_Folding = EnumType.Folding;
        Type_Gathering = EnumType.Gathering;
        Type_Gluing = EnumType.Gluing;
        Type_HeadBandApplication = EnumType.HeadBandApplication;
        Type_HoleMaking = EnumType.HoleMaking;
        Type_Inserting = EnumType.Inserting;
        Type_Jacketing = EnumType.Jacketing;
        Type_Labeling = EnumType.Labeling;
        Type_Laminating = EnumType.Laminating;
        Type_LongitudinalRibbonOperations = EnumType.LongitudinalRibbonOperations;
        Type_Numbering = EnumType.Numbering;
        Type_Palletizing = EnumType.Palletizing;
        Type_Perforating = EnumType.Perforating;
        Type_PlasticCombBinding = EnumType.PlasticCombBinding;
        Type_PrintRolling = EnumType.PrintRolling;
        Type_RingBinding = EnumType.RingBinding;
        Type_SaddleStitching = EnumType.SaddleStitching;
        Type_ShapeCutting = EnumType.ShapeCutting;
        Type_Shrinking = EnumType.Shrinking;
        Type_SideSewing = EnumType.SideSewing;
        Type_SpinePreparation = EnumType.SpinePreparation;
        Type_SpineTaping = EnumType.SpineTaping;
        Type_Stacking = EnumType.Stacking;
        Type_Stitching = EnumType.Stitching;
        Type_Strapping = EnumType.Strapping;
        Type_StripBinding = EnumType.StripBinding;
        Type_ThreadSealing = EnumType.ThreadSealing;
        Type_ThreadSewing = EnumType.ThreadSewing;
        Type_Trimming = EnumType.Trimming;
        Type_WireCombBinding = EnumType.WireCombBinding;
        Type_Wrapping = EnumType.Wrapping;
        ProcessUsage_AnyInput = EnumProcessUsage.AnyInput;
        ProcessUsage_AnyOutput = EnumProcessUsage.AnyOutput;
        ProcessUsage_Any = EnumProcessUsage.Any;
        ProcessUsage_Rejected = EnumProcessUsage.Rejected;
        ProcessUsage_Accepted = EnumProcessUsage.Accepted;
        ProcessUsage_Marks = EnumProcessUsage.Marks;
        ProcessUsage_Document = EnumProcessUsage.Document;
        ProcessUsage_Surface = EnumProcessUsage.Surface;
        ProcessUsage_Waste = EnumProcessUsage.Waste;
        ProcessUsage_Proof = EnumProcessUsage.Proof;
        ProcessUsage_Input = EnumProcessUsage.Input;
        ProcessUsage_Plate = EnumProcessUsage.Plate;
        ProcessUsage_Good = EnumProcessUsage.Good;
        ProcessUsage_Cover = EnumProcessUsage.Cover;
        ProcessUsage_BookBlock = EnumProcessUsage.BookBlock;
        ProcessUsage_Box = EnumProcessUsage.Box;
        ProcessUsage_CoverMaterial = EnumProcessUsage.CoverMaterial;
        ProcessUsage_SpineBoard = EnumProcessUsage.SpineBoard;
        ProcessUsage_CoverBoard = EnumProcessUsage.CoverBoard;
        ProcessUsage_Case = EnumProcessUsage.Case;
        ProcessUsage_FrontEndSheet = EnumProcessUsage.FrontEndSheet;
        ProcessUsage_BackEndSheet = EnumProcessUsage.BackEndSheet;
        ProcessUsage_Child = EnumProcessUsage.Child;
        ProcessUsage_Mother = EnumProcessUsage.Mother;
        ProcessUsage_Jacket = EnumProcessUsage.Jacket;
        ProcessUsage_Book = EnumProcessUsage.Book;
        ProcessUsage_Label = EnumProcessUsage.Label;
        ProcessUsage_RingBinder = EnumProcessUsage.RingBinder;
        ProcessUsage_Ancestor = EnumProcessUsage.Ancestor;
    }

    private static final class ExecPartFlags {
        private final boolean m_isAvailable;
        private final boolean m_isProcStatOK;

        protected ExecPartFlags(boolean isAvailable, boolean isProcStatOK) {
            this.m_isAvailable = isAvailable;
            this.m_isProcStatOK = isProcStatOK;
        }

        boolean isAvailable() {
            return this.m_isAvailable;
        }

        boolean isProcStatOK() {
            return this.m_isProcStatOK;
        }
    }

    private class ExecCheck {
        private ExecCheck() {
        }

        private ExecPartFlags addExecutablePartitions(JDFResourceLink link, JDFResource res, VString vsPartIDKeys, VJDFAttributeMap vamPartMaps, JDFResource.EnumResStatus minStatus, boolean bCheckNodeStatus) {
            boolean hasResourcePartMap;
            boolean isAvailable;
            JDFAttributeMap amPartMap = res.getPartMap();
            VElement veChildPartitions = res.getChildElementVector_JDFElement(res.getNodeName(), null, null, false, 0, true);
            int nChildPartitions = veChildPartitions.size();
            boolean isLeaf = this.isLeaf(vsPartIDKeys, amPartMap, nChildPartitions);
            JDFElement.EnumNodeStatus stat = JDFNode.this.getPartStatus(amPartMap, 0);
            boolean isProcStatOK = false;
            if (bCheckNodeStatus) {
                if (stat == null && isLeaf || stat == JDFElement.EnumNodeStatus.Waiting || stat == JDFElement.EnumNodeStatus.Ready) {
                    isProcStatOK = true;
                }
            } else {
                isProcStatOK = true;
            }
            JDFResource.EnumPartUsage partUsage = res.getPartUsage();
            boolean allChildsAvailable = true;
            for (int i = 0; i < nChildPartitions; ++i) {
                JDFResource sub = (JDFResource)veChildPartitions.get(i);
                JDFAttributeMap amSub = sub.getPartMap();
                if (!link.overlapsResourcePartMap(amSub)) continue;
                ExecPartFlags ExecChild = this.addExecutablePartitions(link, sub, vsPartIDKeys, vamPartMaps, minStatus, bCheckNodeStatus);
                if (!ExecChild.isAvailable()) {
                    allChildsAvailable = false;
                }
                if (ExecChild.isProcStatOK() || partUsage == JDFResource.EnumPartUsage.Implicit) continue;
                isProcStatOK = false;
            }
            JDFResource.EnumResStatus statRes = res.getResStatus(false);
            boolean bl = isAvailable = statRes.getValue() >= minStatus.getValue();
            if (nChildPartitions > 0) {
                if (!allChildsAvailable) {
                    isAvailable = false;
                } else if (partUsage != JDFResource.EnumPartUsage.Implicit || link.hasChildElement("Part", null)) {
                    isAvailable = true;
                }
            }
            boolean isExecutable = (hasResourcePartMap = link.hasResourcePartMap(amPartMap, true)) && isProcStatOK && isAvailable && res.isSpawnAllowed();
            this.modifyPartMap(vamPartMaps, amPartMap, isLeaf, stat, isExecutable);
            return new ExecPartFlags(isAvailable, isProcStatOK);
        }

        private void modifyPartMap(VJDFAttributeMap vamPartMaps, JDFAttributeMap amPartMap, boolean isLeaf, JDFElement.EnumNodeStatus stat, boolean isExecutable) {
            if (isExecutable) {
                if (isLeaf && stat == null) {
                    if (JDFNode.this.getStatus() == JDFElement.EnumNodeStatus.Part) {
                        JDFNodeInfo ni = JDFNode.this.getNodeInfo();
                        VElement veParts = ni.getPartitionVector(amPartMap, JDFResource.EnumPartUsage.Implicit);
                        if (veParts == null || veParts.isEmpty()) {
                            vamPartMaps.add(amPartMap);
                        } else {
                            for (int p = 0; p < veParts.size(); ++p) {
                                JDFNodeInfo niPart = (JDFNodeInfo)veParts.elementAt(p);
                                JDFElement.EnumNodeStatus statPart = niPart.getNodeStatus();
                                if (statPart != JDFElement.EnumNodeStatus.Waiting && statPart != JDFElement.EnumNodeStatus.Ready) continue;
                                vamPartMaps.add(niPart.getPartMap());
                            }
                            vamPartMaps.unify();
                        }
                    }
                } else {
                    vamPartMaps.add(amPartMap);
                }
            }
        }

        private boolean isLeaf(VString vsPartIDKeys, JDFAttributeMap amPartMap, int nChildPartitions) {
            boolean isLeaf = false;
            if (nChildPartitions == 0) {
                if (vsPartIDKeys != null) {
                    StringArray vsMapKeys = amPartMap.getKeyList();
                    if (vsMapKeys != null) {
                        isLeaf = vsMapKeys.containsAll(vsPartIDKeys);
                    }
                } else {
                    isLeaf = true;
                }
            }
            return isLeaf;
        }
    }

    public static final class EnumProcessUsage
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumProcessUsage AnyInput = new EnumProcessUsage("AnyInput");
        public static final EnumProcessUsage AnyOutput = new EnumProcessUsage("AnyOutput");
        @Deprecated
        public static final EnumProcessUsage Any = new EnumProcessUsage("Any");
        public static final EnumProcessUsage Rejected = new EnumProcessUsage("Rejected");
        public static final EnumProcessUsage Accepted = new EnumProcessUsage("Accepted");
        public static final EnumProcessUsage Application = new EnumProcessUsage("Application");
        public static final EnumProcessUsage Marks = new EnumProcessUsage("Marks");
        public static final EnumProcessUsage Document = new EnumProcessUsage("Document");
        public static final EnumProcessUsage Surface = new EnumProcessUsage("Surface");
        public static final EnumProcessUsage Waste = new EnumProcessUsage("Waste");
        public static final EnumProcessUsage ThumbNail = new EnumProcessUsage("ThumbNail");
        public static final EnumProcessUsage Proof = new EnumProcessUsage("Proof");
        public static final EnumProcessUsage Input = new EnumProcessUsage("Input");
        public static final EnumProcessUsage Plate = new EnumProcessUsage("Plate");
        public static final EnumProcessUsage Cylinder = new EnumProcessUsage("Cylinder");
        public static final EnumProcessUsage Good = new EnumProcessUsage("Good");
        public static final EnumProcessUsage Core = new EnumProcessUsage("Core");
        public static final EnumProcessUsage Cover = new EnumProcessUsage("Cover");
        public static final EnumProcessUsage BookBlock = new EnumProcessUsage("BookBlock");
        public static final EnumProcessUsage Box = new EnumProcessUsage("Box");
        public static final EnumProcessUsage CoverMaterial = new EnumProcessUsage("CoverMaterial");
        public static final EnumProcessUsage SpineBoard = new EnumProcessUsage("SpineBoard");
        public static final EnumProcessUsage CoverBoard = new EnumProcessUsage("CoverBoard");
        public static final EnumProcessUsage Case = new EnumProcessUsage("Case");
        public static final EnumProcessUsage EndCustomer = new EnumProcessUsage("EndCustomer");
        public static final EnumProcessUsage FrontEndSheet = new EnumProcessUsage("FrontEndSheet");
        public static final EnumProcessUsage BackEndSheet = new EnumProcessUsage("BackEndSheet");
        public static final EnumProcessUsage Child = new EnumProcessUsage("Child");
        public static final EnumProcessUsage Mother = new EnumProcessUsage("Mother");
        public static final EnumProcessUsage Jacket = new EnumProcessUsage("Jacket");
        public static final EnumProcessUsage Book = new EnumProcessUsage("Book");
        public static final EnumProcessUsage Label = new EnumProcessUsage("Label");
        public static final EnumProcessUsage RingBinder = new EnumProcessUsage("RingBinder");
        public static final EnumProcessUsage Ancestor = new EnumProcessUsage("Ancestor");
        public static final EnumProcessUsage Paper = new EnumProcessUsage("Paper");

        protected EnumProcessUsage(String name) {
            super(name, m_startValue++);
        }

        public static EnumProcessUsage getEnum(String enumName) {
            return (EnumProcessUsage)EnumProcessUsage.getEnum(EnumProcessUsage.class, (String)enumName);
        }

        public static EnumProcessUsage getEnum(int enumValue) {
            return (EnumProcessUsage)EnumProcessUsage.getEnum(EnumProcessUsage.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumProcessUsage.getEnumMap(EnumProcessUsage.class);
        }

        public static List getEnumList() {
            return EnumProcessUsage.getEnumList(EnumProcessUsage.class);
        }

        public static Iterator iterator() {
            return EnumProcessUsage.iterator(EnumProcessUsage.class);
        }
    }

    public static class CombinedProcessIndexHelper {
        public static void generateCombinedProcessIndex(JDFResource jdfResource, JDFResourceLink.EnumUsage usage, EnumProcessUsage processUsage, JDFResourceLink resourceLink, VString types) {
            if (resourceLink == null || jdfResource == null || resourceLink instanceof JDFPartAmount) {
                return;
            }
            JDFIntegerList cpi = new JDFIntegerList();
            String resName = jdfResource.getLocalName();
            int typSize = types.size();
            LinkInfo linkInfoLast = null;
            for (int i = 0; i < typSize; ++i) {
                LinkInfo linkInfo;
                boolean bAddCPI = false;
                EnumType typ = EnumType.getEnum(types.get(i));
                LinkInfoMap linkInfoMap = LinkValidatorMap.getLinkValidatorMap().getTypeMap(typ, true);
                LinkInfo linkInfo2 = linkInfo = linkInfoMap == null ? null : linkInfoMap.getStar(resName);
                if (linkInfo != null) {
                    boolean bMatchUsage = false;
                    for (int ti = 0; ti < linkInfo.size(); ++ti) {
                        if (!linkInfo.matchesUsage(ti, usage) || processUsage != null && !processUsage.getName().equals(linkInfo.getProcessUsage(ti))) continue;
                        bMatchUsage = true;
                        bAddCPI = true;
                        break;
                    }
                    if (bMatchUsage && linkInfoLast != null) {
                        bAddCPI = CombinedProcessIndexHelper.cleanCombinedProcessIndex(usage, linkInfo, cpi, linkInfoLast, bAddCPI);
                    }
                    if (bAddCPI) {
                        cpi.add(i);
                    }
                    linkInfoLast = linkInfo;
                    continue;
                }
                linkInfoLast = null;
            }
            if (cpi.size() > 0) {
                resourceLink.setCombinedProcessIndex(cpi);
            }
        }

        private static boolean cleanCombinedProcessIndex(JDFResourceLink.EnumUsage usage, LinkInfo linkInfo, JDFIntegerList cpi, LinkInfo linkInfoLast, boolean bAddCPI) {
            boolean bOut = linkInfoLast.hasOutput(null);
            if (!bOut) {
                return bAddCPI;
            }
            boolean bIn = linkInfo.hasInput(null);
            bOut = linkInfo.hasOutput(null);
            if (bIn && bOut) {
                if (JDFResourceLink.EnumUsage.Input.equals((Object)usage)) {
                    bAddCPI = false;
                } else {
                    cpi.removeElementAt(-1);
                    bAddCPI = true;
                }
            } else {
                bAddCPI = true;
            }
            return bAddCPI;
        }
    }

    public class StatusSynch {
        public void update() {
            this.update(JDFNode.this);
        }

        private void update(JDFNode n) {
            VElement vNodes = n.getvJDFNode(null, null, true);
            if (vNodes != null && !vNodes.isEmpty()) {
                VJDFAttributeMap vMap = this.getPartVector(n);
                for (int i = 0; i < vNodes.size(); ++i) {
                    JDFNode kid = (JDFNode)vNodes.get(i);
                    this.update(kid);
                }
                for (int ii = 0; ii < vMap.size(); ++ii) {
                    JDFElement.EnumNodeStatus synchStatus;
                    boolean ciao = vNodes.size() == 0;
                    JDFAttributeMap partMap = vMap.get(ii);
                    JDFElement.EnumNodeStatus minStatus = JDFElement.EnumNodeStatus.Aborted;
                    JDFElement.EnumNodeStatus maxStatus = JDFElement.EnumNodeStatus.Waiting;
                    for (int i = 0; i < vNodes.size(); ++i) {
                        JDFNode kid = (JDFNode)vNodes.get(i);
                        if ((minStatus = (JDFElement.EnumNodeStatus)EnumUtil.min(minStatus, kid.getPartStatus(partMap, -1))) == null) {
                            ciao = true;
                            break;
                        }
                        maxStatus = (JDFElement.EnumNodeStatus)EnumUtil.max(maxStatus, kid.getPartStatus(partMap, 1));
                    }
                    if (ciao || (synchStatus = this.getSynchStatus(minStatus, maxStatus)) == null || !EnumUtil.aLessThanB(n.getPartStatus(partMap, 0), synchStatus)) continue;
                    n.setPartStatus(partMap, synchStatus, null);
                }
            }
        }

        private JDFElement.EnumNodeStatus getSynchStatus(JDFElement.EnumNodeStatus minStatus, JDFElement.EnumNodeStatus maxStatus) {
            JDFElement.EnumNodeStatus synchStatus = null;
            synchStatus = minStatus.equals((Object)maxStatus) ? minStatus : (EnumUtil.aLessEqualsThanB(minStatus, JDFElement.EnumNodeStatus.Ready) ? (EnumUtil.aLessEqualsThanB(JDFElement.EnumNodeStatus.InProgress, maxStatus) ? JDFElement.EnumNodeStatus.InProgress : maxStatus) : minStatus);
            return synchStatus;
        }

        private VJDFAttributeMap getPartVector(JDFNode n) {
            VJDFAttributeMap vParts = n.getNodeInfoPartMapVector();
            if (vParts == null) {
                vParts = new VJDFAttributeMap();
                vParts.add(null);
            }
            return vParts;
        }
    }

    static class ResPart {
        private final JDFResource res;
        private final JDFAttributeMap part;

        ResPart(JDFResource res) {
            this.res = res;
            this.part = res == null ? null : res.getAttributeMap();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hash(this.part, this.res);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResPart other = (ResPart)obj;
            return Objects.equals(this.part, other.part) && Objects.equals(this.res, other.res);
        }

        public String toString() {
            return "ResPart [res=" + this.res + ", part=" + this.part + "]";
        }
    }

    private class PartStatusHelper {
        protected PartStatusHelper() {
        }

        public boolean setPartStatus(JDFAttributeMap mattr, JDFElement.EnumNodeStatus status, String statusDetails) {
            statusDetails = StringUtil.getNonEmpty(statusDetails);
            if (mattr != null && !mattr.isEmpty() && (status.equals((Object)JDFElement.EnumNodeStatus.Pool) || status.equals((Object)JDFElement.EnumNodeStatus.Part))) {
                return false;
            }
            if (mattr == null || mattr.isEmpty()) {
                return this.setRootStatus(status, statusDetails);
            }
            if (JDFNode.this.getVersion(true).getValue() < JDFElement.EnumVersion.Version_1_3.getValue()) {
                this.setPoolStatus(mattr, status, statusDetails);
            } else {
                this.setPartitionedStatus(mattr, status, statusDetails);
            }
            return true;
        }

        private void setPartitionedStatus(JDFAttributeMap mattr, JDFElement.EnumNodeStatus status, String statusDetails) {
            JDFNodeInfo ni = JDFNode.this.getCreateNodeInfo();
            ni = (JDFNodeInfo)ni.getResourceRoot();
            if (!JDFElement.EnumNodeStatus.Part.equals((Object)JDFNode.this.getStatus())) {
                ni.setNodeStatus(JDFNode.this.getStatus());
                if (statusDetails != null) {
                    ni.setNodeStatusDetails(statusDetails);
                }
            }
            Collection<JDFNodeInfo> niLeaves = this.getPartitionsForMap(mattr, ni);
            for (JDFNodeInfo niLeaf : niLeaves) {
                if (niLeaf == null) continue;
                niLeaf.removeAttributeFromLeaves("NodeStatus", null);
                niLeaf.setNodeStatus(status);
                if (statusDetails == null) continue;
                niLeaf.removeAttributeFromLeaves("NodeStatusDetails", null);
                niLeaf.setNodeStatusDetails(statusDetails);
            }
            JDFNode.this.setStatus(JDFElement.EnumNodeStatus.Part);
        }

        private Collection<JDFNodeInfo> getPartitionsForMap(JDFAttributeMap mattr, JDFNodeInfo ni) {
            JDFResource niRoot = ni.getResourceRoot();
            ArrayList<JDFNodeInfo> leaves = new ArrayList<JDFNodeInfo>();
            niRoot.setPartUsage(JDFResource.EnumPartUsage.Implicit);
            JDFNodeInfo niLeaf = (JDFNodeInfo)ni.getPartition(mattr, JDFResource.EnumPartUsage.Explicit);
            if (niLeaf == null) {
                VElement l2 = ni.getPartitionVector(mattr, JDFResource.EnumPartUsage.Explicit);
                if (!ContainerUtil.isEmpty(l2)) {
                    for (KElement e : l2) {
                        leaves.add((JDFNodeInfo)e);
                    }
                } else {
                    try {
                        niLeaf = (JDFNodeInfo)ni.getCreatePartition(mattr, null);
                        leaves.add(niLeaf);
                    }
                    catch (Exception exception) {}
                }
            } else {
                leaves.add(niLeaf);
            }
            return leaves;
        }

        private void setPoolStatus(JDFAttributeMap mattr, JDFElement.EnumNodeStatus status, String statusDetails) {
            JDFStatusPool statusPool = JDFNode.this.getCreateStatusPool();
            JDFElement.EnumNodeStatus stat = JDFNode.this.getStatus();
            if (!stat.equals((Object)JDFElement.EnumNodeStatus.Pool)) {
                statusPool.setStatus(stat);
                JDFNode.this.setStatus(JDFElement.EnumNodeStatus.Pool);
            }
            statusPool.setStatus(mattr, status, statusDetails);
            if (statusPool.numChildElements("PartStatus", null) == 0) {
                JDFNode.this.setStatus(status);
                if (statusDetails != null) {
                    JDFNode.this.setStatusDetails(statusDetails);
                }
                statusPool.deleteNode();
            }
        }

        private boolean setRootStatus(JDFElement.EnumNodeStatus status, String statusDetails) {
            JDFNodeInfo ni;
            JDFNode.this.setStatus(status);
            if (statusDetails != null) {
                JDFNode.this.setStatusDetails(statusDetails);
            }
            JDFNode.this.removeChild("StatusPool", null, 0);
            if (JDFNode.this.getVersion(true).getValue() >= JDFElement.EnumVersion.Version_1_3.getValue() && (ni = JDFNode.this.getNodeInfo()) != null) {
                ni.removeAttributeFromLeaves("NodeStatus", null);
                ni.setNodeStatus(status);
                if (statusDetails != null) {
                    ni.removeAttributeFromLeaves("NodeStatusDetails", null);
                    ni.setNodeStatusDetails(statusDetails);
                }
            }
            return true;
        }

        public boolean setPartStatus(VJDFAttributeMap vmattr, JDFElement.EnumNodeStatus status, String statusDetails) {
            boolean bRet = true;
            if (!ContainerUtil.isEmpty(vmattr)) {
                for (JDFAttributeMap map : vmattr) {
                    bRet = this.setPartStatus(map, status, statusDetails) && bRet;
                }
            } else {
                bRet = this.setPartStatus((JDFAttributeMap)null, status, statusDetails);
            }
            return bRet;
        }
    }

    public class CombinedProcessLinkHelper {
        private int nType = 0;
        private JDFResourceLink.EnumUsage usage;
        private String linkName;
        private boolean linkBoth;

        public CombinedProcessLinkHelper() {
            this.usage = null;
            this.linkName = null;
        }

        public CombinedProcessLinkHelper(String _linkName, JDFResourceLink.EnumUsage _usage) {
            this.usage = _usage;
            this.setLinkName(_linkName);
        }

        public JDFResourceLink getCreateLinkForType(EnumType type) {
            int cpi;
            CombinedProcessLinkHelper hTmp;
            int cpiType = JDFNode.this.getCombinedProcessIndex(type, this.nType);
            int nPI = JDFNode.this.getTypes().size();
            if (cpiType < 0) {
                return null;
            }
            VElement ve = this.getLinksForType(type);
            if (ve != null) {
                return (JDFResourceLink)ve.get(0);
            }
            JDFResourceLink rlLast = null;
            if (JDFResourceLink.EnumUsage.Input.equals((Object)this.usage) && cpiType > 0) {
                hTmp = new CombinedProcessLinkHelper();
                hTmp.setUsage(JDFResourceLink.EnumUsage.Output);
                hTmp.setLinkName(this.linkName);
                rlLast = hTmp.getLinkForCombinedProcessIndex(cpiType - 1, 0);
            } else if (JDFResourceLink.EnumUsage.Output.equals((Object)this.usage) && cpiType < nPI - 1) {
                hTmp = new CombinedProcessLinkHelper();
                hTmp.setUsage(JDFResourceLink.EnumUsage.Input);
                hTmp.setLinkName(this.linkName);
                rlLast = hTmp.getLinkForCombinedProcessIndex(cpiType + 1, 0);
            }
            JDFResource r = rlLast != null ? rlLast.getLinkRoot() : JDFNode.this.addResource(this.getResName(), this.usage);
            JDFIntegerList il = new JDFIntegerList();
            JDFResourceLink rl = JDFNode.this.ensureLink(r, this.usage, null);
            int nPos = 0;
            while ((cpi = JDFNode.this.getCombinedProcessIndex(type, nPos)) >= 0) {
                if (this.nType < 0 || this.nType == nPos) {
                    il.add(cpi);
                }
                nPos = cpi + 1;
            }
            rl.setCombinedProcessIndex(il);
            if (rlLast == null && this.linkBoth && this.nType >= 0) {
                JDFResourceLink.EnumUsage otherUsage = this.usage.invert();
                rlLast = JDFNode.this.ensureLink(r, otherUsage, null);
                --nPos;
                if ((nPos += JDFResourceLink.EnumUsage.Output.equals((Object)otherUsage) ? -1 : 1) >= 0 && nPos < JDFNode.this.getTypes().size()) {
                    rlLast.setCombinedProcessIndex(nPos);
                }
            }
            return rl;
        }

        public JDFResourceLink getLinkForCombinedProcessIndex(int combinedProcessIndex, int skip) {
            VElement v = this.getLinksForCombinedProcessIndex(combinedProcessIndex);
            return (JDFResourceLink)(v != null && v.size() > skip ? v.get(skip) : null);
        }

        public VElement getLinksForCombinedProcessIndex(int combinedProcessIndex) {
            VElement vLinks;
            EnumType typ = JDFNode.this.getEnumType();
            if (!EnumType.Combined.equals((Object)typ) && !EnumType.ProcessGroup.equals((Object)typ)) {
                return null;
            }
            JDFAttributeMap attMap = new JDFAttributeMap();
            if (this.usage != null) {
                attMap.put("Usage", (ValuedEnum)this.usage);
            }
            if ((vLinks = JDFNode.this.getResourceLinks(this.linkName, attMap, null)) == null) {
                return null;
            }
            String indexString = StringUtil.formatInteger(combinedProcessIndex);
            for (int i = vLinks.size() - 1; i >= 0; --i) {
                JDFResourceLink rl = (JDFResourceLink)vLinks.elementAt(i);
                if (!rl.hasAttribute("CombinedProcessIndex") || rl.includesMatchingAttribute("CombinedProcessIndex", indexString, AttributeInfo.EnumAttributeType.IntegerList)) continue;
                vLinks.remove(i);
            }
            return vLinks;
        }

        public VElement getLinksForType(EnumType type) {
            EnumType typ = JDFNode.this.getEnumType();
            if (typ == null) {
                return null;
            }
            JDFAttributeMap attMap = new JDFAttributeMap();
            if (this.usage != null) {
                attMap.put("Usage", (ValuedEnum)this.usage);
            }
            if (typ.equals((Object)type)) {
                return JDFNode.this.getResourceLinks(this.linkName, attMap, null);
            }
            if (!typ.equals((Object)EnumType.Combined) && !typ.equals((Object)EnumType.ProcessGroup)) {
                return null;
            }
            Vector<EnumType> vTypes = JDFNode.this.getEnumTypes();
            if (vTypes == null) {
                return null;
            }
            int typSize = vTypes.size();
            VElement vLinks = JDFNode.this.getResourceLinks(this.linkName, attMap, null);
            if (vLinks == null) {
                return null;
            }
            for (int iLink = vLinks.size() - 1; iLink >= 0; --iLink) {
                JDFResourceLink rl = (JDFResourceLink)vLinks.elementAt(iLink);
                JDFIntegerList cpi = rl.getCombinedProcessIndex();
                if (cpi == null) continue;
                int size = cpi.size();
                boolean bFound = false;
                for (int j = 0; j < size; ++j) {
                    EnumType cpiType;
                    int index = cpi.getInt(j);
                    if (index >= typSize || !(cpiType = vTypes.elementAt(index)).equals((Object)type)) continue;
                    if (this.nType < 0) {
                        bFound = true;
                        continue;
                    }
                    int nFound = -1;
                    for (int k = 0; k <= index; ++k) {
                        EnumType cpiTypeCount = vTypes.elementAt(k);
                        if (!cpiTypeCount.equals((Object)type)) continue;
                        ++nFound;
                    }
                    boolean bl = bFound = nFound == this.nType;
                    if (bFound) break;
                }
                if (bFound) continue;
                vLinks.remove(iLink);
            }
            return vLinks.isEmpty() ? null : vLinks;
        }

        public void setNPos(int nPos) {
            this.nType = nPos;
        }

        public void setUsage(JDFResourceLink.EnumUsage usage) {
            this.usage = usage;
        }

        public void setBoth(boolean b) {
            this.linkBoth = b;
        }

        public void setLinkName(String linkName) {
            if (!((String)linkName).endsWith("Link")) {
                linkName = (String)linkName + "Link";
            }
            this.linkName = linkName;
        }

        public String getResName() {
            return StringUtil.leftStr(this.linkName, -4);
        }
    }

    public static final class EnumType
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumType ProcessGroup = new EnumType("ProcessGroup");
        public static final EnumType Combined = new EnumType("Combined");
        public static final EnumType Product = new EnumType("Product");
        public static final EnumType Approval = new EnumType("Approval");
        public static final EnumType Buffer = new EnumType("Buffer");
        public static final EnumType Combine = new EnumType("Combine");
        public static final EnumType Delivery = new EnumType("Delivery");
        public static final EnumType ManualLabor = new EnumType("ManualLabor");
        public static final EnumType Ordering = new EnumType("Ordering");
        public static final EnumType Packing = new EnumType("Packing");
        public static final EnumType QualityControl = new EnumType("QualityControl");
        public static final EnumType ResourceDefinition = new EnumType("ResourceDefinition");
        public static final EnumType Split = new EnumType("Split");
        public static final EnumType Verification = new EnumType("Verification");
        public static final EnumType AssetListCreation = new EnumType("AssetListCreation");
        public static final EnumType Bending = new EnumType("Bending");
        public static final EnumType ColorCorrection = new EnumType("ColorCorrection");
        public static final EnumType ColorSpaceConversion = new EnumType("ColorSpaceConversion");
        public static final EnumType ContactCopying = new EnumType("ContactCopying");
        public static final EnumType ContoneCalibration = new EnumType("ContoneCalibration");
        public static final EnumType CylinderLayoutPreparation = new EnumType("CylinderLayoutPreparation");
        public static final EnumType DBDocTemplateLayout = new EnumType("DBDocTemplateLayout");
        public static final EnumType DBTemplateMerging = new EnumType("DBTemplateMerging");
        public static final EnumType DieDesign = new EnumType("DieDesign");
        public static final EnumType DieLayoutProduction = new EnumType("DieLayoutProduction");
        public static final EnumType DigitalDelivery = new EnumType("DigitalDelivery");
        public static final EnumType FilmToPlateCopying = new EnumType("FilmToPlateCopying");
        public static final EnumType FormatConversion = new EnumType("FormatConversion");
        public static final EnumType ImageEnhancement = new EnumType("ImageEnhancement");
        public static final EnumType ImageReplacement = new EnumType("ImageReplacement");
        public static final EnumType ImageSetting = new EnumType("ImageSetting");
        public static final EnumType Imposition = new EnumType("Imposition");
        public static final EnumType InkZoneCalculation = new EnumType("InkZoneCalculation");
        public static final EnumType Interpreting = new EnumType("Interpreting");
        public static final EnumType LayoutElementProduction = new EnumType("LayoutElementProduction");
        public static final EnumType LayoutPreparation = new EnumType("LayoutPreparation");
        public static final EnumType LayoutShifting = new EnumType("LayoutShifting");
        public static final EnumType PageAssigning = new EnumType("PageAssigning");
        public static final EnumType PDFToPSConversion = new EnumType("PDFToPSConversion");
        public static final EnumType PDLCreation = new EnumType("PDLCreation");
        public static final EnumType Preflight = new EnumType("Preflight");
        public static final EnumType PreviewGeneration = new EnumType("PreviewGeneration");
        public static final EnumType Proofing = new EnumType("Proofing");
        public static final EnumType PSToPDFConversion = new EnumType("PSToPDFConversion");
        public static final EnumType RasterReading = new EnumType("RasterReading");
        public static final EnumType Rendering = new EnumType("Rendering");
        public static final EnumType RIPing = new EnumType("RIPing");
        public static final EnumType Scanning = new EnumType("Scanning");
        public static final EnumType Screening = new EnumType("Screening");
        public static final EnumType Separation = new EnumType("Separation");
        public static final EnumType SoftProofing = new EnumType("SoftProofing");
        public static final EnumType Stripping = new EnumType("Stripping");
        public static final EnumType Tiling = new EnumType("Tiling");
        public static final EnumType Trapping = new EnumType("Trapping");
        public static final EnumType ConventionalPrinting = new EnumType("ConventionalPrinting");
        public static final EnumType DigitalPrinting = new EnumType("DigitalPrinting");
        public static final EnumType IDPrinting = new EnumType("IDPrinting");
        public static final EnumType Varnishing = new EnumType("Varnishing");
        public static final EnumType AdhesiveBinding = new EnumType("AdhesiveBinding");
        public static final EnumType BlockPreparation = new EnumType("BlockPreparation");
        public static final EnumType BoxPacking = new EnumType("BoxPacking");
        public static final EnumType BoxFolding = new EnumType("BoxFolding");
        public static final EnumType Bundling = new EnumType("Bundling");
        public static final EnumType CaseMaking = new EnumType("CaseMaking");
        public static final EnumType CasingIn = new EnumType("CasingIn");
        public static final EnumType ChannelBinding = new EnumType("ChannelBinding");
        public static final EnumType CoilBinding = new EnumType("CoilBinding");
        public static final EnumType Collecting = new EnumType("Collecting");
        public static final EnumType CoverApplication = new EnumType("CoverApplication");
        public static final EnumType Creasing = new EnumType("Creasing");
        public static final EnumType Cutting = new EnumType("Cutting");
        public static final EnumType DieMaking = new EnumType("DieMaking");
        public static final EnumType Dividing = new EnumType("Dividing");
        public static final EnumType Embossing = new EnumType("Embossing");
        public static final EnumType EndSheetGluing = new EnumType("EndSheetGluing");
        public static final EnumType Feeding = new EnumType("Feeding");
        public static final EnumType Folding = new EnumType("Folding");
        public static final EnumType Gathering = new EnumType("Gathering");
        public static final EnumType Gluing = new EnumType("Gluing");
        public static final EnumType HeadBandApplication = new EnumType("HeadBandApplication");
        public static final EnumType HoleMaking = new EnumType("HoleMaking");
        public static final EnumType Inserting = new EnumType("Inserting");
        public static final EnumType Jacketing = new EnumType("Jacketing");
        public static final EnumType Labeling = new EnumType("Labeling");
        public static final EnumType Laminating = new EnumType("Laminating");
        public static final EnumType LongitudinalRibbonOperations = new EnumType("LongitudinalRibbonOperations");
        public static final EnumType Numbering = new EnumType("Numbering");
        public static final EnumType Palletizing = new EnumType("Palletizing");
        public static final EnumType Perforating = new EnumType("Perforating");
        public static final EnumType PlasticCombBinding = new EnumType("PlasticCombBinding");
        public static final EnumType PrintRolling = new EnumType("PrintRolling");
        public static final EnumType RingBinding = new EnumType("RingBinding");
        public static final EnumType SaddleStitching = new EnumType("SaddleStitching");
        public static final EnumType ShapeCutting = new EnumType("ShapeCutting");
        public static final EnumType ShapeDefProduction = new EnumType("ShapeDefProduction");
        public static final EnumType SheetOptimizing = new EnumType("SheetOptimizing");
        public static final EnumType Shrinking = new EnumType("Shrinking");
        public static final EnumType SideSewing = new EnumType("SideSewing");
        public static final EnumType SpinePreparation = new EnumType("SpinePreparation");
        public static final EnumType SpineTaping = new EnumType("SpineTaping");
        public static final EnumType Stacking = new EnumType("Stacking");
        public static final EnumType StaticBlocking = new EnumType("StaticBlocking");
        public static final EnumType Stitching = new EnumType("Stitching");
        public static final EnumType Strapping = new EnumType("Strapping");
        public static final EnumType StripBinding = new EnumType("StripBinding");
        public static final EnumType ThreadSealing = new EnumType("ThreadSealing");
        public static final EnumType ThreadSewing = new EnumType("ThreadSewing");
        public static final EnumType Trimming = new EnumType("Trimming");
        public static final EnumType WebInlineFinishing = new EnumType("WebInlineFinishing");
        public static final EnumType Winding = new EnumType("Winding");
        public static final EnumType WireCombBinding = new EnumType("WireCombBinding");
        public static final EnumType Wrapping = new EnumType("Wrapping");
        public static final EnumType PlateSetting = new EnumType("PlateSetting");
        public static final EnumType PlateMaking = new EnumType("PlateMaking");
        public static final EnumType ProofAndPlateMaking = new EnumType("ProofAndPlateMaking");
        public static final EnumType ImpositionPreparation = new EnumType("ImpositionPreparation");
        public static final EnumType ImpositionProofing = new EnumType("ImpositionProofing");
        public static final EnumType PageProofing = new EnumType("PageProofing");
        public static final EnumType PageSoftProofing = new EnumType("PageSoftProofing");
        public static final EnumType PrepressPreparation = new EnumType("PrePressPreparation");
        public static final EnumType ProofImaging = new EnumType("ProofImaging");

        protected EnumType(String name) {
            super(name, m_startValue++);
        }

        public static EnumType getEnum(String enumName) {
            EnumType myEnum = (EnumType)EnumType.getEnum(EnumType.class, (String)enumName);
            return myEnum;
        }

        public static EnumType getEnum(int enumValue) {
            return (EnumType)EnumType.getEnum(EnumType.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumType.getEnumMap(EnumType.class);
        }

        public static List getEnumList() {
            return EnumType.getEnumList(EnumType.class);
        }

        public static Iterator iterator() {
            return EnumType.iterator(EnumType.class);
        }
    }

    public static final class EnumActivation
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumActivation Unknown = null;
        public static final EnumActivation Inactive = new EnumActivation("Inactive");
        public static final EnumActivation Informative = new EnumActivation("Informative");
        public static final EnumActivation Held = new EnumActivation("Held");
        public static final EnumActivation TestRun = new EnumActivation("TestRun");
        public static final EnumActivation TestRunAndGo = new EnumActivation("TestRunAndGo");
        public static final EnumActivation Active = new EnumActivation("Active");

        public static boolean isActive(EnumActivation a) {
            return a == null || Active.equals((Object)a) || TestRunAndGo.equals((Object)a);
        }

        protected EnumActivation(String name) {
            super(name, m_startValue++);
        }

        public static EnumActivation getEnum(String enumName) {
            return (EnumActivation)EnumActivation.getEnum(EnumActivation.class, (String)enumName);
        }

        public static EnumActivation getEnum(int enumValue) {
            return (EnumActivation)EnumActivation.getEnum(EnumActivation.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumActivation.getEnumMap(EnumActivation.class);
        }

        public static List getEnumList() {
            return EnumActivation.getEnumList(EnumActivation.class);
        }

        public static Iterator iterator() {
            return EnumActivation.iterator(EnumActivation.class);
        }
    }

    public static final class EnumCleanUpMerge
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumCleanUpMerge None = new EnumCleanUpMerge("None");
        public static final EnumCleanUpMerge RemoveRRefs = new EnumCleanUpMerge("RemoverRefs");
        public static final EnumCleanUpMerge RemoveAll = new EnumCleanUpMerge("RemoveAll");

        public String toString() {
            return this.getName();
        }

        protected EnumCleanUpMerge(String name) {
            super(name, m_startValue++);
        }

        public static EnumCleanUpMerge getEnum(String enumName) {
            return (EnumCleanUpMerge)EnumCleanUpMerge.getEnum(EnumCleanUpMerge.class, (String)enumName);
        }

        public static EnumCleanUpMerge getEnum(int enumValue) {
            return (EnumCleanUpMerge)EnumCleanUpMerge.getEnum(EnumCleanUpMerge.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumCleanUpMerge.getEnumMap(EnumCleanUpMerge.class);
        }

        public static List<EnumCleanUpMerge> getEnumList() {
            return EnumCleanUpMerge.getEnumList(EnumCleanUpMerge.class);
        }

        public static Iterator iterator() {
            return EnumCleanUpMerge.iterator(EnumCleanUpMerge.class);
        }
    }
}

