/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoResourceAudit;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.ifaces.ISignalAudit;
import org.cip4.jdflib.jmf.JDFJMF;
import org.cip4.jdflib.jmf.JDFMessage;
import org.cip4.jdflib.jmf.JDFResourceInfo;
import org.cip4.jdflib.jmf.JDFResourceQuParams;
import org.cip4.jdflib.jmf.JDFSignal;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.util.StringUtil;

public class JDFResourceAudit
extends JDFAutoResourceAudit
implements ISignalAudit {
    private static final long serialVersionUID = 1L;

    public JDFResourceAudit(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFResourceAudit(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFResourceAudit(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Deprecated
    public JDFResourceLink addNewLink(JDFResource r, boolean bInput) {
        return this.addNewOldLink(true, r, bInput);
    }

    @Deprecated
    public JDFResourceLink addOldLink(JDFResource r, boolean bInput) {
        return this.addNewOldLink(false, r, bInput);
    }

    @Deprecated
    public JDFResourceLink addNewOldLink(boolean bNew, JDFResource r, boolean bInput) {
        return this.addNewOldLink(bNew, r, bInput ? JDFResourceLink.EnumUsage.Input : JDFResourceLink.EnumUsage.Output);
    }

    public JDFResourceLink addNewOldLink(boolean bNew, JDFResource r, JDFResourceLink.EnumUsage usage) {
        VElement v = this.getChildElementVector(null, null, null, true, 0, false);
        int iNew = bNew ? 0 : 1;
        for (int i = v.size() - 1; i >= 0; --i) {
            if (v.elementAt(i) instanceof JDFResourceLink) continue;
            v.removeElementAt(i);
        }
        if (v.size() != iNew) {
            throw new JDFException("JDFResourceLink::AddNewOldLink invalid  ResourceAudit");
        }
        JDFResourceLink l = (JDFResourceLink)this.appendElement(r.getLinkString(), "");
        l.setTarget(r);
        l.setUsage(usage);
        return l;
    }

    public JDFResourceLink getNewLink() {
        return this.getNewOldLink(true);
    }

    public JDFResourceLink getOldLink() {
        return this.getNewOldLink(false);
    }

    public JDFResourceLink getNewOldLink(boolean bNew) {
        VElement v = this.getChildElementVector(null, null, null, true, 0, false);
        int iNew = bNew ? 0 : 1;
        for (int i = v.size() - 1; i >= 0; --i) {
            if (v.elementAt(i) instanceof JDFResourceLink) continue;
            v.removeElementAt(i);
        }
        if (v.size() <= iNew) {
            return null;
        }
        return (JDFResourceLink)v.elementAt(iNew);
    }

    public JDFResourceLink updateLink(JDFResourceLink newLink) {
        VElement v = this.getResourceLinkVector();
        if (v.size() > 2) {
            throw new JDFException("JDFResourceLink.UpdateLink invalid  ResourceAudit");
        }
        if (v.size() > 1) {
            v.elementAt(0).deleteNode();
            v.remove(v.elementAt(0));
        }
        JDFResourceLink resLink = (JDFResourceLink)this.copyElement(newLink, null);
        if (v.size() > 0) {
            resLink = (JDFResourceLink)this.insertBefore(resLink, v.elementAt(0));
        }
        return resLink;
    }

    public VElement getResourceLinkVector() {
        VElement v = this.getChildElementVector(null, null, null, true, 0, false);
        for (int i = v.size() - 1; i >= 0; --i) {
            JDFElement e = (JDFElement)v.elementAt(i);
            if (e instanceof JDFResourceLink) continue;
            v.remove(v.elementAt(i));
        }
        return v;
    }

    @Override
    public VString getUnknownElements(boolean bIgnorePrivate, int nMax) {
        return this.getUnknownPoolElements(JDFElement.EnumPoolType.ResourceLinkPool, nMax);
    }

    @Override
    public VString getMissingElements(int nMax) {
        VString vs = this.getTheElementInfo().requiredElements();
        vs = this.getMissingElementVector(vs, nMax);
        VElement v2 = this.getChildElementVector_KElement(null, null, null, true, 0);
        int n = 0;
        for (int i = 0; i < v2.size(); ++i) {
            if (!(v2.elementAt(i) instanceof JDFResourceLink)) continue;
            ++n;
        }
        if (n == 0) {
            vs.add("ResourceLink");
        }
        return vs;
    }

    @Override
    public void setPartMapVector(VJDFAttributeMap vParts) {
        super.setPartMapVector(vParts);
    }

    @Override
    public void setPartMap(JDFAttributeMap mPart) {
        super.setPartMap(mPart);
    }

    @Override
    public void removePartMap(JDFAttributeMap mPart) {
        super.removePartMap(mPart);
    }

    @Override
    public boolean hasPartMap(JDFAttributeMap mPart) {
        return super.hasPartMap(mPart);
    }

    @Override
    public JDFJMF toSignalJMF() {
        JDFResourceLink rl;
        JDFJMF newJMF = JDFJMF.createJMF(JDFMessage.EnumFamily.Signal, JDFMessage.EnumType.Resource);
        JDFSignal s = newJMF.getSignal(0);
        JDFResourceQuParams rqp = s.appendResourceQuParams();
        JDFResourceInfo ri = s.appendResourceInfo();
        JDFNode parentJDF = this.getParentJDF();
        if (parentJDF != null) {
            rqp.setJobID(parentJDF.getJobID(true));
            rqp.setJobPartID(StringUtil.getNonEmpty(parentJDF.getJobPartID(false)));
        }
        if ((rl = this.getNewLink()) != null) {
            ri.setResourceName(rl.getLinkedResourceName());
            ri.copyAttribute("ProcessUsage", rl);
            ri.copyAttribute("Usage", rl);
            if (rl.hasChildElement("AmountPool", null)) {
                ri.copyElement(rl.getAmountPool(), null);
            } else {
                ri.copyAttribute("Amount", rl);
                ri.copyAttribute("ActualAmount", rl);
            }
        }
        return newJMF;
    }
}

