/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.elementwalker.fixversion;

import java.util.List;
import java.util.zip.DataFormatException;
import org.apache.commons.lang.StringUtils;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.StringArray;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.JDFNameRangeList;
import org.cip4.jdflib.datatypes.JDFNumList;
import org.cip4.jdflib.datatypes.JDFShape;
import org.cip4.jdflib.datatypes.JDFXYPair;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.elementwalker.fixversion.FixVersionImpl;
import org.cip4.jdflib.span.JDFTimeSpan;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.EnumUtil;
import org.cip4.jdflib.util.JDFDate;
import org.cip4.jdflib.util.JDFDuration;
import org.cip4.jdflib.util.StringUtil;

public class WalkElement
extends BaseWalker {
    FixVersionImpl fixVersion = null;

    public void setParent(FixVersionImpl fixVersion) {
        this.fixVersion = fixVersion;
    }

    @Override
    public KElement walk(KElement e1, KElement trackElem) {
        JDFElement el = (JDFElement)e1;
        if (this.fixVersion.isZappDeprecated() && el.isDeprecated()) {
            this.processDeprecated(el);
            return null;
        }
        JDFAttributeMap m = el.getAttributeMap_KElement();
        if (this.updateAttributes(m)) {
            el.removeAttributes(null);
            el.setAttributes(m);
        }
        List<String> keys = ContainerUtil.getKeyList(m);
        AttributeInfo ai = el.getAttributeInfo();
        if (keys != null) {
            String localName = el.getLocalName();
            List ignore = (List)this.fixVersion.ignoreMap.get(localName);
            for (String key : keys) {
                String value = m.get(key);
                if (ignore != null && ignore.contains(key)) continue;
                this.walkSingleAttribute(el, ai, key, value);
            }
        }
        return el;
    }

    protected void processDeprecated(JDFElement el) {
        el.deleteNode();
    }

    boolean updateAttributes(JDFAttributeMap m) {
        return false;
    }

    void walkSingleAttribute(JDFElement el, AttributeInfo ai, String key, String value) {
        String prefix;
        AttributeInfo.EnumAttributeType attType = ai.getAttributeType(key);
        if (this.fixVersion.bZappInvalid && attType == null) {
            String uri;
            prefix = KElement.xmlnsPrefix(key);
            String string = uri = prefix == null ? null : el.getNamespaceURIFromPrefix(prefix);
            if ((uri == null || JDFElement.isInJDFNameSpaceStatic(uri)) && ai.getLastVersion(key) == null) {
                el.removeAttribute_KElement(key, null);
                return;
            }
        } else if (this.fixVersion.bZappDeprecated && this.fixVersion.version != null) {
            String uri;
            prefix = KElement.xmlnsPrefix(key);
            String string = uri = prefix == null ? null : el.getNamespaceURIFromPrefix(prefix);
            if ((uri == null || JDFElement.isInJDFNameSpaceStatic(uri)) && this.fixVersion.version.isGreater(ai.getLastVersion(key))) {
                el.removeAttribute_KElement(key, null);
                return;
            }
        }
        if (AttributeInfo.EnumAttributeType.isRange(attType)) {
            this.fixRange(el, key, value);
        } else if (AttributeInfo.EnumAttributeType.duration.equals((Object)attType)) {
            this.fixDuration(el, key, value);
        } else if (AttributeInfo.EnumAttributeType.boolean_.equals((Object)attType)) {
            this.fixBoolean(el, key, value);
        } else if (AttributeInfo.EnumAttributeType.integer.equals((Object)attType)) {
            int i = StringUtil.parseInt(value, -2147483606);
            if (i == -2147483606) {
                el.removeAttribute(key);
            } else {
                el.setAttribute(key, i, (String)null);
            }
        } else if (AttributeInfo.EnumAttributeType.double_.equals((Object)attType)) {
            double d = StringUtil.parseDouble(value, Double.POSITIVE_INFINITY);
            if (d == Double.POSITIVE_INFINITY) {
                el.removeAttribute(key);
            } else {
                el.setAttribute(key, d, null);
            }
        } else if (AttributeInfo.EnumAttributeType.dateTime.equals((Object)attType)) {
            this.fixDateTime(el, key, value);
        } else if (AttributeInfo.EnumAttributeType.NMTOKEN.equals((Object)attType)) {
            this.fixNMTOKEN(el, key, value);
        } else if (AttributeInfo.EnumAttributeType.XYPair.equals((Object)attType)) {
            JDFXYPair xyPair = JDFXYPair.createXYPair(value);
            el.setAttribute(key, (JDFNumList)xyPair, (String)null);
        } else if (AttributeInfo.EnumAttributeType.shape.equals((Object)attType)) {
            JDFShape shape = JDFShape.createShape(value);
            el.setAttribute(key, (JDFNumList)shape, (String)null);
        } else if (AttributeInfo.EnumAttributeType.enumerations.equals((Object)attType)) {
            this.fixSourceObjects(el, key, value);
        }
        if (this.fixVersion.bFixIDs && value.length() > 0 && StringUtils.isNumeric((String)value.substring(0, 1))) {
            this.fixIDs(el, ai, key, value);
        }
        if ("ICSVersions".equals(key)) {
            this.fixICSVersions(el, value);
        }
        if (this.fixVersion.bZappInvalid && !AttributeInfo.validStringForType(value, attType, null)) {
            String newValue = el.getNonEmpty_KElement(key);
            if (el == null || !AttributeInfo.validStringForType(newValue, attType, null)) {
                el.removeAttribute_KElement(key, null);
            }
        }
    }

    void fixNMTOKEN(JDFElement el, String key, String value) {
        String newVal;
        if (!StringUtil.isNMTOKEN(value) && !StringUtil.equals(newVal = StringUtil.replaceCharSet(value, " ", "_", 0), value) && StringUtil.isNMTOKEN(newVal)) {
            el.setAttribute(key, newVal);
        }
    }

    private void fixBoolean(JDFElement el, String key, String value) {
        if (!"false".equals(value) && !"true".equals(value) && StringUtil.isBoolean(value)) {
            boolean newVal = StringUtil.parseBoolean(value, true);
            el.setAttribute(key, "" + newVal);
        }
    }

    protected void fixSourceObjects(JDFElement el, String key, String value) {
        if ("SourceObjects".equals(key) && EnumUtil.aLessEqualsThanB(JDFElement.EnumVersion.Version_1_5, this.fixVersion.version) && StringUtil.hasToken(value, "All", null, 0)) {
            el.removeAttribute_KElement(key, null);
        }
    }

    private void fixICSVersions(JDFElement el, String value) {
        if (!this.fixVersion.fixICSVersions) {
            return;
        }
        VString v = StringUtil.tokenize(value, null, false);
        if (v == null) {
            return;
        }
        int minor = this.fixVersion.version.getMinorVersion();
        for (int i = 0; i < v.size(); ++i) {
            Object icsToken = v.get(i);
            if (!".".equals(StringUtil.substring((String)icsToken, -2, -1)) || !StringUtil.isInteger(StringUtil.rightStr((String)icsToken, 1))) continue;
            icsToken = StringUtil.leftStr((String)icsToken, -1) + minor;
            v.set(i, icsToken);
        }
        el.setAttribute("ICSVersions", v, (String)null);
    }

    private void fixRange(JDFElement el, String key, String value) {
        try {
            JDFNameRangeList nrl = new JDFNameRangeList(value);
            el.setAttribute(key, nrl, null);
        }
        catch (JDFException jDFException) {
        }
        catch (DataFormatException dataFormatException) {
            // empty catch block
        }
    }

    private void fixDuration(JDFElement el, String key, String value) {
        try {
            el.setAttribute(key, new JDFDuration(value).getDurationISO());
        }
        catch (DataFormatException dataFormatException) {
            // empty catch block
        }
    }

    void fixDateTime(JDFElement el, String key, String value) {
        int hour = -1;
        String check = key;
        if (el instanceof JDFTimeSpan) {
            check = el.getLocalName();
        }
        if (check != null) {
            if (check.endsWith("End") || "Required".equals(check)) {
                hour = this.fixVersion.lasthour;
            } else if (check.endsWith("Start") || "Earliest".equals(check)) {
                hour = this.fixVersion.firsthour;
            }
        }
        try {
            el.setAttribute(key, new JDFDate(value, hour, 0).getDateTimeISO());
        }
        catch (DataFormatException dataFormatException) {
            // empty catch block
        }
    }

    private void fixIDs(JDFElement el, AttributeInfo ai, String key, String value) {
        AttributeInfo.EnumAttributeType atType = ai.getAttributeType(key);
        if (atType != null) {
            if (atType.equals((Object)AttributeInfo.EnumAttributeType.ID) || atType.equals((Object)AttributeInfo.EnumAttributeType.IDREF)) {
                value = "_" + (String)value;
                el.setAttribute(key, (String)value);
            } else if (atType.equals((Object)AttributeInfo.EnumAttributeType.IDREFS)) {
                StringArray vvalues = new StringArray((String)value, " ");
                for (int i = 0; i < vvalues.size(); ++i) {
                    Object s = vvalues.get(i);
                    if (((String)s).length() <= 0 || !StringUtils.isNumeric((String)((String)s).substring(0, 1))) continue;
                    s = "_" + (String)s;
                    vvalues.set(i, s);
                }
                el.setAttribute(key, vvalues, null);
            }
        }
    }

    @Override
    public boolean matches(KElement toCheck) {
        return toCheck instanceof JDFElement && JDFElement.isInJDFNameSpaceStatic(toCheck);
    }
}

