/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions;

import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.extensions.MessageHelper;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.extensions.XJMFHelper;
import org.cip4.jdflib.util.StringUtil;

public class AuditHelper
extends MessageHelper {
    public static boolean isAudit(KElement element) {
        String localName;
        String string = localName = element == null ? null : element.getLocalName();
        if (localName == null) {
            return false;
        }
        return localName.startsWith("Audit") && eAudit.getEnum(localName) != null;
    }

    public AuditHelper(KElement audit) {
        super(audit);
    }

    public XJMFHelper makeXJMFSignal() {
        XJMFHelper xh = new XJMFHelper();
        KElement m = xh.getRoot().copyElement(this.getRoot(), null);
        m.renameElement(StringUtil.replaceString(m.getNodeName(), "Audit", "Signal"), null);
        return xh;
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this.getHeader().removeAttribute("ID", null);
        VElement v = this.theElement.getChildrenByTagName("ResourceSet", null, null, false, true, 0);
        if (v != null) {
            for (KElement e : v) {
                new SetHelper(e).cleanUp();
                e.removeAttribute("ID");
                VElement vRes = e.getChildElementVector("Resource", null);
                if (vRes == null) continue;
                for (KElement res : vRes) {
                    res.removeAttribute("ID");
                }
            }
        }
    }

    public static enum eAudit {
        Created,
        Notification,
        Resource,
        Status,
        ProcessRun;


        public static eAudit getEnum(String name) {
            if (name == null) {
                return null;
            }
            while (name.toLowerCase().startsWith("audit")) {
                name = name.substring(5);
            }
            for (eAudit e : eAudit.values()) {
                if (!e.name().equalsIgnoreCase(name)) continue;
                return e;
            }
            return null;
        }

        public String getAuditName() {
            return "Audit" + this.name();
        }
    }
}

