/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.JDFAttributeMapArray;
import org.cip4.jdflib.datatypes.JDFIntegerList;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.extensions.BaseXJDFHelper;
import org.cip4.jdflib.extensions.ResourceHelper;
import org.cip4.jdflib.extensions.XJDFHelper;
import org.cip4.jdflib.extensions.XJDFSetCleanupComparator;
import org.cip4.jdflib.ifaces.IMatches;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.StringUtil;

public class SetHelper
extends BaseXJDFHelper
implements IMatches {
    public static final String SET = "Set";
    public static final String PARAMETER_SET = EnumFamily.Parameter.name() + "Set";
    public static final String RESOURCE_SET = "ResourceSet";

    public double getAmountSum(boolean bGood) {
        double a = 0.0;
        List<ResourceHelper> l = this.getPartitionList();
        for (ResourceHelper h : l) {
            a += h.getAmountSum(bGood);
        }
        return a;
    }

    public SetHelper(KElement set) {
        this.theElement = set;
    }

    public void ensureReference(KElement src, String key) {
        if (src != null && this.theElement != null) {
            if (StringUtil.isEmpty((String)key)) {
                key = this.getName();
            }
            if (!((String)key).endsWith("Ref") && !((String)key).endsWith("Refs")) {
                key = (String)key + "Ref";
            }
            String id = this.ensureID();
            src.setAttribute((String)key, id);
        }
    }

    public static boolean isSet(KElement e) {
        String localName = e == null ? null : e.getLocalName();
        return SetHelper.isSet(localName);
    }

    public static boolean isSet(String localName) {
        return RESOURCE_SET.equals(localName) || PARAMETER_SET.equals(localName);
    }

    public ResourceHelper getPartition(JDFAttributeMap map) {
        return this.getResource(map);
    }

    public ResourceHelper getResource(JDFAttributeMap map) {
        List<ResourceHelper> v = this.getPartitionList();
        for (ResourceHelper ph : v) {
            if (!ph.matches(map)) continue;
            return ph;
        }
        return null;
    }

    public ResourceHelper getPartition(String key, String value) {
        return this.getResource(new JDFAttributeMap(key, value));
    }

    public ResourceHelper getResource(String key, String value) {
        return this.getResource(new JDFAttributeMap(key, value));
    }

    public ResourceHelper getPartition(int index) {
        return ContainerUtil.get(this.getResourceList(), index);
    }

    public ResourceHelper getResource(int index) {
        return ContainerUtil.get(this.getResourceList(), index);
    }

    public ResourceHelper getCreatePartition(JDFAttributeMap map, boolean addRes) {
        return this.getCreateResource(map, addRes);
    }

    public ResourceHelper getCreateResource(JDFAttributeMap map, boolean addRes) {
        ResourceHelper e = this.getResource(map);
        if (e == null) {
            e = this.appendPartition(map, addRes);
        } else if (!e.containsMap(map)) {
            e = this.insertPartitionBefore(e, map, addRes);
        }
        if (addRes) {
            e.getCreateResource();
        }
        return e;
    }

    public ResourceHelper getCreateVPartition(VJDFAttributeMap vmap, boolean addRes) {
        ResourceHelper e = null;
        JDFAttributeMap map = null;
        if (vmap != null) {
            for (JDFAttributeMap map2 : vmap) {
                e = this.getPartition(map2);
                if (e == null) continue;
                map = map2;
                break;
            }
        }
        if (e == null) {
            e = this.appendPartition(map, addRes);
        } else if (!e.containsMap(map)) {
            e = this.insertPartitionBefore(e, map, addRes);
        }
        e.setPartMapVector(vmap);
        if (addRes) {
            e.getCreateResource();
        }
        return e;
    }

    public ResourceHelper getCreateExactPartition(JDFAttributeMap map, boolean addRes) {
        ResourceHelper h = this.getExactPartition(map);
        return h != null ? h : this.appendPartition(map, addRes);
    }

    public ResourceHelper getExactPartition(JDFAttributeMap map) {
        for (ResourceHelper h : this.getPartitionList()) {
            if (!h.hasPartition(map)) continue;
            return h;
        }
        return null;
    }

    public ResourceHelper insertPartitionBefore(ResourceHelper e, JDFAttributeMap map, boolean addRes) {
        ResourceHelper e2 = this.appendPartition(map, addRes);
        if (e != null) {
            KElement e3 = e.getPartition();
            e3.getParentNode_KElement().moveElement(e2.getPartition(), e3);
        }
        return e2;
    }

    public Vector<ResourceHelper> getCreatePartitions(VJDFAttributeMap vmap, boolean addRes) {
        if (vmap == null) {
            vmap = new VJDFAttributeMap();
            vmap.add(null);
        }
        Vector<ResourceHelper> vp = new Vector<ResourceHelper>();
        for (JDFAttributeMap m : vmap) {
            vp.add(this.getCreatePartition(m, addRes));
        }
        return vp;
    }

    public ResourceHelper getCreatePartition(int index, boolean addRes) {
        return this.getCreateResource(index, addRes);
    }

    public ResourceHelper getCreateResource() {
        return this.getCreateResource(0, true);
    }

    public ResourceHelper getCreateResource(int index, boolean addRes) {
        List<ResourceHelper> v = this.getResourceList();
        int size = v.size();
        if (index < 0) {
            index += size;
        }
        while (index < 0) {
            this.appendResource((JDFAttributeMap)null, addRes);
            ++index;
        }
        while (index >= size) {
            this.appendResource((JDFAttributeMap)null, addRes);
            ++size;
        }
        if (size != v.size()) {
            v = this.getResourceList();
        }
        ResourceHelper ph = v.get(index);
        if (addRes) {
            ph.getCreateResource();
        }
        return ph;
    }

    public void removePartitions() {
        List<ResourceHelper> v = this.getPartitionList();
        for (ResourceHelper ph : v) {
            ph.getPartition().deleteNode();
        }
    }

    public ResourceHelper appendResource(String partKey, String partValue, boolean addRes) {
        return this.appendResource(new JDFAttributeMap(partKey, partValue), addRes);
    }

    public ResourceHelper appendPartition(String partKey, String partValue, boolean addRes) {
        return this.appendResource(partKey, partValue, addRes);
    }

    public ResourceHelper getCreatePartition(String partKey, String partValue, boolean addRes) {
        return this.getCreatePartition(new JDFAttributeMap(partKey, partValue), addRes);
    }

    public ResourceHelper appendResource(JDFAttributeMap partMap, boolean addRes) {
        return this.appendResource(JDFAttributeMap.isEmpty(partMap) ? null : new VJDFAttributeMap(partMap), addRes);
    }

    public ResourceHelper appendPartition(JDFAttributeMap partMap, boolean addRes) {
        return this.appendResource(partMap, addRes);
    }

    public ResourceHelper appendResource(VJDFAttributeMap partMaps, boolean addRes) {
        KElement newPart = this.theElement.appendElement(this.getPartitionName());
        ResourceHelper partitionHelper = new ResourceHelper(newPart);
        partitionHelper.cleanUp();
        partitionHelper.setPartMapVector(partMaps);
        String resName = this.getName();
        if (resName != null && addRes) {
            KElement newRes = newPart.appendElement(resName);
            newRes.removeAttribute("Class");
        }
        return partitionHelper;
    }

    public XJDFHelper getXJDF() {
        return XJDFHelper.getHelper(this.theElement);
    }

    public Vector<ResourceHelper> getPartitions() {
        List<KElement> v = this.theElement.getChildList(this.getPartitionName(), null);
        Vector<ResourceHelper> v2 = new Vector<ResourceHelper>();
        if (v != null) {
            for (KElement e : v) {
                v2.add(new ResourceHelper(e));
            }
        }
        return v2;
    }

    public List<ResourceHelper> getPartitionList() {
        return this.getResourceList();
    }

    public List<ResourceHelper> getResourceList() {
        List<KElement> v = this.theElement.getChildList(this.getPartitionName(), null);
        ArrayList<ResourceHelper> v2 = new ArrayList<ResourceHelper>();
        for (KElement e : v) {
            v2.add(new ResourceHelper(e));
        }
        return v2;
    }

    @Override
    public void cleanUp() {
        List<ResourceHelper> kids;
        if (!this.theElement.hasAttribute("Name")) {
            this.theElement.setAttribute("Name", this.getName());
        }
        if (!ContainerUtil.isEmpty(kids = this.getPartitionList())) {
            for (ResourceHelper kid : kids) {
                kid.cleanUp();
            }
            this.theElement.sortChildren(new XJDFSetCleanupComparator());
        }
    }

    public String getName() {
        String name = this.theElement.getAttribute("Name", null, null);
        if (name == null) {
            List<ResourceHelper> v = this.getPartitionList();
            for (ResourceHelper ph : v) {
                KElement res = ph.getResource();
                if (res == null) continue;
                name = res.getNodeName();
                this.theElement.setAttribute("Name", name);
                return name;
            }
        }
        return name;
    }

    public String getPartitionName() {
        String name = SetHelper.getSetName(this.theElement.getLocalName());
        return name;
    }

    public static String getSetName(KElement e) {
        return e == null ? null : SetHelper.getSetName(e.getLocalName());
    }

    public static String getSetName(String setName) {
        return SetHelper.isSet(setName) || "IntentSet".equals(setName) ? StringUtil.leftStr(setName, -3) : null;
    }

    public ResourceHelper getPartition(VJDFAttributeMap vmap) {
        List<ResourceHelper> v = this.getPartitionList();
        for (ResourceHelper ph : v) {
            if (!ph.matches(vmap)) continue;
            return ph;
        }
        return null;
    }

    public Vector<ResourceHelper> getPartitions(VJDFAttributeMap vmap) {
        Vector<ResourceHelper> v = this.getPartitions();
        Vector<ResourceHelper> vRet = new Vector<ResourceHelper>();
        for (ResourceHelper ph : v) {
            if (!ph.matches(vmap)) continue;
            vRet.add(ph);
        }
        return vRet;
    }

    public Vector<ResourceHelper> getPartitions(JDFAttributeMap map) {
        Vector<ResourceHelper> v = this.getPartitions();
        Vector<ResourceHelper> vRet = new Vector<ResourceHelper>();
        for (ResourceHelper ph : v) {
            if (!ph.matches(map)) continue;
            vRet.add(ph);
        }
        return vRet;
    }

    public Vector<ResourceHelper> getSuperPartitions(JDFAttributeMap map) {
        Vector<ResourceHelper> v = this.getPartitions();
        Vector<ResourceHelper> vRet = new Vector<ResourceHelper>();
        for (ResourceHelper ph : v) {
            VJDFAttributeMap vMap = ph.getPartMapVector();
            if (map != null && (vMap == null || !vMap.subMap(map))) continue;
            vRet.add(ph);
        }
        return vRet;
    }

    public KElement getSet() {
        return this.theElement;
    }

    public void setUsage(JDFResourceLink.EnumUsage value) {
        this.theElement.setAttribute("Usage", value == null ? null : value.getName());
    }

    public JDFResourceLink.EnumUsage getUsage() {
        return JDFResourceLink.EnumUsage.getEnum(this.theElement.getAttribute("Usage", null, null));
    }

    public String getProcessUsage() {
        return this.getAttribute("ProcessUsage");
    }

    public JDFIntegerList getCombinedProcessIndex() {
        return JDFIntegerList.createIntegerList(this.getAttribute("CombinedProcessIndex"));
    }

    public void removeTypeFromCPI(int pos) {
        JDFIntegerList il = this.getCombinedProcessIndex();
        if (il != null) {
            boolean mod = false;
            for (int i = 0; i < il.size(); ++i) {
                int iPos = il.getInt(i);
                if (iPos == pos) {
                    il.remove(i);
                    --i;
                    mod = true;
                    continue;
                }
                if (iPos <= pos) continue;
                il.setInt(i, iPos - 1);
                mod = true;
            }
            if (mod) {
                this.setCombinedProcessIndex(il);
            }
        }
    }

    public void addTypeToCPI(int pos) {
        JDFIntegerList il = this.getCombinedProcessIndex();
        if (il != null) {
            boolean mod = false;
            for (int i = 0; i < il.size(); ++i) {
                int iPos = il.getInt(i);
                if (iPos < pos) continue;
                il.setInt(i, iPos + 1);
                mod = true;
            }
            if (mod) {
                this.setCombinedProcessIndex(il);
            }
        }
    }

    public void setCombinedProcessIndex(JDFIntegerList cpi) {
        this.setAttribute("CombinedProcessIndex", cpi == null || cpi.isEmpty() ? null : cpi.toString());
    }

    public void setProcessUsage(String processUsage) {
        this.setAttribute("ProcessUsage", processUsage);
    }

    public void setUnit(JDFElement.eUnit unit) {
        this.setAttribute("Unit", unit == null ? null : unit.name());
    }

    public JDFElement.eUnit getUnit() {
        return JDFElement.eUnit.getEnum(this.getAttribute("Unit"));
    }

    @Override
    public String getDescriptiveName() {
        return this.getAttribute("DescriptiveName");
    }

    @Override
    public String getExternalID() {
        return this.getAttribute("ExternalID");
    }

    @Override
    public String toString() {
        return "SetHelper: " + this.theElement;
    }

    public ResourceHelper getPartition(String id) {
        if (!StringUtil.isEmpty(id)) {
            String partitionName = this.getPartitionName();
            for (KElement e = this.theElement.getFirstChildElement(partitionName, null); e != null; e = e.getNextSiblingElement(partitionName, null)) {
                if (!id.equals(e.getID())) continue;
                return new ResourceHelper(e);
            }
        }
        return null;
    }

    public EnumFamily getFamily() {
        if (this.theElement == null) {
            return null;
        }
        String name = this.theElement.getLocalName();
        name = StringUtil.leftStr(name, -3);
        return EnumFamily.valueOf(name);
    }

    @Override
    public void setID(String newID) {
        String oldID = this.getID();
        super.setID(newID);
        List<ResourceHelper> parts = this.getPartitionList();
        if (parts != null) {
            for (ResourceHelper part : parts) {
                String partID = part.getID();
                partID = StringUtil.replaceString(partID, oldID, newID);
                part.setID(newID);
            }
        }
    }

    public VJDFAttributeMap getPartMapVector() {
        List<ResourceHelper> vph = this.getPartitionList();
        VJDFAttributeMap vMap = new VJDFAttributeMap();
        for (ResourceHelper ph : vph) {
            vMap.addAll(ph.getPartMapList());
        }
        vMap.unify();
        return vMap;
    }

    public List<JDFAttributeMap> getPartMapList() {
        List<ResourceHelper> vph = this.getPartitionList();
        JDFAttributeMapArray vMap = new JDFAttributeMapArray();
        for (ResourceHelper ph : vph) {
            vMap.addAll(ph.getPartMapList());
        }
        vMap.unify();
        return vMap;
    }

    public Collection<VJDFAttributeMap> getPartMapVectors() {
        List<ResourceHelper> vph = this.getPartitionList();
        ArrayList<VJDFAttributeMap> vMap = new ArrayList<VJDFAttributeMap>();
        for (ResourceHelper ph : vph) {
            vMap.add(ph.getPartMapVector());
        }
        return vMap;
    }

    public Collection<List<JDFAttributeMap>> getPartMapLists() {
        List<ResourceHelper> vph = this.getPartitionList();
        ArrayList<List<JDFAttributeMap>> vMap = new ArrayList<List<JDFAttributeMap>>();
        for (ResourceHelper ph : vph) {
            vMap.add(ph.getPartMapVector());
        }
        return vMap;
    }

    public VString getDependentJobParts() {
        VElement deps = this.theElement.getChildElementVector("Dependent", null);
        VString ret = new VString();
        if (deps != null) {
            for (KElement dep : deps) {
                String jpID = dep.getNonEmpty("JobPartID");
                ret.appendUnique(jpID);
            }
        }
        return ret.isEmpty() ? null : ret;
    }

    public void setName(String name) {
        this.setAttribute("Name", name);
    }

    public void removeIDs() {
        this.removeAttribute("ID", null);
        List<ResourceHelper> v = this.getPartitionList();
        if (v != null) {
            for (ResourceHelper ph : v) {
                ph.removeAttribute("ID", null);
            }
        }
    }

    public int indexOf(ResourceHelper bsHelper) {
        if (bsHelper == null) {
            return -1;
        }
        List<KElement> v = this.theElement.getChildList(this.getPartitionName(), null);
        if (v == null) {
            return -1;
        }
        return v.indexOf(bsHelper.getRoot());
    }

    public static SetHelper getHelper(KElement e) {
        while (e != null && !SetHelper.isSet(e)) {
            e = e.getParentNode_KElement();
        }
        return SetHelper.isSet(e) ? new SetHelper(e) : null;
    }

    @Override
    public void setExternalID(String newID) {
        super.setExternalID(newID);
    }

    @Override
    public void setDescriptiveName(String description) {
        super.setDescriptiveName(description);
    }

    @Override
    public void setGeneralID(String idUsage, String idValue) {
        super.setGeneralID(idUsage, idValue);
    }

    @Override
    public boolean matches(Object subset) {
        if (!(subset instanceof SetHelper)) {
            return false;
        }
        SetHelper sh = (SetHelper)subset;
        if (!ContainerUtil.equals((Object)sh.getUsage(), (Object)this.getUsage())) {
            return false;
        }
        if (!ContainerUtil.equals(sh.getProcessUsage(), this.getProcessUsage())) {
            return false;
        }
        return ContainerUtil.equals(sh.getCombinedProcessIndex(), this.getCombinedProcessIndex());
    }

    public int size() {
        return this.theElement == null ? 0 : ContainerUtil.size(this.theElement.getChildList(this.getPartitionName(), null));
    }

    public static enum EnumFamily {
        Parameter,
        Resource;

    }
}

