/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.goldenticket;

import org.cip4.jdflib.auto.JDFAutoComponent;
import org.cip4.jdflib.auto.JDFAutoLayoutIntent;
import org.cip4.jdflib.auto.JDFAutoPart;
import org.cip4.jdflib.core.JDFAudit;
import org.cip4.jdflib.core.JDFCustomerInfo;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFNodeInfo;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFIntegerRange;
import org.cip4.jdflib.datatypes.JDFIntegerRangeList;
import org.cip4.jdflib.datatypes.JDFShape;
import org.cip4.jdflib.goldenticket.MISGoldenTicket;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.intent.JDFBindingIntent;
import org.cip4.jdflib.resource.intent.JDFColorIntent;
import org.cip4.jdflib.resource.intent.JDFDeliveryIntent;
import org.cip4.jdflib.resource.intent.JDFDropItemIntent;
import org.cip4.jdflib.resource.intent.JDFFoldingIntent;
import org.cip4.jdflib.resource.intent.JDFLayoutIntent;
import org.cip4.jdflib.resource.intent.JDFMediaIntent;
import org.cip4.jdflib.resource.intent.JDFPackingIntent;
import org.cip4.jdflib.resource.process.JDFComponent;
import org.cip4.jdflib.resource.process.JDFContact;
import org.cip4.jdflib.span.JDFIntegerSpan;
import org.cip4.jdflib.span.JDFSpanBindingType;
import org.cip4.jdflib.span.JDFSpanCoatings;
import org.cip4.jdflib.util.JDFDate;

public class ProductGoldenTicket
extends MISGoldenTicket {
    public ProductGoldenTicket(int _icsLevel, JDFElement.EnumVersion jdfVersion, int _jmfLevel, int _misLevel) {
        super(_misLevel, jdfVersion, _jmfLevel);
        this.cols.set(4, "Blue");
        this.icsLevel = _icsLevel;
        this.devID = null;
        this.grayBox = false;
    }

    @Override
    public void init() {
        if (this.icsLevel < 0) {
            return;
        }
        if (!this.theNode.hasAttribute("DescriptiveName")) {
            this.theNode.setDescriptiveName("Product Golden Ticket Example Job - version: " + JDFAudit.software());
        }
        this.theNode.setType(JDFNode.EnumType.Product);
        JDFComponent out = (JDFComponent)this.theNode.getCreateResource("Component", JDFResourceLink.EnumUsage.Output, 0);
        if (this.theNode.isJDFRoot()) {
            out.setComponentType(JDFAutoComponent.EnumComponentType.FinalProduct, null);
        } else {
            out.setComponentType(JDFAutoComponent.EnumComponentType.PartialProduct, null);
        }
        super.init();
    }

    protected JDFComponent initOutputComponent(JDFNode childNode, JDFLayoutIntent li, String productType) {
        JDFComponent outComp = (JDFComponent)childNode.getCreateResource("Component", JDFResourceLink.EnumUsage.Output, 0);
        if (productType == null) {
            outComp.setComponentType(JDFAutoComponent.EnumComponentType.FinalProduct, JDFAutoComponent.EnumComponentType.Sheet);
        } else {
            outComp.setComponentType(JDFAutoComponent.EnumComponentType.PartialProduct, JDFAutoComponent.EnumComponentType.Sheet);
            outComp.setProductType(productType);
        }
        this.theNode.getResource("LayoutIntent", null, 0);
        JDFShape s = li.getFinishedDimensions().getActual();
        outComp.setDimensions(s);
        if (this.theNode != childNode) {
            this.theNode.getResourcePool().moveElement(outComp, null);
            this.theNode.linkResource((JDFResource)outComp, JDFResourceLink.EnumUsage.Input, null);
        }
        return outComp;
    }

    protected JDFDeliveryIntent initDeliveryIntent(int amount) {
        JDFDeliveryIntent di = (JDFDeliveryIntent)this.theNode.addResource("DeliveryIntent", JDFResourceLink.EnumUsage.Input);
        JDFDate d = new JDFDate();
        d.addOffset(0, 0, 0, 7);
        di.appendRequired().setPreferred(d);
        if (amount > 0) {
            JDFComponent outComp = (JDFComponent)this.theNode.getCreateResource("Component", JDFResourceLink.EnumUsage.Output, 0);
            JDFDropItemIntent dit = di.appendDropIntent().appendDropItemIntent();
            dit.refElement(outComp);
            dit.setAmount(amount);
            JDFResourceLink rl = this.theNode.getLink((JDFResource)outComp, null);
            rl.setAmount(amount, null);
        }
        di.setResStatus(JDFResource.EnumResStatus.Available, false);
        di.preferredToActual();
        return di;
    }

    @Override
    protected JDFNodeInfo initNodeInfo() {
        super.initNodeInfo();
        JDFNodeInfo ni = this.theNode.getCreateNodeInfo();
        ni.setStart(null);
        return ni;
    }

    protected JDFCustomerInfo initCustomerInfo(String firstame, String lastame, String companyName, String jobName) {
        JDFCustomerInfo ci = this.theNode.getCreateCustomerInfo();
        ci.setCustomerJobName(jobName);
        JDFContact c = ci.getContactWithContactType(JDFContact.EnumContactType.Customer.getName(), 0);
        if (c == null) {
            c = ci.appendContact(JDFContact.EnumContactType.Customer);
        }
        c.setPerson(firstame, lastame);
        if (companyName != null) {
            c.getCreateCompany().setOrganizationName(companyName);
        }
        return ci;
    }

    protected JDFMediaIntent initMediaIntent(JDFNode node, String quality) {
        JDFMediaIntent mi = (JDFMediaIntent)node.addResource("MediaIntent", JDFResourceLink.EnumUsage.Input);
        mi.getCreateMediaQuality().setActual(quality);
        mi.setResStatus(JDFResource.EnumResStatus.Available, false);
        mi.preferredToActual();
        return mi;
    }

    protected JDFMediaIntent initMediaIntent(JDFNode node, double gsm, JDFSpanCoatings.EnumSpanCoatings coating, String brand) {
        JDFMediaIntent mi = (JDFMediaIntent)node.addResource("MediaIntent", JDFResourceLink.EnumUsage.Input);
        mi.getCreateWeight().setPreferred(gsm);
        mi.getCreateFrontCoatings().setPreferred(coating);
        mi.setBrand(brand);
        mi.setResStatus(JDFResource.EnumResStatus.Available, false);
        mi.preferredToActual();
        return mi;
    }

    protected JDFColorIntent initColorIntent(JDFNode node, int front, int back, String coatings) {
        JDFColorIntent ci = (JDFColorIntent)node.addResource("ColorIntent", JDFResourceLink.EnumUsage.Input);
        VElement vci = new VElement();
        this.nCols[0] = front;
        this.nCols[1] = back;
        if (front != back && back != 0) {
            vci.add(ci.addPartition(JDFResource.EnumPartIDKey.Side, JDFAutoPart.EnumSide.Front));
            vci.add(ci.addPartition(JDFResource.EnumPartIDKey.Side, JDFAutoPart.EnumSide.Back));
        } else {
            vci.add(ci);
        }
        for (int i = 0; i < vci.size(); ++i) {
            int colors = i == 0 ? front : back;
            VString newCols = new VString();
            for (int j = 0; j < colors; ++j) {
                newCols.add(this.cols.elementAt(j));
            }
            JDFColorIntent cip = (JDFColorIntent)vci.elementAt(i);
            cip.appendColorsUsed().setSeparations(newCols);
        }
        ci.setResStatus(JDFResource.EnumResStatus.Available, false);
        ci.preferredToActual();
        return ci;
    }

    protected JDFLayoutIntent initLayoutIntent(JDFNode node, double xCM, double yCM, int pages, int sides) {
        JDFLayoutIntent loi = (JDFLayoutIntent)node.addResource("LayoutIntent", JDFResourceLink.EnumUsage.Input);
        loi.getCreateFinishedDimensions().setPreferred(xCM * 72.0 / 2.54, yCM * 72.0 / 2.54, 0.0);
        loi.getCreatePages().setPreferred(pages);
        loi.setSides(sides == 2 ? JDFAutoLayoutIntent.EnumSides.TwoSidedHeadToHead : JDFAutoLayoutIntent.EnumSides.OneSided);
        loi.setResStatus(JDFResource.EnumResStatus.Available, false);
        loi.preferredToActual();
        return loi;
    }

    protected JDFFoldingIntent initFoldingIntent(JDFNode node, String foldCatalog) {
        JDFFoldingIntent fi = (JDFFoldingIntent)node.addResource("FoldingIntent", JDFResourceLink.EnumUsage.Input);
        fi.appendFoldingCatalog().setPreferred(foldCatalog);
        fi.setResStatus(JDFResource.EnumResStatus.Available, false);
        fi.preferredToActual();
        return fi;
    }

    public void createPostCards() {
        this.initCustomerInfo(null, null, "Volkswagen AG", "Freeway postcards");
        this.theNode.setDescriptiveName("7.5.1   Postcards 4c/4c");
        this.initMediaIntent(this.theNode, 300.0, JDFSpanCoatings.EnumSpanCoatings.Coated, null);
        JDFLayoutIntent li = this.initLayoutIntent(this.theNode, 14.8, 10.5, 16, 2);
        this.initColorIntent(this.theNode, 4, 4, null);
        this.initOutputComponent(this.theNode, li, null);
        this.initDeliveryIntent(5000);
    }

    public void createFlyer() {
        this.initCustomerInfo(null, null, "Acme", "Acme A4 Flyer");
        this.theNode.setDescriptiveName("7.5.1   Flyer 4c/4c");
        this.initMediaIntent(this.theNode, "FSC Coated130");
        JDFLayoutIntent li = this.initLayoutIntent(this.theNode, 21.0, 29.0, 4, 2);
        this.initColorIntent(this.theNode, 4, 4, null);
        this.initOutputComponent(this.theNode, li, null);
        this.initDeliveryIntent(5000);
    }

    public void createMultiLabels() {
        this.theNode.setDescriptiveName("Multi Label Product");
        JDFDeliveryIntent diBig = this.initDeliveryIntent(0);
        this.theNode.removeResource("CustomerInfo", 0);
        ProductGoldenTicket gtLabel1 = new ProductGoldenTicket(0, JDFElement.EnumVersion.Version_1_3, 0, 0);
        JDFNode n1 = this.theNode.addProduct();
        gtLabel1.assign(n1);
        this.addKid(gtLabel1);
        gtLabel1.initCustomerInfo("Johann", "ReweEink\u00e4ufer", "Rewe", "Mineralwasser label");
        this.initMediaIntent(n1, 24.4, JDFSpanCoatings.EnumSpanCoatings.Coated, "38DL247 38");
        JDFLayoutIntent li = this.initLayoutIntent(n1, 92.0, 28.3, 1, 1);
        this.initColorIntent(n1, 6, 0, null);
        this.initOutputComponent(n1, li, "Label");
        JDFDeliveryIntent di = gtLabel1.initDeliveryIntent(5000);
        diBig.moveElement(di.getDropIntent(0), null);
        gtLabel1.getNode().removeResource("DeliveryIntent", 0);
        ProductGoldenTicket gtLabel2 = new ProductGoldenTicket(0, JDFElement.EnumVersion.Version_1_3, 0, 0);
        JDFNode n2 = this.theNode.addProduct();
        gtLabel2.assign(n2);
        this.addKid(gtLabel2);
        gtLabel2.initCustomerInfo("Franzi", "KulmbachEink\u00e4ufer", "Kulmbach", "Weissbier label");
        this.initMediaIntent(n2, 24.4, JDFSpanCoatings.EnumSpanCoatings.Coated, "38DL247 38");
        li = this.initLayoutIntent(n2, 11.4, 5.0, 1, 1);
        gtLabel2.cols = new VString("Green Gold Black Yellow Gold Thermo", null);
        gtLabel2.initColorIntent(n2, 6, 0, null);
        this.initOutputComponent(n2, li, "Label");
        di = gtLabel2.initDeliveryIntent(10000);
        diBig.moveElement(di.getDropIntent(0), null);
        gtLabel2.getNode().removeResource("DeliveryIntent", 0);
    }

    public void createHarley() {
        this.initCustomerInfo(null, null, "ABC Promotions Company", "Speed-Point Harley Poster");
        this.theNode.setDescriptiveName("7.5.4   Poster 4c/0c");
        this.initMediaIntent(this.theNode, 170.0, JDFSpanCoatings.EnumSpanCoatings.Glossy, null);
        JDFLayoutIntent li = this.initLayoutIntent(this.theNode, 43.0, 32.6, 1, 1);
        this.initColorIntent(this.theNode, 4, 0, null);
        this.initOutputComponent(this.theNode, li, null);
        this.initDeliveryIntent(5000);
    }

    protected JDFBindingIntent initBindingIntent(JDFComponent cover, JDFComponent body, int numStitches) {
        JDFBindingIntent bi = (JDFBindingIntent)this.theNode.addResource("BindingIntent", JDFResourceLink.EnumUsage.Input);
        if (numStitches > 0) {
            bi.appendSaddleStitching().appendStitchNumber().setActual(numStitches);
            bi.appendBindingType().setActual(JDFSpanBindingType.EnumSpanBindingType.SaddleStitch);
        }
        this.theNode.linkResource((JDFResource)cover, JDFResourceLink.EnumUsage.Input, JDFNode.EnumProcessUsage.Cover);
        this.theNode.linkResource((JDFResource)body, JDFResourceLink.EnumUsage.Input, null);
        bi.setResStatus(JDFResource.EnumResStatus.Available, false);
        bi.preferredToActual();
        return bi;
    }

    public void createAddressBook() {
        this.initCustomerInfo(null, null, "Art Point", "Address Pocketbook");
        this.theNode.setDescriptiveName("7.5.2   A5 brochure 4c/4c, 4pg Cover, 32 pg Text");
        JDFNode cover = this.addJDFNode(this.theNode, JDFNode.EnumType.Product);
        cover.setDescriptiveName("Address Book Cover");
        this.initMediaIntent(cover, 200.0, JDFSpanCoatings.EnumSpanCoatings.Glossy, null);
        JDFLayoutIntent li = this.initLayoutIntent(cover, 14.8, 21.0, 4, 2);
        JDFColorIntent ci = this.initColorIntent(cover, 4, 4, null);
        JDFComponent cCover = this.initOutputComponent(cover, li, "Cover");
        cCover.setComponentType(JDFAutoComponent.EnumComponentType.PartialProduct, JDFAutoComponent.EnumComponentType.Sheet);
        JDFNode body = this.addJDFNode(this.theNode, JDFNode.EnumType.Product);
        body.setDescriptiveName("Address Book Body");
        body.linkResource((JDFResource)ci, JDFResourceLink.EnumUsage.Input, null);
        this.initMediaIntent(body, 135.0, JDFSpanCoatings.EnumSpanCoatings.Coated, null);
        this.initLayoutIntent(body, 14.8, 21.0, 32, 2);
        JDFComponent cBody = this.initOutputComponent(body, li, "Body");
        cBody.setComponentType(JDFAutoComponent.EnumComponentType.PartialProduct, JDFAutoComponent.EnumComponentType.Sheet);
        this.initBindingIntent(cCover, cBody, 2);
        this.initOutputComponent(this.theNode, li, null);
        this.initDeliveryIntent(5000);
    }

    public void createHDCity() {
        this.initCustomerInfo(null, null, "Heidelberger Druckmaschinen AG", "Heidelberg A4 brochure");
        this.theNode.setDescriptiveName("7.5.5   A4 brochure with spot colors, 4pg Cover 6c/4c, 32 pg Text 4c/4c");
        JDFNode cover = this.addJDFNode(this.theNode, JDFNode.EnumType.Product);
        cover.setDescriptiveName("HD Brochure Cover");
        this.initMediaIntent(cover, 200.0, JDFSpanCoatings.EnumSpanCoatings.Glossy, null);
        JDFLayoutIntent li = this.initLayoutIntent(cover, 21.0, 29.7, 4, 2);
        this.initColorIntent(cover, 6, 4, null);
        JDFComponent cCover = this.initOutputComponent(cover, li, "Cover");
        cCover.setComponentType(JDFAutoComponent.EnumComponentType.PartialProduct, JDFAutoComponent.EnumComponentType.Sheet);
        JDFNode body = this.addJDFNode(this.theNode, JDFNode.EnumType.Product);
        body.setDescriptiveName("HD Brochure Body");
        this.initColorIntent(body, 4, 4, null);
        this.initMediaIntent(body, 135.0, JDFSpanCoatings.EnumSpanCoatings.Coated, null);
        this.initLayoutIntent(body, 21.0, 29.7, 32, 2);
        JDFComponent cBody = this.initOutputComponent(body, li, "Body");
        cBody.setComponentType(JDFAutoComponent.EnumComponentType.PartialProduct, JDFAutoComponent.EnumComponentType.Sheet);
        this.initBindingIntent(cCover, cBody, 2);
        this.initOutputComponent(this.theNode, li, null);
        this.initDeliveryIntent(5000);
    }

    public void createWatches() {
        this.initCustomerInfo(null, null, "ABC Promotions Company", "Sinn watches double flap");
        this.theNode.setDescriptiveName("7.5.3 Flyer with special fold 4c/4c");
        this.initMediaIntent(this.theNode, 170.0, JDFSpanCoatings.EnumSpanCoatings.Coated, null);
        JDFLayoutIntent li = this.initLayoutIntent(this.theNode, 21.0, 29.7, 6, 2);
        this.initColorIntent(this.theNode, 4, 4, null);
        JDFFoldingIntent fi = this.initFoldingIntent(this.theNode, "F6-3");
        fi.setDescriptiveName("F6-3 should be the gate fold");
        this.initOutputComponent(this.theNode, li, null);
        this.initDeliveryIntent(5000);
    }

    public void createDrupaFlower() throws Exception {
        this.initCustomerInfo("Jane", "Customer", "Messe D\u00fcsseldorf", "CIP4 Drupa Flower Demo Job");
        this.theNode.setDescriptiveName("Drupa Flower Brochure, 4pg Cover 5c5c, 48 pg Text 5c5c");
        JDFNode cover = this.addJDFNode(this.theNode, JDFNode.EnumType.Product);
        cover.setDescriptiveName("Drupa Flower Brochure Cover");
        this.initMediaIntent(cover, 200.0, JDFSpanCoatings.EnumSpanCoatings.Glossy, "Luxocard 2 SB");
        JDFLayoutIntent li = this.initLayoutIntent(cover, 23.3, 21.6, 4, 2);
        this.initColorIntent(cover, 5, 5, null);
        JDFComponent cCover = this.initOutputComponent(cover, li, "Cover");
        cCover.setComponentType(JDFAutoComponent.EnumComponentType.PartialProduct, JDFAutoComponent.EnumComponentType.Sheet);
        JDFNode body = this.addJDFNode(this.theNode, JDFNode.EnumType.Product);
        body.setDescriptiveName("Drupa Flower Brochure Body");
        this.initColorIntent(body, 5, 5, "Cyan Magenta Yellow Black Blue");
        this.initMediaIntent(body, 150.0, JDFSpanCoatings.EnumSpanCoatings.Glossy, "Scheufelen BVS dull BB");
        this.initLayoutIntent(body, 23.3, 21.6, 48, 2);
        JDFComponent cBody = this.initOutputComponent(body, li, "Body");
        cBody.setComponentType(JDFAutoComponent.EnumComponentType.PartialProduct, JDFAutoComponent.EnumComponentType.Sheet);
        this.initBindingIntent(cCover, cBody, 2);
        this.initOutputComponent(this.theNode, li, null);
        this.initDeliveryIntent(5000);
        JDFPackingIntent pi = (JDFPackingIntent)this.theNode.getCreateResource("PackingIntent", JDFResourceLink.EnumUsage.Input, 0);
        pi.setDescriptiveName("want cartons of products");
        JDFIntegerSpan is = pi.appendCartonQuantity();
        is.setRange(new JDFIntegerRangeList(new JDFIntegerRange(50, 500)));
    }

    @Override
    protected void runphases(int pgood, int pwaste, boolean bOutAvail, boolean bFirst) {
    }
}

