/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.jmf;

import java.util.Collection;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoDeviceInfo;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.extensions.XJDFEnums;
import org.cip4.jdflib.jmf.JDFJobPhase;
import org.cip4.jdflib.jmf.JDFMessage;
import org.cip4.jdflib.jmf.JDFModuleInfo;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.resource.JDFDevice;
import org.cip4.jdflib.resource.JDFEvent;
import org.cip4.jdflib.resource.JDFModulePhase;
import org.cip4.jdflib.resource.JDFPhaseTime;
import org.cip4.jdflib.resource.process.JDFEmployee;
import org.cip4.jdflib.resource.process.JDFMISDetails;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.StringUtil;

public class JDFDeviceInfo
extends JDFAutoDeviceInfo {
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[1];
    private static ElemInfoTable[] elemInfoTable;
    private static final long serialVersionUID = 1L;

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    public void setCounterUnit(JDFElement.eUnit unit) {
        this.setCounterUnit(unit == null ? null : unit.name());
    }

    public JDFElement.eUnit getCountUnitEnum() {
        return JDFElement.eUnit.getEnum(this.getCounterUnit());
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        return super.getTheElementInfo().updateReplace(elemInfoTable);
    }

    public JDFDeviceInfo(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFDeviceInfo(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFDeviceInfo(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFDeviceInfo[  --> " + super.toString() + " ]";
    }

    @Deprecated
    public int getJobCount() {
        return this.getChildrenByTagName("JobPhase", null, null, false, true, 0).size();
    }

    public JDFJobPhase createJobPhaseFromPhaseTime(JDFPhaseTime pt) {
        JDFJobPhase jp = this.appendJobPhase();
        JDFNode node = pt.getParentJDF();
        jp.setJobID(node.getJobID(true));
        jp.setJobPartID(StringUtil.getNonEmpty(node.getJobPartID(true)));
        VJDFAttributeMap partMapVector = pt.getPartMapVector();
        jp.setPartMapVector(partMapVector);
        jp.copyAttribute("Status", pt);
        jp.copyAttribute("StatusDetails", pt);
        jp.setPhaseStartTime(pt.getStart());
        JDFResourceLink rl = pt.getLink(0);
        if (rl != null && rl.getAmountPoolAttribute("ActualAmount", null, null, 0) != null) {
            jp.setPhaseAmount(rl.getActualAmount(null));
        }
        JDFMISDetails md = pt.getMISDetails();
        jp.copyElement(md, null);
        VElement modules = pt.getChildElementVector("ModulePhase", null);
        if (modules != null) {
            int mLen = modules.size();
            for (int i = 0; i < mLen; ++i) {
                jp.createModuleStatusFromModulePhase((JDFModulePhase)modules.elementAt(i));
            }
        }
        jp.eraseEmptyAttributes(true);
        return jp;
    }

    @Override
    public String getDeviceID() {
        KElement km;
        String ret;
        if (this.hasAttribute("DeviceID")) {
            return super.getDeviceID();
        }
        JDFDevice d = this.getDevice();
        String string = ret = d == null ? null : d.getDeviceID();
        if (ret == null && (km = this.getParentNode_KElement()) instanceof JDFMessage) {
            ret = ((JDFMessage)km).getSenderID();
        }
        return ret;
    }

    @Override
    public String getDescriptiveName() {
        if (this.hasAttribute("DescriptiveName")) {
            return super.getDescriptiveName();
        }
        JDFDevice d = this.getDevice();
        return d == null ? "" : d.getDescriptiveName();
    }

    public boolean isSamePhase(JDFDeviceInfo lastInfo, boolean bExact) {
        if (lastInfo == null) {
            return false;
        }
        if (!ContainerUtil.equals(this.getDeviceID(), lastInfo.getDeviceID())) {
            return false;
        }
        if (!ContainerUtil.equals((Object)this.getDeviceOperationMode(), (Object)lastInfo.getDeviceOperationMode())) {
            return false;
        }
        if (!ContainerUtil.equals((Object)this.getDeviceStatus(), (Object)lastInfo.getDeviceStatus())) {
            return false;
        }
        if (!ContainerUtil.equals(this.getStatusDetails(), lastInfo.getStatusDetails())) {
            return false;
        }
        int numEmployees = this.numChildElements("Employee", null);
        if (numEmployees != lastInfo.numChildElements("Employee", null)) {
            return false;
        }
        boolean bSame = true;
        for (int i = 0; i < numEmployees && bSame; ++i) {
            JDFEmployee employee = lastInfo.getEmployee(i);
            if (employee == null) continue;
            bSame = bSame && this.getEmployee(i).matches(employee);
        }
        if (!bSame) {
            return false;
        }
        int numJobPhases = this.numChildElements("JobPhase", null);
        if (numJobPhases != lastInfo.numChildElements("JobPhase", null)) {
            return false;
        }
        bSame = numJobPhases == 0;
        for (int i = 0; i < numJobPhases; ++i) {
            bSame = bSame || this.getJobPhase(i).isSamePhase(lastInfo.getJobPhase(i), bExact);
        }
        if (bSame) {
            VString ignore = new VString(new String[]{"Part", "Employee", "JobPhase"});
            VElement childrenIgnoreList = this.getChildrenIgnoreList(ignore, true, null);
            VElement lastchildrenIgnoreList = lastInfo.getChildrenIgnoreList(ignore, true, null);
            if (childrenIgnoreList.size() > 0 || lastchildrenIgnoreList.size() > 0) {
                if (childrenIgnoreList.size() != lastchildrenIgnoreList.size()) {
                    return false;
                }
                for (int i = 0; i < childrenIgnoreList.size(); ++i) {
                    if (childrenIgnoreList.get(i).isEqual(lastchildrenIgnoreList.get(i))) continue;
                    return false;
                }
            }
        }
        return bSame;
    }

    public boolean mergeLastPhase(JDFDeviceInfo lastInfo) {
        if (!this.isSamePhase(lastInfo, false)) {
            return false;
        }
        int numJobPhases = this.numChildElements("JobPhase", null);
        boolean bGood = true;
        for (int i = 0; i < numJobPhases; ++i) {
            bGood = this.getJobPhase(i).mergeLastPhase(lastInfo.getJobPhase(i)) || bGood;
        }
        return bGood;
    }

    public void setDevice(JDFDevice device, boolean bCopy) {
        if (device == null) {
            return;
        }
        this.copyAttribute("DeviceID", device);
        if (bCopy && this.getDevice() == null) {
            this.copyElement(device, null);
        }
    }

    @Override
    public JDFEvent getCreateEvent(int iSkip) {
        return (JDFEvent)this.getCreateElement_JDFElement("Event", null, iSkip);
    }

    @Override
    public JDFEvent getEvent(int iSkip) {
        return (JDFEvent)this.getElement("Event", null, iSkip);
    }

    @Override
    public Collection<JDFEvent> getAllEvent() {
        return this.getChildrenByClass(JDFEvent.class, false, 0);
    }

    @Override
    public JDFEvent appendEvent() {
        return (JDFEvent)this.appendElement("Event", null);
    }

    public JDFEvent appendEvent(String eventID) {
        JDFEvent e = this.appendEvent();
        e.setEventID(StringUtil.getNonEmpty(eventID));
        return e;
    }

    public XJDFEnums.eDeviceStatus getXJMFStatus() {
        return XJDFEnums.eDeviceStatus.getEnum(this.getAttribute("Status"));
    }

    public void setXJMFStatus(XJDFEnums.eDeviceStatus s) {
        this.setAttribute("Status", s == null ? null : s.name());
    }

    public JDFModuleInfo getModuleInfo() {
        return (JDFModuleInfo)this.getElement("ModuleInfo", null, 0);
    }

    public JDFModuleInfo getCreateModuleInfo() {
        return (JDFModuleInfo)this.getCreateElement_JDFElement("ModuleInfo", null, 0);
    }

    public JDFModuleInfo getCreateModuleInfo(int iSkip) {
        return (JDFModuleInfo)this.getCreateElement_JDFElement("ModuleInfo", null, iSkip);
    }

    public JDFModuleInfo getModuleInfo(int iSkip) {
        return (JDFModuleInfo)this.getElement("ModuleInfo", null, iSkip);
    }

    public Collection<JDFModuleInfo> getAllModuleInfo() {
        return this.getChildArrayByClass(JDFModuleInfo.class, false, 0);
    }

    public JDFModuleInfo appendModuleInfo() {
        return (JDFModuleInfo)this.appendElement("ModuleInfo", null);
    }

    public JDFModuleInfo getModuleInfo(String id) {
        return this.getChildWithAttribute(JDFModuleInfo.class, "ModuleID", id);
    }

    static {
        JDFDeviceInfo.atrInfoTable[0] = new AtrInfoTable("IdleStartTime", 0x33333000L, AttributeInfo.EnumAttributeType.dateTime, null, null);
        elemInfoTable = new ElemInfoTable[2];
        JDFDeviceInfo.elemInfoTable[0] = new ElemInfoTable("Employee", 0x33333333L);
        JDFDeviceInfo.elemInfoTable[1] = new ElemInfoTable("Event", 0x33333333L);
    }
}

