/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.node;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.StringArray;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.StringUtil;

public class ICSVersion {
    private final int level;
    private final JDFElement.EnumVersion version;
    private final String ics;

    public int getLevel() {
        return this.level;
    }

    public JDFElement.EnumVersion getVersion() {
        return this.version;
    }

    public String getIcs() {
        return this.ics;
    }

    public ICSVersion(String ics, int level, JDFElement.EnumVersion version) {
        this.ics = ics;
        this.version = version;
        this.level = level;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.ics, this.level, this.version});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ICSVersion other = (ICSVersion)obj;
        return Objects.equals(this.ics, other.ics) && this.level == other.level && Objects.equals((Object)this.version, (Object)other.version);
    }

    public static List<ICSVersion> getVersions(String input) {
        ArrayList<ICSVersion> ret = new ArrayList<ICSVersion>();
        StringArray versions = StringArray.getVString(input, null);
        if (versions != null) {
            for (String ics : versions) {
                ContainerUtil.add(ret, ICSVersion.getVersion(ics));
            }
        }
        return ret;
    }

    public static ICSVersion getVersion(String in) {
        int li = StringUtil.index(in, "_L", 0);
        if (li > 0 && in.length() >= li + 7) {
            String ics = in.substring(0, li);
            int level = StringUtil.parseInt(in.substring(li + 2, li + 3), -1);
            JDFElement.EnumVersion v = level >= 0 ? JDFElement.EnumVersion.getEnum(in.substring(li + 4, li + 7)) : null;
            return v == null ? null : new ICSVersion(ics, level, v);
        }
        return null;
    }

    public String toString() {
        return this.ics + "_L" + this.level + "-" + this.version;
    }

    public ICSVersion getBase(String dependentICS, int depLevel) {
        return new ICSVersion(dependentICS, depLevel, this.version);
    }
}

