/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource;

import java.util.HashSet;
import java.util.Set;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoPart;
import org.cip4.jdflib.core.AtrInfo;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.StringArray;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.StringUtil;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class JDFPart
extends JDFAutoPart {
    private static final String ALL = "All";
    private static final long serialVersionUID = 1L;
    private static final String[] partSequence = new String[]{"SignatureName", "SheetName", "Side", "Separation", "RunSet", "Run"};
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[6];
    static Set<String> fastparts;
    static Set<String> allparts;

    public JDFPart(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFPart(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFPart(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFPart[  --> " + super.toString() + " ]";
    }

    @Override
    public JDFAttributeMap getPartMap() {
        JDFAttributeMap m = new JDFAttributeMap();
        NamedNodeMap nm = this.getAttributes();
        if (nm != null) {
            int siz = nm.getLength();
            for (int i = 0; i < siz; ++i) {
                Node a = nm.item(i);
                String nodeName = a.getNodeName();
                if (!allparts.contains(nodeName)) continue;
                m.put(nodeName, a.getNodeValue());
            }
        }
        return m;
    }

    public VString guessPartIDKeys() {
        JDFAttributeMap map = this.getPartMap();
        return JDFPart.guessPartIDKeys(map);
    }

    public static VString guessPartIDKeys(JDFAttributeMap map) {
        if (ContainerUtil.isEmpty(map)) {
            return null;
        }
        if (map.size() == 1) {
            return map.getKeys();
        }
        VString v = new VString();
        StringArray keys = map.getKeyList();
        for (String key : partSequence) {
            if (!keys.contains(key)) continue;
            v.add(key);
            keys.remove(key);
        }
        v.addAll(keys);
        return v;
    }

    @Override
    public void setPartMap(JDFAttributeMap mPart) {
        this.removeAttributes(null);
        this.setAttributes(mPart);
    }

    @Deprecated
    public static boolean matchesPart(String key, String resourceValue, String linkValue) {
        return JDFPart.matchesPart(key, resourceValue, linkValue, false);
    }

    public static boolean matchesPart(String key, String resourceValue, VString linkValues, boolean strictPartVersion) {
        if (linkValues == null || linkValues.size() == 0) {
            return true;
        }
        for (String linkValue : linkValues) {
            if (!JDFPart.matchesPart(key, resourceValue, linkValue, strictPartVersion)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchesPart(String key, String resourceValue, String linkValue, boolean strictPartVersion) {
        if (resourceValue.equals(linkValue)) {
            return true;
        }
        if (fastparts.contains(linkValue)) {
            return false;
        }
        boolean b = "ItemNames".equals(key) || key.endsWith("Tags") ? AtrInfo.matchesAttribute(linkValue, resourceValue, AttributeInfo.EnumAttributeType.NMTOKENS) : ("PageNumber".equals(key) || key.endsWith("Index") || "LayerIDs".equals(key) || "DocCopies".equals(key) ? AtrInfo.matchesAttribute(linkValue, resourceValue, AttributeInfo.EnumAttributeType.IntegerRangeList) : (!strictPartVersion && "PartVersion".equals(key) ? JDFPart.matchesPartVersion(resourceValue, linkValue) : false));
        return b;
    }

    public static boolean matchesPartVersion(String resourceValue, String linkValue) {
        boolean b;
        if (resourceValue == null || linkValue == null) {
            return false;
        }
        boolean bl = b = resourceValue.equals(linkValue) || KElement.isWildCard(resourceValue) || KElement.isWildCard(linkValue) || ALL.equalsIgnoreCase(linkValue) || ALL.equalsIgnoreCase(resourceValue);
        if (!b) {
            int iResPos = resourceValue.indexOf(32);
            int iLinkPos = linkValue.indexOf(32);
            if (iResPos < 0 && iLinkPos >= 0) {
                b = StringUtil.hasToken(linkValue, resourceValue, null, 0);
            } else if (iLinkPos < 0 && iResPos >= 0) {
                b = StringUtil.hasToken(resourceValue, linkValue, null, 0);
            }
        }
        return b;
    }

    @Deprecated
    public static boolean overlapPartMap(JDFAttributeMap resourceMap, JDFAttributeMap linkMap) {
        return JDFPart.overlapPartMap(resourceMap, linkMap, false);
    }

    public static boolean overlapPartMap(JDFAttributeMap resourceMap, JDFAttributeMap linkMap, boolean strictPartVersion) {
        if (resourceMap == null || linkMap == null) {
            return true;
        }
        Set subMapKeys = linkMap.keySet();
        for (String key : subMapKeys) {
            String linkVal;
            String resVal = resourceMap.get(key);
            if (resVal == null || JDFPart.matchesPart(key, resVal, linkVal = linkMap.get(key), strictPartVersion)) continue;
            return false;
        }
        return true;
    }

    public static boolean subPartMap(JDFAttributeMap resourceMap, JDFAttributeMap linkMap, boolean strictPartVersion) {
        if (resourceMap == null) {
            return linkMap == null || linkMap.isEmpty();
        }
        if (linkMap == null) {
            return resourceMap.isEmpty();
        }
        if (resourceMap.size() < linkMap.size()) {
            return false;
        }
        Set subMapKeys = linkMap.keySet();
        for (String key : subMapKeys) {
            String resVal = resourceMap.get(key);
            if (resVal != null) {
                String linkVal = linkMap.get(key);
                if (JDFPart.matchesPart(key, resVal, linkVal, strictPartVersion)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static boolean overlapPartMap(JDFAttributeMap resourceMap, VJDFAttributeMap vLinkMap, boolean strictPartVersion) {
        if (resourceMap == null || vLinkMap == null) {
            return true;
        }
        for (JDFAttributeMap linkMap : vLinkMap) {
            if (!JDFPart.overlapPartMap(resourceMap, linkMap, strictPartVersion)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        AttributeInfo ai = AttributeInfo.fixedMap.get("JDFPart");
        if (ai != null) {
            return ai;
        }
        ai = super.getTheAttributeInfo();
        ai.updateReplace(atrInfoTable);
        AttributeInfo.fixedMap.put("JDFPart", ai);
        return ai;
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        ElementInfo ai = ElementInfo.getFixedmap().get("Part");
        if (ai != null) {
            return ai;
        }
        ai = super.getTheElementInfo();
        ElementInfo.getFixedmap().put("Part", ai);
        return ai;
    }

    static Set<String> fillFastParts() {
        HashSet<String> hashSet = new HashSet<String>();
        for (JDFResource.EnumPartIDKey e : JDFResource.EnumPartIDKey.getEnumList()) {
            String key = e.getName();
            if ("ItemNames".equals(key) || key.endsWith("Tags") || "PageNumber".equals(key) || key.endsWith("Index") || "LayerIDs".equals(key) || "DocCopies".equals(key)) continue;
            hashSet.add(key);
        }
        return hashSet;
    }

    static Set<String> fillAllParts() {
        HashSet<String> hashSet = new HashSet<String>();
        for (JDFResource.EnumPartIDKey e : JDFResource.EnumPartIDKey.getEnumList()) {
            String key = e.getName();
            hashSet.add(key);
        }
        return hashSet;
    }

    public void setMetadata(int iMetaData, String value) {
        if (iMetaData < 0 || iMetaData > 9) {
            throw new IllegalArgumentException("iMetaData mut be between 0 and 9");
        }
        this.setAttribute("Metadata" + iMetaData, value, null);
    }

    public static Set<String> getFastparts() {
        return fastparts;
    }

    static {
        JDFPart.atrInfoTable[0] = new AtrInfoTable("LotID", 0x33311111L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFPart.atrInfoTable[1] = new AtrInfoTable("ProductPart", 0x33311111L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFPart.atrInfoTable[2] = new AtrInfoTable("PrintCondition", 0x33311111L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFPart.atrInfoTable[3] = new AtrInfoTable("QualityMeasurement", 0x33311111L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFPart.atrInfoTable[4] = new AtrInfoTable("TransferCurveName", 0x33311111L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFPart.atrInfoTable[5] = new AtrInfoTable("DropID", 0x33111111L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        fastparts = JDFPart.fillFastParts();
        allparts = JDFPart.fillAllParts();
    }
}

